/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.callback.client;

import com.sshtools.callback.client.MutualCallbackAuthenticationProvider;
import com.sshtools.common.auth.AbstractAuthenticationProtocol;
import com.sshtools.common.auth.AuthenticationMechanism;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.Context;
import com.sshtools.common.ssh.ExecutorOperationSupport;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.jce.JCEComponentManager;
import com.sshtools.common.sshd.AbstractServerTransport;
import com.sshtools.common.sshd.SshMessage;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;

public class MutualCallbackAuthentication<C extends Context>
implements AuthenticationMechanism {
    public static final int SSH_MSG_USERAUTH_SIGNED_CHALLENGE = 60;
    AbstractServerTransport<C> transport;
    AbstractAuthenticationProtocol<C> authentication;
    SshConnection con;
    MutualCallbackAuthenticationProvider provider;
    public static final String AUTHENTICATION_METHOD = "publickey";

    public MutualCallbackAuthentication(AbstractServerTransport<C> transport, AbstractAuthenticationProtocol<C> authentication, SshConnection con, MutualCallbackAuthenticationProvider provider) {
        this.transport = transport;
        this.authentication = authentication;
        this.con = con;
        this.provider = provider;
    }

    public boolean startRequest(String username, byte[] msg) throws IOException {
        this.transport.addTask(ExecutorOperationSupport.EVENTS, (ConnectionAwareTask)new ProcessRemoteChallenge(this.con, username, msg));
        return true;
    }

    public boolean processMessage(byte[] msg) throws IOException {
        if (msg[0] != 60) {
            return false;
        }
        this.transport.addTask(ExecutorOperationSupport.EVENTS, (ConnectionAwareTask)new ProcessLocalChallenge(this.con, msg));
        return true;
    }

    public String getMethod() {
        return "mutual-key-auth@sshtools.com";
    }

    class ProcessRemoteChallenge
    extends ConnectionAwareTask {
        byte[] msg;
        String username;

        public ProcessRemoteChallenge(SshConnection con, String username, byte[] msg) {
            super(con);
            this.username = username;
            this.msg = msg;
        }

        protected void doTask() throws Throwable {
            try (ByteArrayReader bar = new ByteArrayReader(this.msg);){
                byte[] theirChallenge = bar.readBinaryString();
                try (ByteArrayWriter writer = new ByteArrayWriter();){
                    writer.writeBinaryString(theirChallenge);
                    writer.writeString(this.username);
                    writer.writeBinaryString(MutualCallbackAuthentication.this.transport.getSessionKey());
                    SshKeyPair key = MutualCallbackAuthentication.this.provider.getLocalPrivateKey(this.con);
                    if (Objects.isNull(key)) {
                        MutualCallbackAuthentication.this.authentication.failedAuthentication();
                        return;
                    }
                    final byte[] signed = key.getPrivateKey().sign(writer.toByteArray());
                    if (!key.getPublicKey().verifySignature(signed, writer.toByteArray())) {
                        throw new IllegalStateException();
                    }
                    final byte[] ourChallenge = new byte[512];
                    JCEComponentManager.getSecureRandom().nextBytes(ourChallenge);
                    this.con.setProperty("ourChallenge", (Object)ourChallenge);
                    this.con.setProperty("username", (Object)this.username);
                    MutualCallbackAuthentication.this.transport.postMessage(new SshMessage(){

                        public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                            buf.put((byte)60);
                            buf.putInt(signed.length);
                            buf.put(signed);
                            buf.putInt(ourChallenge.length);
                            buf.put(ourChallenge);
                            return true;
                        }

                        public void messageSent(Long sequenceNo) {
                            if (Log.isDebugEnabled()) {
                                Log.debug((String)"Sent SSH_MSG_USERAUTH_SIGNED_CHALLENGE", (Object[])new Object[0]);
                            }
                        }
                    });
                }
            }
        }
    }

    class ProcessLocalChallenge
    extends ConnectionAwareTask {
        byte[] msg;

        public ProcessLocalChallenge(SshConnection con, byte[] msg) {
            super(con);
            this.msg = msg;
        }

        protected void doTask() throws Throwable {
            try (ByteArrayReader bar = new ByteArrayReader(this.msg);){
                bar.skip(1L);
                byte[] signature = bar.readBinaryString();
                String username = this.con.getProperty("username").toString();
                try (ByteArrayWriter writer = new ByteArrayWriter();){
                    writer.writeBinaryString((byte[])this.con.getProperty("ourChallenge"));
                    writer.writeString(username);
                    writer.writeBinaryString(MutualCallbackAuthentication.this.transport.getSessionKey());
                    SshPublicKey key = MutualCallbackAuthentication.this.provider.getRemotePublicKey(this.con);
                    if (Objects.isNull(key)) {
                        MutualCallbackAuthentication.this.authentication.failedAuthentication();
                    }
                    if (key.verifySignature(signature, writer.toByteArray())) {
                        MutualCallbackAuthentication.this.authentication.completedAuthentication();
                    } else {
                        MutualCallbackAuthentication.this.authentication.failedAuthentication();
                    }
                }
            }
        }
    }
}

