/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.callback.client;

import com.sshtools.callback.client.CallbackClient;
import com.sshtools.callback.client.CallbackConfiguration;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SshException;
import com.sshtools.server.SshServerContext;
import com.sshtools.synergy.nio.ConnectRequestFuture;
import com.sshtools.synergy.nio.DisconnectRequestFuture;
import com.sshtools.synergy.nio.ProtocolContext;
import com.sshtools.synergy.ssh.Connection;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class CallbackSession
implements Runnable {
    public static final String CALLBACK_IDENTIFIER = "CallbackClient-";
    CallbackConfiguration config;
    CallbackClient app;
    ConnectRequestFuture future;
    boolean isStopped = false;
    String hostname;
    int port;
    Map<String, Object> attributes = new HashMap<String, Object>();
    int numberOfAuthenticationErrors = 0;

    public CallbackSession(CallbackConfiguration config, CallbackClient app, String hostname, int port) throws IOException {
        this.config = config;
        this.app = app;
        this.hostname = hostname;
        this.port = port;
    }

    @Override
    public void run() {
        try {
            this.connect();
        }
        catch (IOException e) {
            Log.error((String)"Failed to startup", (Throwable)e, (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException {
        if (this.isStopped) {
            throw new IOException("Client has been stopped");
        }
        if (Log.isInfoEnabled()) {
            Log.info((String)"Connecting to {}:{}", (Object[])new Object[]{this.hostname, this.port});
        }
        CallbackClient callbackClient = this.app;
        synchronized (callbackClient) {
            if (!(this.app.getSshEngine().isStarted() || this.app.getSshEngine().isStarting() || this.app.getSshEngine().startup())) {
                throw new IOException("SSH Engine failed to start");
            }
        }
        int count = 1;
        while (this.app.getSshEngine().isStarted()) {
            try {
                this.future = this.app.getSshEngine().connect(this.hostname, this.port, this.createContext(this.config));
                this.future.waitFor(30000L);
                if (this.future.isDone() && this.future.isSuccess()) {
                    Connection currentConnection = this.future.getConnection();
                    currentConnection.getAuthenticatedFuture().waitFor(30000L);
                    if (currentConnection.getAuthenticatedFuture().isDone() && currentConnection.getAuthenticatedFuture().isSuccess()) {
                        currentConnection.setProperty("callbackClient", (Object)this);
                        this.app.onClientConnected(this);
                        if (Log.isInfoEnabled()) {
                            Log.info((String)"Client is connected to {}:{}", (Object[])new Object[]{this.hostname, this.port});
                        }
                        this.numberOfAuthenticationErrors = 0;
                        break;
                    }
                    if (Log.isInfoEnabled()) {
                        Log.info((String)"Could not authenticate to {}:{}", (Object[])new Object[]{this.hostname, this.port});
                    }
                    currentConnection.disconnect();
                    ++this.numberOfAuthenticationErrors;
                }
                try {
                    long interval = this.config.getReconnectIntervalMs();
                    if (this.numberOfAuthenticationErrors >= 3) {
                        interval = TimeUnit.MINUTES.toMillis(10L);
                    }
                    if (this.numberOfAuthenticationErrors >= 9) {
                        interval = TimeUnit.MINUTES.toMillis(60L);
                    }
                    if (Log.isInfoEnabled()) {
                        Log.info((String)"Will reconnect to {}:{} in {} seconds", (Object[])new Object[]{this.hostname, this.port, interval / 1000L});
                    }
                    Thread.sleep(interval);
                }
                catch (InterruptedException interval) {
                }
            }
            catch (Throwable e) {
                Log.error((String)"{} on {}:{}", (Throwable)e, (Object[])new Object[]{e.getMessage(), this.config.getServerHost(), this.config.getServerPort()});
                long interval = this.config.getReconnectIntervalMs() * (long)Math.min(count, 720);
                if (Log.isInfoEnabled()) {
                    Log.info((String)"Reconnecting to {}:{} in {} seconds", (Object[])new Object[]{this.hostname, this.port, interval / 1000L});
                }
                try {
                    Thread.sleep(interval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (count >= 12) {
                    count += 12;
                    continue;
                }
                ++count;
            }
        }
    }

    protected ProtocolContext createContext(CallbackConfiguration config) throws IOException, SshException {
        SshServerContext ctx = this.app.createContext(this.app.getSshEngine().getContext(), config);
        return ctx;
    }

    public void disconnect() {
        if (this.future.isDone() && this.future.isSuccess()) {
            this.future.getTransport().disconnect(11, "The user disconnected.");
        }
    }

    public DisconnectRequestFuture stop() {
        this.isStopped = true;
        this.disconnect();
        return this.future.getTransport().getDisconnectFuture();
    }

    public String getName() {
        return this.config.getAgentName() + "@" + this.config.getServerHost();
    }

    public CallbackConfiguration getConfig() {
        return this.config;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void setConfig(CallbackConfiguration config) {
        this.config = config;
    }

    public boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object val) {
        this.attributes.put(key, val);
    }
}

