/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.agent.openssh;

import com.sshtools.agent.AgentMessage;
import com.sshtools.agent.KeyConstraints;
import com.sshtools.agent.exceptions.InvalidMessageException;
import com.sshtools.common.rsa.Rsa;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.SshPrivateKey;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.jce.ECUtils;
import com.sshtools.common.ssh.components.jce.Ssh2DsaPrivateKey;
import com.sshtools.common.ssh.components.jce.Ssh2DsaPublicKey;
import com.sshtools.common.ssh.components.jce.Ssh2EcdsaSha2NistPrivateKey;
import com.sshtools.common.ssh.components.jce.Ssh2EcdsaSha2NistPublicKey;
import com.sshtools.common.ssh.components.jce.Ssh2RsaPrivateCrtKey;
import com.sshtools.common.ssh.components.jce.Ssh2RsaPublicKey;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;

public class SshAgentAddKey
extends AgentMessage {
    SshPrivateKey prvkey;
    SshPublicKey pubkey;
    String description;
    KeyConstraints constraints;

    public SshAgentAddKey() {
        super(17);
    }

    public SshAgentAddKey(SshPrivateKey prvkey, SshPublicKey pubkey, String description, KeyConstraints constraints) {
        super(17);
        this.prvkey = prvkey;
        this.pubkey = pubkey;
        this.description = description;
        this.constraints = constraints;
    }

    public SshPrivateKey getPrivateKey() {
        return this.prvkey;
    }

    public SshPublicKey getPublicKey() {
        return this.pubkey;
    }

    public String getDescription() {
        return this.description;
    }

    public KeyConstraints getKeyConstraints() {
        return this.constraints;
    }

    @Override
    public String getMessageName() {
        return "SSH_AGENTC_ADD_IDENTITY";
    }

    @Override
    public void constructByteArray(ByteArrayWriter baw) throws IOException, InvalidMessageException {
        try {
            baw.write(17);
            this.encodeKey(baw);
            baw.writeString(this.description);
            baw.write(this.constraints.toByteArray());
        }
        catch (IOException ex) {
            throw new InvalidMessageException(ex.getMessage(), 13);
        }
        catch (SshException e) {
            throw new InvalidMessageException(e.getMessage(), 13);
        }
    }

    protected void encodeKey(ByteArrayWriter baw) throws IOException, SshException {
    }

    protected SshKeyPair decodeKey(ByteArrayReader bar) throws IOException, SshException {
        SshKeyPair pair = new SshKeyPair();
        String type = bar.readString();
        try {
            switch (type) {
                case "ssh-dss": {
                    BigInteger p = bar.readBigInteger();
                    BigInteger q = bar.readBigInteger();
                    BigInteger g = bar.readBigInteger();
                    BigInteger y = bar.readBigInteger();
                    BigInteger x = bar.readBigInteger();
                    pair.setPrivateKey((SshPrivateKey)new Ssh2DsaPrivateKey(p, q, g, x, y));
                    pair.setPublicKey((SshPublicKey)new Ssh2DsaPublicKey(p, q, g, y));
                    break;
                }
                case "ssh-rsa": {
                    BigInteger n = bar.readBigInteger();
                    BigInteger e = bar.readBigInteger();
                    BigInteger d = bar.readBigInteger();
                    BigInteger iqmp = bar.readBigInteger();
                    BigInteger p = bar.readBigInteger();
                    BigInteger q = bar.readBigInteger();
                    pair.setPrivateKey((SshPrivateKey)new Ssh2RsaPrivateCrtKey(n, e, d, p, q, Rsa.getPrimeExponent((BigInteger)d, (BigInteger)p), Rsa.getPrimeExponent((BigInteger)d, (BigInteger)q), iqmp));
                    pair.setPublicKey((SshPublicKey)new Ssh2RsaPublicKey(n, e));
                    break;
                }
                case "ecdsa-sha2-nistp256": {
                    String curveName = bar.readString();
                    byte[] Q = bar.readBinaryString();
                    BigInteger d = bar.readBigInteger();
                    ECPublicKey pub = ECUtils.decodeKey((byte[])Q, (String)curveName);
                    pair.setPrivateKey((SshPrivateKey)new Ssh2EcdsaSha2NistPrivateKey((PrivateKey)ECUtils.decodePrivateKey((byte[])d.toByteArray(), (ECPublicKey)pub), curveName));
                    pair.setPublicKey((SshPublicKey)new Ssh2EcdsaSha2NistPublicKey(pub, curveName));
                    break;
                }
                case "ecdsa-sha2-nistp384": {
                    break;
                }
                case "ecdsa-sha2-nistp521": {
                    break;
                }
                default: {
                    throw new IOException(String.format("Unsupported key type %s", type));
                }
            }
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IOException(e.getMessage(), e);
        }
        return pair;
    }

    @Override
    public void constructMessage(ByteArrayReader bar) throws IOException, InvalidMessageException {
        try {
            SshKeyPair keyPair = this.decodeKey(bar);
            this.prvkey = keyPair.getPrivateKey();
            this.pubkey = keyPair.getPublicKey();
            this.description = bar.readString();
            this.constraints = new KeyConstraints(bar);
        }
        catch (SshException | IOException ex) {
            throw new InvalidMessageException(ex.getMessage(), 13);
        }
    }
}

