/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.publickey.putty;

import com.sshtools.common.publickey.SshPrivateKeyFile;
import com.sshtools.common.publickey.SshPrivateKeyProvider;
import com.sshtools.common.publickey.putty.PuTTYPrivateKeyFile;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class PuTTYPrivateKeyProvider
implements SshPrivateKeyProvider {
    public boolean isFormatted(byte[] formattedkey) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(formattedkey)));
        try {
            String line = reader.readLine();
            return line != null && (line.startsWith("PuTTY-User-Key-File-3:") || line.startsWith("PuTTY-User-Key-File-2:") || line.equals("PuTTY-User-Key-File-1:"));
        }
        catch (IOException ex) {
            return false;
        }
    }

    public SshPrivateKeyFile create(byte[] formattedkey) throws IOException {
        if (!this.isFormatted(formattedkey)) {
            throw new IOException("Key is not formatted in the PuTTY key format!");
        }
        return new PuTTYPrivateKeyFile(formattedkey);
    }
}

