/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.sftp.files;

import com.sshtools.common.events.Event;
import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileRandomAccess;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.OpenFile;
import com.sshtools.common.util.UnsignedInteger32;
import java.io.IOException;

public class RandomAccessOpenFile
implements OpenFile {
    AbstractFile f;
    UnsignedInteger32 flags;
    boolean textMode = false;
    AbstractFileRandomAccess raf;
    boolean closed;
    byte[] handle;

    public RandomAccessOpenFile(AbstractFile f, UnsignedInteger32 flags, byte[] handle) throws IOException, PermissionDeniedException {
        this.f = f;
        this.flags = flags;
        this.handle = handle;
        this.raf = f.openFile((flags.intValue() & 2) != 0);
        boolean bl = this.textMode = (flags.intValue() & 0x40) != 0;
        if (this.isTextMode() && Log.isDebugEnabled()) {
            Log.debug((String)(f.getName() + " is being opened in TEXT mode"), (Object[])new Object[0]);
        }
    }

    @Override
    public boolean isTextMode() {
        return this.textMode;
    }

    @Override
    public void close() throws IOException {
        try {
            this.raf.close();
        }
        finally {
            this.raf = null;
        }
        this.closed = true;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException, PermissionDeniedException {
        if (this.closed) {
            return -1;
        }
        return this.raf.read(buf, off, len);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException, PermissionDeniedException {
        if (this.closed) {
            throw new IOException("File has been closed.");
        }
        this.raf.write(buf, off, len);
    }

    @Override
    public void seek(long longValue) throws IOException {
        if (this.closed) {
            throw new IOException("File has been closed [getOutputStream].");
        }
        this.raf.seek(longValue);
    }

    @Override
    public AbstractFile getFile() {
        return this.f;
    }

    @Override
    public UnsignedInteger32 getFlags() {
        return this.flags;
    }

    @Override
    public long getFilePointer() throws IOException {
        if (this.closed) {
            throw new IOException("File has been closed [getFilePointer].");
        }
        return this.raf.getFilePointer();
    }

    @Override
    public void processEvent(Event evt) {
        evt.addAttribute("ABSTRACT_FILE", this.f);
        evt.addAttribute("ABSTRACT_FILE_RAF", this.raf);
    }

    @Override
    public byte[] getHandle() {
        return this.handle;
    }
}

