/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.sftp.extensions;

import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.AbstractFileSystem;
import com.sshtools.common.sftp.InvalidHandleException;
import com.sshtools.common.sftp.SftpSubsystem;
import com.sshtools.common.sftp.extensions.AbstractSftpExtension;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.Digest;
import com.sshtools.common.ssh.components.jce.JCEComponentManager;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.UnsignedInteger32;
import com.sshtools.common.util.UnsignedInteger64;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractDigestExtension
extends AbstractSftpExtension {
    static final Map<String, String> ALGOS = new HashMap<String, String>();

    AbstractDigestExtension(String extensionName) {
        super(extensionName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] doHash(String algorithm, String filename, long startOffset, long length, SftpSubsystem sftp) throws FileNotFoundException, PermissionDeniedException, IOException, SshException, InvalidHandleException {
        AbstractFileSystem fs = sftp.getFileSystem();
        byte[] handle = fs.openFile(filename, new UnsignedInteger32(1L), null);
        try {
            byte[] byArray = this.doHash(algorithm, handle, startOffset, length, sftp);
            return byArray;
        }
        finally {
            fs.closeFile(handle);
            fs.freeHandle(handle);
        }
    }

    protected byte[] doHash(String algorithm, byte[] handle, long startOffset, long length, SftpSubsystem sftp) throws SshException, EOFException, InvalidHandleException, IOException, PermissionDeniedException {
        int read;
        byte[] tmp = new byte[32768];
        AbstractFileSystem fs = sftp.getFileSystem();
        Digest digest = JCEComponentManager.getInstance().supportedDigests().getInstance(ALGOS.get(algorithm));
        long total = 0L;
        do {
            if ((read = fs.readFile(handle, new UnsignedInteger64(startOffset), tmp, 0, length == 0L ? tmp.length : Math.min(tmp.length, (int)(length - total)))) > 0) {
                digest.putBytes(tmp, 0, read);
                total += (long)read;
                startOffset += (long)read;
                continue;
            }
            if (total != 0L) continue;
            throw new EOFException();
        } while (read > -1 && (length == 0L || total < length));
        return digest.doFinal();
    }

    @Override
    public boolean supportsExtendedMessage(int messageId) {
        return false;
    }

    @Override
    public void processExtendedMessage(ByteArrayReader msg, SftpSubsystem sftp) {
    }

    static {
        ALGOS.put("md5", "MD5");
        ALGOS.put("sha1", "SHA-1");
        ALGOS.put("sha256", "SHA-256");
        ALGOS.put("sha384", "SHA-384");
        ALGOS.put("sha512", "SHA-512");
    }
}

