/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh.components;

import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SecureComponent;
import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.ComponentManager;
import com.sshtools.common.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.Vector;

public class ComponentFactory<T>
implements Cloneable {
    protected Map<String, Class<? extends T>> supported = new HashMap<String, Class<? extends T>>();
    protected List<String> order = new ArrayList<String>();
    private boolean locked = false;
    private ComponentManager componentManager;

    public ComponentFactory(ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    public synchronized String changePositionofAlgorithm(String name, int position) throws SshException {
        int currentLocation;
        if (position < 0) {
            throw new SshException("index out of bounds", 4);
        }
        if (!this.contains(name)) {
            throw new SshException(String.format("%s is not a supported algorithm", name), 4);
        }
        if (position >= this.order.size()) {
            position = this.order.size();
        }
        if ((currentLocation = this.order.indexOf(name)) < position) {
            this.order.add(position, name);
            if (currentLocation > 0) {
                this.order.remove(currentLocation);
            }
        } else {
            this.order.remove(currentLocation);
            this.order.add(position, name);
        }
        return this.order.get(0);
    }

    public Collection<String> names() {
        return this.supported.keySet();
    }

    public synchronized String order(String[] ordering) throws SshException {
        Vector<String> newOrder = new Vector<String>();
        for (String alg : ordering) {
            if (!this.supported.containsKey(alg)) continue;
            newOrder.add(alg);
        }
        if (newOrder.size() == 0) {
            throw new SshException("No algorithms supported", 4);
        }
        this.order = newOrder;
        return this.order.get(0);
    }

    public synchronized String createNewOrdering(int[] ordering) throws SshException {
        int i;
        if (ordering.length > this.order.size()) {
            throw new SshException("too many indicies", 4);
        }
        for (i = 0; i < ordering.length; ++i) {
            if (ordering[i] < 0 || ordering[i] >= this.order.size()) {
                throw new SshException("index out of bounds", 4);
            }
            this.order.add(this.order.size(), this.order.get(ordering[i]));
        }
        Arrays.sort(ordering);
        for (i = ordering.length - 1; i >= 0; --i) {
            this.order.remove(ordering[i]);
        }
        for (i = 0; i < ordering.length; ++i) {
            String element = this.order.get(this.order.size() - 1);
            this.order.remove(this.order.size() - 1);
            this.order.add(0, element);
        }
        return this.order.get(0);
    }

    public boolean contains(String name) {
        return this.supported.containsKey(name);
    }

    public synchronized String list(String preferred, String ... ignores) {
        return this.createDelimitedList(preferred, ignores);
    }

    public synchronized String list(String preferred) {
        return this.createDelimitedList(preferred, new String[0]);
    }

    public synchronized void add(String name, Class<? extends T> cls) {
        if (this.locked) {
            throw new IllegalStateException("Component factory is locked. Components cannot be added");
        }
        this.supported.put(name, cls);
        if (!this.order.contains(name)) {
            this.order.add(name);
        }
    }

    public T getInstance(String name) throws SshException {
        if (this.supported.containsKey(name)) {
            try {
                return this.createInstance(name, this.supported.get(name));
            }
            catch (Throwable t) {
                throw new SshException(t.getMessage(), 5, t);
            }
        }
        throw new SshException(name + " is not supported", 7);
    }

    protected T createInstance(String name, Class<? extends T> cls) throws Throwable {
        return cls.newInstance();
    }

    private synchronized String createDelimitedList(String preferred, String ... ignores) {
        StringBuffer listBuf = new StringBuffer();
        int prefIndex = this.order.indexOf(preferred);
        if (prefIndex != -1 && !this.isDisabled(preferred)) {
            listBuf.append(preferred);
        }
        for (int i = 0; i < this.order.size(); ++i) {
            if (prefIndex == i || this.isDisabled(this.order.get(i))) continue;
            boolean ignoreItem = false;
            for (String ignore : ignores) {
                if (!this.order.get(i).equals(ignore)) continue;
                ignoreItem = true;
                break;
            }
            if (ignoreItem) continue;
            if (listBuf.length() > 0) {
                listBuf.append(",");
            }
            listBuf.append(this.order.get(i));
        }
        return listBuf.toString();
    }

    private boolean isDisabled(String alg) {
        return this.componentManager != null && this.componentManager.isDisabled(alg);
    }

    public synchronized void remove(String name) {
        this.order.remove(name);
    }

    public synchronized void clear() {
        if (this.locked) {
            throw new IllegalStateException("Component factory is locked. Removing all components renders it unusable");
        }
        this.supported.clear();
        this.order.clear();
    }

    public Object clone() {
        ComponentFactory<T> clone = new ComponentFactory<T>(this.componentManager);
        clone.order = new ArrayList<String>(this.order);
        clone.supported = new HashMap<String, Class<T>>(this.supported);
        return clone;
    }

    public String[] toArray() {
        return this.order.toArray(new String[this.order.size()]);
    }

    public synchronized void removeAllBut(String names) {
        StringTokenizer t = new StringTokenizer(names, ",");
        Vector<String> v = new Vector<String>();
        while (t.hasMoreTokens()) {
            String name = t.nextToken();
            if (!this.supported.containsKey(name)) continue;
            v.add(name);
        }
        for (String name : this.supported.keySet()) {
            if (v.contains(name)) continue;
            this.remove(name);
        }
    }

    public void lockComponents() {
        this.locked = true;
    }

    public void configureSecurityLevel(SecurityLevel securityLevel) throws SshException {
        ArrayList<SecureComponent> list = new ArrayList<SecureComponent>();
        for (String name : this.supported.keySet()) {
            SecureComponent o = (SecureComponent)this.getInstance(name);
            if (!Objects.nonNull(o)) continue;
            if (o.getSecurityLevel().ordinal() < securityLevel.ordinal()) {
                this.remove(name);
                continue;
            }
            list.add(o);
        }
        list.sort(new Comparator<SecureComponent>(){

            @Override
            public int compare(SecureComponent o1, SecureComponent o2) {
                return new Integer(o2.getPriority()).compareTo(o1.getPriority());
            }
        });
        Vector<String> newOrder = new Vector<String>();
        for (SecureComponent alg : list) {
            newOrder.add(alg.getAlgorithm());
        }
        if (newOrder.size() == 0) {
            throw new SshException("No algorithms supported", 4);
        }
        this.order = newOrder;
    }

    public String selectStrongestComponent(String[] remoteAlgs) throws SshException {
        HashMap<String, SecureComponent> list = new HashMap<String, SecureComponent>();
        for (String name : this.supported.keySet()) {
            SecureComponent o = (SecureComponent)this.getInstance(name);
            list.put(name, o);
        }
        SecureComponent strongest = null;
        for (String remoteAlg : remoteAlgs) {
            SecureComponent component = (SecureComponent)list.get(remoteAlg);
            if (!Objects.nonNull(component)) continue;
            if (Objects.isNull(strongest)) {
                strongest = component;
                continue;
            }
            if (new Integer(component.getPriority()).compareTo(strongest.getPriority()) <= 0) continue;
            strongest = component;
        }
        if (Objects.isNull(strongest)) {
            throw new SshException("Failed to negotiate component", 9);
        }
        if (Log.isInfoEnabled()) {
            Log.info((String)"Selecting strongest component {}", (Object[])new Object[]{strongest.getAlgorithm()});
        }
        return strongest.getAlgorithm();
    }

    public boolean hasComponents() {
        return !this.supported.isEmpty();
    }

    public Collection<String> order() {
        return this.order;
    }

    public String list() {
        return this.list("");
    }

    public String filter(String list, String ... ignores) {
        if (list == null) {
            return list;
        }
        Vector<String> newOrder = new Vector<String>();
        for (String alg : list.split(",")) {
            if (!this.supported.containsKey(alg)) continue;
            newOrder.add(alg);
        }
        return Utils.csv(newOrder);
    }
}

