/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.config;

import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.components.ComponentFactory;
import com.sshtools.common.util.IOUtils;
import com.sshtools.common.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdaptiveConfiguration {
    public static final String KEY_EXCHANGE = "kex";
    public static final String PUBLIC_KEYS = "publickeys";
    public static final String CIPHERS = "ciphers";
    public static final String MACS = "macs";
    public static final String COMPRESSION = "compressions";
    public static final String SCP_BUFFER_SIZE = "scp.bufferSize";
    public static final String SFTP_MAX_WINDOW_SPACE = "sftp.maxWindowSpace";
    public static final String SFTP_MIN_WINDOW_SPACE = "sftp.minWindowSpace";
    public static final String SESSION_MAX_WINDOW_SPACE = "ssh.maxWindowSpace";
    public static final String SOCKET_OPTION_KEEP_ALIVE = "tcp.keepAlive";
    public static final String SOCKET_OPTION_REUSE_ADDR = "tcp.reuseAddr";
    public static final String SOCKET_OPTION_SEND_BUFFER = "tcp.sendBuffer";
    public static final String SOCKET_OPTION_NO_DELAY = "tcp.noDelay";
    public static final String SOCKET_OPTION_RECV_BUFFER = "tcp.recvBuffer";
    public static final String SOCKET_OPTION_SO_LINGER = "tcp.soLinger";
    public static final String SOCKET_OPTION_LINGER_TIMEOUT = "tcp.lingerTimeout";
    private static Map<String, String> globalConfig = new HashMap<String, String>();
    private static Map<String, Map<String, String>> patternConfigs = new HashMap<String, Map<String, String>>();

    public static String createAlgorithmList(String supportedList, String key, String ident, String hostname, String ... ignores) {
        List<String> supported = Arrays.asList(supportedList.split("."));
        String locallist = AdaptiveConfiguration.getPatternConfig(key, ident);
        if (Utils.isBlank((String)locallist)) {
            locallist = AdaptiveConfiguration.getPatternConfig(key, hostname);
        }
        if (Utils.isBlank((String)locallist)) {
            locallist = AdaptiveConfiguration.getGlobalConfig(key);
        }
        if (Utils.isBlank((String)locallist)) {
            return supportedList;
        }
        ArrayList<String> results = new ArrayList<String>();
        for (String algorithm : locallist.split(",")) {
            if (!supported.contains(algorithm)) continue;
            results.add(algorithm);
        }
        return Utils.csv(results);
    }

    public static String createAlgorithmList(ComponentFactory<?> factory, String key, String contextPreference, String remoteIdentification, String hostname, String ... ignores) {
        String ident = AdaptiveConfiguration.getIdent(remoteIdentification);
        String locallist = factory.filter(AdaptiveConfiguration.getPatternConfig(key, ident), new String[0]);
        if (Utils.isBlank((String)locallist)) {
            locallist = factory.filter(AdaptiveConfiguration.getPatternConfig(key, hostname), new String[0]);
        }
        if (Utils.isBlank((String)locallist)) {
            locallist = factory.filter(AdaptiveConfiguration.getGlobalConfig(key), new String[0]);
        }
        if (Utils.isBlank((String)locallist)) {
            locallist = factory.list(contextPreference, ignores);
        }
        return locallist;
    }

    public static String getPatternConfig(String key, String ... values) {
        for (String value : values) {
            for (String pattern : patternConfigs.keySet()) {
                String result;
                if (!value.matches(pattern) || (result = patternConfigs.get(pattern).get(key)) == null) continue;
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Matched {} from pattern configuration {} [{}] with value {}", (Object[])new Object[]{key, value, pattern, result});
                }
                return result;
            }
            String result = AdaptiveConfiguration.getSystemProperty(AdaptiveConfiguration.formatKey(value, key));
            if (result == null) continue;
            return result;
        }
        return AdaptiveConfiguration.getGlobalConfig(key);
    }

    private static String formatKey(String key1, String key2) {
        StringBuilder str = new StringBuilder();
        str.append(key1);
        str.append(".");
        str.append(key2);
        return str.toString();
    }

    private static String getSystemProperty(String key) {
        String result = System.getProperty(key);
        if (result != null && Log.isDebugEnabled()) {
            Log.debug((String)"Matched {} from system property with value {}", (Object[])new Object[]{key, result});
        }
        return result;
    }

    public static void setPatternConfig(String pattern, String key, String val) {
        if (!patternConfigs.containsKey(pattern)) {
            patternConfigs.put(pattern, new HashMap());
        }
        patternConfigs.get(pattern).put(key, val);
    }

    public static String getGlobalConfig(String key) {
        String result = globalConfig.get(key);
        if (result != null) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Matched {} from global configuration with value {}", (Object[])new Object[]{key, result});
            }
            return result;
        }
        return AdaptiveConfiguration.getSystemProperty(AdaptiveConfiguration.formatKey("maverick", key));
    }

    public static void setGlobalConfig(String key, String val) {
        globalConfig.put(key, val);
    }

    public static String getIdent(String remoteIdentification) {
        String ident = remoteIdentification.substring(8);
        int idx = ident.indexOf(32);
        if (idx > -1) {
            ident = ident.substring(0, idx);
        }
        return ident;
    }

    public static boolean getBoolean(String key, String ... match) {
        String result = AdaptiveConfiguration.getPatternConfig(key, match);
        if (result == null) {
            return AdaptiveConfiguration.getBoolean(key);
        }
        return Boolean.parseBoolean(result);
    }

    public static boolean getBoolean(String key) {
        return Boolean.parseBoolean(AdaptiveConfiguration.getGlobalConfig(key));
    }

    public static void setBoolean(String key, String pattern) {
        AdaptiveConfiguration.setPatternConfig(pattern, key, Boolean.TRUE.toString());
    }

    public static void setBoolean(String key, String pattern, Boolean val) {
        AdaptiveConfiguration.setPatternConfig(pattern, key, val.toString());
    }

    public static void setBoolean(String key, Boolean value) {
        AdaptiveConfiguration.setGlobalConfig(key, value.toString());
    }

    public static long getLong(String key) {
        return Long.parseLong(AdaptiveConfiguration.getGlobalConfig(key));
    }

    public static boolean getBooleanOrDefault(String key, boolean defaultValue) {
        String result = AdaptiveConfiguration.getGlobalConfig(key);
        if (result != null) {
            return Boolean.parseBoolean(result);
        }
        return defaultValue;
    }

    public static long getByteSizeOrDefault(String key, String defaultValue) {
        String result = AdaptiveConfiguration.getGlobalConfig(key);
        if (result != null) {
            return IOUtils.fromByteSize((String)result);
        }
        return IOUtils.fromByteSize((String)defaultValue);
    }

    public static int getIntOrDefault(String key, int defaultValue) {
        String result = AdaptiveConfiguration.getGlobalConfig(key);
        if (result != null) {
            return Integer.parseInt(result);
        }
        return defaultValue;
    }
}

