/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.sftp;

import com.sshtools.common.events.Event;
import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.AbstractFileRandomAccess;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.policy.FileSystemPolicy;
import com.sshtools.common.sftp.FileIsDirectoryException;
import com.sshtools.common.sftp.InvalidHandleException;
import com.sshtools.common.sftp.SftpFile;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.common.sftp.SftpFileFilter;
import com.sshtools.common.sftp.UnsupportedFileOperationException;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshIOException;
import com.sshtools.common.util.FileUtils;
import com.sshtools.common.util.UnsignedInteger32;
import com.sshtools.common.util.UnsignedInteger64;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public final class AbstractFileSystem {
    public static final int OPEN_READ = 1;
    public static final int OPEN_WRITE = 2;
    public static final int OPEN_APPEND = 4;
    public static final int OPEN_CREATE = 8;
    public static final int OPEN_TRUNCATE = 16;
    public static final int OPEN_EXCLUSIVE = 32;
    public static final int OPEN_TEXT = 64;
    public static final String AUTHORIZED_KEYS_STORE = "authorized_keys";
    public static final String SFTP = "sftp";
    public static final String SCP = "scp";
    public static final String SHELL = "shell";
    protected Map<String, OpenFile> openFiles = new ConcurrentHashMap<String, OpenFile>(8, 0.9f, 1);
    protected Map<String, OpenDirectory> openDirectories = new ConcurrentHashMap<String, OpenDirectory>(8, 0.9f, 1);
    protected AbstractFileFactory<?> fileFactory;
    static Set<String> defaultPaths = new HashSet<String>(Arrays.asList("", ".", "./"));
    final SshConnection con;
    final String protocolInUse;

    public AbstractFileSystem(SshConnection con, String protocolInUse) throws IOException, PermissionDeniedException {
        this.fileFactory = con.getContext().getPolicy(FileSystemPolicy.class).getFileFactory().getFileFactory(con);
        this.con = con;
        this.protocolInUse = protocolInUse;
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Completed Abstract File System Initialization", (Object[])new Object[0]);
        }
    }

    public AbstractFileFactory<?> getFileFactory() {
        return this.fileFactory;
    }

    public void init(SshConnection con, String protocolInUse) {
    }

    protected AbstractFile resolveFile(String path, SshConnection con) throws PermissionDeniedException, IOException {
        if (Objects.isNull(this.fileFactory)) {
            throw new PermissionDeniedException("The user does not have access to a file system.");
        }
        if (defaultPaths.contains(path)) {
            return this.fileFactory.getDefaultPath();
        }
        return this.fileFactory.getFile(path);
    }

    public void closeFilesystem() {
        String obj;
        Iterator<String> it = this.openFiles.keySet().iterator();
        while (it.hasNext()) {
            block6: {
                obj = it.next();
                try {
                    this.closeFile(obj, false);
                }
                catch (Exception ex) {
                    if (!Log.isErrorEnabled()) break block6;
                    Log.error((String)"Error closing file", (Throwable)ex, (Object[])new Object[0]);
                }
            }
            it.remove();
        }
        it = this.openDirectories.keySet().iterator();
        while (it.hasNext()) {
            block7: {
                obj = it.next();
                try {
                    this.closeFile(obj, false);
                }
                catch (Exception ex) {
                    if (!Log.isErrorEnabled()) break block7;
                    Log.error((String)"Error closing directory", (Throwable)ex, (Object[])new Object[0]);
                }
            }
            it.remove();
        }
    }

    public boolean makeDirectory(String path, SftpFileAttributes attrs) throws PermissionDeniedException, FileNotFoundException, IOException {
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Creating directory " + path), (Object[])new Object[0]);
        }
        if (path.equals("/")) {
            throw new PermissionDeniedException("Unable to create root file");
        }
        String parentPath = FileUtils.getParentPath((String)path);
        AbstractFile parent = this.resolveFile(parentPath, this.con);
        if (!parent.isWritable()) {
            throw new PermissionDeniedException("The user does not have permission to write/create in " + parentPath);
        }
        if (this.getConnection().getContext().getPolicy(FileSystemPolicy.class).isMkdirParentMustExist() && !parent.exists()) {
            throw new FileNotFoundException("The parent folder does not exist!");
        }
        AbstractFile f = this.resolveFile(path, this.con);
        if (f.createFolder()) {
            f.setAttributes(attrs);
            boolean exists = f.exists();
            return exists;
        }
        return false;
    }

    public SftpFileAttributes getFileAttributes(byte[] handle) throws IOException, InvalidHandleException, PermissionDeniedException {
        String shandle = this.getHandle(handle);
        if (this.openFiles.containsKey(shandle)) {
            OpenFile f = this.openFiles.get(shandle);
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Getting file attributes for " + f.getFile().getAbsolutePath()), (Object[])new Object[0]);
            }
            return f.getFile().getAttributes();
        }
        throw new InvalidHandleException("The handle is invalid 1");
    }

    public SftpFileAttributes getFileAttributes(String path) throws IOException, FileNotFoundException, PermissionDeniedException {
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Getting file attributes for " + path), (Object[])new Object[0]);
        }
        AbstractFile f = this.resolveFile(path, this.con);
        return f.getAttributes();
    }

    public byte[] openDirectory(String path) throws PermissionDeniedException, FileNotFoundException, IOException {
        return this.openDirectory(path, null);
    }

    public byte[] openDirectory(String path, SftpFileFilter filter) throws PermissionDeniedException, FileNotFoundException, IOException {
        AbstractFile f;
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Opening directory for " + path), (Object[])new Object[0]);
        }
        if (!(f = this.resolveFile(path, this.con)).isReadable()) {
            throw new PermissionDeniedException("The user does not have permission to read " + path);
        }
        if (f.exists()) {
            if (f.isDirectory()) {
                byte[] handle = this.createHandle();
                this.openDirectories.put(this.getHandle(handle), new OpenDirectory(f, filter));
                return handle;
            }
            throw new IOException(path + " is not a directory");
        }
        throw new FileNotFoundException(path + " does not exist");
    }

    private byte[] createHandle() throws UnsupportedEncodingException, IOException, SshIOException {
        return UUID.randomUUID().toString().getBytes("UTF-8");
    }

    protected byte[] getHandle(String handle) {
        try {
            return handle.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Your system appears not to support UTF-8!");
        }
    }

    protected String getHandle(byte[] b) {
        try {
            return new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Your system appears not to support UTF-8!");
        }
    }

    public SftpFile[] readDirectory(byte[] handle) throws InvalidHandleException, EOFException, IOException, PermissionDeniedException {
        String shandle = this.getHandle(handle);
        if (this.openDirectories.containsKey(shandle)) {
            OpenDirectory dir = this.openDirectories.get(shandle);
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Read directory for " + dir.getFile().getAbsolutePath()), (Object[])new Object[0]);
            }
            int pos = dir.getPosition();
            AbstractFile[] children = dir.getChildren();
            if (dir.children == null) {
                throw new IOException("Permission denined.");
            }
            Vector<SftpFile> files = new Vector<SftpFile>();
            while (files.size() < 100 && pos < children.length) {
                AbstractFile f = children[pos++];
                if (dir.getFilter() != null && !dir.getFilter().matches(f.getName())) continue;
                try {
                    SftpFile sftpfile = new SftpFile(f.getName(), f.getAttributes());
                    files.add(sftpfile);
                }
                catch (PermissionDeniedException | IOException e) {
                    Log.debug((String)"Could not access attributes of file {}", (Throwable)e, (Object[])new Object[]{f.getName()});
                }
            }
            dir.readpos = pos;
            if (files.size() > 0) {
                Object[] sf = new SftpFile[files.size()];
                files.copyInto(sf);
                return sf;
            }
            throw new EOFException("There are no more files");
        }
        throw new InvalidHandleException("Handle is not an open directory");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] openFile(String path, UnsignedInteger32 flags, SftpFileAttributes attrs) throws PermissionDeniedException, FileNotFoundException, IOException {
        AbstractFile f;
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Opening file for " + path), (Object[])new Object[0]);
        }
        if ((f = this.resolveFile(path, this.con)).isDirectory()) {
            throw new PermissionDeniedException("File cannot be opened as it is a Directory");
        }
        if (f.exists() && !f.isReadable() && (flags.intValue() & 1) != 0) {
            throw new PermissionDeniedException("The user does not have permission to read.");
        }
        if (!((flags.intValue() & 2) == 0 && (flags.longValue() & 8L) == 0L || f.isWritable())) {
            throw new PermissionDeniedException("The user does not have permission to write/create.");
        }
        if (!f.exists()) {
            if ((flags.longValue() & 8L) != 8L) throw new FileNotFoundException(path + " does not exist");
            if (!f.createNewFile()) {
                throw new IOException(path + " could not be created");
            }
        } else if ((flags.longValue() & 8L) == 8L && (flags.longValue() & 0x20L) == 32L) {
            throw new IOException(path + " already exists");
        }
        if ((flags.longValue() & 8L) == 8L && (flags.longValue() & 0x10L) == 16L) {
            f.truncate();
        }
        byte[] handle = this.createHandle();
        this.openFiles.put(this.getHandle(handle), new OpenFile(f, flags));
        return handle;
    }

    public int readFile(byte[] handle, UnsignedInteger64 offset, byte[] buf, int start, int numBytesToRead) throws InvalidHandleException, EOFException, IOException, PermissionDeniedException {
        String shandle = this.getHandle(handle);
        if (this.openFiles.containsKey(shandle)) {
            OpenFile file = this.openFiles.get(shandle);
            if ((file.getFlags().longValue() & 1L) == 1L) {
                int read;
                if (!file.isTextMode() && file.getFilePointer() != offset.longValue()) {
                    file.seek(offset.longValue());
                }
                if ((read = file.read(buf, start, numBytesToRead)) >= 0) {
                    return read;
                }
                return -1;
            }
            throw new InvalidHandleException("The file handle was not opened for reading");
        }
        throw new InvalidHandleException("The handle is invalid 2");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeFile(byte[] handle, UnsignedInteger64 offset, byte[] data, int off, int len) throws InvalidHandleException, IOException, PermissionDeniedException {
        String shandle = this.getHandle(handle);
        if (!this.openFiles.containsKey(shandle)) throw new InvalidHandleException("The handle is invalid 3");
        OpenFile file = this.openFiles.get(shandle);
        if ((file.getFlags().longValue() & 2L) != 2L) throw new InvalidHandleException("The file was not opened for writing");
        if ((file.getFlags().longValue() & 4L) == 4L) {
            file.seek(file.getFile().length());
        } else if (!file.isTextMode() && file.getFilePointer() != offset.longValue()) {
            file.seek(offset.longValue());
        }
        file.write(data, off, len);
    }

    public void closeFile(byte[] handle) throws InvalidHandleException, IOException {
        this.closeFile(handle, true);
    }

    public boolean closeFile(byte[] handle, boolean remove) throws InvalidHandleException, IOException {
        return this.closeFile(this.getHandle(handle), remove);
    }

    protected boolean closeFile(String handle, boolean remove) throws InvalidHandleException, IOException {
        OpenDirectory dir = this.openDirectories.get(handle);
        if (dir != null) {
            this.openDirectories.remove(handle);
        } else {
            OpenFile file = this.openFiles.get(handle);
            if (file == null) {
                throw new InvalidHandleException(handle + " is an invalid handle");
            }
            file.close();
            if (remove) {
                this.openFiles.remove(handle);
            } else {
                return true;
            }
        }
        return false;
    }

    public void removeFile(String path) throws PermissionDeniedException, IOException, FileNotFoundException {
        block6: {
            AbstractFile f = this.resolveFile(path, this.con);
            if (!f.isWritable()) {
                throw new PermissionDeniedException("User does not have the permission to delete.");
            }
            if (f.exists()) {
                try {
                    if (f.isFile()) {
                        if (!f.delete(false)) {
                            throw new IOException("Failed to delete " + path);
                        }
                        break block6;
                    }
                    throw new FileIsDirectoryException(path + " is a directory, use remove directory command to remove");
                }
                catch (SecurityException se) {
                    throw new PermissionDeniedException("Permission denied");
                }
            }
            throw new FileNotFoundException(path + " does not exist");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void renameFile(String oldpath, String newpath) throws PermissionDeniedException, FileNotFoundException, IOException {
        Object f1 = this.fileFactory.getFile(oldpath);
        Object f2 = this.fileFactory.getFile(newpath);
        if (!f1.isWritable()) {
            throw new PermissionDeniedException("User does not have permission to change " + oldpath);
        }
        if (!f2.isWritable()) {
            throw new PermissionDeniedException("User does not have permission to write " + newpath);
        }
        if (!f1.exists()) throw new FileNotFoundException(oldpath + " does not exist");
        if (!f2.exists()) {
            f1.moveTo((AbstractFile)f2);
            return;
        } else {
            if (!f2.isDirectory() || !Boolean.getBoolean("maverick.enableRenameIntoDir")) throw new IOException(newpath + " already exists");
            if ((f2 = this.fileFactory.getFile(FileUtils.checkEndsWithSlash((String)f2.getAbsolutePath()) + f1.getName())).exists()) {
                throw new IOException(newpath + " already exists");
            }
            f1.moveTo((AbstractFile)f2);
        }
    }

    public void copyFile(String oldpath, String newpath, boolean overwrite) throws PermissionDeniedException, FileNotFoundException, IOException {
        Object f1 = this.fileFactory.getFile(oldpath);
        Object f2 = this.fileFactory.getFile(newpath);
        if (!f1.exists()) {
            throw new FileNotFoundException(oldpath + " does not exist");
        }
        if (f2.exists() && f2.isDirectory()) {
            f2 = this.fileFactory.getFile(FileUtils.checkEndsWithSlash((String)f2.getAbsolutePath()) + f1.getName());
        }
        if (f2.exists() && !overwrite) {
            throw new PermissionDeniedException("File already exists " + newpath);
        }
        if (f2.exists() && !f2.isWritable()) {
            throw new PermissionDeniedException("User does not have permission to write " + newpath);
        }
        f2.copyFrom((AbstractFile)f1);
    }

    public String getDefaultPath() throws IOException, PermissionDeniedException {
        return this.fileFactory.getDefaultPath().getCanonicalPath();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeDirectory(String path) throws PermissionDeniedException, FileNotFoundException, IOException {
        AbstractFile f = this.resolveFile(path, this.con);
        if (!f.isWritable()) {
            throw new PermissionDeniedException("User does not have the permission to write.");
        }
        if (!f.isDirectory()) throw new IOException(path + " is not a directory");
        if (!f.exists()) throw new FileNotFoundException(path + " does not exist");
        if (f.getChildren().size() != 0) throw new IOException(path + " is not an empty directory");
        if (f.delete(false)) return;
        throw new IOException("Failed to remove directory " + path);
    }

    public void setFileAttributes(String path, SftpFileAttributes attrs) throws PermissionDeniedException, IOException, FileNotFoundException {
        AbstractFile f = this.resolveFile(path, this.con);
        f.setAttributes(attrs);
    }

    public void setFileAttributes(byte[] handle, SftpFileAttributes attrs) throws PermissionDeniedException, IOException, InvalidHandleException {
        String shandle = this.getHandle(handle);
        if (this.openFiles.containsKey(shandle)) {
            OpenFile f = this.openFiles.get(shandle);
            f.getFile().setAttributes(attrs);
        } else if (this.openDirectories.containsKey(shandle)) {
            OpenDirectory dir = this.openDirectories.get(shandle);
            dir.getFile().setAttributes(attrs);
        } else {
            throw new InvalidHandleException(shandle);
        }
    }

    public SftpFile readSymbolicLink(String link) throws UnsupportedFileOperationException, FileNotFoundException, IOException, PermissionDeniedException {
        try {
            String linkTarget = this.resolveFile(link, this.con).readSymbolicLink();
            AbstractFile f = this.resolveFile(linkTarget, this.con);
            SftpFileAttributes a = f.getAttributes();
            return new SftpFile(linkTarget, a);
        }
        catch (UnsupportedOperationException uoe) {
            throw new UnsupportedFileOperationException("Symbolic links are not supported by the Virtual File System");
        }
    }

    public void createSymbolicLink(String link, String target) throws UnsupportedFileOperationException, FileNotFoundException, IOException, PermissionDeniedException {
        try {
            this.resolveFile(link, this.con).symlinkTo(target);
        }
        catch (UnsupportedOperationException uoe) {
            throw new UnsupportedFileOperationException("Symbolic links are not supported by the Virtual File System");
        }
    }

    public boolean fileExists(String path) throws IOException, PermissionDeniedException {
        try {
            AbstractFile f = this.resolveFile(path, this.con);
            return f.exists();
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
    }

    public String getRealPath(String path) throws IOException, FileNotFoundException, PermissionDeniedException {
        AbstractFile f = this.resolveFile(path, this.con);
        return f.getCanonicalPath();
    }

    public AbstractFile getFileForHandle(byte[] handle) throws IOException, InvalidHandleException {
        if (!this.openFiles.containsKey(this.getHandle(handle))) {
            throw new InvalidHandleException("Invalid handle passed to getFileForHandle");
        }
        return this.openFiles.get(this.getHandle(handle)).getFile();
    }

    public void populateEvent(Event evt) {
        OpenFile openFile;
        if (Objects.isNull(this.fileFactory)) {
            return;
        }
        evt.addAttribute("FILE_FACTORY", this.fileFactory);
        evt.addAttribute("CONNECTION", this.con);
        byte[] handle = (byte[])evt.getAttribute("HANDLE");
        if (handle != null && (openFile = this.openFiles.get(this.getHandle(handle))) != null) {
            if (openFile.f != null) {
                evt.addAttribute("ABSTRACT_FILE", openFile.f);
            }
            if (openFile.in != null) {
                evt.addAttribute("ABSTRACT_FILE_IN", openFile.in);
            }
            if (openFile.out != null) {
                evt.addAttribute("ABSTRACT_FILE_OUT", openFile.out);
            }
            if (openFile.raf != null) {
                evt.addAttribute("ABSTRACT_FILE_RAF", openFile.raf);
            }
        }
        this.fileFactory.populateEvent(evt);
    }

    public SshConnection getConnection() {
        return this.con;
    }

    public String getPathForHandle(byte[] handle) throws IOException, InvalidHandleException {
        String h = this.getHandle(handle);
        try {
            if (this.openFiles.containsKey(h)) {
                return this.openFiles.get(h).getFile().getAbsolutePath();
            }
            if (this.openDirectories.containsKey(h)) {
                return this.openDirectories.get(h).getFile().getAbsolutePath();
            }
        }
        catch (PermissionDeniedException e) {
            Log.error((String)"Permission denied in getPathForHandle!", (Throwable)e, (Object[])new Object[0]);
        }
        throw new InvalidHandleException("Invalid handle");
    }

    protected class OpenDirectory {
        AbstractFile f;
        AbstractFile[] children;
        int readpos = 0;
        SftpFileFilter filter;

        public OpenDirectory(AbstractFile f, SftpFileFilter filter) throws IOException, PermissionDeniedException {
            this.f = f;
            this.filter = filter;
            this.children = f.getChildren().toArray(new AbstractFile[0]);
        }

        public AbstractFile getFile() {
            return this.f;
        }

        public AbstractFile[] getChildren() throws IOException, PermissionDeniedException {
            return this.children;
        }

        public int getPosition() {
            return this.readpos;
        }

        public SftpFileFilter getFilter() {
            return this.filter;
        }

        public void setPosition(int readpos) {
            this.readpos = readpos;
        }
    }

    protected class OpenFile {
        AbstractFile f;
        UnsignedInteger32 flags;
        long filePointer;
        boolean textMode = false;
        InputStream in;
        OutputStream out;
        AbstractFileRandomAccess raf;
        boolean closed;

        public OpenFile(AbstractFile f, UnsignedInteger32 flags) throws IOException, PermissionDeniedException {
            this.f = f;
            this.flags = flags;
            if (f.supportsRandomAccess()) {
                this.raf = f.openFile((flags.intValue() & 2) != 0);
            }
            boolean bl = this.textMode = (flags.intValue() & 0x40) != 0;
            if (this.isTextMode() && Log.isDebugEnabled()) {
                Log.debug((String)(f.getName() + " is being opened in TEXT mode"), (Object[])new Object[0]);
            }
        }

        public boolean isTextMode() {
            return this.textMode;
        }

        public void close() throws IOException {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                finally {
                    this.in = null;
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                finally {
                    this.out = null;
                }
            }
            if (this.raf != null) {
                try {
                    this.raf.close();
                }
                finally {
                    this.raf = null;
                }
            }
            this.closed = true;
        }

        public int read(byte[] buf, int off, int len) throws IOException, PermissionDeniedException {
            if (this.closed) {
                return -1;
            }
            if (this.raf == null) {
                int count;
                int r;
                if (this.filePointer == -1L) {
                    return -1;
                }
                InputStream in = this.getInputStream();
                for (count = 0; count < len; count += r) {
                    r = in.read(buf, off + count, len - count);
                    if (r == -1) {
                        if (count == 0) {
                            this.filePointer = -1L;
                            return -1;
                        }
                        return count;
                    }
                    this.filePointer += (long)r;
                }
                return count;
            }
            return this.raf.read(buf, off, len);
        }

        public void write(byte[] buf, int off, int len) throws IOException, PermissionDeniedException {
            if (this.closed) {
                throw new IOException("File has been closed.");
            }
            if (this.raf == null) {
                if (this.filePointer == -1L) {
                    throw new IOException("File is EOF");
                }
                OutputStream out = this.getOutputStream();
                out.write(buf, off, len);
                this.filePointer += (long)len;
            } else {
                this.raf.write(buf, off, len);
            }
        }

        private OutputStream getOutputStream() throws IOException, PermissionDeniedException {
            if (this.closed) {
                throw new IOException("File has been closed [getOutputStream].");
            }
            if (this.out == null) {
                this.out = this.f.getOutputStream();
            }
            return this.out;
        }

        private InputStream getInputStream() throws IOException, PermissionDeniedException {
            if (this.closed) {
                throw new IOException("File has been closed [getInputStream].");
            }
            if (this.in == null) {
                this.in = this.f.getInputStream();
            }
            return this.in;
        }

        public void seek(long longValue) throws IOException {
            if (this.closed) {
                throw new IOException("File has been closed [getOutputStream].");
            }
            if (this.raf == null) {
                this.filePointer = -1L;
                return;
            }
            this.raf.seek(longValue);
        }

        public AbstractFile getFile() {
            return this.f;
        }

        public UnsignedInteger32 getFlags() {
            return this.flags;
        }

        public long getFilePointer() throws IOException {
            if (this.closed) {
                throw new IOException("File has been closed [getFilePointer].");
            }
            return this.raf == null ? this.filePointer : this.raf.getFilePointer();
        }
    }
}

