/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh;

import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.Context;
import com.sshtools.common.ssh.ExecutorOperationSupport;
import com.sshtools.common.ssh.Packet;
import com.sshtools.common.ssh.SessionChannel;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.util.ByteBufferPool;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class Subsystem {
    protected SessionChannel session;
    protected Context context;
    String name;
    ByteBuffer buffer;
    int message_length = -1;
    int maximumPacketSize = 0;
    ByteBufferPool bufferPool;
    boolean shutdown = false;
    int bytesSinceLastWindowIssue = 0;

    public Subsystem(String name) {
        this.name = name;
    }

    public Context getContext() {
        return this.session.getConnection().getContext();
    }

    public SshConnection getConnection() {
        return this.session.getConnection();
    }

    public SessionChannel getSession() {
        return this.session;
    }

    public void init(SessionChannel session, Context context) throws IOException, PermissionDeniedException {
        this.bufferPool = context.getByteBufferPool();
        this.session = session;
        this.context = context;
        session.haltIncomingData();
    }

    protected void executeOperation(Integer messageQueue, ConnectionAwareTask r) {
        this.session.getConnection().addTask(messageQueue, r);
    }

    protected synchronized void cleanup() {
        if (!this.shutdown) {
            this.session.getConnection().addTask(ExecutorOperationSupport.EVENTS, new ConnectionAwareTask(this.session.getConnection()){

                @Override
                public void doTask() {
                    if (Log.isTraceEnabled()) {
                        Log.trace((String)"Cleaning up operations", (Object[])new Object[0]);
                    }
                    Subsystem.this.cleanupSubsystem();
                    Subsystem.this.session.close();
                }
            });
            this.shutdown = true;
        }
    }

    protected abstract void cleanupSubsystem();

    public void processMessage(ByteBuffer data) throws IOException {
        this.parseMessage(data);
    }

    protected void parseMessage(ByteBuffer data) throws IOException {
        if (this.session.isClosed()) {
            throw new IOException("Session is closed");
        }
        if (this.buffer == null) {
            this.buffer = this.bufferPool.get();
        }
        if (Log.isTraceEnabled()) {
            Log.trace((String)("Buffer has " + this.buffer.remaining() + " bytes remaining of " + this.buffer.capacity()), (Object[])new Object[0]);
        }
        if (Log.isTraceEnabled()) {
            Log.trace((String)("Processing " + data.remaining() + " bytes of data"), (Object[])new Object[0]);
        }
        this.buffer(data, false);
        do {
            if (Log.isTraceEnabled()) {
                Log.trace((String)("Buffer has remaining=" + this.buffer.remaining() + " messagLength=" + this.message_length + " data=" + data.remaining()), (Object[])new Object[0]);
            }
            if (this.message_length == -1 && this.buffer.remaining() >= 4) {
                this.message_length = this.buffer.getInt();
                if (Log.isTraceEnabled()) {
                    Log.trace((String)("Expecting subsystem packet length " + this.message_length), (Object[])new Object[0]);
                }
                this.buffer(data, true);
                if (this.message_length < 0 || this.message_length > this.context.getMaximumPacketLength() - 4) {
                    if (Log.isErrorEnabled()) {
                        Log.error((String)("Incoming subsystem message length " + this.message_length + " exceeds maximum supported packet length " + this.context.getMaximumPacketLength()), (Object[])new Object[0]);
                    }
                    this.session.getConnection().disconnect("Protocol error");
                    return;
                }
            }
            while (this.message_length >= 0 && this.buffer.remaining() >= this.message_length) {
                if (this.message_length > 0) {
                    byte[] msg = new byte[this.message_length];
                    this.buffer.get(msg);
                    this.session.getConnection().addTask(ExecutorOperationSupport.EVENTS, new ProcessMessageOperation(msg));
                    this.buffer(data, true);
                } else {
                    Log.warn((String)"Received zero length message in SFTP subsystem!!", (Object[])new Object[0]);
                }
                if (this.buffer.remaining() >= 4) {
                    this.message_length = this.buffer.getInt();
                    this.buffer(data, true);
                    continue;
                }
                this.message_length = -1;
            }
        } while (data.hasRemaining());
        if (!this.buffer.hasRemaining()) {
            this.bufferPool.add(this.buffer);
            this.buffer = null;
        } else {
            this.buffer.compact();
        }
    }

    private void buffer(ByteBuffer data, boolean compact) {
        boolean flip = false;
        if (compact) {
            this.buffer.compact();
            flip = true;
        }
        if (data.hasRemaining() && this.buffer.hasRemaining()) {
            int length = Math.min(this.buffer.remaining(), data.remaining());
            ByteBuffer slice = data.slice();
            slice.limit(length);
            this.buffer.put(slice);
            data.position(data.position() + length);
            flip = true;
        }
        if (flip) {
            this.buffer.flip();
        }
    }

    public void free() {
        if (Log.isTraceEnabled()) {
            Log.trace((String)("Cleaning up " + this.name + " subsystem references"), (Object[])new Object[0]);
        }
        this.onSubsystemFree();
        this.cleanup();
        if (this.buffer != null) {
            this.bufferPool.add(this.buffer);
        }
        this.buffer = null;
    }

    protected abstract void onSubsystemFree();

    protected abstract void onMessageReceived(byte[] var1) throws IOException;

    public void sendMessage(Packet packet) throws IOException {
        if (this.session.isClosed()) {
            throw new IOException("Failed to send subsystem packet, session closed");
        }
        if (Log.isTraceEnabled()) {
            Log.trace((String)("Sending subsystem packet of " + packet.size() + " bytes"), (Object[])new Object[0]);
        }
        packet.finish();
        this.session.sendData(packet.array(), 0, packet.size());
    }

    public void onFreeMessage(byte[] msg) {
        if (this.maximumPacketSize < msg.length + 4) {
            this.maximumPacketSize = msg.length + 4;
        }
        this.bytesSinceLastWindowIssue += msg.length + 4;
        int threshold = Math.min(this.session.getMaximumWindowSpace() - this.session.getMinimumWindowSpace(), this.session.getMaximumWindowSpace() - Math.max(this.session.getLocalPacket(), this.maximumPacketSize) * 2);
        if (this.bytesSinceLastWindowIssue >= threshold) {
            this.session.sendWindowAdjust(this.bytesSinceLastWindowIssue);
            this.bytesSinceLastWindowIssue = 0;
        }
    }

    class ProcessMessageOperation
    extends ConnectionAwareTask {
        byte[] msg;

        ProcessMessageOperation(byte[] msg) {
            super(Subsystem.this.session.getConnection());
            this.msg = msg;
        }

        @Override
        protected void doTask() {
            try {
                Subsystem.this.onMessageReceived(this.msg);
            }
            catch (IOException e) {
                Log.error((String)"Failed to process SFTP message", (Throwable)e, (Object[])new Object[0]);
                Subsystem.this.cleanup();
            }
        }
    }
}

