/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh.components.jce;

import com.sshtools.common.logger.Log;
import com.sshtools.common.publickey.SshPublicKeyFileFactory;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.SshKeyFingerprint;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.jce.JCEComponentManager;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.common.util.UnsignedInteger64;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class OpenSshCertificate
implements SshPublicKey {
    public static final int SSH_CERT_TYPE_USER = 1;
    public static final int SSH_CERT_TYPE_HOST = 2;
    public static final String PERMIT_X11_FORWARDING = "permit-x11-forwarding";
    public static final String PERMIT_PORT_FORWARDING = "permit-port-forwarding";
    public static final String PERMIT_AGENT_FORWARDING = "permit-agent-forwarding";
    public static final String PERMIT_USER_PTY = "permit-pty";
    public static final String PERMIT_USER_RC = "permit-user-rc";
    public static final String OPTION_FORCE_COMMAND = "force-command";
    public static final String OPTION_SOURCE_ADDRESS = "source-address";
    SshPublicKey publicKey;
    byte[] nonce;
    UnsignedInteger64 serial;
    int type;
    String keyId;
    List<String> validPrincipals = new ArrayList<String>();
    UnsignedInteger64 validAfter;
    UnsignedInteger64 validBefore;
    List<String> optionsOrder = new ArrayList<String>();
    Map<String, String> criticalOptions = new HashMap<String, String>();
    List<String> extensionOrder = new ArrayList<String>();
    Map<String, String> extensions = new HashMap<String, String>();
    String reserved;
    SshPublicKey signedBy;
    byte[] signature;

    @Override
    public String getEncodingAlgorithm() {
        return this.getAlgorithm();
    }

    public boolean isUserCertificate() {
        return this.type == 1;
    }

    public boolean isHostCertificate() {
        return this.type == 2;
    }

    public SshPublicKey getSignedKey() {
        return this.publicKey;
    }

    @Override
    public final String getFingerprint() throws SshException {
        return SshKeyFingerprint.getFingerprint(this.getSignedKey().getEncoded());
    }

    @Override
    public void init(byte[] blob, int start, int len) throws SshException {
        try (ByteArrayReader bar = new ByteArrayReader(blob, start, len);){
            String header = bar.readString();
            if (!header.equals(this.getAlgorithm())) {
                throw new SshException("The encoded key is not DSA", 5);
            }
            this.nonce = bar.readBinaryString();
            this.decodePublicKey(bar);
            this.decodeCertificate(bar);
        }
    }

    @Override
    public byte[] getEncoded() throws SshException {
        ByteArrayWriter blob = new ByteArrayWriter();
        try {
            blob.writeString(this.getEncodingAlgorithm());
            blob.writeBinaryString(this.nonce);
            ByteArrayReader reader = new ByteArrayReader(this.getSignedKey().getEncoded());
            reader.readString();
            blob.write(reader.array(), reader.getPosition(), reader.available());
            reader.close();
            this.encodeCertificate(blob);
            this.encodeSignature(blob);
            byte[] byArray = blob.toByteArray();
            return byArray;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new SshException("Failed to encode public key", 5);
        }
        finally {
            try {
                blob.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void encodeSignature(ByteArrayWriter writer) throws IOException {
        writer.writeBinaryString(this.signature);
    }

    protected abstract void decodePublicKey(ByteArrayReader var1) throws IOException, SshException;

    protected void encodeCertificate(ByteArrayWriter writer) throws IOException, SshException {
        writer.writeUINT64(this.serial);
        writer.writeInt(this.type);
        writer.writeString(this.keyId);
        ByteArrayWriter users = new ByteArrayWriter();
        for (String string : this.validPrincipals) {
            users.writeString(string);
        }
        writer.writeBinaryString(users.toByteArray());
        users.close();
        writer.writeUINT64(this.validAfter);
        writer.writeUINT64(this.validBefore);
        ByteArrayWriter options = new ByteArrayWriter();
        for (String option : this.optionsOrder) {
            options.writeString(option);
            options.writeString(this.criticalOptions.get(option));
        }
        writer.writeBinaryString(options.toByteArray());
        options.close();
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        for (String e : this.extensionOrder) {
            byteArrayWriter.writeString(e);
            byteArrayWriter.writeString(this.extensions.get(e));
        }
        writer.writeBinaryString(byteArrayWriter.toByteArray());
        byteArrayWriter.close();
        writer.writeString(this.reserved);
        writer.writeBinaryString(this.signedBy.getEncoded());
    }

    protected void decodeCertificate(ByteArrayReader reader) throws IOException, SshException {
        String name;
        this.serial = reader.readUINT64();
        this.type = (int)reader.readInt();
        this.keyId = reader.readString();
        byte[] buf = reader.readBinaryString();
        ByteArrayReader tmp = new ByteArrayReader(buf);
        this.validPrincipals = new ArrayList<String>();
        while (tmp.available() > 0) {
            this.validPrincipals.add(tmp.readString());
        }
        tmp.close();
        this.validAfter = reader.readUINT64();
        this.validBefore = reader.readUINT64();
        tmp = new ByteArrayReader(reader.readBinaryString());
        this.optionsOrder = new ArrayList<String>();
        while (tmp.available() > 0) {
            name = tmp.readString();
            this.optionsOrder.add(name);
            this.criticalOptions.put(name, tmp.readString());
        }
        tmp.close();
        tmp = new ByteArrayReader(reader.readBinaryString());
        this.extensions = new HashMap<String, String>();
        this.extensionOrder = new ArrayList<String>();
        while (tmp.available() > 0) {
            name = tmp.readString().trim();
            this.extensionOrder.add(name);
            this.extensions.put(name, tmp.readString());
        }
        tmp.close();
        this.reserved = reader.readString();
        this.signedBy = SshPublicKeyFileFactory.decodeSSH2PublicKey(reader.readBinaryString());
        this.signature = reader.readBinaryString();
        byte[] data = new byte[reader.array().length - (this.signature.length + 4)];
        System.arraycopy(reader.array(), 0, data, 0, data.length);
        if (!this.signedBy.verifySignature(this.signature, data)) {
            throw new SshException(16, "Certificate file could not validate the signature supplied by the CA");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sign(SshPublicKey publicKey, UnsignedInteger64 serial, int type, String keyId, List<String> validPrincipals, UnsignedInteger64 validAfter, UnsignedInteger64 validBefore, Map<String, String> criticalOptions, List<String> extensions, SshKeyPair signingKey) throws SshException {
        this.publicKey = publicKey;
        this.nonce = new byte[32];
        JCEComponentManager.getSecureRandom().nextBytes(this.nonce);
        this.serial = serial;
        this.type = type;
        this.keyId = keyId;
        this.validPrincipals = validPrincipals;
        this.validAfter = validAfter;
        this.validBefore = validBefore;
        this.criticalOptions = criticalOptions;
        this.extensions = new HashMap<String, String>();
        this.reserved = "";
        this.signedBy = signingKey.getPublicKey();
        for (String ext : extensions) {
            this.extensions.put(ext, "");
        }
        ByteArrayWriter blob = new ByteArrayWriter();
        try {
            blob.writeString(this.getEncodingAlgorithm());
            blob.writeBinaryString(this.nonce);
            try (ByteArrayReader reader = new ByteArrayReader(publicKey.getEncoded());){
                reader.readString();
                blob.write(reader.array(), reader.getPosition(), reader.available());
            }
            this.encodeCertificate(blob);
            byte[] encoded = blob.toByteArray();
            try (ByteArrayWriter sig = new ByteArrayWriter();){
                sig.writeString(signingKey.getPublicKey().getSigningAlgorithm());
                sig.writeBinaryString(signingKey.getPrivateKey().sign(encoded));
                this.signature = sig.toByteArray();
            }
            reader = new ByteArrayReader(this.getEncoded());
            try {
                String algortihm = reader.readString();
                if (!algortihm.equals(this.getAlgorithm())) {
                    throw new SshException(String.format("Unexpected encoding error generating signed certificate [%s] [%s]", algortihm, this.getAlgorithm()), 5);
                }
                byte[] n = reader.readBinaryString();
                if (!Arrays.equals(this.nonce, n)) {
                    throw new SshException("Unexpected encoding error generating signed certificate [nonce]", 5);
                }
                this.decodePublicKey(reader);
                this.decodeCertificate(reader);
            }
            finally {
                reader.close();
            }
        }
        catch (Throwable t) {
            Log.error((String)"Ssh certificate sign failed", (Throwable)t, (Object[])new Object[0]);
            t.printStackTrace();
            throw new SshException("Failed to encode public key", 5);
        }
        finally {
            try {
                blob.close();
            }
            catch (IOException reader) {}
        }
    }

    public SshPublicKey getSignedBy() {
        return this.signedBy;
    }

    public int getType() {
        return this.type;
    }

    public List<String> getPrincipals() {
        return Collections.unmodifiableList(this.validPrincipals);
    }

    @Deprecated
    public List<String> getExtensions() {
        return Collections.unmodifiableList(new ArrayList<String>(this.extensions.keySet()));
    }

    public Map<String, String> getExtensionsMap() {
        return Collections.unmodifiableMap(this.extensions);
    }

    public boolean isForceCommand() {
        return this.criticalOptions.containsKey(OPTION_FORCE_COMMAND);
    }

    public String getForcedCommand() {
        return this.criticalOptions.get(OPTION_FORCE_COMMAND);
    }

    public Set<String> getSourceAddresses() {
        HashSet<String> tmp = new HashSet<String>();
        if (this.criticalOptions.containsKey(OPTION_SOURCE_ADDRESS)) {
            StringTokenizer t = new StringTokenizer(this.criticalOptions.get(OPTION_SOURCE_ADDRESS), ",");
            while (t.hasMoreTokens()) {
                tmp.add(t.nextToken());
            }
        }
        return Collections.unmodifiableSet(tmp);
    }

    public Date getValidBefore() {
        return new Date(this.validBefore.longValue() * 1000L);
    }

    public Date getValidAfter() {
        return new Date(this.validAfter.longValue() * 1000L);
    }

    public UnsignedInteger64 getSerial() {
        return this.serial;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public Map<String, String> getCriticalOptions() {
        return Collections.unmodifiableMap(this.criticalOptions);
    }
}

