/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.sftp.extensions.filter;

import com.sshtools.common.events.Event;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.AbstractFileSystem;
import com.sshtools.common.sftp.GlobSftpFileFilter;
import com.sshtools.common.sftp.RegexSftpFileFilter;
import com.sshtools.common.sftp.SftpExtension;
import com.sshtools.common.sftp.SftpStatusEventException;
import com.sshtools.common.sftp.SftpSubsystem;
import com.sshtools.common.util.ByteArrayReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;

public class OpenDirectoryWithFilterExtension
implements SftpExtension {
    public static final String EXTENSION_NAME = "open-directory-with-filter@sshtools.com";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMessage(ByteArrayReader bar, int requestId, SftpSubsystem sftp) {
        String path = null;
        String filter = null;
        Date started = new Date();
        try {
            AbstractFileSystem fs = sftp.getFileSystem();
            path = sftp.checkDefaultPath(bar.readString(sftp.getCharsetEncoding()));
            filter = bar.readString(sftp.getCharsetEncoding());
            boolean regex = bar.readBoolean();
            byte[] handle = fs.openDirectory(path, regex ? new RegexSftpFileFilter(filter) : new GlobSftpFileFilter(filter));
            try {
                this.fireOpenDirectoryEvent(sftp, path, filter, started, handle, null);
                sftp.sendHandleMessage(requestId, handle);
            }
            catch (SftpStatusEventException ex) {
                sftp.sendStatusMessage(requestId, ex.getStatus(), ex.getMessage());
            }
        }
        catch (FileNotFoundException ioe) {
            this.fireOpenDirectoryEvent(sftp, path, filter, started, null, ioe);
            sftp.sendStatusMessage(requestId, 2, ioe.getMessage());
        }
        catch (IOException ioe2) {
            this.fireOpenDirectoryEvent(sftp, path, filter, started, null, ioe2);
            sftp.sendStatusMessage(requestId, 4, ioe2.getMessage());
        }
        catch (PermissionDeniedException pde) {
            this.fireOpenDirectoryEvent(sftp, path, filter, started, null, pde);
            sftp.sendStatusMessage(requestId, 3, pde.getMessage());
        }
        finally {
            bar.close();
        }
    }

    public void fireOpenDirectoryEvent(SftpSubsystem sftp, String path, String filter, Date started, byte[] handle, Exception error) {
        sftp.fireEvent(new Event((Object)sftp, -16777124, error).addAttribute("CONNECTION", sftp.getConnection()).addAttribute("BYTES_TRANSFERED", new Long(0L)).addAttribute("HANDLE", handle).addAttribute("FILE_NAME", path).addAttribute("OP_STARTED", started).addAttribute("OP_FINISHED", new Date()));
    }

    @Override
    public boolean supportsExtendedMessage(int messageId) {
        return false;
    }

    @Override
    public void processExtendedMessage(ByteArrayReader msg, SftpSubsystem sftp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDeclaredInVersion() {
        return false;
    }

    @Override
    public byte[] getDefaultData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return EXTENSION_NAME;
    }
}

