/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.events;

import com.sshtools.common.events.Event;
import com.sshtools.common.events.EventCodes;
import com.sshtools.common.events.EventException;
import com.sshtools.common.events.EventListener;
import com.sshtools.common.events.EventService;
import com.sshtools.common.events.EventTrigger;
import com.sshtools.common.logger.Log;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class EventServiceImplementation
implements EventService {
    private static EventService INSTANCE = new EventServiceImplementation();
    private static boolean got;
    private static StackTraceElement[] gotStack;
    protected final Hashtable<String, EventListener> keyedListeners;
    protected List<EventListener> globalListeners = new ArrayList<EventListener>();
    protected List<Class> eventCodeDescriptors = new ArrayList<Class>(Arrays.asList(EventCodes.class));
    boolean processAllEventsOnEventException = false;
    Map<Integer, String> cachedEventNames = new HashMap<Integer, String>();

    protected EventServiceImplementation() {
        this.keyedListeners = new Hashtable();
        try {
            this.registerEventCodeDescriptor(Class.forName("com.sshtools.common.events.EventCodes"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected static void setInstance(EventService eventService) {
        if (got) {
            StringBuilder trace = new StringBuilder();
            for (StackTraceElement el : gotStack) {
                if (trace.length() > 0) {
                    trace.append('\n');
                }
                trace.append(el);
            }
            throw new IllegalArgumentException(EventServiceImplementation.class + ".setInstance() must be called before the first getInstace() which was called from :-\n" + trace.toString());
        }
        INSTANCE = eventService;
    }

    public static EventService getInstance() {
        if (!got) {
            got = true;
            gotStack = Thread.currentThread().getStackTrace();
        }
        return INSTANCE;
    }

    @Override
    public void registerEventCodeDescriptor(Class cls) {
        this.eventCodeDescriptors.add(cls);
    }

    @Override
    public String getEventName(Integer id) {
        if (this.cachedEventNames.containsKey(id)) {
            return this.cachedEventNames.get(id);
        }
        for (Class cls : this.eventCodeDescriptors) {
            for (Field f : cls.getFields()) {
                if ((f.getModifiers() & 0) != 0 || !f.getType().isAssignableFrom(Integer.TYPE)) continue;
                try {
                    int val = (Integer)f.get(null);
                    if (val != id) continue;
                    this.cachedEventNames.put(id, f.getName());
                    return f.getName();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        return Integer.toHexString(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireEvent(Event evt) {
        Object obj;
        if (evt == null) {
            return;
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Firing {} success={}", (Object[])new Object[]{this.getEventName(evt.getId()), evt.getState() ? "true" : "false"});
        }
        if ((obj = evt.getAttribute("CONNECTION")) != null && obj instanceof EventTrigger) {
            ((EventTrigger)obj).fireEvent(evt);
        }
        EventServiceImplementation eventServiceImplementation = this;
        synchronized (eventServiceImplementation) {
            EventException lastException = null;
            for (EventListener mListener : this.globalListeners) {
                try {
                    mListener.processEvent(evt);
                }
                catch (Throwable t) {
                    if (t instanceof EventException) {
                        lastException = (EventException)t;
                        if (this.processAllEventsOnEventException) continue;
                        throw lastException;
                    }
                    if (!Log.isWarnEnabled()) continue;
                    Log.warn((String)"Caught exception from event listener", (Throwable)t, (Object[])new Object[0]);
                }
            }
            if (this.processAllEventsOnEventException && lastException != null) {
                throw lastException;
            }
        }
    }

    public void setProcessAllEventsOnEventException(boolean processAllEventsOnEventException) {
        this.processAllEventsOnEventException = processAllEventsOnEventException;
    }

    @Override
    public void addListener(EventListener listener) {
        this.globalListeners.add(listener);
    }

    @Override
    public void removeListener(EventListener listener) {
        this.globalListeners.remove(listener);
    }
}

