/*
 * Decompiled with CFR 0.152.
 */
package com.srcclr.sdk;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.srcclr.sdk.Library;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.RecordMetadata;
import com.srcclr.sdk.Vulnerability;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@JsonDeserialize(builder=Builder.class)
@Immutable
public class Record {
    private final RecordMetadata metadata;
    private final Collection<LibraryGraph> graphs;
    private final Collection<Library> libraries;
    private final Collection<Vulnerability> vulnerabilities;

    private Record(Builder builder) {
        this.metadata = builder.metadata;
        this.graphs = Collections.unmodifiableCollection(builder.graphs);
        this.libraries = Collections.unmodifiableCollection(builder.libraries);
        this.vulnerabilities = Collections.unmodifiableCollection(builder.vulnerabilities);
    }

    @Nonnull
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Nonnull
    public Collection<LibraryGraph> getGraphs() {
        return this.graphs;
    }

    @Nonnull
    public Collection<Library> getLibraries() {
        return this.libraries;
    }

    @Nonnull
    public Collection<Vulnerability> getVulnerabilities() {
        return this.vulnerabilities;
    }

    public static class Builder {
        private RecordMetadata metadata;
        private Collection<LibraryGraph> graphs = new LinkedList<LibraryGraph>();
        private Collection<Library> libraries = new LinkedList<Library>();
        private Collection<Vulnerability> vulnerabilities = new LinkedList<Vulnerability>();

        public Builder withMetadata(RecordMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder withGraphs(Collection<LibraryGraph> graphs) {
            this.graphs = new ArrayList<LibraryGraph>(graphs);
            return this;
        }

        public Builder withGraph(LibraryGraph graph) {
            this.graphs.add(graph);
            return this;
        }

        public Builder withLibraries(Collection<Library> libraries) {
            this.libraries = new ArrayList<Library>(libraries);
            return this;
        }

        public Builder withVulnerabilities(Collection<Vulnerability> vulnerabilities) {
            this.vulnerabilities = new ArrayList<Vulnerability>(vulnerabilities);
            return this;
        }

        public Record build() {
            return new Record(this);
        }
    }
}

