/*
 * Decompiled with CFR 0.152.
 */
package com.srcclr.sdk;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.srcclr.sdk.LibraryGraphContainer;
import com.srcclr.sdk.LibraryGraphSerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class LibraryGraphSerializer {
    private static long CURRENT_GENERATION = 1L;
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(JsonGenerator.Feature.IGNORE_UNKNOWN, true).enable(SerializationFeature.INDENT_OUTPUT);

    public static void checkGeneration(Long generation) throws LibraryGraphSerializationException {
        if (generation == null) {
            if (CURRENT_GENERATION != 1L) {
                throw new LibraryGraphSerializationException("Generation number missing from component graph JSON");
            }
            return;
        }
        if (generation != CURRENT_GENERATION) {
            throw new LibraryGraphSerializationException("Cannot deserialize JSON: Expected to deserialize generation " + LibraryGraphSerializer.getCurrentGeneration() + " but found " + generation);
        }
    }

    public static long getCurrentGeneration() {
        return CURRENT_GENERATION;
    }

    public static void write(LibraryGraphContainer container, OutputStream os) throws IOException {
        MAPPER.writeValue(os, (Object)container);
    }

    public static LibraryGraphContainer read(InputStream is) throws IOException {
        return (LibraryGraphContainer)MAPPER.readValue(is, LibraryGraphContainer.class);
    }

    private LibraryGraphSerializer() {
    }
}

