/*
 * Decompiled with CFR 0.152.
 */
package com.srcclr.sdk;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryGraphContainerDeserializer;
import com.srcclr.sdk.LibraryGraphSerializer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonDeserialize(using=LibraryGraphContainerDeserializer.class)
@Immutable
public class LibraryGraphContainer {
    public static final LibraryGraphContainer EMPTY_GRAPH = new Builder().build();
    @NotNull
    @Valid
    protected final Set<LibraryGraph> graphs;

    protected LibraryGraphContainer(Builder builder) {
        this.graphs = Collections.unmodifiableSet(builder.graphs);
    }

    public long getGeneration() {
        return LibraryGraphSerializer.getCurrentGeneration();
    }

    public Set<LibraryGraph> getGraphs() {
        return this.graphs;
    }

    public static class Builder {
        private Set<LibraryGraph> graphs = new HashSet<LibraryGraph>();

        public Builder withGraph(LibraryGraph graph) {
            this.graphs.add(graph);
            return this;
        }

        public Builder withGraphs(Collection<LibraryGraph> graphs) {
            this.graphs.addAll(graphs);
            return this;
        }

        public LibraryGraphContainer build() {
            return new LibraryGraphContainer(this);
        }
    }
}

