/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.Syntax;
import com.squareup.wire.internal._PlatformKt;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.OneOf;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Rpc;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.SchemaEncoder;
import com.squareup.wire.schema.internal.SchemaEncoder$WhenMappings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004?@ABB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010-\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u001f0.2\b\u0010/\u001a\u0004\u0018\u00010!2\f\u00100\u001a\b\u0012\u0004\u0012\u00020'01H\u0002J\u000e\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0011J\u0018\u00105\u001a\u00020\u00012\u0006\u00106\u001a\u00020'2\u0006\u00107\u001a\u00020\u0001H\u0002J*\u00108\u001a\u0010\u0012\u0004\u0012\u00020!\u0012\u0006\u0012\u0004\u0018\u00010\u00010.2\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020\u00010.H\u0002J\u0018\u0010;\u001a\u00020\u00012\u0006\u0010<\u001a\u00020\"2\u0006\u00107\u001a\u00020\u0001H\u0002J\u000e\u0010=\u001a\u0004\u0018\u00010\u0001*\u00020>H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010 \u001a\u00020!*\u00020\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0018\u0010%\u001a\u00020&*\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0018\u0010*\u001a\u00020&*\u00020\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006C"}, d2={"Lcom/squareup/wire/schema/internal/SchemaEncoder;", "", "schema", "Lcom/squareup/wire/schema/Schema;", "(Lcom/squareup/wire/schema/Schema;)V", "enumConstantEncoder", "Lcom/squareup/wire/schema/internal/SchemaEncoder$Encoder;", "Lcom/squareup/wire/schema/EnumConstant;", "enumEncoder", "Lcom/squareup/wire/schema/EnumType;", "enumOptionsProtoAdapter", "Lcom/squareup/wire/ProtoAdapter;", "enumValueOptionsProtoAdapter", "fieldEncoder", "Lcom/squareup/wire/schema/internal/SchemaEncoder$EncodedField;", "fieldOptionsProtoAdapter", "fileEncoder", "Lcom/squareup/wire/schema/ProtoFile;", "fileOptionsProtoAdapter", "messageEncoder", "Lcom/squareup/wire/schema/MessageType;", "messageOptionsProtoAdapter", "oneOfEncoder", "Lcom/squareup/wire/schema/internal/SchemaEncoder$EncodedOneOf;", "rpcEncoder", "Lcom/squareup/wire/schema/Rpc;", "rpcOptionsProtoAdapter", "serviceEncoder", "Lcom/squareup/wire/schema/Service;", "serviceOptionsProtoAdapter", "syntheticMapEntryEncoder", "Lcom/squareup/wire/schema/internal/SchemaEncoder$SyntheticMapEntry;", "dotName", "", "Lcom/squareup/wire/schema/ProtoType;", "getDotName", "(Lcom/squareup/wire/schema/ProtoType;)Ljava/lang/String;", "labelTag", "", "Lcom/squareup/wire/schema/Field;", "getLabelTag", "(Lcom/squareup/wire/schema/Field;)I", "typeTag", "getTypeTag", "(Lcom/squareup/wire/schema/ProtoType;)I", "collectSyntheticMapEntries", "", "enclosingTypeOrPackage", "fields", "", "encode", "Lokio/ByteString;", "protoFile", "toJson", "field", "value", "toJsonMap", "map", "Lcom/squareup/wire/schema/ProtoMember;", "toJsonSingle", "type", "toJsonOptions", "Lcom/squareup/wire/schema/Options;", "EncodedField", "EncodedOneOf", "Encoder", "SyntheticMapEntry", "wire-schema"})
public final class SchemaEncoder {
    private final ProtoAdapter<Object> fileOptionsProtoAdapter;
    private final ProtoAdapter<Object> messageOptionsProtoAdapter;
    private final ProtoAdapter<Object> fieldOptionsProtoAdapter;
    private final ProtoAdapter<Object> enumOptionsProtoAdapter;
    private final ProtoAdapter<Object> enumValueOptionsProtoAdapter;
    private final ProtoAdapter<Object> serviceOptionsProtoAdapter;
    private final ProtoAdapter<Object> rpcOptionsProtoAdapter;
    private final Encoder<ProtoFile> fileEncoder;
    private final Encoder<MessageType> messageEncoder;
    private final Encoder<SyntheticMapEntry> syntheticMapEntryEncoder;
    private final Encoder<EncodedField> fieldEncoder;
    private final Encoder<EncodedOneOf> oneOfEncoder;
    private final Encoder<EnumType> enumEncoder;
    private final Encoder<EnumConstant> enumConstantEncoder;
    private final Encoder<Service> serviceEncoder;
    private final Encoder<Rpc> rpcEncoder;
    private final Schema schema;

    @NotNull
    public final ByteString encode(@NotNull ProtoFile protoFile) {
        Intrinsics.checkNotNullParameter((Object)protoFile, (String)"protoFile");
        return ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])this.fileEncoder.encode(protoFile), (int)0, (int)0, (int)3, null);
    }

    private final Map<Field, SyntheticMapEntry> collectSyntheticMapEntries(String enclosingTypeOrPackage, List<Field> fields) {
        boolean bl = false;
        Map result = new LinkedHashMap();
        for (Field field : fields) {
            ProtoType fieldType;
            Intrinsics.checkNotNull((Object)field.getType());
            if (!fieldType.isMap()) continue;
            String name = _PlatformKt.camelCase((String)field.getName(), (boolean)true) + "Entry";
            ProtoType protoType = fieldType.getKeyType();
            Intrinsics.checkNotNull((Object)protoType);
            ProtoType protoType2 = fieldType.getValueType();
            Intrinsics.checkNotNull((Object)protoType2);
            result.put(field, new SyntheticMapEntry(enclosingTypeOrPackage, name, protoType, protoType2));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int getLabelTag(Field $this$labelTag) {
        Field.EncodeMode encodeMode = $this$labelTag.getEncodeMode();
        if (encodeMode != null) {
            switch (SchemaEncoder$WhenMappings.$EnumSwitchMapping$0[encodeMode.ordinal()]) {
                case 1: 
                case 2: {
                    return 1;
                }
                case 3: {
                    return 2;
                }
                case 4: 
                case 5: 
                case 6: {
                    return 3;
                }
            }
        }
        String string = "unexpected encodeMode: " + (Object)((Object)$this$labelTag.getEncodeMode());
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    private final String getDotName(ProtoType $this$dotName) {
        return "" + '.' + $this$dotName;
    }

    private final int getTypeTag(ProtoType $this$typeTag) {
        int n;
        if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.DOUBLE)) {
            n = 1;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.FLOAT)) {
            n = 2;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.INT64)) {
            n = 3;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.UINT64)) {
            n = 4;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.INT32)) {
            n = 5;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.FIXED64)) {
            n = 6;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.FIXED32)) {
            n = 7;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.BOOL)) {
            n = 8;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.STRING)) {
            n = 9;
        } else if (this.schema.getType($this$typeTag) instanceof MessageType) {
            n = 11;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.BYTES)) {
            n = 12;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.UINT32)) {
            n = 13;
        } else if (this.schema.getType($this$typeTag) instanceof EnumType) {
            n = 14;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.SFIXED32)) {
            n = 15;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.SFIXED64)) {
            n = 16;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.SINT32)) {
            n = 17;
        } else if (Intrinsics.areEqual((Object)$this$typeTag, (Object)ProtoType.SINT64)) {
            n = 18;
        } else if ($this$typeTag.isMap()) {
            n = 11;
        } else {
            String string = "unexpected type: " + $this$typeTag;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private final Object toJsonOptions(Options $this$toJsonOptions) {
        Map<ProtoMember, Object> optionsMap = $this$toJsonOptions.getMap();
        if (optionsMap.isEmpty()) {
            return null;
        }
        boolean bl = false;
        Map result = new LinkedHashMap();
        Object object = optionsMap;
        boolean bl2 = false;
        Iterator<Map.Entry<ProtoMember, Object>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Field field;
            void key;
            Map.Entry<ProtoMember, Object> entry;
            Map.Entry<ProtoMember, Object> entry2 = entry = iterator.next();
            boolean bl3 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl3 = false;
            Object value = entry2.getValue();
            if (this.schema.getField((ProtoMember)key) == null) {
                String string = "unexpected options field: " + key;
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            String string = field.getName();
            Object object2 = value;
            Intrinsics.checkNotNull((Object)object2);
            result.put(string, this.toJson(field, object2));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final Object toJson(Field field, Object value) {
        Object object;
        if (field.isRepeated()) {
            void $this$mapTo$iv$iv;
            Object object2 = value;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<*>");
            }
            Iterable $this$map$iv = (List)object2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ProtoType protoType = field.getType();
                Intrinsics.checkNotNull((Object)protoType);
                void v2 = it;
                Intrinsics.checkNotNull((Object)v2);
                Object object3 = this.toJsonSingle(protoType, v2);
                collection.add(object3);
            }
            object = (List)destination$iv$iv;
        } else {
            ProtoType protoType = field.getType();
            Intrinsics.checkNotNull((Object)protoType);
            object = this.toJsonSingle(protoType, value);
        }
        return object;
    }

    private final Object toJsonSingle(ProtoType type, Object value) {
        Object object;
        ProtoType protoType = type;
        if (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.INT32)) {
            Object object2 = value;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String string = (String)object2;
            boolean bl = false;
            object = Integer.parseInt(string);
        } else if (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.DOUBLE)) {
            Object object3 = value;
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String string = (String)object3;
            boolean bl = false;
            object = Double.parseDouble(string);
        } else if (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.BOOL)) {
            Object object4 = value;
            if (object4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String string = (String)object4;
            boolean bl = false;
            object = Boolean.parseBoolean(string);
        } else if (Intrinsics.areEqual((Object)protoType, (Object)ProtoType.STRING)) {
            Object object5 = value;
            if (object5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            object = (String)object5;
        } else {
            Type type2 = this.schema.getType(type);
            if (type2 instanceof MessageType) {
                Object object6 = value;
                if (object6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<com.squareup.wire.schema.ProtoMember, kotlin.Any>");
                }
                object = this.toJsonMap((Map)object6);
            } else if (type2 instanceof EnumType) {
                Object object7 = value;
                if (object7 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                object = (String)object7;
            } else {
                String string = "not implemented yet!!";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> toJsonMap(Map<ProtoMember, ? extends Object> map) {
        boolean bl = false;
        Map result = new LinkedHashMap();
        Object object = map;
        boolean bl2 = false;
        Iterator<Map.Entry<ProtoMember, ? extends Object>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Field field;
            void key;
            Map.Entry<ProtoMember, ? extends Object> entry;
            Map.Entry<ProtoMember, ? extends Object> entry2 = entry = iterator.next();
            boolean bl3 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl3 = false;
            Object value = entry2.getValue();
            if (this.schema.getField((ProtoMember)key) == null) {
                continue;
            }
            result.put(key.getSimpleName(), this.toJson(field, value));
        }
        return result;
    }

    public SchemaEncoder(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        this.schema = schema;
        this.fileOptionsProtoAdapter = this.schema.protoAdapter(Options.FILE_OPTIONS.toString(), false);
        this.messageOptionsProtoAdapter = this.schema.protoAdapter(Options.MESSAGE_OPTIONS.toString(), false);
        this.fieldOptionsProtoAdapter = this.schema.protoAdapter(Options.FIELD_OPTIONS.toString(), false);
        this.enumOptionsProtoAdapter = this.schema.protoAdapter(Options.ENUM_OPTIONS.toString(), false);
        this.enumValueOptionsProtoAdapter = this.schema.protoAdapter(Options.ENUM_VALUE_OPTIONS.toString(), false);
        this.serviceOptionsProtoAdapter = this.schema.protoAdapter(Options.SERVICE_OPTIONS.toString(), false);
        this.rpcOptionsProtoAdapter = this.schema.protoAdapter(Options.METHOD_OPTIONS.toString(), false);
        this.fileEncoder = new Encoder<ProtoFile>(this){
            final /* synthetic */ SchemaEncoder this$0;

            /*
             * WARNING - void declaration
             */
            public void encode(@NotNull ProtoWriter writer, @NotNull ProtoFile value) {
                Iterable $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                ProtoAdapter.STRING.encodeWithTag(writer, 1, (Object)value.getLocation().getPath());
                ProtoAdapter.STRING.encodeWithTag(writer, 2, (Object)value.getPackageName());
                ProtoAdapter.STRING.asRepeated().encodeWithTag(writer, 3, value.getImports());
                Iterable iterable = value.getTypes();
                int n = 4;
                ProtoWriter protoWriter = writer;
                ProtoAdapter protoAdapter = SchemaEncoder.access$getMessageEncoder$p(this.this$0).asRepeated();
                boolean $i$f$filterIsInstance = false;
                void var5_9 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof MessageType)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Collection<EncodedField> collection = (List)destination$iv$iv;
                protoAdapter.encodeWithTag(protoWriter, n, (Object)collection);
                $this$filterIsInstance$iv = value.getTypes();
                n = 5;
                protoWriter = writer;
                protoAdapter = SchemaEncoder.access$getEnumEncoder$p(this.this$0).asRepeated();
                $i$f$filterIsInstance = false;
                $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof EnumType)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                collection = (List)destination$iv$iv;
                protoAdapter.encodeWithTag(protoWriter, n, (Object)collection);
                SchemaEncoder.access$getServiceEncoder$p(this.this$0).asRepeated().encodeWithTag(writer, 6, value.getServices());
                for (Extend extend : value.getExtendList()) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    $this$filterIsInstanceTo$iv$iv = extend.getFields();
                    n = 7;
                    protoWriter = writer;
                    protoAdapter = SchemaEncoder.access$getFieldEncoder$p(this.this$0).asRepeated();
                    boolean $i$f$map = false;
                    void $i$f$filterIsInstanceTo2 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Field field = (Field)item$iv$iv;
                        collection = destination$iv$iv2;
                        boolean bl = false;
                        Syntax syntax = value.getSyntax();
                        ProtoType protoType = extend.getType();
                        Intrinsics.checkNotNull((Object)protoType);
                        EncodedField encodedField = new EncodedField(syntax, (Field)it, null, SchemaEncoder.access$getDotName$p(this.this$0, protoType), null, 20, null);
                        collection.add(encodedField);
                    }
                    collection = (List)destination$iv$iv2;
                    protoAdapter.encodeWithTag(protoWriter, n, (Object)collection);
                }
                SchemaEncoder.access$getFileOptionsProtoAdapter$p(this.this$0).encodeWithTag(writer, 8, SchemaEncoder.access$toJsonOptions(this.this$0, value.getOptions()));
                if (value.getSyntax() != Syntax.PROTO_2) {
                    Syntax syntax = value.getSyntax();
                    ProtoAdapter.STRING.encodeWithTag(writer, 12, (Object)(syntax != null ? syntax.toString() : null));
                }
            }
            {
                this.this$0 = this$0;
            }
        };
        this.messageEncoder = new Encoder<MessageType>(this){
            final /* synthetic */ SchemaEncoder this$0;

            /*
             * WARNING - void declaration
             */
            public void encode(@NotNull ProtoWriter writer, @NotNull MessageType value) {
                Iterable $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                void $this$flatMapTo$iv$iv222;
                void $this$flatMap$iv;
                Object oneOfFields;
                Object object;
                Collection collection;
                Collection $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                ProtoFile protoFile = SchemaEncoder.access$getSchema$p(this.this$0).protoFile(value.getType());
                Intrinsics.checkNotNull((Object)protoFile);
                Syntax syntax = protoFile.getSyntax();
                Map syntheticMaps = SchemaEncoder.access$collectSyntheticMapEntries(this.this$0, value.getType().toString(), value.getDeclaredFields());
                boolean bl = false;
                List encodedOneOfs = new ArrayList<E>();
                for (OneOf oneOf : value.getOneOfs()) {
                    Iterable $this$map$iv = oneOf.getFields();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Field field = (Field)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl2 = false;
                        object = new EncodedField(syntax, (Field)it, null, null, encodedOneOfs.size(), 12, null);
                        collection.add(object);
                    }
                    oneOfFields = (List)destination$iv$iv;
                    encodedOneOfs.add(new EncodedOneOf(oneOf.getName(), (List<EncodedField>)oneOfFields));
                }
                boolean bl3 = false;
                List encodedFields = new ArrayList<E>();
                for (Field field : value.getDeclaredFields()) {
                    SyntheticMapEntry syntheticMap = (SyntheticMapEntry)syntheticMaps.get(field);
                    Object object2 = syntheticMap;
                    if (object2 == null || (object2 = ((SyntheticMapEntry)object2).getFieldType()) == null) {
                        ProtoType protoType = field.getType();
                        object2 = protoType;
                        Intrinsics.checkNotNull((Object)protoType);
                    }
                    EncodedField encodedField = new EncodedField(syntax, field, (ProtoType)object2, null, null, 24, null);
                    if (encodedField.isProto3Optional()) {
                        encodedField = EncodedField.copy$default(encodedField, null, null, null, null, encodedOneOfs.size(), 15, null);
                        $this$mapTo$iv$iv = encodedOneOfs;
                        EncodedOneOf destination$iv$iv = new EncodedOneOf('_' + field.getName(), null, 2, null);
                        boolean bl4 = false;
                        $this$mapTo$iv$iv.add(destination$iv$iv);
                    }
                    $this$mapTo$iv$iv = encodedFields;
                    boolean destination$iv$iv = false;
                    $this$mapTo$iv$iv.add(encodedField);
                }
                ProtoAdapter.STRING.encodeWithTag(writer, 1, (Object)value.getType().getSimpleName());
                oneOfFields = encodedOneOfs;
                collection = encodedFields;
                boolean $i$f$flatMap = false;
                void encodedField = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv222) {
                    EncodedOneOf it = (EncodedOneOf)element$iv$iv;
                    boolean bl5 = false;
                    Iterable list$iv$iv = it.getFields();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                object = (List)destination$iv$iv;
                Iterable $this$sortedBy$iv = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object));
                boolean $i$f$sortedBy = false;
                boolean $this$flatMapTo$iv$iv222 = false;
                List fieldsAndOneOfFields = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        EncodedField it = (EncodedField)a;
                        boolean bl2 = false;
                        Comparable comparable = Integer.valueOf(it.getField().getTag());
                        it = (EncodedField)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Integer n = it.getField().getTag();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                    }
                });
                SchemaEncoder.access$getFieldEncoder$p(this.this$0).asRepeated().encodeWithTag(writer, 2, (Object)fieldsAndOneOfFields);
                $this$sortedBy$iv = value.getNestedTypes();
                int n = 3;
                object = writer;
                collection = this.asRepeated();
                boolean $i$f$filterIsInstance = false;
                void $this$flatMapTo$iv$iv222 = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof MessageType)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv;
                collection.encodeWithTag((ProtoWriter)object, n, list);
                SchemaEncoder.access$getSyntheticMapEntryEncoder$p(this.this$0).asRepeated().encodeWithTag(writer, 3, (Object)CollectionsKt.toList((Iterable)syntheticMaps.values()));
                $this$filterIsInstance$iv = value.getNestedTypes();
                n = 4;
                object = writer;
                collection = SchemaEncoder.access$getEnumEncoder$p(this.this$0).asRepeated();
                $i$f$filterIsInstance = false;
                $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof EnumType)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
                collection.encodeWithTag((ProtoWriter)object, n, list);
                SchemaEncoder.access$getOneOfEncoder$p(this.this$0).asRepeated().encodeWithTag(writer, 8, (Object)encodedOneOfs);
                SchemaEncoder.access$getMessageOptionsProtoAdapter$p(this.this$0).encodeWithTag(writer, 7, SchemaEncoder.access$toJsonOptions(this.this$0, value.getOptions()));
            }
            {
                this.this$0 = this$0;
            }
        };
        this.syntheticMapEntryEncoder = new Encoder<SyntheticMapEntry>(this){
            @NotNull
            private final syntheticMapEntryEncoder.keyFieldEncoder.1 keyFieldEncoder;
            @NotNull
            private final syntheticMapEntryEncoder.valueFieldEncoder.1 valueFieldEncoder;
            final /* synthetic */ SchemaEncoder this$0;

            @NotNull
            public final syntheticMapEntryEncoder.keyFieldEncoder.1 getKeyFieldEncoder() {
                return this.keyFieldEncoder;
            }

            @NotNull
            public final syntheticMapEntryEncoder.valueFieldEncoder.1 getValueFieldEncoder() {
                return this.valueFieldEncoder;
            }

            public void encode(@NotNull ProtoWriter writer, @NotNull SyntheticMapEntry value) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                ProtoAdapter.STRING.encodeWithTag(writer, 1, (Object)value.getName());
                this.keyFieldEncoder.encodeWithTag(writer, 2, value);
                this.valueFieldEncoder.encodeWithTag(writer, 2, value);
                SchemaEncoder.access$getMessageOptionsProtoAdapter$p(this.this$0).encodeWithTag(writer, 7, (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"map_entry", (Object)true)));
            }
            {
                this.this$0 = this$0;
                this.keyFieldEncoder = new Encoder<SyntheticMapEntry>(this){
                    final /* synthetic */ syntheticMapEntryEncoder.1 this$0;

                    public void encode(@NotNull ProtoWriter writer, @NotNull SyntheticMapEntry value) {
                        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        ProtoAdapter.STRING.encodeWithTag(writer, 1, (Object)"key");
                        ProtoAdapter.INT32.encodeWithTag(writer, 3, (Object)1);
                        ProtoAdapter.INT32.encodeWithTag(writer, 4, (Object)1);
                        ProtoAdapter.INT32.encodeWithTag(writer, 5, (Object)SchemaEncoder.access$getTypeTag$p(this.this$0.this$0, value.getKeyType()));
                        if (!value.getKeyType().isScalar()) {
                            ProtoAdapter.STRING.encodeWithTag(writer, 6, (Object)SchemaEncoder.access$getDotName$p(this.this$0.this$0, value.getKeyType()));
                        }
                        ProtoAdapter.STRING.encodeWithTag(writer, 10, (Object)"key");
                    }
                    {
                        this.this$0 = this$0;
                    }
                };
                this.valueFieldEncoder = new Encoder<SyntheticMapEntry>(this){
                    final /* synthetic */ syntheticMapEntryEncoder.1 this$0;

                    public void encode(@NotNull ProtoWriter writer, @NotNull SyntheticMapEntry value) {
                        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        ProtoAdapter.STRING.encodeWithTag(writer, 1, (Object)"value");
                        ProtoAdapter.INT32.encodeWithTag(writer, 3, (Object)2);
                        ProtoAdapter.INT32.encodeWithTag(writer, 4, (Object)1);
                        ProtoAdapter.INT32.encodeWithTag(writer, 5, (Object)SchemaEncoder.access$getTypeTag$p(this.this$0.this$0, value.getValueType()));
                        if (!value.getValueType().isScalar()) {
                            ProtoAdapter.STRING.encodeWithTag(writer, 6, (Object)SchemaEncoder.access$getDotName$p(this.this$0.this$0, value.getValueType()));
                        }
                        ProtoAdapter.STRING.encodeWithTag(writer, 10, (Object)"value");
                    }
                    {
                        this.this$0 = this$0;
                    }
                };
            }
        };
        this.fieldEncoder = new Encoder<EncodedField>(this){
            final /* synthetic */ SchemaEncoder this$0;

            public void encode(@NotNull ProtoWriter writer, @NotNull EncodedField value) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                ProtoAdapter.STRING.encodeWithTag(writer, 1, (Object)value.getField().getName());
                ProtoAdapter.INT32.encodeWithTag(writer, 3, (Object)value.getField().getTag());
                ProtoAdapter.INT32.encodeWithTag(writer, 4, (Object)SchemaEncoder.access$getLabelTag$p(this.this$0, value.getField()));
                ProtoType protoType = value.getField().getType();
                Intrinsics.checkNotNull((Object)protoType);
                ProtoAdapter.INT32.encodeWithTag(writer, 5, (Object)SchemaEncoder.access$getTypeTag$p(this.this$0, protoType));
                if (!value.getType().isScalar()) {
                    ProtoAdapter.STRING.encodeWithTag(writer, 6, (Object)SchemaEncoder.access$getDotName$p(this.this$0, value.getType()));
                }
                ProtoAdapter.STRING.encodeWithTag(writer, 2, (Object)value.getExtendee());
                ProtoAdapter.STRING.encodeWithTag(writer, 7, (Object)value.getField().getDefault());
                if (value.getSyntax() == Syntax.PROTO_2 && Intrinsics.areEqual((Object)value.getField().getJsonName(), (Object)value.getField().getName()) ^ true) {
                    ProtoAdapter.STRING.encodeWithTag(writer, 10, (Object)value.getField().getJsonName());
                }
                SchemaEncoder.access$getFieldOptionsProtoAdapter$p(this.this$0).encodeWithTag(writer, 8, SchemaEncoder.access$toJsonOptions(this.this$0, value.getField().getOptions()));
                if (value.isProto3Optional()) {
                    ProtoAdapter.BOOL.encodeWithTag(writer, 17, (Object)true);
                }
                ProtoAdapter.INT32.encodeWithTag(writer, 9, (Object)value.getOneOfIndex());
            }
            {
                this.this$0 = this$0;
            }
        };
        this.oneOfEncoder = new Encoder<EncodedOneOf>(){

            public void encode(@NotNull ProtoWriter writer, @NotNull EncodedOneOf value) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                ProtoAdapter.STRING.encodeWithTag(writer, 1, (Object)value.getName());
            }
        };
        this.enumEncoder = new Encoder<EnumType>(this){
            final /* synthetic */ SchemaEncoder this$0;

            public void encode(@NotNull ProtoWriter writer, @NotNull EnumType value) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                ProtoAdapter.STRING.encodeWithTag(writer, 1, (Object)value.getName());
                SchemaEncoder.access$getEnumConstantEncoder$p(this.this$0).asRepeated().encodeWithTag(writer, 2, value.getConstants());
                SchemaEncoder.access$getEnumOptionsProtoAdapter$p(this.this$0).encodeWithTag(writer, 3, SchemaEncoder.access$toJsonOptions(this.this$0, value.getOptions()));
            }
            {
                this.this$0 = this$0;
            }
        };
        this.enumConstantEncoder = new Encoder<EnumConstant>(this){
            final /* synthetic */ SchemaEncoder this$0;

            public void encode(@NotNull ProtoWriter writer, @NotNull EnumConstant value) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                ProtoAdapter.STRING.encodeWithTag(writer, 1, (Object)value.getName());
                ProtoAdapter.INT32.encodeWithTag(writer, 2, (Object)value.getTag());
                SchemaEncoder.access$getEnumValueOptionsProtoAdapter$p(this.this$0).encodeWithTag(writer, 3, SchemaEncoder.access$toJsonOptions(this.this$0, value.getOptions()));
            }
            {
                this.this$0 = this$0;
            }
        };
        this.serviceEncoder = new Encoder<Service>(this){
            final /* synthetic */ SchemaEncoder this$0;

            public void encode(@NotNull ProtoWriter writer, @NotNull Service value) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                ProtoAdapter.STRING.encodeWithTag(writer, 1, (Object)value.name());
                SchemaEncoder.access$getRpcEncoder$p(this.this$0).asRepeated().encodeWithTag(writer, 2, value.rpcs());
                SchemaEncoder.access$getServiceOptionsProtoAdapter$p(this.this$0).encodeWithTag(writer, 3, SchemaEncoder.access$toJsonOptions(this.this$0, value.options()));
            }
            {
                this.this$0 = this$0;
            }
        };
        this.rpcEncoder = new Encoder<Rpc>(this){
            final /* synthetic */ SchemaEncoder this$0;

            public void encode(@NotNull ProtoWriter writer, @NotNull Rpc value) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                ProtoAdapter.STRING.encodeWithTag(writer, 1, (Object)value.getName());
                ProtoType protoType = value.getRequestType();
                Intrinsics.checkNotNull((Object)protoType);
                ProtoAdapter.STRING.encodeWithTag(writer, 2, (Object)SchemaEncoder.access$getDotName$p(this.this$0, protoType));
                ProtoType protoType2 = value.getResponseType();
                Intrinsics.checkNotNull((Object)protoType2);
                ProtoAdapter.STRING.encodeWithTag(writer, 3, (Object)SchemaEncoder.access$getDotName$p(this.this$0, protoType2));
                SchemaEncoder.access$getRpcOptionsProtoAdapter$p(this.this$0).encodeWithTag(writer, 4, SchemaEncoder.access$toJsonOptions(this.this$0, value.getOptions()));
                if (value.getRequestStreaming()) {
                    ProtoAdapter.BOOL.encodeWithTag(writer, 5, (Object)value.getRequestStreaming());
                }
                if (value.getResponseStreaming()) {
                    ProtoAdapter.BOOL.encodeWithTag(writer, 6, (Object)value.getResponseStreaming());
                }
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    public static final /* synthetic */ Encoder access$getMessageEncoder$p(SchemaEncoder $this) {
        return $this.messageEncoder;
    }

    public static final /* synthetic */ Encoder access$getEnumEncoder$p(SchemaEncoder $this) {
        return $this.enumEncoder;
    }

    public static final /* synthetic */ Encoder access$getServiceEncoder$p(SchemaEncoder $this) {
        return $this.serviceEncoder;
    }

    public static final /* synthetic */ Encoder access$getFieldEncoder$p(SchemaEncoder $this) {
        return $this.fieldEncoder;
    }

    public static final /* synthetic */ String access$getDotName$p(SchemaEncoder $this, ProtoType $this$access_u24dotName_u24p) {
        return $this.getDotName($this$access_u24dotName_u24p);
    }

    public static final /* synthetic */ ProtoAdapter access$getFileOptionsProtoAdapter$p(SchemaEncoder $this) {
        return $this.fileOptionsProtoAdapter;
    }

    public static final /* synthetic */ Object access$toJsonOptions(SchemaEncoder $this, Options $this$access_u24toJsonOptions) {
        return $this.toJsonOptions($this$access_u24toJsonOptions);
    }

    public static final /* synthetic */ Schema access$getSchema$p(SchemaEncoder $this) {
        return $this.schema;
    }

    public static final /* synthetic */ Map access$collectSyntheticMapEntries(SchemaEncoder $this, String enclosingTypeOrPackage, List fields) {
        return $this.collectSyntheticMapEntries(enclosingTypeOrPackage, fields);
    }

    public static final /* synthetic */ Encoder access$getSyntheticMapEntryEncoder$p(SchemaEncoder $this) {
        return $this.syntheticMapEntryEncoder;
    }

    public static final /* synthetic */ Encoder access$getOneOfEncoder$p(SchemaEncoder $this) {
        return $this.oneOfEncoder;
    }

    public static final /* synthetic */ ProtoAdapter access$getMessageOptionsProtoAdapter$p(SchemaEncoder $this) {
        return $this.messageOptionsProtoAdapter;
    }

    public static final /* synthetic */ int access$getTypeTag$p(SchemaEncoder $this, ProtoType $this$access_u24typeTag_u24p) {
        return $this.getTypeTag($this$access_u24typeTag_u24p);
    }

    public static final /* synthetic */ int access$getLabelTag$p(SchemaEncoder $this, Field $this$access_u24labelTag_u24p) {
        return $this.getLabelTag($this$access_u24labelTag_u24p);
    }

    public static final /* synthetic */ ProtoAdapter access$getFieldOptionsProtoAdapter$p(SchemaEncoder $this) {
        return $this.fieldOptionsProtoAdapter;
    }

    public static final /* synthetic */ Encoder access$getEnumConstantEncoder$p(SchemaEncoder $this) {
        return $this.enumConstantEncoder;
    }

    public static final /* synthetic */ ProtoAdapter access$getEnumOptionsProtoAdapter$p(SchemaEncoder $this) {
        return $this.enumOptionsProtoAdapter;
    }

    public static final /* synthetic */ ProtoAdapter access$getEnumValueOptionsProtoAdapter$p(SchemaEncoder $this) {
        return $this.enumValueOptionsProtoAdapter;
    }

    public static final /* synthetic */ Encoder access$getRpcEncoder$p(SchemaEncoder $this) {
        return $this.rpcEncoder;
    }

    public static final /* synthetic */ ProtoAdapter access$getServiceOptionsProtoAdapter$p(SchemaEncoder $this) {
        return $this.serviceOptionsProtoAdapter;
    }

    public static final /* synthetic */ ProtoAdapter access$getRpcOptionsProtoAdapter$p(SchemaEncoder $this) {
        return $this.rpcOptionsProtoAdapter;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/squareup/wire/schema/internal/SchemaEncoder$SyntheticMapEntry;", "", "enclosingTypeOrPackage", "", "name", "keyType", "Lcom/squareup/wire/schema/ProtoType;", "valueType", "(Ljava/lang/String;Ljava/lang/String;Lcom/squareup/wire/schema/ProtoType;Lcom/squareup/wire/schema/ProtoType;)V", "fieldType", "getFieldType", "()Lcom/squareup/wire/schema/ProtoType;", "getKeyType", "getName", "()Ljava/lang/String;", "getValueType", "wire-schema"})
    private static final class SyntheticMapEntry {
        @NotNull
        private final ProtoType fieldType;
        @NotNull
        private final String name;
        @NotNull
        private final ProtoType keyType;
        @NotNull
        private final ProtoType valueType;

        @NotNull
        public final ProtoType getFieldType() {
            return this.fieldType;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final ProtoType getKeyType() {
            return this.keyType;
        }

        @NotNull
        public final ProtoType getValueType() {
            return this.valueType;
        }

        public SyntheticMapEntry(@Nullable String enclosingTypeOrPackage, @NotNull String name, @NotNull ProtoType keyType, @NotNull ProtoType valueType) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
            Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
            this.name = name;
            this.keyType = keyType;
            this.valueType = valueType;
            this.fieldType = ProtoType.Companion.get(enclosingTypeOrPackage, this.name);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0014\b\u0082\b\u0018\u00002\u00020\u0001B9\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0015JF\u0010 \u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001\u00a2\u0006\u0002\u0010!J\u0013\u0010\"\u001a\u00020\u00122\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020\u000bH\u00d6\u0001J\t\u0010%\u001a\u00020\tH\u00d6\u0001R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0015\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006&"}, d2={"Lcom/squareup/wire/schema/internal/SchemaEncoder$EncodedField;", "", "syntax", "Lcom/squareup/wire/Syntax;", "field", "Lcom/squareup/wire/schema/Field;", "type", "Lcom/squareup/wire/schema/ProtoType;", "extendee", "", "oneOfIndex", "", "(Lcom/squareup/wire/Syntax;Lcom/squareup/wire/schema/Field;Lcom/squareup/wire/schema/ProtoType;Ljava/lang/String;Ljava/lang/Integer;)V", "getExtendee", "()Ljava/lang/String;", "getField", "()Lcom/squareup/wire/schema/Field;", "isProto3Optional", "", "()Z", "getOneOfIndex", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getSyntax", "()Lcom/squareup/wire/Syntax;", "getType", "()Lcom/squareup/wire/schema/ProtoType;", "component1", "component2", "component3", "component4", "component5", "copy", "(Lcom/squareup/wire/Syntax;Lcom/squareup/wire/schema/Field;Lcom/squareup/wire/schema/ProtoType;Ljava/lang/String;Ljava/lang/Integer;)Lcom/squareup/wire/schema/internal/SchemaEncoder$EncodedField;", "equals", "other", "hashCode", "toString", "wire-schema"})
    private static final class EncodedField {
        @Nullable
        private final Syntax syntax;
        @NotNull
        private final Field field;
        @NotNull
        private final ProtoType type;
        @Nullable
        private final String extendee;
        @Nullable
        private final Integer oneOfIndex;

        public final boolean isProto3Optional() {
            return this.syntax == Syntax.PROTO_3 && this.field.getLabel() == Field.Label.OPTIONAL;
        }

        @Nullable
        public final Syntax getSyntax() {
            return this.syntax;
        }

        @NotNull
        public final Field getField() {
            return this.field;
        }

        @NotNull
        public final ProtoType getType() {
            return this.type;
        }

        @Nullable
        public final String getExtendee() {
            return this.extendee;
        }

        @Nullable
        public final Integer getOneOfIndex() {
            return this.oneOfIndex;
        }

        public EncodedField(@Nullable Syntax syntax, @NotNull Field field, @NotNull ProtoType type, @Nullable String extendee, @Nullable Integer oneOfIndex) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.syntax = syntax;
            this.field = field;
            this.type = type;
            this.extendee = extendee;
            this.oneOfIndex = oneOfIndex;
        }

        public /* synthetic */ EncodedField(Syntax syntax, Field field, ProtoType protoType, String string, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                ProtoType protoType2 = field.getType();
                Intrinsics.checkNotNull((Object)protoType2);
                protoType = protoType2;
            }
            if ((n2 & 8) != 0) {
                string = null;
            }
            if ((n2 & 0x10) != 0) {
                n = null;
            }
            this(syntax, field, protoType, string, n);
        }

        @Nullable
        public final Syntax component1() {
            return this.syntax;
        }

        @NotNull
        public final Field component2() {
            return this.field;
        }

        @NotNull
        public final ProtoType component3() {
            return this.type;
        }

        @Nullable
        public final String component4() {
            return this.extendee;
        }

        @Nullable
        public final Integer component5() {
            return this.oneOfIndex;
        }

        @NotNull
        public final EncodedField copy(@Nullable Syntax syntax, @NotNull Field field, @NotNull ProtoType type, @Nullable String extendee, @Nullable Integer oneOfIndex) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new EncodedField(syntax, field, type, extendee, oneOfIndex);
        }

        public static /* synthetic */ EncodedField copy$default(EncodedField encodedField, Syntax syntax, Field field, ProtoType protoType, String string, Integer n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                syntax = encodedField.syntax;
            }
            if ((n2 & 2) != 0) {
                field = encodedField.field;
            }
            if ((n2 & 4) != 0) {
                protoType = encodedField.type;
            }
            if ((n2 & 8) != 0) {
                string = encodedField.extendee;
            }
            if ((n2 & 0x10) != 0) {
                n = encodedField.oneOfIndex;
            }
            return encodedField.copy(syntax, field, protoType, string, n);
        }

        @NotNull
        public String toString() {
            return "EncodedField(syntax=" + this.syntax + ", field=" + this.field + ", type=" + this.type + ", extendee=" + this.extendee + ", oneOfIndex=" + this.oneOfIndex + ")";
        }

        public int hashCode() {
            Syntax syntax = this.syntax;
            Field field = this.field;
            ProtoType protoType = this.type;
            String string = this.extendee;
            Integer n = this.oneOfIndex;
            return ((((syntax != null ? syntax.hashCode() : 0) * 31 + (field != null ? ((Object)field).hashCode() : 0)) * 31 + (protoType != null ? ((Object)protoType).hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (n != null ? ((Object)n).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof EncodedField)) break block3;
                    EncodedField encodedField = (EncodedField)object;
                    if (!Intrinsics.areEqual((Object)this.syntax, (Object)encodedField.syntax) || !Intrinsics.areEqual((Object)this.field, (Object)encodedField.field) || !Intrinsics.areEqual((Object)this.type, (Object)encodedField.type) || !Intrinsics.areEqual((Object)this.extendee, (Object)encodedField.extendee) || !Intrinsics.areEqual((Object)this.oneOfIndex, (Object)encodedField.oneOfIndex)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/squareup/wire/schema/internal/SchemaEncoder$EncodedOneOf;", "", "name", "", "fields", "", "Lcom/squareup/wire/schema/internal/SchemaEncoder$EncodedField;", "(Ljava/lang/String;Ljava/util/List;)V", "getFields", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "wire-schema"})
    private static final class EncodedOneOf {
        @NotNull
        private final String name;
        @NotNull
        private final List<EncodedField> fields;

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final List<EncodedField> getFields() {
            return this.fields;
        }

        public EncodedOneOf(@NotNull String name, @NotNull List<EncodedField> fields) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(fields, (String)"fields");
            this.name = name;
            this.fields = fields;
        }

        public /* synthetic */ EncodedOneOf(String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                boolean bl = false;
                list = CollectionsKt.emptyList();
            }
            this(string, list);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\"\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\f\u001a\u00028\u00002\u0006\u0010\n\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/squareup/wire/schema/internal/SchemaEncoder$Encoder;", "T", "Lcom/squareup/wire/ProtoAdapter;", "()V", "decode", "reader", "Lcom/squareup/wire/ProtoReader;", "(Lcom/squareup/wire/ProtoReader;)Ljava/lang/Object;", "encodedSize", "", "value", "(Ljava/lang/Object;)I", "redact", "(Ljava/lang/Object;)Ljava/lang/Object;", "wire-schema"})
    private static abstract class Encoder<T>
    extends ProtoAdapter<T> {
        public T redact(T value) {
            return value;
        }

        public int encodedSize(T value) {
            Buffer buffer = new Buffer();
            ProtoWriter writer = new ProtoWriter((BufferedSink)buffer);
            this.encode(writer, value);
            int n = (int)buffer.size();
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            buffer.clear();
            return n;
        }

        public T decode(@NotNull ProtoReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            throw (Throwable)new UnsupportedOperationException();
        }

        public Encoder() {
            super(FieldEncoding.LENGTH_DELIMITED, null, null, Syntax.PROTO_2);
        }
    }
}

