

package com.squareup.wire.schema.internal.parser;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Location;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_RpcElement extends RpcElement {

  private final Location location;

  private final String name;

  private final String documentation;

  private final String requestType;

  private final String responseType;

  private final boolean requestStreaming;

  private final boolean responseStreaming;

  private final ImmutableList<OptionElement> options;

  private AutoValue_RpcElement(
      Location location,
      String name,
      String documentation,
      String requestType,
      String responseType,
      boolean requestStreaming,
      boolean responseStreaming,
      ImmutableList<OptionElement> options) {
    this.location = location;
    this.name = name;
    this.documentation = documentation;
    this.requestType = requestType;
    this.responseType = responseType;
    this.requestStreaming = requestStreaming;
    this.responseStreaming = responseStreaming;
    this.options = options;
  }

  @Override
  public Location location() {
    return location;
  }

  @Override
  public String name() {
    return name;
  }

  @Override
  public String documentation() {
    return documentation;
  }

  @Override
  public String requestType() {
    return requestType;
  }

  @Override
  public String responseType() {
    return responseType;
  }

  @Override
  public boolean requestStreaming() {
    return requestStreaming;
  }

  @Override
  public boolean responseStreaming() {
    return responseStreaming;
  }

  @Override
  public ImmutableList<OptionElement> options() {
    return options;
  }

  @Override
  public String toString() {
    return "RpcElement{"
         + "location=" + location + ", "
         + "name=" + name + ", "
         + "documentation=" + documentation + ", "
         + "requestType=" + requestType + ", "
         + "responseType=" + responseType + ", "
         + "requestStreaming=" + requestStreaming + ", "
         + "responseStreaming=" + responseStreaming + ", "
         + "options=" + options
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof RpcElement) {
      RpcElement that = (RpcElement) o;
      return (this.location.equals(that.location()))
           && (this.name.equals(that.name()))
           && (this.documentation.equals(that.documentation()))
           && (this.requestType.equals(that.requestType()))
           && (this.responseType.equals(that.responseType()))
           && (this.requestStreaming == that.requestStreaming())
           && (this.responseStreaming == that.responseStreaming())
           && (this.options.equals(that.options()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= location.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= documentation.hashCode();
    h$ *= 1000003;
    h$ ^= requestType.hashCode();
    h$ *= 1000003;
    h$ ^= responseType.hashCode();
    h$ *= 1000003;
    h$ ^= requestStreaming ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= responseStreaming ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= options.hashCode();
    return h$;
  }

  static final class Builder implements RpcElement.Builder {
    private Location location;
    private String name;
    private String documentation;
    private String requestType;
    private String responseType;
    private Boolean requestStreaming;
    private Boolean responseStreaming;
    private ImmutableList<OptionElement> options;
    Builder() {
    }
    @Override
    public RpcElement.Builder location(Location location) {
      if (location == null) {
        throw new NullPointerException("Null location");
      }
      this.location = location;
      return this;
    }
    @Override
    public RpcElement.Builder name(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public RpcElement.Builder documentation(String documentation) {
      if (documentation == null) {
        throw new NullPointerException("Null documentation");
      }
      this.documentation = documentation;
      return this;
    }
    @Override
    public RpcElement.Builder requestType(String requestType) {
      if (requestType == null) {
        throw new NullPointerException("Null requestType");
      }
      this.requestType = requestType;
      return this;
    }
    @Override
    public RpcElement.Builder responseType(String responseType) {
      if (responseType == null) {
        throw new NullPointerException("Null responseType");
      }
      this.responseType = responseType;
      return this;
    }
    @Override
    public RpcElement.Builder requestStreaming(boolean requestStreaming) {
      this.requestStreaming = requestStreaming;
      return this;
    }
    @Override
    public RpcElement.Builder responseStreaming(boolean responseStreaming) {
      this.responseStreaming = responseStreaming;
      return this;
    }
    @Override
    public RpcElement.Builder options(ImmutableList<OptionElement> options) {
      if (options == null) {
        throw new NullPointerException("Null options");
      }
      this.options = options;
      return this;
    }
    @Override
    public RpcElement build() {
      String missing = "";
      if (this.location == null) {
        missing += " location";
      }
      if (this.name == null) {
        missing += " name";
      }
      if (this.documentation == null) {
        missing += " documentation";
      }
      if (this.requestType == null) {
        missing += " requestType";
      }
      if (this.responseType == null) {
        missing += " responseType";
      }
      if (this.requestStreaming == null) {
        missing += " requestStreaming";
      }
      if (this.responseStreaming == null) {
        missing += " responseStreaming";
      }
      if (this.options == null) {
        missing += " options";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_RpcElement(
          this.location,
          this.name,
          this.documentation,
          this.requestType,
          this.responseType,
          this.requestStreaming,
          this.responseStreaming,
          this.options);
    }
  }

}
