/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MarkSet;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Rpc;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.RpcElement;
import com.squareup.wire.schema.internal.parser.ServiceElement;
import java.util.List;

public final class Service {
    private final ProtoType protoType;
    private final ServiceElement element;
    private final ImmutableList<Rpc> rpcs;
    private final Options options;

    private Service(ProtoType protoType, ServiceElement element, ImmutableList<Rpc> rpcs, Options options) {
        this.protoType = protoType;
        this.element = element;
        this.rpcs = rpcs;
        this.options = options;
    }

    public static Service get(ProtoType protoType, ServiceElement element) {
        ImmutableList.Builder rpcs = ImmutableList.builder();
        for (RpcElement rpc : element.rpcs()) {
            rpcs.add((Object)new Rpc(rpc, new Options(Options.METHOD_OPTIONS, (List<OptionElement>)rpc.options())));
        }
        Options options = new Options(Options.SERVICE_OPTIONS, (List<OptionElement>)element.options());
        return new Service(protoType, element, (ImmutableList<Rpc>)rpcs.build(), options);
    }

    public Location location() {
        return this.element.location();
    }

    public ProtoType type() {
        return this.protoType;
    }

    public String documentation() {
        return this.element.documentation();
    }

    public ImmutableList<Rpc> rpcs() {
        return this.rpcs;
    }

    public Rpc rpc(String name) {
        for (Rpc rpc : this.rpcs) {
            if (!rpc.name().equals(name)) continue;
            return rpc;
        }
        return null;
    }

    public Options options() {
        return this.options;
    }

    void link(Linker linker) {
        linker = linker.withContext(this);
        for (Rpc rpc : this.rpcs) {
            rpc.link(linker);
        }
    }

    void linkOptions(Linker linker) {
        linker = linker.withContext(this);
        for (Rpc rpc : this.rpcs) {
            rpc.linkOptions(linker);
        }
        this.options.link(linker);
    }

    void validate(Linker linker) {
        linker = linker.withContext(this);
        for (Rpc rpc : this.rpcs) {
            rpc.validate(linker);
        }
    }

    Service retainAll(Schema schema, MarkSet markSet) {
        if (!markSet.contains(this.protoType)) {
            return null;
        }
        ImmutableList.Builder retainedRpcs = ImmutableList.builder();
        for (Rpc rpc : this.rpcs) {
            Rpc retainedRpc = rpc.retainAll(schema, markSet);
            if (retainedRpc == null || !markSet.contains(ProtoMember.get(this.protoType, rpc.name()))) continue;
            retainedRpcs.add((Object)retainedRpc);
        }
        return new Service(this.protoType, this.element, (ImmutableList<Rpc>)retainedRpcs.build(), this.options.retainAll(schema, markSet));
    }
}

