/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Pruner;
import com.squareup.wire.schema.Rpc;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.RpcElement;
import com.squareup.wire.schema.internal.parser.ServiceElement;
import java.util.List;
import java.util.NavigableSet;

public final class Service {
    private final ProtoType protoType;
    private final ServiceElement element;
    private final ImmutableList<Rpc> rpcs;
    private final Options options;

    private Service(ProtoType protoType, ServiceElement element, ImmutableList<Rpc> rpcs, Options options) {
        this.protoType = protoType;
        this.element = element;
        this.rpcs = rpcs;
        this.options = options;
    }

    public static Service get(ProtoType protoType, ServiceElement element) {
        ImmutableList.Builder rpcs = ImmutableList.builder();
        for (RpcElement rpc : element.rpcs()) {
            rpcs.add((Object)new Rpc(rpc));
        }
        Options options = new Options(Options.SERVICE_OPTIONS, (List<OptionElement>)element.options());
        return new Service(protoType, element, (ImmutableList<Rpc>)rpcs.build(), options);
    }

    public Location location() {
        return this.element.location();
    }

    public ProtoType type() {
        return this.protoType;
    }

    public String documentation() {
        return this.element.documentation();
    }

    public ImmutableList<Rpc> rpcs() {
        return this.rpcs;
    }

    public Rpc rpc(String name) {
        for (Rpc rpc : this.rpcs) {
            if (!rpc.name().equals(name)) continue;
            return rpc;
        }
        return null;
    }

    public Options options() {
        return this.options;
    }

    void link(Linker linker) {
        linker = linker.withContext(this);
        for (Rpc rpc : this.rpcs) {
            rpc.link(linker);
        }
    }

    void linkOptions(Linker linker) {
        linker = linker.withContext(this);
        for (Rpc rpc : this.rpcs) {
            rpc.linkOptions(linker);
        }
        this.options.link(linker);
    }

    void validate(Linker linker) {
        linker = linker.withContext(this);
        for (Rpc rpc : this.rpcs) {
            rpc.validate(linker);
        }
    }

    Service retainAll(NavigableSet<String> identifiers) {
        String serviceName = this.protoType.toString();
        if (!identifiers.contains(serviceName)) {
            return null;
        }
        ImmutableList retainedRpcs = this.rpcs;
        if (Pruner.hasMarkedMember(identifiers, this.protoType)) {
            ImmutableList.Builder retainedRpcsBuilder = ImmutableList.builder();
            for (Rpc rpc : this.rpcs) {
                if (!identifiers.contains(serviceName + '#' + rpc.name())) continue;
                retainedRpcsBuilder.add((Object)rpc);
            }
            retainedRpcs = retainedRpcsBuilder.build();
        }
        return new Service(this.protoType, this.element, retainedRpcs, this.options);
    }
}

