/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.parser.OptionElement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Options {
    public static final ProtoType FILE_OPTIONS = ProtoType.get("google.protobuf.FileOptions");
    public static final ProtoType MESSAGE_OPTIONS = ProtoType.get("google.protobuf.MessageOptions");
    public static final ProtoType FIELD_OPTIONS = ProtoType.get("google.protobuf.FieldOptions");
    public static final ProtoType ENUM_OPTIONS = ProtoType.get("google.protobuf.EnumOptions");
    public static final ProtoType ENUM_VALUE_OPTIONS = ProtoType.get("google.protobuf.EnumValueOptions");
    public static final ProtoType SERVICE_OPTIONS = ProtoType.get("google.protobuf.ServiceOptions");
    public static final ProtoType METHOD_OPTIONS = ProtoType.get("google.protobuf.MethodOptions");
    private final ProtoType optionType;
    private final ImmutableList<OptionElement> optionElements;
    private ImmutableMap<Field, Object> map;

    public Options(ProtoType optionType, List<OptionElement> elements) {
        this.optionType = optionType;
        this.optionElements = ImmutableList.copyOf(elements);
    }

    public Map<Field, Object> map() {
        return this.map;
    }

    public Object get(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        OptionElement found = null;
        for (OptionElement option : this.optionElements) {
            if (!option.name().equals(name)) continue;
            if (found != null) {
                throw new IllegalStateException("Multiple options match name: " + name);
            }
            found = option;
        }
        return found != null ? found.value() : null;
    }

    public boolean optionMatches(String namePattern, String valuePattern) {
        Matcher nameMatcher = Pattern.compile(namePattern).matcher("");
        Matcher valueMatcher = Pattern.compile(valuePattern).matcher("");
        for (OptionElement option : this.optionElements) {
            if (!nameMatcher.reset(option.name()).matches() || !valueMatcher.reset(String.valueOf(option.value())).matches()) continue;
            return true;
        }
        return false;
    }

    void link(Linker linker) {
        ImmutableMap<Field, Object> map = ImmutableMap.of();
        for (OptionElement option : this.optionElements) {
            Map<Field, Object> canonicalOption = this.canonicalizeOption(linker, this.optionType, option);
            if (canonicalOption == null) continue;
            map = this.union(linker, (Map<Field, Object>)map, canonicalOption);
        }
        this.map = map;
    }

    Map<Field, Object> canonicalizeOption(Linker linker, ProtoType extensionType, OptionElement option) {
        LinkedHashMap<Field, Object> result;
        Type type = linker.get(extensionType);
        if (!(type instanceof MessageType)) {
            return null;
        }
        Map<String, Field> extensionsForType = ((MessageType)type).extensionFieldsMap();
        String[] path = Options.resolveFieldPath(option.name(), extensionsForType.keySet());
        String packageName = linker.packageName();
        if (path == null && packageName != null) {
            path = Options.resolveFieldPath(packageName + "." + option.name(), extensionsForType.keySet());
        }
        if (path == null) {
            return null;
        }
        LinkedHashMap<Field, Object> last = result = new LinkedHashMap<Field, Object>();
        Field field = extensionsForType.get(path[0]);
        for (int i = 1; i < path.length; ++i) {
            LinkedHashMap nested = new LinkedHashMap();
            last.put(field, nested);
            last = nested;
            field = linker.dereference(field, path[i]);
            if (field != null) continue;
            return null;
        }
        last.put(field, this.canonicalizeValue(linker, field, option.value()));
        return result;
    }

    static String[] resolveFieldPath(String name, Set<String> fullyQualifiedNames) {
        for (int i = 0; i < name.length(); ++i) {
            String candidate;
            if ((i = name.indexOf(46, i)) == -1) {
                i = name.length();
            }
            if (!fullyQualifiedNames.contains(candidate = name.substring(0, i))) continue;
            String[] path = name.substring(i).split("\\.", -1);
            path[0] = name.substring(0, i);
            return path;
        }
        return null;
    }

    private Object canonicalizeValue(Linker linker, Field context, Object value) {
        if (value instanceof OptionElement) {
            ImmutableMap.Builder result = ImmutableMap.builder();
            OptionElement option = (OptionElement)value;
            Field field = linker.dereference(context, option.name());
            if (field == null) {
                linker.addError("unable to resolve option %s on %s", option.name(), context.type());
            } else {
                result.put((Object)field, this.canonicalizeValue(linker, field, option.value()));
            }
            return this.coerceValueForField(context, result.build());
        }
        if (value instanceof Map) {
            ImmutableMap.Builder result = ImmutableMap.builder();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                String name = (String)entry.getKey();
                Field field = linker.dereference(context, name);
                if (field == null) {
                    linker.addError("unable to resolve option %s on %s", name, context.type());
                    continue;
                }
                result.put((Object)field, this.canonicalizeValue(linker, field, entry.getValue()));
            }
            return this.coerceValueForField(context, result.build());
        }
        if (value instanceof List) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (Object element : (List)value) {
                result.addAll((Iterable)((List)this.canonicalizeValue(linker, context, element)));
            }
            return this.coerceValueForField(context, result.build());
        }
        if (value instanceof String) {
            return this.coerceValueForField(context, value);
        }
        throw new IllegalArgumentException("Unexpected option value: " + value);
    }

    private Object coerceValueForField(Field context, Object value) {
        if (context.isRepeated()) {
            return value instanceof List ? value : ImmutableList.of((Object)value);
        }
        return value instanceof List ? Iterables.getOnlyElement((Iterable)((List)value)) : value;
    }

    private Object union(Linker linker, Object a, Object b) {
        if (a instanceof List) {
            return this.union((List)a, (List)b);
        }
        if (a instanceof Map) {
            return this.union(linker, (Map)a, (Map)b);
        }
        linker.addError("conflicting options: %s, %s", a, b);
        return a;
    }

    private ImmutableMap<Field, Object> union(Linker linker, Map<Field, Object> a, Map<Field, Object> b) {
        LinkedHashMap<Field, Object> result = new LinkedHashMap<Field, Object>(a);
        for (Map.Entry<Field, Object> entry : b.entrySet()) {
            Object aValue = result.get(entry.getKey());
            Object bValue = entry.getValue();
            Object union = aValue != null ? this.union(linker, aValue, bValue) : bValue;
            result.put(entry.getKey(), union);
        }
        return ImmutableMap.copyOf(result);
    }

    private ImmutableList<Object> union(List<?> a, List<?> b) {
        return ImmutableList.builder().addAll(a).addAll(b).build();
    }

    public ImmutableSet<Field> fields() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        this.gatherFields((ImmutableSet.Builder<Field>)result, this.map);
        return result.build();
    }

    private void gatherFields(ImmutableSet.Builder<Field> sink, Object o) {
        block3: {
            block2: {
                if (!(o instanceof Map)) break block2;
                for (Map.Entry entry : ((Map)o).entrySet()) {
                    sink.add((Object)((Field)entry.getKey()));
                    this.gatherFields(sink, entry.getValue());
                }
                break block3;
            }
            if (!(o instanceof List)) break block3;
            for (Object e : (List)o) {
                this.gatherFields(sink, e);
            }
        }
    }
}

