/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.ProtoType;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.internal.parser.ExtendElement;
import com.squareup.wire.schema.internal.parser.FieldElement;

public final class Extend {
    private final ExtendElement element;
    private final ImmutableList<Field> fields;
    private ProtoType protoType;

    Extend(String packageName, ExtendElement element) {
        this.element = element;
        ImmutableList.Builder fields = ImmutableList.builder();
        for (FieldElement field : element.fields()) {
            fields.add((Object)new Field(packageName, field));
        }
        this.fields = fields.build();
    }

    public Location location() {
        return this.element.location();
    }

    public ProtoType type() {
        return this.protoType;
    }

    public String documentation() {
        return this.element.documentation();
    }

    public ImmutableList<Field> fields() {
        return this.fields;
    }

    void link(Linker linker) {
        linker = linker.withContext(this);
        this.protoType = linker.resolveNamedType(this.element.name());
        for (Field field : this.fields) {
            field.link(linker);
        }
    }

    void validate(Linker linker) {
        linker = linker.withContext(this);
        for (Field field : this.fields) {
            field.validate(linker, true);
        }
        linker.validateImport(this.location(), this.type());
    }
}

