/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.ProtoType;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.OptionElement;
import java.util.List;

public final class Field {
    private final String packageName;
    private final FieldElement element;
    private final Options options;
    private ProtoType type;

    Field(String packageName, FieldElement element) {
        this.packageName = packageName;
        this.element = element;
        this.options = new Options(Options.FIELD_OPTIONS, (List<OptionElement>)element.options());
    }

    public Location location() {
        return this.element.location();
    }

    public String packageName() {
        return this.packageName;
    }

    public Label label() {
        return this.element.label();
    }

    public boolean isRepeated() {
        return this.label() == Label.REPEATED;
    }

    public boolean isOptional() {
        return this.label() == Label.OPTIONAL;
    }

    public boolean isRequired() {
        return this.label() == Label.REQUIRED;
    }

    public ProtoType type() {
        return this.type;
    }

    public String name() {
        return this.element.name();
    }

    public int tag() {
        return this.element.tag();
    }

    public String documentation() {
        return this.element.documentation();
    }

    public Options options() {
        return this.options;
    }

    public boolean isDeprecated() {
        return "true".equals(this.options().get("deprecated"));
    }

    public boolean isPacked() {
        return "true".equals(this.options().get("packed"));
    }

    public Object getDefault() {
        return this.options.get("default");
    }

    void link(Linker linker) {
        linker = linker.withContext(this);
        this.type = linker.resolveType(this.element.type());
    }

    void linkOptions(Linker linker) {
        linker = linker.withContext(this);
        this.options.link(linker);
    }

    public String toString() {
        return this.name();
    }

    void validate(Linker linker, boolean extension) {
        linker = linker.withContext(this);
        if (this.isPacked() && !this.isPackable(linker, this.type)) {
            linker.addError("packed=true not permitted on %s", this.type);
        }
        if (extension && this.isRequired()) {
            linker.addError("extension fields cannot be required", this.type);
        }
        linker.validateImport(this.location(), this.type);
    }

    private boolean isPackable(Linker linker, ProtoType type) {
        return !type.equals(ProtoType.STRING) && !type.equals(ProtoType.BYTES) && !(linker.get(type) instanceof MessageType);
    }

    public static enum Label {
        OPTIONAL,
        REQUIRED,
        REPEATED,
        ONE_OF;

    }
}

