/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ProtoParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import okio.Okio;
import okio.Source;

public final class SchemaLoader {
    private final List<Path> directories = new ArrayList<Path>();
    private final List<Path> protos = new ArrayList<Path>();
    private final Map<Path, ZipFile> zipFiles = new LinkedHashMap<Path, ZipFile>();

    public SchemaLoader addDirectory(File file) {
        return this.addDirectory(file.toPath());
    }

    public SchemaLoader addDirectory(Path path) {
        this.directories.add(path);
        return this;
    }

    public List<Path> directories() {
        return this.directories;
    }

    public SchemaLoader addProto(File file) {
        return this.addProto(file.toPath());
    }

    public SchemaLoader addProto(Path path) {
        this.protos.add(path);
        return this;
    }

    public List<Path> protos() {
        return this.protos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema load() throws IOException {
        if (this.directories.isEmpty()) {
            throw new IllegalStateException("No directories added.");
        }
        try {
            for (Path directory : this.directories) {
                if (!Files.isRegularFile(directory, new LinkOption[0])) continue;
                try {
                    ZipFile zipFile = new ZipFile(directory.toFile());
                    this.zipFiles.put(directory, zipFile);
                }
                catch (IOException zipFile) {}
            }
            Schema schema = this.loadZipsAndDirectories();
            return schema;
        }
        finally {
            for (ZipFile zipFile : this.zipFiles.values()) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            this.zipFiles.clear();
        }
    }

    private Schema loadZipsAndDirectories() throws IOException {
        ArrayDeque<Path> protos = new ArrayDeque<Path>(this.protos);
        if (protos.isEmpty()) {
            // empty if block
        }
        LinkedHashMap<Path, ProtoFile> loaded = new LinkedHashMap<Path, ProtoFile>();
        while (!protos.isEmpty()) {
            Path proto = (Path)protos.removeFirst();
            if (loaded.containsKey(proto)) continue;
            ProtoFileElement element = null;
            for (Path directory : this.directories) {
                Source source;
                if (proto.isAbsolute() && !proto.startsWith(directory) || (source = this.source(proto, directory)) == null) continue;
                try {
                    Location location = Location.get(directory.toString(), proto.toString());
                    String data = Okio.buffer((Source)source).readUtf8();
                    element = ProtoParser.parse(location, data);
                }
                catch (IOException e) {
                    throw new IOException("Failed to load " + proto + " from " + directory, e);
                }
                finally {
                    source.close();
                }
            }
            if (element == null) {
                throw new FileNotFoundException("Failed to locate " + proto + " in " + this.directories);
            }
            ProtoFile protoFile = ProtoFile.get(element);
            loaded.put(proto, protoFile);
            FileSystem fs = proto.getFileSystem();
            for (String importPath : element.imports()) {
                protos.addLast(fs.getPath(importPath, new String[0]));
            }
        }
        return new Linker(loaded.values()).link();
    }

    private Source source(Path proto, Path directory) throws IOException {
        ZipEntry zipEntry;
        ZipFile zipFile = this.zipFiles.get(directory);
        if (zipFile != null && (zipEntry = zipFile.getEntry(proto.toString())) != null) {
            return Okio.source((InputStream)zipFile.getInputStream(zipEntry));
        }
        Path resolvedPath = directory.resolve(proto);
        if (Files.exists(resolvedPath, new LinkOption[0])) {
            return Okio.source((Path)resolvedPath, (OpenOption[])new OpenOption[0]);
        }
        return null;
    }
}

