/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.internal.protoparser;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.internal.Util;
import com.squareup.wire.internal.protoparser.AutoValue_RpcElement;
import com.squareup.wire.internal.protoparser.OptionElement;
import com.squareup.wire.schema.Location;

public abstract class RpcElement {
    public static Builder builder(Location location) {
        return new AutoValue_RpcElement.Builder().documentation("").location(location).options((ImmutableList<OptionElement>)ImmutableList.of());
    }

    public abstract Location location();

    public abstract String name();

    public abstract String documentation();

    public abstract String requestType();

    public abstract String responseType();

    public abstract ImmutableList<OptionElement> options();

    public final String toSchema() {
        StringBuilder builder = new StringBuilder();
        Util.appendDocumentation(builder, this.documentation());
        builder.append("rpc ").append(this.name()).append(" (").append(this.requestType()).append(") returns (").append(this.responseType()).append(')');
        if (!this.options().isEmpty()) {
            builder.append(" {\n");
            for (OptionElement option : this.options()) {
                Util.appendIndented(builder, option.toSchemaDeclaration());
            }
            builder.append("}");
        }
        return builder.append(";\n").toString();
    }

    public static interface Builder {
        public Builder location(Location var1);

        public Builder name(String var1);

        public Builder documentation(String var1);

        public Builder requestType(String var1);

        public Builder responseType(String var1);

        public Builder options(ImmutableList<OptionElement> var1);

        public RpcElement build();
    }
}

