/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.internal.protoparser;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.internal.Util;
import com.squareup.wire.internal.protoparser.AutoValue_FieldElement;
import com.squareup.wire.internal.protoparser.OptionElement;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Location;
import java.util.Locale;

public abstract class FieldElement {
    public static Builder builder(Location location) {
        return new AutoValue_FieldElement.Builder().documentation("").options((ImmutableList<OptionElement>)ImmutableList.of()).location(location);
    }

    public abstract Location location();

    public abstract Field.Label label();

    public abstract String type();

    public abstract String name();

    public abstract int tag();

    public abstract String documentation();

    public abstract ImmutableList<OptionElement> options();

    public final String toSchema() {
        StringBuilder builder = new StringBuilder();
        Util.appendDocumentation(builder, this.documentation());
        if (this.label() != null) {
            builder.append(this.label().name().toLowerCase(Locale.US)).append(' ');
        }
        builder.append(this.type()).append(' ').append(this.name()).append(" = ").append(this.tag());
        if (!this.options().isEmpty()) {
            builder.append(" [\n");
            for (OptionElement option : this.options()) {
                Util.appendIndented(builder, option.toSchema());
            }
            builder.append(']');
        }
        return builder.append(";\n").toString();
    }

    public static interface Builder {
        public Builder location(Location var1);

        public Builder label(Field.Label var1);

        public Builder type(String var1);

        public Builder name(String var1);

        public Builder tag(int var1);

        public Builder documentation(String var1);

        public Builder options(ImmutableList<OptionElement> var1);

        public FieldElement build();
    }
}

