/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.base.CharMatcher;
import com.squareup.wire.schema.AutoValue_Location;
import java.io.File;

public abstract class Location {
    public static Location get(String path) {
        return Location.get("", path);
    }

    public static Location get(String base, String path) {
        base = CharMatcher.is((char)'/').trimTrailingFrom((CharSequence)base);
        path = CharMatcher.is((char)'/').trimLeadingFrom((CharSequence)path);
        return new AutoValue_Location(base, path, -1, -1);
    }

    public Location at(int line, int column) {
        return new AutoValue_Location(this.base(), this.path(), line, column);
    }

    public abstract String base();

    public abstract String path();

    public abstract int line();

    public abstract int column();

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (!this.base().isEmpty()) {
            result.append(this.base()).append(File.separator);
        }
        result.append(this.path());
        if (this.line() != -1) {
            result.append(" at ").append(this.line());
            if (this.column() != -1) {
                result.append(':').append(this.column());
            }
        }
        return result.toString();
    }
}

