/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.SchemaLoader;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.BufferedSink;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.fakefilesystem.FakeFileSystem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005J\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ\u001f\u0010\u0012\u001a\u00020\u00002\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0013\"\u00020\u000b\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/squareup/wire/SchemaBuilder;", "", "<init>", "()V", "sourcePath", "Lokio/Path;", "protoPath", "fileSystem", "Lokio/FileSystem;", "opaqueTypes", "", "Lcom/squareup/wire/schema/ProtoType;", "add", "name", "protoFile", "", "path", "addProtoPath", "addOpaqueTypes", "", "([Lcom/squareup/wire/schema/ProtoType;)Lcom/squareup/wire/SchemaBuilder;", "build", "Lcom/squareup/wire/schema/Schema;", "wire-schema-tests"})
@SourceDebugExtension(value={"SMAP\nSchemaBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaBuilder.kt\ncom/squareup/wire/SchemaBuilder\n+ 2 FileSystem.kt\nokio/FileSystem\n+ 3 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,118:1\n80#2:119\n165#2:120\n81#2:121\n82#2:126\n52#3,4:122\n60#3,10:127\n56#3,18:137\n*S KotlinDebug\n*F\n+ 1 SchemaBuilder.kt\ncom/squareup/wire/SchemaBuilder\n*L\n68#1:119\n68#1:120\n68#1:121\n68#1:126\n68#1:122,4\n68#1:127,10\n68#1:137,18\n*E\n"})
public final class SchemaBuilder {
    @NotNull
    private final Path sourcePath = Path.Companion.get$default((Path.Companion)Path.Companion, (String)"/sourcePath", (boolean)false, (int)1, null);
    @NotNull
    private final Path protoPath = Path.Companion.get$default((Path.Companion)Path.Companion, (String)"/protoPath", (boolean)false, (int)1, null);
    @NotNull
    private final FileSystem fileSystem = (FileSystem)new FakeFileSystem(null, 1, null);
    @NotNull
    private List<ProtoType> opaqueTypes = new ArrayList();

    public SchemaBuilder() {
        this.fileSystem.createDirectories(this.sourcePath);
        this.fileSystem.createDirectories(this.protoPath);
    }

    @NotNull
    public final SchemaBuilder add(@NotNull Path name, @NotNull String protoFile) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)protoFile, (String)"protoFile");
        return this.add(name, protoFile, this.sourcePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final SchemaBuilder add(@NotNull Path name, @NotNull String protoFile, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)protoFile, (String)"protoFile");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!StringsKt.endsWith$default((String)name.toString(), (String)".proto", (boolean)false, (int)2, null)) {
            boolean $i$a$-require-SchemaBuilder$add$23332 = false;
            String $i$a$-require-SchemaBuilder$add$23332 = "unexpected file extension for " + name + ". Proto files should use the '.proto' extension";
            throw new IllegalArgumentException($i$a$-require-SchemaBuilder$add$23332.toString());
        }
        try {
            BufferedSink bufferedSink;
            Throwable thrown$iv$iv;
            block18: {
                Path resolvedPath = path.resolve(name);
                Path parent = resolvedPath.parent();
                if (parent != null) {
                    this.fileSystem.createDirectories(parent);
                }
                FileSystem $this$iv = this.fileSystem;
                boolean mustCreate$iv = false;
                boolean bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(resolvedPath, mustCreate$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                    boolean bl2 = false;
                    BufferedSink $this$add_u24lambda_u241 = it$iv;
                    boolean bl3 = false;
                    bufferedSink = $this$add_u24lambda_u241.writeUtf8(protoFile);
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        bufferedSink = null;
                        break block18;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block19: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block19;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            BufferedSink result$iv$iv = bufferedSink;
            Throwable throwable = thrown$iv$iv;
            if (throwable == null) return this;
            throw throwable;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public final SchemaBuilder addProtoPath(@NotNull Path name, @NotNull String protoFile) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)protoFile, (String)"protoFile");
        return this.add(name, protoFile, this.protoPath);
    }

    @NotNull
    public final SchemaBuilder addOpaqueTypes(ProtoType ... opaqueTypes) {
        Intrinsics.checkNotNullParameter((Object)opaqueTypes, (String)"opaqueTypes");
        CollectionsKt.addAll((Collection)this.opaqueTypes, (Object[])opaqueTypes);
        return this;
    }

    @NotNull
    public final Schema build() {
        SchemaLoader schemaLoader = new SchemaLoader(this.fileSystem);
        schemaLoader.setOpaqueTypes(CollectionsKt.toList((Iterable)this.opaqueTypes));
        schemaLoader.initRoots(CollectionsKt.listOf((Object)Location.Companion.get(this.sourcePath.toString())), CollectionsKt.listOf((Object)Location.Companion.get(this.protoPath.toString())));
        return schemaLoader.loadSchema();
    }
}

