/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal;

import com.squareup.wire.schema.EnclosingType;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.parser.OptionElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00060\u0002j\u0002`\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001e\u0010\u0006\u001a\u00020\u0001*\u00060\u0002j\u0002`\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0000\u001a\u0016\u0010\n\u001a\u00020\u0001*\u00060\u0002j\u0002`\u00032\u0006\u0010\u000b\u001a\u00020\u0005\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\rH\u0000\u001a\u0018\u0010\u0013\u001a\u00020\u0014*\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u001a\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0019H\u0002\u001a\f\u0010\u0018\u001a\u00020\u001a*\u00020\u001aH\u0002\u001a\n\u0010\u001b\u001a\u00020\u001c*\u00020\u001c\"\u000e\u0010\f\u001a\u00020\rX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\rX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"appendDocumentation", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "documentation", "", "appendOptions", "options", "", "Lcom/squareup/wire/schema/internal/parser/OptionElement;", "appendIndented", "value", "MIN_TAG_VALUE", "", "MAX_TAG_VALUE", "RESERVED_TAG_VALUE_START", "RESERVED_TAG_VALUE_END", "isValidTag", "", "withStubs", "Lcom/squareup/wire/schema/Schema;", "typesToStub", "", "Lcom/squareup/wire/schema/ProtoType;", "asStub", "Lcom/squareup/wire/schema/Type;", "Lcom/squareup/wire/schema/Service;", "withUnixSlashes", "Lokio/Path;", "wire-schema"})
@SourceDebugExtension(value={"SMAP\nUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Util.kt\ncom/squareup/wire/schema/internal/UtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n1557#2:161\n1628#2,2:162\n1557#2:164\n1628#2,3:165\n1557#2:168\n1628#2,3:169\n1630#2:172\n1557#2:173\n1628#2,3:174\n1557#2:177\n1628#2,3:178\n*S KotlinDebug\n*F\n+ 1 Util.kt\ncom/squareup/wire/schema/internal/UtilKt\n*L\n113#1:161\n113#1:162,2\n115#1:164\n115#1:165,3\n118#1:168\n118#1:169,3\n113#1:172\n135#1:173\n135#1:174,3\n145#1:177\n145#1:178,3\n*E\n"})
public final class UtilKt {
    public static final int MIN_TAG_VALUE = 1;
    public static final int MAX_TAG_VALUE = 0x1FFFFFFF;
    private static final int RESERVED_TAG_VALUE_START = 19000;
    private static final int RESERVED_TAG_VALUE_END = 19999;

    public static final void appendDocumentation(@NotNull StringBuilder $this$appendDocumentation, @NotNull String documentation) {
        Intrinsics.checkNotNullParameter((Object)$this$appendDocumentation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)documentation, (String)"documentation");
        if (((CharSequence)documentation).length() == 0) {
            return;
        }
        String[] stringArray = new String[]{"\n"};
        List lines = StringsKt.split$default((CharSequence)documentation, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (((Collection)lines).size() > 1 && ((CharSequence)CollectionsKt.last((List)lines)).length() == 0) {
            lines = CollectionsKt.dropLast((List)lines, (int)1);
        }
        for (String line : lines) {
            $this$appendDocumentation.append("// ").append(line).append('\n');
        }
    }

    public static final void appendOptions(@NotNull StringBuilder $this$appendOptions, @NotNull List<OptionElement> options) {
        Intrinsics.checkNotNullParameter((Object)$this$appendOptions, (String)"<this>");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        int count = options.size();
        if (count == 1) {
            $this$appendOptions.append('[').append(options.get(0).toSchema()).append(']');
            return;
        }
        $this$appendOptions.append("[\n");
        for (int i = 0; i < count; ++i) {
            String endl = i < count - 1 ? "," : "";
            UtilKt.appendIndented($this$appendOptions, options.get(i).toSchema() + endl);
        }
        $this$appendOptions.append(']');
    }

    public static final void appendIndented(@NotNull StringBuilder $this$appendIndented, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$appendIndented, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String[] stringArray = new String[]{"\n"};
        List lines = StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (((Collection)lines).size() > 1 && ((CharSequence)CollectionsKt.last((List)lines)).length() == 0) {
            lines = CollectionsKt.dropLast((List)lines, (int)1);
        }
        for (String line : lines) {
            $this$appendIndented.append("  ").append(line).append('\n');
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isValidTag(int $this$isValidTag) {
        boolean bl;
        if (1 <= $this$isValidTag) {
            if ($this$isValidTag < 19000) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (20000 > $this$isValidTag) return false;
        if ($this$isValidTag >= 0x20000000) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Schema withStubs(@NotNull Schema $this$withStubs, @NotNull Set<ProtoType> typesToStub) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$withStubs, (String)"<this>");
        Intrinsics.checkNotNullParameter(typesToStub, (String)"typesToStub");
        if (typesToStub.isEmpty()) {
            return $this$withStubs;
        }
        Iterable $this$map$iv = $this$withStubs.getProtoFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection<Service> collection;
            Service type;
            Collection<Type> collection2;
            Iterable $this$mapTo$iv$iv2;
            Iterable $this$map$iv2;
            void protoFile;
            ProtoFile protoFile2 = (ProtoFile)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            Iterable iterable2 = protoFile.getTypes();
            String string = null;
            List list = null;
            List list2 = null;
            List list3 = null;
            Location location = null;
            void var17_17 = protoFile;
            boolean $i$f$map2 = false;
            void var19_19 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                Type type2 = (Type)item$iv$iv2;
                collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add((Type)(typesToStub.contains(((Type)((Object)type)).getType()) ? UtilKt.asStub((Type)((Object)type)) : type));
            }
            collection2 = (List)destination$iv$iv2;
            $this$map$iv2 = protoFile.getServices();
            $i$f$map2 = false;
            $this$mapTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void service;
                type = (Service)item$iv$iv2;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add((Service)(typesToStub.contains(service.type()) ? UtilKt.asStub((Service)service) : service));
            }
            collection = (List)destination$iv$iv2;
            ProtoFile result = ProtoFile.copy$default((ProtoFile)var17_17, location, list3, list2, list, string, collection2, (List)collection, null, null, null, 927, null);
            collection3.add(result);
        }
        Iterable iterable3 = (List)destination$iv$iv;
        return new Schema(iterable3);
    }

    /*
     * WARNING - void declaration
     */
    private static final Type asStub(Type $this$asStub) {
        Type type;
        if (StringsKt.startsWith$default((String)$this$asStub.getType().toString(), (String)"google.protobuf.", (boolean)false, (int)2, null)) {
            type = $this$asStub;
        } else if ($this$asStub instanceof MessageType) {
            Collection<Type> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = ((MessageType)$this$asStub).getNestedTypes();
            List list = null;
            List list2 = new ArrayList();
            List list3 = CollectionsKt.emptyList();
            String string = null;
            String string2 = null;
            Location location = null;
            ProtoType protoType = null;
            MessageType messageType = (MessageType)$this$asStub;
            boolean $i$f$map = false;
            void var3_19 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Type type2 = (Type)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(UtilKt.asStub((Type)it));
            }
            collection = (List)destination$iv$iv;
            type = MessageType.copy$default(messageType, protoType, location, string2, string, list3, list2, list, collection, null, null, null, new Options(Options.MESSAGE_OPTIONS, CollectionsKt.emptyList()), null, 5967, null);
        } else if ($this$asStub instanceof EnumType) {
            type = EnumType.copy$default((EnumType)$this$asStub, null, null, null, null, CollectionsKt.emptyList(), null, new Options(Options.ENUM_OPTIONS, CollectionsKt.emptyList()), null, 175, null);
        } else if ($this$asStub instanceof EnclosingType) {
            Collection<Type> collection;
            Iterable $this$map$iv = ((EnclosingType)$this$asStub).getNestedTypes();
            String string = null;
            String string3 = null;
            ProtoType protoType = null;
            Location location = null;
            EnclosingType enclosingType = (EnclosingType)$this$asStub;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Type it = (Type)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(UtilKt.asStub(it));
            }
            collection = (List)destination$iv$iv;
            type = EnclosingType.copy$default(enclosingType, location, protoType, string3, string, collection, null, null, 111, null);
        } else {
            throw new AssertionError((Object)("Unknown type " + $this$asStub.getType()));
        }
        return type;
    }

    private static final Service asStub(Service $this$asStub) {
        return Service.copy$default($this$asStub, null, null, null, null, CollectionsKt.emptyList(), new Options(Options.SERVICE_OPTIONS, CollectionsKt.emptyList()), 15, null);
    }

    @NotNull
    public static final Path withUnixSlashes(@NotNull Path $this$withUnixSlashes) {
        Intrinsics.checkNotNullParameter((Object)$this$withUnixSlashes, (String)"<this>");
        return Path.Companion.get$default((Path.Companion)Path.Companion, (String)StringsKt.replace$default((String)$this$withUnixSlashes.toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null), (boolean)false, (int)1, null);
    }
}

