/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal;

import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Rpc;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001#B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u0006\u0010\u0018\u001a\u00020\u0003J\b\u0010\u0019\u001a\u00020\u0015H\u0002J\u001a\u0010\u001a\u001a\u00020\u0015*\u00020\r2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0002J\u001a\u0010\u001a\u001a\u00020\u0015*\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0002J\u001a\u0010\u001c\u001a\u00020\u0015*\u00020\u001d2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0002J\u001a\u0010\u001c\u001a\u00020\u0015*\u00020\r2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0002J\u001a\u0010\u001c\u001a\u00020\u0015*\u00020\u001e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0002J\u001a\u0010\u001c\u001a\u00020\u0015*\u00020\u001f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0002J\u001a\u0010\u001c\u001a\u00020\u0015*\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0002J\u0014\u0010 \u001a\u00020\r*\u00020\r2\u0006\u0010!\u001a\u00020\nH\u0002J\f\u0010\"\u001a\u00020\r*\u00020\rH\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/squareup/wire/schema/internal/TypeMover;", "", "oldSchema", "Lcom/squareup/wire/schema/Schema;", "moves", "", "Lcom/squareup/wire/schema/internal/TypeMover$Move;", "(Lcom/squareup/wire/schema/Schema;Ljava/util/List;)V", "errors", "", "", "pathToFile", "", "Lcom/squareup/wire/schema/ProtoFile;", "pathToTypes", "", "Lcom/squareup/wire/schema/ProtoType;", "sourceAndTargetPaths", "", "typeToPath", "checkForErrors", "", "getType", "Lcom/squareup/wire/schema/Type;", "move", "rebuildIndexes", "collectDeclaredTypes", "sink", "collectReferencedTypes", "Lcom/squareup/wire/schema/Field;", "Lcom/squareup/wire/schema/Rpc;", "Lcom/squareup/wire/schema/Service;", "emptyCopy", "path", "fixImports", "Move", "wire-schema"})
public final class TypeMover {
    @NotNull
    private final Schema oldSchema;
    @NotNull
    private final List<Move> moves;
    @NotNull
    private final Map<String, ProtoFile> pathToFile;
    @NotNull
    private final Set<String> sourceAndTargetPaths;
    @NotNull
    private final Map<ProtoType, String> typeToPath;
    @NotNull
    private final Map<String, Set<ProtoType>> pathToTypes;
    @NotNull
    private final List<String> errors;

    /*
     * WARNING - void declaration
     */
    public TypeMover(@NotNull Schema oldSchema, @NotNull List<Move> moves) {
        Map map;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)oldSchema, (String)"oldSchema");
        Intrinsics.checkNotNullParameter(moves, (String)"moves");
        this.oldSchema = oldSchema;
        this.moves = moves;
        Iterable iterable = this.oldSchema.getProtoFiles();
        TypeMover typeMover = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var6_8 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ProtoFile protoFile = (ProtoFile)element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            String string = it.getLocation().getPath();
            map.put(string, element$iv$iv);
        }
        map = destination$iv$iv;
        typeMover.pathToFile = MapsKt.toMutableMap((Map)map);
        boolean bl = false;
        this.sourceAndTargetPaths = new LinkedHashSet();
        bl = false;
        this.typeToPath = new LinkedHashMap();
        bl = false;
        this.pathToTypes = new LinkedHashMap();
        bl = false;
        this.errors = new ArrayList();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Schema move() {
        void $this$mapTo$iv$iv;
        ProtoFile targetProtoFile;
        Object targetPath;
        if (this.moves.isEmpty()) {
            return this.oldSchema;
        }
        for (Move move : this.moves) {
            if (this.oldSchema.protoFile(move.getType()) != null) continue;
            TypeMover typeMover = this;
            Collection collection = typeMover.errors;
            String string = "cannot move " + move.getType() + ", it isn't in this schema";
            boolean bl = false;
            collection.add(string);
        }
        this.checkForErrors();
        this.rebuildIndexes();
        for (Move move : this.moves) {
            int n;
            ProtoFile oldSourceProtoFile;
            List sourceTypes;
            String sourcePath;
            block6: {
                Intrinsics.checkNotNull((Object)this.typeToPath.remove(move.getType()));
                targetPath = move.getTargetPath();
                Intrinsics.checkNotNull((Object)this.pathToFile.get(sourcePath));
                List $this$indexOfFirst$iv = sourceTypes = CollectionsKt.toMutableList((Collection)oldSourceProtoFile.getTypes());
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    Type it = (Type)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getType(), (Object)move.getType())) {
                        n = index$iv;
                        break block6;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int typeIndex = n;
            Type movedType = (Type)sourceTypes.remove(typeIndex);
            Map<String, ProtoFile> $i$f$indexOfFirst = this.pathToFile;
            Object index$iv = ProtoFile.copy$default(oldSourceProtoFile, null, null, null, null, sourceTypes, null, null, null, null, 495, null);
            boolean bl = false;
            $i$f$indexOfFirst.put(sourcePath, (ProtoFile)index$iv);
            index$iv = this.pathToFile.get(targetPath);
            targetProtoFile = index$iv == null ? this.emptyCopy(oldSourceProtoFile, (String)targetPath) : index$iv;
            index$iv = this.pathToFile;
            Object object = ProtoFile.copy$default(targetProtoFile, null, null, null, null, CollectionsKt.plus((Collection)targetProtoFile.getTypes(), (Object)movedType), null, null, null, null, 495, null);
            boolean bl2 = false;
            index$iv.put(targetPath, object);
            index$iv = this;
            object = ((TypeMover)index$iv).sourceAndTargetPaths;
            bl2 = false;
            object.add(sourcePath);
            index$iv = this;
            object = ((TypeMover)index$iv).sourceAndTargetPaths;
            bl2 = false;
            object.add(targetPath);
        }
        this.rebuildIndexes();
        Iterable $this$map$iv = this.pathToFile.values();
        boolean $i$f$map = false;
        targetPath = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            targetProtoFile = (ProtoFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ProtoFile protoFile = this.fixImports((ProtoFile)it);
            collection.add(protoFile);
        }
        List updatedProtoFiles = (List)destination$iv$iv;
        this.checkForErrors();
        return new Schema(updatedProtoFiles);
    }

    private final void rebuildIndexes() {
        this.pathToTypes.clear();
        this.typeToPath.clear();
        Object object = this.pathToFile;
        boolean bl = false;
        Iterator<Map.Entry<String, ProtoFile>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            String path = (String)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            ProtoFile protoFile = (ProtoFile)object3.getValue();
            bl3 = false;
            Set declaredTypes = new LinkedHashSet();
            this.collectDeclaredTypes(protoFile, (Set<ProtoType>)declaredTypes);
            Map<String, Set<ProtoType>> map = this.pathToTypes;
            boolean bl4 = false;
            map.put(path, declaredTypes);
            for (ProtoType protoType : declaredTypes) {
                Map<ProtoType, String> map2 = this.typeToPath;
                boolean bl5 = false;
                map2.put(protoType, path);
            }
        }
    }

    private final ProtoFile fixImports(ProtoFile $this$fixImports) {
        boolean $i$f$none;
        if (!this.sourceAndTargetPaths.contains($this$fixImports.getLocation().getPath())) {
            boolean bl;
            block15: {
                Iterable $this$none$iv = this.sourceAndTargetPaths;
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!($this$fixImports.getImports().contains(it) || $this$fixImports.getPublicImports().contains(it))) continue;
                        bl = false;
                        break block15;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return $this$fixImports;
            }
        }
        $i$f$none = false;
        Set referencedTypes = new LinkedHashSet();
        this.collectReferencedTypes($this$fixImports, (Set<ProtoType>)referencedTypes);
        boolean bl = false;
        Set definitelyNeed = new LinkedHashSet();
        boolean element$iv = false;
        Set possiblyDrop = new LinkedHashSet();
        for (Move move : this.moves) {
            boolean bl3;
            Object object;
            Collection bl2;
            if (referencedTypes.contains(move.getType())) {
                bl2 = definitelyNeed;
                object = move.getType();
                bl3 = false;
                bl2.add(object);
            } else {
                bl2 = possiblyDrop;
                object = move.getType();
                bl3 = false;
                bl2.add(object);
            }
            object = this.oldSchema.protoFile(move.getType());
            if (object == null) {
                String string = Intrinsics.stringPlus((String)"no source file for ", (Object)move.getType());
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Object oldSchemaFile = object;
            if (Intrinsics.areEqual((Object)((ProtoFile)oldSchemaFile).getLocation().getPath(), (Object)$this$fixImports.getLocation().getPath())) {
                this.collectReferencedTypes(this.getType(move), (Set<ProtoType>)possiblyDrop);
            }
            if (!Intrinsics.areEqual((Object)$this$fixImports.getLocation().getPath(), (Object)move.getTargetPath())) continue;
            this.collectReferencedTypes(this.getType(move), (Set<ProtoType>)definitelyNeed);
        }
        boolean move = false;
        Set obsoleteImports = new LinkedHashSet();
        for (ProtoType type : possiblyDrop) {
            boolean bl5;
            String path;
            block16: {
                Set<ProtoType> otherTypesInFile;
                String string = this.typeToPath.get(type);
                if (string == null) continue;
                path = string;
                Intrinsics.checkNotNull(this.pathToTypes.get(path));
                Iterable $this$any$iv = otherTypesInFile;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl5 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        ProtoType it = (ProtoType)element$iv2;
                        boolean bl6 = false;
                        if (!referencedTypes.contains(it)) continue;
                        bl5 = true;
                        break block16;
                    }
                    bl5 = false;
                }
            }
            if (bl5) continue;
            obsoleteImports.add(path);
        }
        List newImports = CollectionsKt.toMutableList((Collection)$this$fixImports.getImports());
        List newPublicImports = CollectionsKt.toMutableList((Collection)$this$fixImports.getPublicImports());
        for (ProtoType requiredType : definitelyNeed) {
            String path;
            Object object = this.typeToPath.get(requiredType);
            if (object == null || Intrinsics.areEqual((Object)(path = object), (Object)$this$fixImports.getLocation().getPath()) || newImports.contains(path) || $this$fixImports.getPublicImports().contains(path)) continue;
            object = newImports;
            boolean bl7 = false;
            object.add(path);
        }
        newImports.removeAll(obsoleteImports);
        newPublicImports.removeAll(obsoleteImports);
        return ProtoFile.copy$default($this$fixImports, null, newImports, newPublicImports, null, null, null, null, null, null, 505, null);
    }

    private final Type getType(Move move) {
        Object element$iv2;
        block1: {
            ProtoFile protoFile = this.pathToFile.get(move.getTargetPath());
            Intrinsics.checkNotNull((Object)protoFile);
            Iterable $this$first$iv = protoFile.getTypes();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Type it = (Type)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)move.getType())) continue;
                break block1;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (Type)element$iv2;
    }

    private final void collectReferencedTypes(ProtoFile $this$collectReferencedTypes, Set<ProtoType> sink) {
        for (Type type : $this$collectReferencedTypes.getTypes()) {
            this.collectReferencedTypes(type, sink);
        }
        for (Service service : $this$collectReferencedTypes.getServices()) {
            this.collectReferencedTypes(service, sink);
        }
    }

    private final void collectReferencedTypes(Type $this$collectReferencedTypes, Set<ProtoType> sink) {
        for (Type type : $this$collectReferencedTypes.getNestedTypes()) {
            this.collectReferencedTypes(type, sink);
        }
        if ($this$collectReferencedTypes instanceof MessageType) {
            for (Field field : ((MessageType)$this$collectReferencedTypes).getFieldsAndOneOfFields()) {
                this.collectReferencedTypes(field, sink);
            }
        }
    }

    private final void collectReferencedTypes(Service $this$collectReferencedTypes, Set<ProtoType> sink) {
        for (Rpc rpc : $this$collectReferencedTypes.rpcs()) {
            this.collectReferencedTypes(rpc, sink);
        }
    }

    private final void collectReferencedTypes(Rpc $this$collectReferencedTypes, Set<ProtoType> sink) {
        Collection collection = sink;
        ProtoType protoType = $this$collectReferencedTypes.getRequestType();
        Intrinsics.checkNotNull((Object)protoType);
        ProtoType protoType2 = protoType;
        boolean bl = false;
        collection.add(protoType2);
        collection = sink;
        ProtoType protoType3 = $this$collectReferencedTypes.getResponseType();
        Intrinsics.checkNotNull((Object)protoType3);
        protoType2 = protoType3;
        bl = false;
        collection.add(protoType2);
    }

    private final void collectReferencedTypes(Field $this$collectReferencedTypes, Set<ProtoType> sink) {
        Collection collection = sink;
        ProtoType protoType = $this$collectReferencedTypes.getType();
        Intrinsics.checkNotNull((Object)protoType);
        ProtoType protoType2 = protoType;
        boolean bl = false;
        collection.add(protoType2);
    }

    private final void collectDeclaredTypes(ProtoFile $this$collectDeclaredTypes, Set<ProtoType> sink) {
        for (Type type : $this$collectDeclaredTypes.getTypes()) {
            this.collectDeclaredTypes(type, sink);
        }
    }

    private final void collectDeclaredTypes(Type $this$collectDeclaredTypes, Set<ProtoType> sink) {
        sink.add($this$collectDeclaredTypes.getType());
        for (Type type : $this$collectDeclaredTypes.getNestedTypes()) {
            this.collectDeclaredTypes(type, sink);
        }
    }

    private final ProtoFile emptyCopy(ProtoFile $this$emptyCopy, String path) {
        boolean bl = false;
        bl = false;
        bl = false;
        bl = false;
        bl = false;
        return ProtoFile.copy$default($this$emptyCopy, Location.copy$default($this$emptyCopy.getLocation(), null, path, 0, 0, 13, null), CollectionsKt.emptyList(), CollectionsKt.emptyList(), null, CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), null, null, 392, null);
    }

    private final void checkForErrors() {
        boolean bl = this.errors.isEmpty();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = CollectionsKt.joinToString$default((Iterable)this.errors, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/squareup/wire/schema/internal/TypeMover$Move;", "", "type", "Lcom/squareup/wire/schema/ProtoType;", "targetPath", "", "(Lcom/squareup/wire/schema/ProtoType;Ljava/lang/String;)V", "getTargetPath", "()Ljava/lang/String;", "getType", "()Lcom/squareup/wire/schema/ProtoType;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "wire-schema"})
    public static final class Move {
        @NotNull
        private final ProtoType type;
        @NotNull
        private final String targetPath;

        public Move(@NotNull ProtoType type, @NotNull String targetPath) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
            this.type = type;
            this.targetPath = targetPath;
        }

        @NotNull
        public final ProtoType getType() {
            return this.type;
        }

        @NotNull
        public final String getTargetPath() {
            return this.targetPath;
        }

        @NotNull
        public final ProtoType component1() {
            return this.type;
        }

        @NotNull
        public final String component2() {
            return this.targetPath;
        }

        @NotNull
        public final Move copy(@NotNull ProtoType type, @NotNull String targetPath) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
            return new Move(type, targetPath);
        }

        public static /* synthetic */ Move copy$default(Move move, ProtoType protoType, String string, int n, Object object) {
            if ((n & 1) != 0) {
                protoType = move.type;
            }
            if ((n & 2) != 0) {
                string = move.targetPath;
            }
            return move.copy(protoType, string);
        }

        @NotNull
        public String toString() {
            return "Move(type=" + this.type + ", targetPath=" + this.targetPath + ')';
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + this.targetPath.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Move)) {
                return false;
            }
            Move move = (Move)other;
            if (!Intrinsics.areEqual((Object)this.type, (Object)move.type)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.targetPath, (Object)move.targetPath);
        }
    }
}

