/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.ExtensionRegistry;
import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.Preconditions;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.RuntimeEnumAdapter;
import com.squareup.wire.RuntimeMessageAdapter;
import com.squareup.wire.WireEnum;
import com.squareup.wire.WireField;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Source;

public abstract class ProtoAdapter<E> {
    static final int FIXED_BOOL_SIZE = 1;
    static final int FIXED_32_SIZE = 4;
    static final int FIXED_64_SIZE = 8;
    final FieldEncoding fieldEncoding;
    final Class<?> javaType;
    public static final ProtoAdapter<Boolean> BOOL = new ProtoAdapter<Boolean>(FieldEncoding.VARINT, Boolean.class){

        @Override
        public int encodedSize(Boolean value) {
            return 1;
        }

        @Override
        public void encode(ProtoWriter writer, Boolean value) throws IOException {
            writer.writeVarint32(value != false ? 1 : 0);
        }

        @Override
        public Boolean decode(ProtoReader reader) throws IOException {
            int value = reader.readVarint32();
            if (value == 0) {
                return Boolean.FALSE;
            }
            if (value == 1) {
                return Boolean.TRUE;
            }
            throw new IOException(String.format("Invalid boolean value 0x%02x", value));
        }
    };
    public static final ProtoAdapter<Integer> INT32 = new ProtoAdapter<Integer>(FieldEncoding.VARINT, Integer.class){

        @Override
        public int encodedSize(Integer value) {
            return ProtoWriter.int32Size(value);
        }

        @Override
        public void encode(ProtoWriter writer, Integer value) throws IOException {
            writer.writeSignedVarint32(value);
        }

        @Override
        public Integer decode(ProtoReader reader) throws IOException {
            return reader.readVarint32();
        }
    };
    public static final ProtoAdapter<Integer> UINT32 = new ProtoAdapter<Integer>(FieldEncoding.VARINT, Integer.class){

        @Override
        public int encodedSize(Integer value) {
            return ProtoWriter.varint32Size(value);
        }

        @Override
        public void encode(ProtoWriter writer, Integer value) throws IOException {
            writer.writeVarint32(value);
        }

        @Override
        public Integer decode(ProtoReader reader) throws IOException {
            return reader.readVarint32();
        }
    };
    public static final ProtoAdapter<Integer> SINT32 = new ProtoAdapter<Integer>(FieldEncoding.VARINT, Integer.class){

        @Override
        public int encodedSize(Integer value) {
            return ProtoWriter.varint32Size(ProtoWriter.encodeZigZag32(value));
        }

        @Override
        public void encode(ProtoWriter writer, Integer value) throws IOException {
            writer.writeVarint32(ProtoWriter.encodeZigZag32(value));
        }

        @Override
        public Integer decode(ProtoReader reader) throws IOException {
            return ProtoWriter.decodeZigZag32(reader.readVarint32());
        }
    };
    public static final ProtoAdapter<Integer> FIXED32 = new ProtoAdapter<Integer>(FieldEncoding.FIXED32, Integer.class){

        @Override
        public int encodedSize(Integer value) {
            return 4;
        }

        @Override
        public void encode(ProtoWriter writer, Integer value) throws IOException {
            writer.writeFixed32(value);
        }

        @Override
        public Integer decode(ProtoReader reader) throws IOException {
            return reader.readFixed32();
        }
    };
    public static final ProtoAdapter<Integer> SFIXED32 = FIXED32;
    public static final ProtoAdapter<Long> INT64 = new ProtoAdapter<Long>(FieldEncoding.VARINT, Long.class){

        @Override
        public int encodedSize(Long value) {
            return ProtoWriter.varint64Size(value);
        }

        @Override
        public void encode(ProtoWriter writer, Long value) throws IOException {
            writer.writeVarint64(value);
        }

        @Override
        public Long decode(ProtoReader reader) throws IOException {
            return reader.readVarint64();
        }
    };
    public static final ProtoAdapter<Long> UINT64 = new ProtoAdapter<Long>(FieldEncoding.VARINT, Long.class){

        @Override
        public int encodedSize(Long value) {
            return ProtoWriter.varint64Size(value);
        }

        @Override
        public void encode(ProtoWriter writer, Long value) throws IOException {
            writer.writeVarint64(value);
        }

        @Override
        public Long decode(ProtoReader reader) throws IOException {
            return reader.readVarint64();
        }
    };
    public static final ProtoAdapter<Long> SINT64 = new ProtoAdapter<Long>(FieldEncoding.VARINT, Long.class){

        @Override
        public int encodedSize(Long value) {
            return ProtoWriter.varint64Size(ProtoWriter.encodeZigZag64(value));
        }

        @Override
        public void encode(ProtoWriter writer, Long value) throws IOException {
            writer.writeVarint64(ProtoWriter.encodeZigZag64(value));
        }

        @Override
        public Long decode(ProtoReader reader) throws IOException {
            return ProtoWriter.decodeZigZag64(reader.readVarint64());
        }
    };
    public static final ProtoAdapter<Long> FIXED64 = new ProtoAdapter<Long>(FieldEncoding.FIXED64, Long.class){

        @Override
        public int encodedSize(Long value) {
            return 8;
        }

        @Override
        public void encode(ProtoWriter writer, Long value) throws IOException {
            writer.writeFixed64(value);
        }

        @Override
        public Long decode(ProtoReader reader) throws IOException {
            return reader.readFixed64();
        }
    };
    public static final ProtoAdapter<Long> SFIXED64 = FIXED64;
    public static final ProtoAdapter<Float> FLOAT = new ProtoAdapter<Float>(FieldEncoding.FIXED32, Float.class){

        @Override
        public int encodedSize(Float value) {
            return 4;
        }

        @Override
        public void encode(ProtoWriter writer, Float value) throws IOException {
            writer.writeFixed32(Float.floatToIntBits(value.floatValue()));
        }

        @Override
        public Float decode(ProtoReader reader) throws IOException {
            return Float.valueOf(Float.intBitsToFloat(reader.readFixed32()));
        }
    };
    public static final ProtoAdapter<Double> DOUBLE = new ProtoAdapter<Double>(FieldEncoding.FIXED64, Double.class){

        @Override
        public int encodedSize(Double value) {
            return 8;
        }

        @Override
        public void encode(ProtoWriter writer, Double value) throws IOException {
            writer.writeFixed64(Double.doubleToLongBits(value));
        }

        @Override
        public Double decode(ProtoReader reader) throws IOException {
            return Double.longBitsToDouble(reader.readFixed64());
        }
    };
    public static final ProtoAdapter<String> STRING = new ProtoAdapter<String>(FieldEncoding.LENGTH_DELIMITED, String.class){

        @Override
        public int encodedSize(String value) {
            return ProtoWriter.utf8Length(value);
        }

        @Override
        public void encode(ProtoWriter writer, String value) throws IOException {
            writer.writeString(value);
        }

        @Override
        public String decode(ProtoReader reader) throws IOException {
            return reader.readString();
        }
    };
    public static final ProtoAdapter<ByteString> BYTES = new ProtoAdapter<ByteString>(FieldEncoding.LENGTH_DELIMITED, ByteString.class){

        @Override
        public int encodedSize(ByteString value) {
            return value.size();
        }

        @Override
        public void encode(ProtoWriter writer, ByteString value) throws IOException {
            writer.writeBytes(value);
        }

        @Override
        public ByteString decode(ProtoReader reader) throws IOException {
            return reader.readBytes();
        }
    };

    public ProtoAdapter(FieldEncoding fieldEncoding, Class<?> javaType) {
        this.fieldEncoding = fieldEncoding;
        this.javaType = javaType;
    }

    public static <M extends Message<M>> ProtoAdapter<M> newMessageAdapter(Class<M> type) {
        return RuntimeMessageAdapter.create(type);
    }

    public static <E extends WireEnum> RuntimeEnumAdapter<E> newEnumAdapter(Class<E> type) {
        return new RuntimeEnumAdapter<E>(type);
    }

    public static <M extends Message<M>> ProtoAdapter<M> get(Class<M> type) {
        try {
            return (ProtoAdapter)type.getField("ADAPTER").get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException("failed to access " + type.getName() + "#ADAPTER", e);
        }
    }

    static ProtoAdapter<?> get(String adapterString) {
        try {
            int hash = adapterString.indexOf(35);
            String className = adapterString.substring(0, hash);
            String fieldName = adapterString.substring(hash + 1);
            return (ProtoAdapter)Class.forName(className).getField(fieldName).get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException("failed to access " + adapterString, e);
        }
    }

    public E redact(E value) {
        return null;
    }

    public abstract int encodedSize(E var1);

    public int encodedSize(int tag, E value) {
        int size = this.encodedSize(value);
        if (this.fieldEncoding == FieldEncoding.LENGTH_DELIMITED) {
            size += ProtoWriter.varint32Size(size);
        }
        return size + ProtoWriter.tagSize(tag);
    }

    public abstract void encode(ProtoWriter var1, E var2) throws IOException;

    public void encodeTagged(ProtoWriter writer, int tag, E value) throws IOException {
        writer.writeTag(tag, this.fieldEncoding);
        if (this.fieldEncoding == FieldEncoding.LENGTH_DELIMITED) {
            writer.writeVarint32(this.encodedSize(value));
        }
        this.encode(writer, value);
    }

    public final void encode(BufferedSink sink, E value) throws IOException {
        Preconditions.checkNotNull(value, "value == null");
        Preconditions.checkNotNull(sink, "sink == null");
        this.encode(new ProtoWriter(sink), value);
    }

    public final byte[] encode(E value) {
        Preconditions.checkNotNull(value, "value == null");
        Buffer buffer = new Buffer();
        try {
            this.encode((BufferedSink)buffer, value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return buffer.readByteArray();
    }

    public final void encode(OutputStream stream, E value) throws IOException {
        Preconditions.checkNotNull(value, "value == null");
        Preconditions.checkNotNull(stream, "stream == null");
        BufferedSink buffer = Okio.buffer((Sink)Okio.sink((OutputStream)stream));
        this.encode(buffer, value);
        buffer.emit();
    }

    public abstract E decode(ProtoReader var1) throws IOException;

    public final E decode(byte[] bytes) throws IOException {
        return this.decode(bytes, ExtensionRegistry.NO_EXTENSIONS);
    }

    public final E decode(byte[] bytes, ExtensionRegistry extensionRegistry) throws IOException {
        Preconditions.checkNotNull(bytes, "bytes == null");
        return this.decode((BufferedSource)new Buffer().write(bytes), extensionRegistry);
    }

    public final E decode(InputStream stream) throws IOException {
        return this.decode(stream, ExtensionRegistry.NO_EXTENSIONS);
    }

    public final E decode(InputStream stream, ExtensionRegistry extensionRegistry) throws IOException {
        Preconditions.checkNotNull(stream, "stream == null");
        return this.decode(Okio.buffer((Source)Okio.source((InputStream)stream)), extensionRegistry);
    }

    public final E decode(BufferedSource source) throws IOException {
        return this.decode(source, ExtensionRegistry.NO_EXTENSIONS);
    }

    public final E decode(BufferedSource source, ExtensionRegistry extensionRegistry) throws IOException {
        Preconditions.checkNotNull(source, "source == null");
        return this.decode(new ProtoReader(source, extensionRegistry));
    }

    public String toString(E value) {
        return value.toString();
    }

    ProtoAdapter<?> withLabel(WireField.Label label) {
        if (label.isRepeated()) {
            return label.isPacked() ? ProtoAdapter.createPacked(this) : ProtoAdapter.createRepeated(this);
        }
        return this;
    }

    private static <T> ProtoAdapter<List<T>> createPacked(final ProtoAdapter<T> adapter) {
        if (adapter.fieldEncoding == FieldEncoding.LENGTH_DELIMITED) {
            throw new IllegalArgumentException("Unable to pack a length-delimited type.");
        }
        return new ProtoAdapter<List<T>>(FieldEncoding.LENGTH_DELIMITED, List.class){

            @Override
            public int encodedSize(List<T> value) {
                int size = 0;
                int count = value.size();
                for (int i = 0; i < count; ++i) {
                    size += adapter.encodedSize(value.get(i));
                }
                return size;
            }

            @Override
            public void encode(ProtoWriter writer, List<T> value) throws IOException {
                int count = value.size();
                for (int i = 0; i < count; ++i) {
                    adapter.encode(writer, value.get(i));
                }
            }

            @Override
            public List<T> decode(ProtoReader reader) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<T> redact(List<T> value) {
                return Collections.emptyList();
            }
        };
    }

    private static <T> ProtoAdapter<List<T>> createRepeated(final ProtoAdapter<T> adapter) {
        return new ProtoAdapter<List<T>>(adapter.fieldEncoding, List.class){

            @Override
            public int encodedSize(List<T> value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int encodedSize(int tag, List<T> value) {
                int size = 0;
                int count = value.size();
                for (int i = 0; i < count; ++i) {
                    size += adapter.encodedSize(tag, value.get(i));
                }
                return size;
            }

            @Override
            public void encode(ProtoWriter writer, List<T> value) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void encodeTagged(ProtoWriter writer, int tag, List<T> value) throws IOException {
                int count = value.size();
                for (int i = 0; i < count; ++i) {
                    adapter.encodeTagged(writer, tag, value.get(i));
                }
            }

            @Override
            public List<T> decode(ProtoReader reader) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public List<T> redact(List<T> value) {
                return Collections.emptyList();
            }
        };
    }
}

