/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.reflector;

import com.squareup.wire.GrpcStatus;
import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.SchemaEncoder;
import grpc.reflection.v1alpha.ErrorResponse;
import grpc.reflection.v1alpha.ExtensionNumberResponse;
import grpc.reflection.v1alpha.ExtensionRequest;
import grpc.reflection.v1alpha.FileDescriptorResponse;
import grpc.reflection.v1alpha.ListServiceResponse;
import grpc.reflection.v1alpha.ServerReflectionRequest;
import grpc.reflection.v1alpha.ServerReflectionResponse;
import grpc.reflection.v1alpha.ServiceResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\bH\u0002J\b\u0010\u0011\u001a\u00020\u0006H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/squareup/wire/reflector/SchemaReflector;", "", "schema", "Lcom/squareup/wire/schema/Schema;", "(Lcom/squareup/wire/schema/Schema;)V", "allExtensionNumbersOfType", "Lgrpc/reflection/v1alpha/ServerReflectionResponse;", "type", "", "fileByFilename", "request", "Lgrpc/reflection/v1alpha/ServerReflectionRequest;", "fileContainingExtension", "extension", "Lgrpc/reflection/v1alpha/ExtensionRequest;", "fileContainingSymbol", "file_containing_symbol", "listServices", "location", "Lcom/squareup/wire/schema/Location;", "symbol", "process", "toFileDescriptorResponse", "Lgrpc/reflection/v1alpha/FileDescriptorResponse;", "Lokio/ByteString;", "wire-reflector"})
public final class SchemaReflector {
    private final Schema schema;

    @NotNull
    public final ServerReflectionResponse process(@NotNull ServerReflectionRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        ServerReflectionResponse response = request.getList_services() != null ? this.listServices() : (request.getFile_by_filename() != null ? this.fileByFilename(request) : (request.getFile_containing_symbol() != null ? this.fileContainingSymbol(request.getFile_containing_symbol()) : (request.getAll_extension_numbers_of_type() != null ? this.allExtensionNumbersOfType(request.getAll_extension_numbers_of_type()) : (request.getFile_containing_extension() != null ? this.fileContainingExtension(request.getFile_containing_extension()) : new ServerReflectionResponse(null, null, null, null, null, new ErrorResponse(GrpcStatus.INVALID_ARGUMENT.getCode(), "unsupported request", null, 4, null), null, 95, null)))));
        return ServerReflectionResponse.copy$default(response, request.getHost(), request, null, null, null, null, null, 124, null);
    }

    /*
     * WARNING - void declaration
     */
    private final ServerReflectionResponse allExtensionNumbersOfType(String type) {
        void $this$mapTo$iv$iv;
        Type wireType = this.schema.getType(type);
        if (wireType == null || !(wireType instanceof MessageType)) {
            return new ServerReflectionResponse(null, null, null, null, null, new ErrorResponse(GrpcStatus.NOT_FOUND.getCode(), "unknown type: \"" + type + '\"', null, 4, null), null, 95, null);
        }
        Iterable $this$map$iv = ((MessageType)wireType).getExtensionFields();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Field field = (Field)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = it.getTag();
            collection.add(n);
        }
        List extensionNumbers = (List)destination$iv$iv;
        return new ServerReflectionResponse(null, null, null, new ExtensionNumberResponse(type, extensionNumbers, null, 4, null), null, null, null, 119, null);
    }

    private final ServerReflectionResponse fileContainingExtension(ExtensionRequest extension) {
        Object v0;
        block3: {
            Type wireType = this.schema.getType(extension.getContaining_type());
            if (wireType == null || !(wireType instanceof MessageType)) {
                return new ServerReflectionResponse(null, null, null, null, null, new ErrorResponse(GrpcStatus.NOT_FOUND.getCode(), "unknown type: \"" + (Object)((Object)extension) + ".containing_type\"", null, 4, null), null, 95, null);
            }
            Iterable $this$firstOrNull$iv = ((MessageType)wireType).getExtensionFields();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Field it = (Field)element$iv;
                boolean bl = false;
                if (!(it.getTag() == extension.getExtension_number())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Field field = v0;
        if (field == null) {
            return new ServerReflectionResponse(null, null, null, null, null, new ErrorResponse(GrpcStatus.NOT_FOUND.getCode(), "unknown type: \"" + (Object)((Object)extension) + ".containing_type\"", null, 4, null), null, 95, null);
        }
        Field field2 = field;
        Location location = field2.getLocation();
        ProtoFile protoFile = this.schema.protoFile(location.getPath());
        Intrinsics.checkNotNull((Object)protoFile);
        ProtoFile protoFile2 = protoFile;
        FileDescriptorResponse result = this.toFileDescriptorResponse(new SchemaEncoder(this.schema).encode(protoFile2));
        return new ServerReflectionResponse(null, null, result, null, null, null, null, 123, null);
    }

    private final ServerReflectionResponse listServices() {
        boolean bl = false;
        List allServiceNames = new ArrayList();
        for (ProtoFile protoFile : this.schema.getProtoFiles()) {
            for (Service service : protoFile.getServices()) {
                String packagePrefix = protoFile.getPackageName() != null ? Intrinsics.stringPlus((String)protoFile.getPackageName(), (Object)".") : "";
                String serviceName = packagePrefix + service.name();
                Collection collection = allServiceNames;
                ServiceResponse serviceResponse = new ServiceResponse(serviceName, null, 2, null);
                boolean bl2 = false;
                collection.add(serviceResponse);
            }
        }
        Iterable $this$sortedBy$iv = allServiceNames;
        boolean $i$f$sortedBy = false;
        boolean bl3 = false;
        return new ServerReflectionResponse(null, null, null, null, new ListServiceResponse(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                ServiceResponse it = (ServiceResponse)((Object)a);
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (ServiceResponse)((Object)b);
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        }), null, 2, null), null, null, 111, null);
    }

    private final ServerReflectionResponse fileByFilename(ServerReflectionRequest request) {
        String string = request.getFile_by_filename();
        Intrinsics.checkNotNull((Object)string);
        ProtoFile protoFile = this.schema.protoFile(string);
        Intrinsics.checkNotNull((Object)protoFile);
        ProtoFile protoFile2 = protoFile;
        return new ServerReflectionResponse(null, null, this.toFileDescriptorResponse(new SchemaEncoder(this.schema).encode(protoFile2)), null, null, null, null, 123, null);
    }

    private final ServerReflectionResponse fileContainingSymbol(String file_containing_symbol) {
        String symbol = StringsKt.removePrefix((String)file_containing_symbol, (CharSequence)".");
        Location location = this.location(symbol);
        if (location == null) {
            return new ServerReflectionResponse(null, null, null, null, null, new ErrorResponse(GrpcStatus.NOT_FOUND.getCode(), "unknown symbol: " + file_containing_symbol, null, 4, null), null, 95, null);
        }
        Location location2 = location;
        ProtoFile protoFile = this.schema.protoFile(location2.getPath());
        Intrinsics.checkNotNull((Object)protoFile);
        ProtoFile protoFile2 = protoFile;
        FileDescriptorResponse result = this.toFileDescriptorResponse(new SchemaEncoder(this.schema).encode(protoFile2));
        return new ServerReflectionResponse(null, null, result, null, null, null, null, 123, null);
    }

    private final Location location(String symbol) {
        Object v3;
        block9: {
            Iterable list$iv$iv;
            Iterable $this$flatMapTo$iv$iv;
            ProtoFile it;
            Iterable $this$filterTo$iv$iv;
            Service serviceWithMethod;
            Service service = this.schema.getService(symbol);
            if (service != null) {
                return service.location();
            }
            Type type = this.schema.getType(symbol);
            if (type != null) {
                return type.getLocation();
            }
            String beforeLastDotName = StringsKt.substringBeforeLast$default((String)symbol, (String)".", null, (int)2, null);
            String string = symbol;
            int n = beforeLastDotName.length() + 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String afterLastDot = string3;
            Service service2 = serviceWithMethod = this.schema.getService(beforeLastDotName);
            if ((service2 != null ? service2.rpc(afterLastDot) : null) != null) {
                return serviceWithMethod.location();
            }
            Iterable $this$filter$iv = this.schema.getProtoFiles();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ProtoFile)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getPackageName(), (Object)beforeLastDotName)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (ProtoFile)element$iv$iv;
                boolean bl3 = false;
                list$iv$iv = it.getExtendList();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (Extend)element$iv$iv;
                boolean bl4 = false;
                list$iv$iv = it.getFields();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Field it2 = (Field)element$iv;
                boolean bl5 = false;
                if (!Intrinsics.areEqual((Object)it2.getName(), (Object)afterLastDot)) continue;
                v3 = element$iv;
                break block9;
            }
            v3 = null;
        }
        Field extend = v3;
        if (extend != null) {
            return extend.getLocation();
        }
        return null;
    }

    private final FileDescriptorResponse toFileDescriptorResponse(ByteString $this$toFileDescriptorResponse) {
        return new FileDescriptorResponse(CollectionsKt.listOf((Object)$this$toFileDescriptorResponse), null, 2, null);
    }

    public SchemaReflector(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        this.schema = schema;
    }
}

