/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.wire.WireEnum;
import com.squareup.wire.internal.EnumJsonFormatter;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0012\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/squareup/wire/EnumJsonAdapter;", "E", "", "Lcom/squareup/wire/WireEnum;", "Lcom/squareup/moshi/JsonAdapter;", "enumJsonFormatter", "Lcom/squareup/wire/internal/EnumJsonFormatter;", "<init>", "(Lcom/squareup/wire/internal/EnumJsonFormatter;)V", "toJson", "", "out", "Lcom/squareup/moshi/JsonWriter;", "value", "(Lcom/squareup/moshi/JsonWriter;Ljava/lang/Enum;)V", "fromJson", "input", "Lcom/squareup/moshi/JsonReader;", "(Lcom/squareup/moshi/JsonReader;)Ljava/lang/Enum;", "wire-moshi-adapter"})
public final class EnumJsonAdapter<E extends Enum<E>>
extends JsonAdapter<E> {
    @NotNull
    private final EnumJsonFormatter<E> enumJsonFormatter;

    public EnumJsonAdapter(@NotNull EnumJsonFormatter<E> enumJsonFormatter) {
        Intrinsics.checkNotNullParameter(enumJsonFormatter, (String)"enumJsonFormatter");
        this.enumJsonFormatter = enumJsonFormatter;
    }

    public void toJson(@NotNull JsonWriter out, @Nullable E value) throws IOException {
        JsonWriter jsonWriter;
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        if (value == null) {
            jsonWriter = out.nullValue();
        } else {
            Object formatted = this.enumJsonFormatter.toStringOrNumber((WireEnum)value);
            jsonWriter = formatted instanceof Number ? out.value((Number)formatted) : out.value(formatted.toString());
        }
    }

    @NotNull
    public E fromJson(@NotNull JsonReader input) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String nextString = input.nextString();
        Intrinsics.checkNotNull((Object)nextString);
        Enum enum_ = (Enum)this.enumJsonFormatter.fromString(nextString);
        if (enum_ == null) {
            throw new JsonDataException("Unexpected " + nextString + " at path " + input.getPath());
        }
        return (E)enum_;
    }
}

