/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import com.squareup.wire.internal.FieldBinding;
import com.squareup.wire.internal.JsonIntegration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c0\u0002\u0018\u00002\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00030\u0001:\u0002\u0013\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0016J \u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003H\u0016J(\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0018\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/squareup/wire/MoshiJsonIntegration;", "Lcom/squareup/wire/internal/JsonIntegration;", "Lcom/squareup/moshi/Moshi;", "Lcom/squareup/moshi/JsonAdapter;", "", "()V", "formatterAdapter", "jsonFormatter", "Lcom/squareup/wire/internal/FieldBinding$JsonFormatter;", "frameworkAdapter", "framework", "type", "Ljava/lang/reflect/Type;", "listAdapter", "elementAdapter", "mapAdapter", "keyType", "valueType", "structAdapter", "FormatterJsonAdapter", "ListJsonAdapter", "wire-moshi-adapter"})
public final class MoshiJsonIntegration
extends JsonIntegration<Moshi, JsonAdapter<Object>> {
    public static final MoshiJsonIntegration INSTANCE;

    @NotNull
    public JsonAdapter<Object> frameworkAdapter(@NotNull Moshi framework, @NotNull Type type) {
        Intrinsics.checkParameterIsNotNull((Object)framework, (String)"framework");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        JsonAdapter jsonAdapter = framework.adapter(type).nullSafe();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"framework.adapter<Any?>(type).nullSafe()");
        return jsonAdapter;
    }

    @NotNull
    public JsonAdapter<Object> listAdapter(@NotNull JsonAdapter<Object> elementAdapter) {
        Intrinsics.checkParameterIsNotNull(elementAdapter, (String)"elementAdapter");
        JsonAdapter jsonAdapter = new ListJsonAdapter<Object>(elementAdapter).nullSafe();
        if (jsonAdapter == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.squareup.moshi.JsonAdapter<kotlin.Any?>");
        }
        return jsonAdapter;
    }

    @NotNull
    public JsonAdapter<Object> mapAdapter(@NotNull Moshi framework, @NotNull Type keyType, @NotNull Type valueType) {
        Intrinsics.checkParameterIsNotNull((Object)framework, (String)"framework");
        Intrinsics.checkParameterIsNotNull((Object)keyType, (String)"keyType");
        Intrinsics.checkParameterIsNotNull((Object)valueType, (String)"valueType");
        ParameterizedType mapType = Types.newParameterizedType((Type)((Type)((Object)Map.class)), (Type[])new Type[]{keyType, valueType});
        JsonAdapter jsonAdapter = framework.adapter((Type)mapType);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"framework.adapter(mapType)");
        return jsonAdapter;
    }

    @NotNull
    public JsonAdapter<Object> structAdapter(@NotNull Moshi framework) {
        Intrinsics.checkParameterIsNotNull((Object)framework, (String)"framework");
        JsonAdapter jsonAdapter = framework.adapter((Type)((Object)Object.class)).serializeNulls().nullSafe();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonAdapter, (String)"framework.adapter<Any?>(\u2026rializeNulls().nullSafe()");
        return jsonAdapter;
    }

    @NotNull
    public JsonAdapter<Object> formatterAdapter(@NotNull FieldBinding.JsonFormatter<?> jsonFormatter) {
        Intrinsics.checkParameterIsNotNull(jsonFormatter, (String)"jsonFormatter");
        JsonAdapter jsonAdapter = new FormatterJsonAdapter(jsonFormatter).nullSafe();
        if (jsonAdapter == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.squareup.moshi.JsonAdapter<kotlin.Any?>");
        }
        return jsonAdapter;
    }

    private MoshiJsonIntegration() {
    }

    static {
        MoshiJsonIntegration moshiJsonIntegration;
        INSTANCE = moshiJsonIntegration = new MoshiJsonIntegration();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u0007\u001a\u0004\u0018\u00018\u00002\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u001f\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/squareup/wire/MoshiJsonIntegration$FormatterJsonAdapter;", "T", "", "Lcom/squareup/moshi/JsonAdapter;", "formatter", "Lcom/squareup/wire/internal/FieldBinding$JsonFormatter;", "(Lcom/squareup/wire/internal/FieldBinding$JsonFormatter;)V", "fromJson", "reader", "Lcom/squareup/moshi/JsonReader;", "(Lcom/squareup/moshi/JsonReader;)Ljava/lang/Object;", "toJson", "", "writer", "Lcom/squareup/moshi/JsonWriter;", "value", "(Lcom/squareup/moshi/JsonWriter;Ljava/lang/Object;)V", "wire-moshi-adapter"})
    private static final class FormatterJsonAdapter<T>
    extends JsonAdapter<T> {
        private final FieldBinding.JsonFormatter<T> formatter;

        public void toJson(@NotNull JsonWriter writer, @Nullable T value) {
            Object stringOrNumber;
            Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
            T t = value;
            if (t == null) {
                Intrinsics.throwNpe();
            }
            if ((stringOrNumber = this.formatter.toStringOrNumber(t)) instanceof Number) {
                writer.value((Number)stringOrNumber);
            } else {
                Object object = stringOrNumber;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                writer.value((String)object);
            }
        }

        @Nullable
        public T fromJson(@NotNull JsonReader reader) {
            Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
            String string = reader.nextString();
            try {
                String string2 = string;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"string");
                return (T)this.formatter.fromString(string2);
            }
            catch (RuntimeException _) {
                throw (Throwable)new JsonDataException("decode failed: " + string + " at path " + reader.getPath());
            }
        }

        public FormatterJsonAdapter(@NotNull FieldBinding.JsonFormatter<T> formatter) {
            Intrinsics.checkParameterIsNotNull(formatter, (String)"formatter");
            this.formatter = formatter;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u00030\u0002B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0003H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/squareup/wire/MoshiJsonIntegration$ListJsonAdapter;", "T", "Lcom/squareup/moshi/JsonAdapter;", "", "single", "(Lcom/squareup/moshi/JsonAdapter;)V", "fromJson", "reader", "Lcom/squareup/moshi/JsonReader;", "toJson", "", "writer", "Lcom/squareup/moshi/JsonWriter;", "value", "wire-moshi-adapter"})
    private static final class ListJsonAdapter<T>
    extends JsonAdapter<List<? extends T>> {
        private final JsonAdapter<T> single;

        @NotNull
        public List<T> fromJson(@NotNull JsonReader reader) {
            Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
            boolean bl = false;
            List result = new ArrayList();
            reader.beginArray();
            while (reader.hasNext()) {
                result.add(this.single.fromJson(reader));
            }
            reader.endArray();
            return result;
        }

        public void toJson(@NotNull JsonWriter writer, @Nullable List<? extends T> value) {
            Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
            writer.beginArray();
            List<T> list = value;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            for (T v : list) {
                this.single.toJson(writer, v);
            }
            writer.endArray();
        }

        public ListJsonAdapter(@NotNull JsonAdapter<T> single) {
            Intrinsics.checkParameterIsNotNull(single, (String)"single");
            this.single = single;
        }
    }
}

