/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import com.squareup.wire.Message;
import com.squareup.wire.MessageJsonAdapter;
import com.squareup.wire.Uint64;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import okio.ByteString;

public final class WireJsonAdapterFactory
implements JsonAdapter.Factory {
    static final JsonAdapter<ByteString> BYTE_STRING_JSON_ADAPTER = new JsonAdapter<ByteString>(){

        public void toJson(JsonWriter out, ByteString byteString) throws IOException {
            out.value(byteString.base64());
        }

        public ByteString fromJson(JsonReader in) throws IOException {
            return ByteString.decodeBase64((String)in.nextString());
        }
    }.nullSafe();
    static final JsonAdapter<Long> UINT64_JSON_ADAPTER = new JsonAdapter<Long>(){
        private final BigInteger power64 = new BigInteger("18446744073709551616");
        private final BigInteger maxLong = BigInteger.valueOf(Long.MAX_VALUE);

        public Long fromJson(JsonReader reader) throws IOException {
            BigInteger bigInteger = new BigInteger(reader.nextString());
            return bigInteger.compareTo(this.maxLong) > 0 ? bigInteger.subtract(this.power64).longValue() : bigInteger.longValue();
        }

        public void toJson(JsonWriter writer, Long value) throws IOException {
            if (value < 0L) {
                BigInteger unsigned = this.power64.add(BigInteger.valueOf(value));
                writer.value((Number)unsigned);
            } else {
                writer.value((Number)value);
            }
        }
    }.nullSafe();
    static final JsonAdapter<List<Long>> LIST_OF_UINT64_JSON_ADAPTER = new JsonAdapter<List<Long>>(){

        public List<Long> fromJson(JsonReader reader) throws IOException {
            ArrayList<Long> result = new ArrayList<Long>();
            reader.beginArray();
            while (reader.hasNext()) {
                result.add((Long)UINT64_JSON_ADAPTER.fromJson(reader));
            }
            reader.endArray();
            return result;
        }

        public void toJson(JsonWriter writer, List<Long> value) throws IOException {
            writer.beginArray();
            for (Long v : value) {
                UINT64_JSON_ADAPTER.toJson(writer, (Object)v);
            }
            writer.endArray();
        }
    }.nullSafe();

    @Nullable
    public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
        if ((type == Long.class || type == Long.TYPE) && Types.nextAnnotations(annotations, Uint64.class) != null) {
            return UINT64_JSON_ADAPTER;
        }
        Class rawType = Types.getRawType((Type)type);
        if (rawType == List.class && ((ParameterizedType)type).getActualTypeArguments()[0] == Long.class && Types.nextAnnotations(annotations, Uint64.class) != null) {
            return LIST_OF_UINT64_JSON_ADAPTER;
        }
        if (!annotations.isEmpty()) {
            return null;
        }
        if (rawType.equals(ByteString.class)) {
            return BYTE_STRING_JSON_ADAPTER;
        }
        if (Message.class.isAssignableFrom(rawType)) {
            return new MessageJsonAdapter(moshi, type);
        }
        return null;
    }
}

