/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.java;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.NameAllocator;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.wire.EnumAdapter;
import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.WireEnum;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import com.squareup.wire.java.AdapterConstant;
import com.squareup.wire.java.Profile;
import com.squareup.wire.schema.EnclosingType;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.OneOf;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.io.IOException;
import java.math.BigInteger;
import java.net.ProtocolException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;
import okio.ByteString;

public final class JavaGenerator {
    static final ProtoMember FIELD_DEPRECATED = ProtoMember.get((ProtoType)Options.FIELD_OPTIONS, (String)"deprecated");
    static final ProtoMember ENUM_DEPRECATED = ProtoMember.get((ProtoType)Options.ENUM_VALUE_OPTIONS, (String)"deprecated");
    static final ProtoMember PACKED = ProtoMember.get((ProtoType)Options.FIELD_OPTIONS, (String)"packed");
    static final ClassName BYTE_STRING = ClassName.get(ByteString.class);
    static final ClassName STRING = ClassName.get(String.class);
    static final ClassName LIST = ClassName.get(List.class);
    static final ClassName MESSAGE = ClassName.get(Message.class);
    static final ClassName ANDROID_MESSAGE = MESSAGE.peerClass("AndroidMessage");
    static final ClassName ADAPTER = ClassName.get(ProtoAdapter.class);
    static final ClassName BUILDER = ClassName.get(Message.Builder.class);
    static final ClassName ENUM_ADAPTER = ClassName.get(EnumAdapter.class);
    static final ClassName NULLABLE = ClassName.get((String)"androidx.annotation", (String)"Nullable", (String[])new String[0]);
    static final ClassName CREATOR = ClassName.get((String)"android.os", (String)"Parcelable", (String[])new String[]{"Creator"});
    private static final Ordering<Field> TAG_ORDERING = Ordering.from((Comparator)new Comparator<Field>(){

        @Override
        public int compare(Field o1, Field o2) {
            return Integer.compare(o1.tag(), o2.tag());
        }
    });
    private static final Map<ProtoType, ClassName> BUILT_IN_TYPES_MAP = ImmutableMap.builder().put((Object)ProtoType.BOOL, (Object)((ClassName)TypeName.BOOLEAN.box())).put((Object)ProtoType.BYTES, (Object)ClassName.get(ByteString.class)).put((Object)ProtoType.DOUBLE, (Object)((ClassName)TypeName.DOUBLE.box())).put((Object)ProtoType.FLOAT, (Object)((ClassName)TypeName.FLOAT.box())).put((Object)ProtoType.FIXED32, (Object)((ClassName)TypeName.INT.box())).put((Object)ProtoType.FIXED64, (Object)((ClassName)TypeName.LONG.box())).put((Object)ProtoType.INT32, (Object)((ClassName)TypeName.INT.box())).put((Object)ProtoType.INT64, (Object)((ClassName)TypeName.LONG.box())).put((Object)ProtoType.SFIXED32, (Object)((ClassName)TypeName.INT.box())).put((Object)ProtoType.SFIXED64, (Object)((ClassName)TypeName.LONG.box())).put((Object)ProtoType.SINT32, (Object)((ClassName)TypeName.INT.box())).put((Object)ProtoType.SINT64, (Object)((ClassName)TypeName.LONG.box())).put((Object)ProtoType.STRING, (Object)ClassName.get(String.class)).put((Object)ProtoType.UINT32, (Object)((ClassName)TypeName.INT.box())).put((Object)ProtoType.UINT64, (Object)((ClassName)TypeName.LONG.box())).put((Object)Options.FIELD_OPTIONS, (Object)ClassName.get((String)"com.google.protobuf", (String)"MessageOptions", (String[])new String[0])).put((Object)Options.ENUM_OPTIONS, (Object)ClassName.get((String)"com.google.protobuf", (String)"FieldOptions", (String[])new String[0])).put((Object)Options.MESSAGE_OPTIONS, (Object)ClassName.get((String)"com.google.protobuf", (String)"EnumOptions", (String[])new String[0])).build();
    private static final String URL_CHARS = "[-!#$%&'()*+,./0-9:;=?@A-Z\\[\\]_a-z~]";
    private static final int MAX_PARAMS_IN_CONSTRUCTOR = 16;
    private final LoadingCache<Type, NameAllocator> nameAllocators = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Type, NameAllocator>(){

        public NameAllocator load(Type type) throws Exception {
            NameAllocator nameAllocator;
            block4: {
                block3: {
                    nameAllocator = new NameAllocator();
                    if (!(type instanceof MessageType)) break block3;
                    nameAllocator.newName("serialVersionUID", (Object)"serialVersionUID");
                    nameAllocator.newName("ADAPTER", (Object)"ADAPTER");
                    nameAllocator.newName("MESSAGE_OPTIONS", (Object)"MESSAGE_OPTIONS");
                    if (JavaGenerator.this.emitAndroid) {
                        nameAllocator.newName("CREATOR", (Object)"CREATOR");
                    }
                    ImmutableList fieldsAndOneOfFields = ((MessageType)type).fieldsAndOneOfFields();
                    Set collidingNames = JavaGenerator.this.collidingFieldNames((ImmutableList<Field>)fieldsAndOneOfFields);
                    for (Field field : fieldsAndOneOfFields) {
                        String suggestion = collidingNames.contains(field.name()) ? field.qualifiedName() : field.name();
                        nameAllocator.newName(suggestion, (Object)field);
                    }
                    break block4;
                }
                if (!(type instanceof EnumType)) break block4;
                nameAllocator.newName("value", (Object)"value");
                nameAllocator.newName("i", (Object)"i");
                nameAllocator.newName("reader", (Object)"reader");
                nameAllocator.newName("writer", (Object)"writer");
                for (EnumConstant constant : ((EnumType)type).constants()) {
                    nameAllocator.newName(constant.getName(), (Object)constant);
                }
            }
            return nameAllocator;
        }
    });
    private final Schema schema;
    private final ImmutableMap<ProtoType, ClassName> nameToJavaName;
    private final Profile profile;
    private final boolean emitAndroid;
    private final boolean emitAndroidAnnotations;
    private final boolean emitCompact;

    private JavaGenerator(Schema schema, Map<ProtoType, ClassName> nameToJavaName, Profile profile, boolean emitAndroid, boolean emitAndroidAnnotations, boolean emitCompact) {
        this.schema = schema;
        this.nameToJavaName = ImmutableMap.copyOf(nameToJavaName);
        this.profile = profile;
        this.emitAndroid = emitAndroid;
        this.emitAndroidAnnotations = emitAndroidAnnotations || emitAndroid;
        this.emitCompact = emitCompact;
    }

    public JavaGenerator withAndroid(boolean emitAndroid) {
        return new JavaGenerator(this.schema, (Map<ProtoType, ClassName>)this.nameToJavaName, this.profile, emitAndroid, this.emitAndroidAnnotations, this.emitCompact);
    }

    public JavaGenerator withAndroidAnnotations(boolean emitAndroidAnnotations) {
        return new JavaGenerator(this.schema, (Map<ProtoType, ClassName>)this.nameToJavaName, this.profile, this.emitAndroid, emitAndroidAnnotations, this.emitCompact);
    }

    public JavaGenerator withCompact(boolean emitCompact) {
        return new JavaGenerator(this.schema, (Map<ProtoType, ClassName>)this.nameToJavaName, this.profile, this.emitAndroid, this.emitAndroidAnnotations, emitCompact);
    }

    public JavaGenerator withProfile(Profile profile) {
        return new JavaGenerator(this.schema, (Map<ProtoType, ClassName>)this.nameToJavaName, profile, this.emitAndroid, this.emitAndroidAnnotations, this.emitCompact);
    }

    public static JavaGenerator get(Schema schema) {
        LinkedHashMap<ProtoType, ClassName> nameToJavaName = new LinkedHashMap<ProtoType, ClassName>(BUILT_IN_TYPES_MAP);
        for (ProtoFile protoFile : schema.protoFiles()) {
            String javaPackage = JavaGenerator.javaPackage(protoFile);
            JavaGenerator.putAll(nameToJavaName, javaPackage, null, protoFile.types());
            for (Service service : protoFile.services()) {
                ClassName className = ClassName.get((String)javaPackage, (String)service.type().simpleName(), (String[])new String[0]);
                nameToJavaName.put(service.type(), className);
            }
        }
        return new JavaGenerator(schema, nameToJavaName, new Profile(), false, false, false);
    }

    private static void putAll(Map<ProtoType, ClassName> wireToJava, String javaPackage, ClassName enclosingClassName, List<Type> types) {
        for (Type type : types) {
            ClassName className = enclosingClassName != null ? enclosingClassName.nestedClass(type.type().simpleName()) : ClassName.get((String)javaPackage, (String)type.type().simpleName(), (String[])new String[0]);
            wireToJava.put(type.type(), className);
            JavaGenerator.putAll(wireToJava, javaPackage, className, type.nestedTypes());
        }
    }

    public Schema schema() {
        return this.schema;
    }

    public TypeName typeName(ProtoType protoType) {
        TypeName profileJavaName = this.profile.getTarget(protoType);
        if (profileJavaName != null) {
            return profileJavaName;
        }
        TypeName candidate = (TypeName)this.nameToJavaName.get((Object)protoType);
        Preconditions.checkArgument((candidate != null ? 1 : 0) != 0, (String)"unexpected type %s", (Object)protoType);
        return candidate;
    }

    @Nullable
    public ClassName abstractAdapterName(ProtoType protoType) {
        TypeName profileJavaName = this.profile.getTarget(protoType);
        if (profileJavaName == null) {
            return null;
        }
        ClassName javaName = (ClassName)this.nameToJavaName.get((Object)protoType);
        Type type = this.schema.getType(protoType);
        return type instanceof EnumType ? javaName.peerClass(javaName.simpleName() + "Adapter") : javaName.peerClass("Abstract" + javaName.simpleName() + "Adapter");
    }

    private CodeBlock singleAdapterFor(Field field) {
        return field.type().isMap() ? CodeBlock.of((String)"$N", (Object[])new Object[]{field.name()}) : this.singleAdapterFor(field.type());
    }

    private CodeBlock singleAdapterFor(ProtoType type) {
        CodeBlock.Builder result = CodeBlock.builder();
        if (type.isScalar()) {
            result.add("$T.$L", new Object[]{ADAPTER, type.simpleName().toUpperCase(Locale.US)});
        } else {
            if (type.isMap()) {
                throw new IllegalArgumentException("Cannot create single adapter for map type " + type);
            }
            AdapterConstant adapterConstant = this.profile.getAdapter(type);
            if (adapterConstant != null) {
                result.add("$T.$L", new Object[]{adapterConstant.className, adapterConstant.memberName});
            } else {
                result.add("$T.ADAPTER", new Object[]{this.typeName(type)});
            }
        }
        return result.build();
    }

    private CodeBlock adapterFor(Field field) {
        CodeBlock.Builder result = this.singleAdapterFor(field).toBuilder();
        if (field.isPacked()) {
            result.add(".asPacked()", new Object[0]);
        } else if (field.isRepeated()) {
            result.add(".asRepeated()", new Object[0]);
        }
        return result.build();
    }

    private static String javaPackage(ProtoFile protoFile) {
        String javaPackage = protoFile.javaPackage();
        if (javaPackage != null) {
            return javaPackage;
        }
        if (protoFile.packageName() != null) {
            return protoFile.packageName();
        }
        return "";
    }

    public boolean isEnum(ProtoType type) {
        return this.schema.getType(type) instanceof EnumType;
    }

    EnumConstant enumDefault(ProtoType type) {
        EnumType wireEnum = (EnumType)this.schema.getType(type);
        return (EnumConstant)wireEnum.constants().get(0);
    }

    static TypeName listOf(TypeName type) {
        return ParameterizedTypeName.get((ClassName)LIST, (TypeName[])new TypeName[]{type});
    }

    static TypeName messageOf(ClassName messageType, TypeName type, ClassName builderType) {
        return ParameterizedTypeName.get((ClassName)messageType, (TypeName[])new TypeName[]{type, builderType});
    }

    static TypeName adapterOf(TypeName messageType) {
        return ParameterizedTypeName.get((ClassName)ADAPTER, (TypeName[])new TypeName[]{messageType});
    }

    static TypeName builderOf(TypeName messageType, ClassName builderType) {
        return ParameterizedTypeName.get((ClassName)BUILDER, (TypeName[])new TypeName[]{messageType, builderType});
    }

    static TypeName creatorOf(TypeName messageType) {
        return ParameterizedTypeName.get((ClassName)CREATOR, (TypeName[])new TypeName[]{messageType});
    }

    static TypeName enumAdapterOf(TypeName enumType) {
        return ParameterizedTypeName.get((ClassName)ENUM_ADAPTER, (TypeName[])new TypeName[]{enumType});
    }

    static String sanitizeJavadoc(String documentation) {
        documentation = documentation.replaceAll("[^\\S\n]+\n", "\n");
        documentation = documentation.replaceAll("\\s+$", "");
        documentation = documentation.replaceAll("\\*/", "&#42;/");
        documentation = documentation.replaceAll("@see (http:[-!#$%&'()*+,./0-9:;=?@A-Z\\[\\]_a-z~]+)", "@see <a href=\"$1\">$1</a>");
        return documentation;
    }

    public ClassName generatedTypeName(Type type) {
        ClassName abstractAdapterName = this.abstractAdapterName(type.type());
        return abstractAdapterName != null ? abstractAdapterName : (ClassName)this.typeName(type.type());
    }

    public TypeSpec generateType(Type type) {
        AdapterConstant adapterConstant = this.profile.getAdapter(type.type());
        if (adapterConstant != null) {
            return this.generateAdapterForCustomType(type);
        }
        if (type instanceof MessageType) {
            return this.generateMessage((MessageType)type);
        }
        if (type instanceof EnumType) {
            return this.generateEnum((EnumType)type);
        }
        if (type instanceof EnclosingType) {
            return this.generateEnclosingType((EnclosingType)type);
        }
        throw new IllegalStateException("Unknown type: " + type);
    }

    @Deprecated
    public TypeSpec generateEnum(EnumType type) {
        NameAllocator nameAllocator = (NameAllocator)this.nameAllocators.getUnchecked((Object)type);
        String value = nameAllocator.get((Object)"value");
        ClassName javaType = (ClassName)this.typeName(type.type());
        TypeSpec.Builder builder = TypeSpec.enumBuilder((String)javaType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(WireEnum.class);
        if (!type.documentation().isEmpty()) {
            builder.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(type.documentation())});
        }
        builder.addField(TypeName.INT, value, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder();
        constructorBuilder.addStatement("this.$1N = $1N", new Object[]{value});
        constructorBuilder.addParameter(TypeName.INT, value, new Modifier[0]);
        LinkedHashSet<ProtoMember> allOptionFieldsBuilder = new LinkedHashSet<ProtoMember>();
        for (EnumConstant constant : type.constants()) {
            for (ProtoMember protoMember : constant.getOptions().map().keySet()) {
                Field optionField = this.schema.getField(protoMember);
                if (!allOptionFieldsBuilder.add(protoMember)) continue;
                TypeName optionJavaType = this.typeName(optionField.type());
                builder.addField(optionJavaType, optionField.name(), new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
                constructorBuilder.addParameter(optionJavaType, optionField.name(), new Modifier[0]);
                constructorBuilder.addStatement("this.$L = $L", new Object[]{optionField.name(), optionField.name()});
            }
        }
        ImmutableList allOptionMembers = ImmutableList.copyOf(allOptionFieldsBuilder);
        String enumArgsFormat = "$L" + Strings.repeat((String)", $L", (int)allOptionMembers.size());
        builder.addMethod(constructorBuilder.build());
        MethodSpec.Builder fromValueBuilder = MethodSpec.methodBuilder((String)"fromValue").addJavadoc("Return the constant for {@code $N} or null.\n", new Object[]{value}).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)javaType).addParameter(Integer.TYPE, value, new Modifier[0]).beginControlFlow("switch ($N)", new Object[]{value});
        LinkedHashSet<Integer> seenTags = new LinkedHashSet<Integer>();
        for (EnumConstant constant : type.constants()) {
            Object[] enumArgs = new Object[allOptionMembers.size() + 1];
            enumArgs[0] = constant.getTag();
            for (int i = 0; i < allOptionMembers.size(); ++i) {
                ProtoMember protoMember = (ProtoMember)allOptionMembers.get(i);
                Field field = this.schema.getField(protoMember);
                Object fieldValue = constant.getOptions().map().get(protoMember);
                enumArgs[i + 1] = fieldValue != null ? this.fieldInitializer(field.type(), fieldValue) : null;
            }
            TypeSpec.Builder constantBuilder = TypeSpec.anonymousClassBuilder((String)enumArgsFormat, (Object[])enumArgs);
            if (!constant.getDocumentation().isEmpty()) {
                constantBuilder.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(constant.getDocumentation())});
            }
            if ("true".equals(constant.getOptions().get(ENUM_DEPRECATED))) {
                constantBuilder.addAnnotation(Deprecated.class);
            }
            builder.addEnumConstant(constant.getName(), constantBuilder.build());
            if (!seenTags.add(constant.getTag())) continue;
            fromValueBuilder.addStatement("case $L: return $L", new Object[]{constant.getTag(), constant.getName()});
        }
        builder.addMethod(fromValueBuilder.addStatement("default: return null", new Object[0]).endControlFlow().build());
        FieldSpec.Builder adapterBuilder = FieldSpec.builder((TypeName)JavaGenerator.adapterOf((TypeName)javaType), (String)"ADAPTER", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        ClassName adapterJavaType = javaType.nestedClass("ProtoAdapter_" + javaType.simpleName());
        if (!this.emitCompact) {
            adapterBuilder.initializer("new $T()", new Object[]{adapterJavaType});
        } else {
            adapterBuilder.initializer("$T.newEnumAdapter($T.class)", new Object[]{ProtoAdapter.class, javaType});
        }
        builder.addField(adapterBuilder.build());
        FieldSpec options = this.optionsField(Options.ENUM_OPTIONS, "ENUM_OPTIONS", type.options());
        if (options != null) {
            builder.addField(options);
        }
        builder.addMethod(MethodSpec.methodBuilder((String)"getValue").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.INT).addStatement("return $N", new Object[]{value}).build());
        if (!this.emitCompact) {
            builder.addType(this.enumAdapter(javaType, adapterJavaType));
        }
        return builder.build();
    }

    @Deprecated
    public TypeSpec generateMessage(MessageType type) {
        boolean constructorTakesAllFields = this.constructorTakesAllFields(type);
        NameAllocator nameAllocator = (NameAllocator)this.nameAllocators.getUnchecked((Object)type);
        ClassName javaType = (ClassName)this.typeName(type.type());
        ClassName builderJavaType = javaType.nestedClass("Builder");
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)javaType.simpleName());
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        if (javaType.enclosingClassName() != null) {
            builder.addModifiers(new Modifier[]{Modifier.STATIC});
        }
        if (!type.documentation().isEmpty()) {
            builder.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(type.documentation())});
        }
        ClassName messageType = this.emitAndroid ? ANDROID_MESSAGE : MESSAGE;
        builder.superclass(JavaGenerator.messageOf(messageType, (TypeName)javaType, builderJavaType));
        String adapterName = nameAllocator.get((Object)"ADAPTER");
        String protoAdapterName = "ProtoAdapter_" + javaType.simpleName();
        String protoAdapterClassName = nameAllocator.newName(protoAdapterName);
        ClassName adapterJavaType = javaType.nestedClass(protoAdapterClassName);
        builder.addField(this.messageAdapterField(adapterName, javaType, adapterJavaType));
        if (this.emitAndroid) {
            TypeName creatorType = JavaGenerator.creatorOf((TypeName)javaType);
            String creatorName = nameAllocator.get((Object)"CREATOR");
            builder.addField(FieldSpec.builder((TypeName)creatorType, (String)creatorName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$T.newCreator($L)", new Object[]{ANDROID_MESSAGE, adapterName}).build());
        }
        builder.addField(FieldSpec.builder((TypeName)TypeName.LONG, (String)nameAllocator.get((Object)"serialVersionUID"), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$LL", new Object[]{0L}).build());
        FieldSpec messageOptions = this.optionsField(Options.MESSAGE_OPTIONS, nameAllocator.get((Object)"MESSAGE_OPTIONS"), type.options());
        if (messageOptions != null) {
            builder.addField(messageOptions);
        }
        for (Field field : type.fieldsAndOneOfFields()) {
            String fieldName = nameAllocator.get((Object)field);
            String optionsFieldName = "FIELD_OPTIONS_" + fieldName.toUpperCase(Locale.US);
            FieldSpec fieldOptions = this.optionsField(Options.FIELD_OPTIONS, optionsFieldName, field.options());
            if (fieldOptions == null) continue;
            builder.addField(fieldOptions);
        }
        for (Field field : type.fieldsAndOneOfFields()) {
            TypeName fieldJavaType = this.fieldType(field);
            if ((field.type().isScalar() || this.isEnum(field.type())) && !field.isRepeated() && !field.isPacked()) {
                builder.addField(this.defaultField(nameAllocator, field, fieldJavaType));
            }
            String fieldName = nameAllocator.get((Object)field);
            FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)fieldJavaType, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            fieldBuilder.addAnnotation(this.wireFieldAnnotation(field));
            if (!field.documentation().isEmpty()) {
                fieldBuilder.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(field.documentation())});
            }
            if (field.isExtension()) {
                fieldBuilder.addJavadoc("Extension source: $L\n", new Object[]{field.location().withPathOnly()});
            }
            if (field.isDeprecated()) {
                fieldBuilder.addAnnotation(Deprecated.class);
            }
            if (this.emitAndroidAnnotations && field.isOptional()) {
                fieldBuilder.addAnnotation(NULLABLE);
            }
            builder.addField(fieldBuilder.build());
        }
        if (constructorTakesAllFields) {
            builder.addMethod(this.messageFieldsConstructor(nameAllocator, type));
        }
        builder.addMethod(this.messageConstructor(nameAllocator, type, builderJavaType));
        builder.addMethod(this.newBuilder(nameAllocator, type));
        builder.addMethod(this.messageEquals(nameAllocator, type));
        builder.addMethod(this.messageHashCode(nameAllocator, type));
        if (!this.emitCompact) {
            builder.addMethod(this.messageToString(nameAllocator, type));
        }
        builder.addType(this.builder(nameAllocator, type, javaType, builderJavaType));
        for (Type nestedType : type.nestedTypes()) {
            builder.addType(this.generateType(nestedType));
        }
        if (!this.emitCompact) {
            builder.addType(this.messageAdapter(nameAllocator, type, javaType, adapterJavaType, builderJavaType));
        }
        return builder.build();
    }

    private boolean constructorTakesAllFields(MessageType type) {
        return type.fields().size() < 16;
    }

    private TypeSpec generateEnclosingType(EnclosingType type) {
        String documentation;
        ClassName javaType = (ClassName)this.typeName(type.type());
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)javaType.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        if (javaType.enclosingClassName() != null) {
            builder.addModifiers(new Modifier[]{Modifier.STATIC});
        }
        if (!(documentation = type.documentation()).isEmpty()) {
            documentation = documentation + "\n\n<p>";
        }
        documentation = documentation + "<b>NOTE:</b> This type only exists to maintain class structure for its nested types and is not an actual message.";
        builder.addJavadoc("$L\n", new Object[]{documentation});
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addStatement("throw new $T()", new Object[]{AssertionError.class}).build());
        for (Type nestedType : type.nestedTypes()) {
            builder.addType(this.generateType(nestedType));
        }
        return builder.build();
    }

    public TypeSpec generateAdapterForCustomType(Type type) {
        NameAllocator nameAllocator = (NameAllocator)this.nameAllocators.getUnchecked((Object)type);
        ClassName adapterTypeName = this.abstractAdapterName(type.type());
        ClassName typeName = (ClassName)this.typeName(type.type());
        TypeSpec.Builder adapter = type instanceof MessageType ? this.messageAdapter(nameAllocator, (MessageType)type, typeName, adapterTypeName, null).toBuilder() : this.enumAdapter(nameAllocator, (EnumType)type, typeName, adapterTypeName).toBuilder();
        if (adapterTypeName.enclosingClassName() != null) {
            adapter.addModifiers(new Modifier[]{Modifier.STATIC});
        }
        for (Type nestedType : type.nestedTypes()) {
            if (this.profile.getAdapter(nestedType.type()) == null) {
                throw new IllegalArgumentException("Missing custom proto adapter for " + nestedType.type().enclosingTypeOrPackage() + "." + nestedType.type().simpleName() + " when enclosing proto has custom proto adapter.");
            }
            adapter.addType(this.generateAdapterForCustomType(nestedType));
        }
        return adapter.build();
    }

    private Set<String> collidingFieldNames(ImmutableList<Field> fields) {
        LinkedHashSet<String> fieldNames = new LinkedHashSet<String>();
        LinkedHashSet<String> collidingNames = new LinkedHashSet<String>();
        for (Field field : fields) {
            if (fieldNames.add(field.name())) continue;
            collidingNames.add(field.name());
        }
        return collidingNames;
    }

    private FieldSpec messageAdapterField(String adapterName, ClassName javaType, ClassName adapterJavaType) {
        FieldSpec.Builder result = FieldSpec.builder((TypeName)JavaGenerator.adapterOf((TypeName)javaType), (String)adapterName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        if (this.emitCompact) {
            result.initializer("$T.newMessageAdapter($T.class)", new Object[]{ProtoAdapter.class, javaType});
        } else {
            result.initializer("new $T()", new Object[]{adapterJavaType});
        }
        return result.build();
    }

    private TypeSpec enumAdapter(NameAllocator nameAllocator, EnumType type, ClassName javaType, ClassName adapterJavaType) {
        String value = nameAllocator.get((Object)"value");
        String i = nameAllocator.get((Object)"i");
        String reader = nameAllocator.get((Object)"reader");
        String writer = nameAllocator.get((Object)"writer");
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)adapterJavaType.simpleName());
        builder.superclass(JavaGenerator.adapterOf((TypeName)javaType));
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder();
        constructorBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        constructorBuilder.addStatement("super($T.VARINT, $T.class)", new Object[]{FieldEncoding.class, javaType});
        for (Object constant : type.constants()) {
            String name = nameAllocator.get(constant);
            FieldSpec.Builder fieldBuilder = FieldSpec.builder((TypeName)javaType, (String)name, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL});
            if (!constant.getDocumentation().isEmpty()) {
                fieldBuilder.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(constant.getDocumentation())});
            }
            if ("true".equals(constant.getOptions().get(ENUM_DEPRECATED))) {
                fieldBuilder.addAnnotation(Deprecated.class);
            }
            builder.addField(fieldBuilder.build());
            constructorBuilder.addParameter((TypeName)javaType, name, new Modifier[0]);
            constructorBuilder.addStatement("this.$N = $N", new Object[]{name, name});
        }
        builder.addMethod(constructorBuilder.build());
        MethodSpec.Builder toValueBuilder = MethodSpec.methodBuilder((String)"toValue").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(Integer.TYPE).addParameter((TypeName)javaType, value, new Modifier[0]);
        for (EnumConstant constant : type.constants()) {
            String name = nameAllocator.get((Object)constant);
            toValueBuilder.addStatement("if ($N.equals($N)) return $L", new Object[]{value, name, constant.getTag()});
        }
        toValueBuilder.addStatement("return $L", new Object[]{-1});
        builder.addMethod(toValueBuilder.build());
        MethodSpec.Builder fromValueBuilder = MethodSpec.methodBuilder((String)"fromValue").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)javaType).addParameter(Integer.TYPE, value, new Modifier[0]);
        fromValueBuilder.beginControlFlow("switch ($N)", new Object[]{value});
        for (EnumConstant constant : type.constants()) {
            String name = nameAllocator.get((Object)constant);
            fromValueBuilder.addStatement("case $L: return $N", new Object[]{constant.getTag(), name});
        }
        fromValueBuilder.addStatement("default: throw new $T($N, $T.class)", new Object[]{ProtoAdapter.EnumConstantNotFoundException.class, value, javaType});
        fromValueBuilder.endControlFlow();
        builder.addMethod(fromValueBuilder.build());
        builder.addMethod(MethodSpec.methodBuilder((String)"encodedSize").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addParameter((TypeName)javaType, value, new Modifier[0]).addStatement("return $T.UINT32.encodedSize(toValue($N))", new Object[]{ProtoAdapter.class, value}).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"encode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ProtoWriter.class, writer, new Modifier[0]).addParameter((TypeName)javaType, value, new Modifier[0]).addException(IOException.class).addStatement("int $N = toValue($N)", new Object[]{i, value}).addStatement("if ($N == $L) throw new $T($S + $N)", new Object[]{i, -1, ProtocolException.class, "Unexpected enum constant: ", value}).addStatement("$N.writeVarint32($N)", new Object[]{writer, i}).build());
        builder.addMethod(MethodSpec.methodBuilder((String)"decode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)javaType).addParameter(ProtoReader.class, reader, new Modifier[0]).addException(IOException.class).addStatement("int $N = $N.readVarint32()", new Object[]{value, reader}).addStatement("return fromValue($N)", new Object[]{value}).build());
        return builder.build();
    }

    private TypeSpec enumAdapter(ClassName javaType, ClassName adapterJavaType) {
        return TypeSpec.classBuilder((String)adapterJavaType.simpleName()).superclass(JavaGenerator.enumAdapterOf((TypeName)javaType)).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addStatement("super($T.class)", new Object[]{javaType}).build()).addMethod(MethodSpec.methodBuilder((String)"fromValue").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)javaType).addParameter(Integer.TYPE, "value", new Modifier[0]).addStatement("return $T.fromValue(value)", new Object[]{javaType}).build()).build();
    }

    private TypeSpec messageAdapter(NameAllocator nameAllocator, MessageType type, ClassName javaType, ClassName adapterJavaType, ClassName builderType) {
        boolean useBuilder = builderType != null;
        TypeSpec.Builder adapter = TypeSpec.classBuilder((String)adapterJavaType.simpleName()).superclass(JavaGenerator.adapterOf((TypeName)javaType));
        if (useBuilder) {
            adapter.addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL});
        } else {
            adapter.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
        }
        adapter.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super($T.LENGTH_DELIMITED, $T.class)", new Object[]{FieldEncoding.class, javaType}).build());
        if (!useBuilder) {
            MethodSpec.Builder fromProto = MethodSpec.methodBuilder((String)"fromProto").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)javaType);
            for (Field field : type.fieldsAndOneOfFields()) {
                TypeName fieldType = this.fieldType(field);
                String fieldName = nameAllocator.get((Object)field);
                fromProto.addParameter(fieldType, fieldName, new Modifier[0]);
                adapter.addMethod(MethodSpec.methodBuilder((String)fieldName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)javaType, "value", new Modifier[0]).returns(fieldType).build());
            }
            adapter.addMethod(fromProto.build());
        }
        adapter.addMethod(this.messageAdapterEncodedSize(nameAllocator, type, (TypeName)javaType, useBuilder));
        adapter.addMethod(this.messageAdapterEncode(nameAllocator, type, (TypeName)javaType, useBuilder));
        adapter.addMethod(this.messageAdapterDecode(nameAllocator, type, (TypeName)javaType, useBuilder, builderType));
        adapter.addMethod(this.messageAdapterRedact(nameAllocator, type, javaType, useBuilder, builderType));
        for (Field field : type.fieldsAndOneOfFields()) {
            if (!field.type().isMap()) continue;
            TypeName adapterType = JavaGenerator.adapterOf(this.fieldType(field));
            adapter.addField(FieldSpec.builder((TypeName)adapterType, (String)field.name(), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("$T.newMapAdapter($L, $L)", new Object[]{ADAPTER, this.singleAdapterFor(field.type().keyType()), this.singleAdapterFor(field.type().valueType())}).build());
        }
        return adapter.build();
    }

    private MethodSpec messageAdapterEncodedSize(NameAllocator nameAllocator, MessageType type, TypeName javaType, boolean useBuilder) {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"encodedSize").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addParameter(javaType, "value", new Modifier[0]);
        result.addCode("$[", new Object[0]);
        String leading = "return";
        for (Field field : type.fieldsAndOneOfFields()) {
            int fieldTag = field.tag();
            String fieldName = nameAllocator.get((Object)field);
            CodeBlock adapter = this.adapterFor(field);
            result.addCode("$L $L.encodedSizeWithTag($L, ", new Object[]{leading, adapter, fieldTag}).addCode(useBuilder ? "value.$L" : "$L(value)", new Object[]{fieldName}).addCode(")", new Object[0]);
            leading = "\n+";
        }
        if (useBuilder) {
            result.addCode("$L value.unknownFields().size()", new Object[]{leading});
        }
        result.addCode(";$]\n", new Object[]{leading});
        return result.build();
    }

    private MethodSpec messageAdapterEncode(NameAllocator nameAllocator, MessageType type, TypeName javaType, boolean useBuilder) {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"encode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ProtoWriter.class, "writer", new Modifier[0]).addParameter(javaType, "value", new Modifier[0]).addException(IOException.class);
        for (Field field : type.fieldsAndOneOfFields()) {
            int fieldTag = field.tag();
            CodeBlock adapter = this.adapterFor(field);
            result.addCode("$L.encodeWithTag(writer, $L, ", new Object[]{adapter, fieldTag}).addCode(useBuilder ? "value.$L" : "$L(value)", new Object[]{nameAllocator.get((Object)field)}).addCode(");\n", new Object[0]);
        }
        if (useBuilder) {
            result.addStatement("writer.writeBytes(value.unknownFields())", new Object[0]);
        }
        return result.build();
    }

    private MethodSpec messageAdapterDecode(NameAllocator nameAllocator, MessageType type, TypeName javaType, boolean useBuilder, ClassName builderJavaType) {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"decode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(javaType).addParameter(ProtoReader.class, "reader", new Modifier[0]).addException(IOException.class);
        List fields = TAG_ORDERING.sortedCopy((Iterable)type.fieldsAndOneOfFields());
        if (useBuilder) {
            result.addStatement("$1T builder = new $1T()", new Object[]{builderJavaType});
        } else {
            for (Field field : fields) {
                result.addStatement("$T $N = $L", new Object[]{this.fieldType(field), nameAllocator.get((Object)field), this.initialValue(field)});
            }
        }
        result.addStatement("long token = reader.beginMessage()", new Object[0]);
        result.beginControlFlow("for (int tag; (tag = reader.nextTag()) != -1;)", new Object[0]);
        result.beginControlFlow("switch (tag)", new Object[0]);
        for (Field field : fields) {
            int fieldTag = field.tag();
            if (this.isEnum(field.type())) {
                result.beginControlFlow("case $L:", new Object[]{fieldTag});
                result.beginControlFlow("try", new Object[0]);
                result.addCode(this.decodeAndAssign(field, nameAllocator, useBuilder));
                result.addCode(";\n", new Object[0]);
                if (useBuilder) {
                    result.nextControlFlow("catch ($T e)", new Object[]{ProtoAdapter.EnumConstantNotFoundException.class});
                    result.addStatement("builder.addUnknownField(tag, $T.VARINT, (long) e.value)", new Object[]{FieldEncoding.class});
                    result.endControlFlow();
                } else {
                    result.nextControlFlow("catch ($T ignored)", new Object[]{ProtoAdapter.EnumConstantNotFoundException.class});
                    result.endControlFlow();
                }
                result.addStatement("break", new Object[0]);
                result.endControlFlow();
                continue;
            }
            result.addCode("case $L: $L; break;\n", new Object[]{fieldTag, this.decodeAndAssign(field, nameAllocator, useBuilder)});
        }
        result.beginControlFlow("default:", new Object[0]);
        if (useBuilder) {
            result.addStatement("reader.readUnknownField(tag)", new Object[0]);
        } else {
            result.addStatement("reader.skip()", new Object[0]);
        }
        result.endControlFlow();
        result.endControlFlow();
        result.endControlFlow();
        if (useBuilder) {
            result.addStatement("builder.addUnknownFields(reader.endMessageAndGetUnknownFields(token))", new Object[0]);
        } else {
            result.addStatement("reader.endMessageAndGetUnknownFields(token)", new Object[0]);
        }
        if (useBuilder) {
            result.addStatement("return builder.build()", new Object[0]);
        } else {
            result.addCode("return fromProto(", new Object[0]);
            boolean first = true;
            for (Field field : type.fieldsAndOneOfFields()) {
                if (!first) {
                    result.addCode(", ", new Object[0]);
                }
                result.addCode("$N", new Object[]{nameAllocator.get((Object)field)});
                first = false;
            }
            result.addCode(");\n", new Object[0]);
        }
        return result.build();
    }

    private CodeBlock decodeAndAssign(Field field, NameAllocator nameAllocator, boolean useBuilder) {
        String fieldName = nameAllocator.get((Object)field);
        CodeBlock decode = CodeBlock.of((String)"$L.decode(reader)", (Object[])new Object[]{this.singleAdapterFor(field)});
        if (field.isRepeated()) {
            return useBuilder ? CodeBlock.of((String)"builder.$L.add($L)", (Object[])new Object[]{fieldName, decode}) : CodeBlock.of((String)"$L.add($L)", (Object[])new Object[]{fieldName, decode});
        }
        if (field.type().isMap()) {
            return useBuilder ? CodeBlock.of((String)"builder.$L.putAll($L)", (Object[])new Object[]{fieldName, decode}) : CodeBlock.of((String)"$L.putAll($L)", (Object[])new Object[]{fieldName, decode});
        }
        return useBuilder ? CodeBlock.of((String)"builder.$L($L)", (Object[])new Object[]{fieldName, decode}) : CodeBlock.of((String)"$L = $L", (Object[])new Object[]{fieldName, decode});
    }

    private MethodSpec messageAdapterRedact(NameAllocator nameAllocator, MessageType type, ClassName javaType, boolean useBuilder, ClassName builderJavaType) {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"redact").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)javaType).addParameter((TypeName)javaType, "value", new Modifier[0]);
        int redactedFieldCount = 0;
        ArrayList<String> requiredRedacted = new ArrayList<String>();
        for (Field field : type.fieldsAndOneOfFields()) {
            if (!field.isRedacted()) continue;
            ++redactedFieldCount;
            if (!field.isRequired()) continue;
            requiredRedacted.add(nameAllocator.get((Object)field));
        }
        if (!useBuilder) {
            result.addStatement(redactedFieldCount == 0 ? "return value" : "return null", new Object[0]);
            return result.build();
        }
        if (!requiredRedacted.isEmpty()) {
            boolean isPlural = requiredRedacted.size() != 1;
            result.addStatement("throw new $T($S)", new Object[]{UnsupportedOperationException.class, (isPlural ? "Fields" : "Field") + " '" + Joiner.on((String)"', '").join(requiredRedacted) + "' " + (isPlural ? "are" : "is") + " required and cannot be redacted."});
            return result.build();
        }
        result.addStatement("$1T builder = value.newBuilder()", new Object[]{builderJavaType});
        for (Field field : type.fieldsAndOneOfFields()) {
            CodeBlock adapter;
            String fieldName = nameAllocator.get((Object)field);
            if (field.isRedacted()) {
                if (field.isRepeated()) {
                    result.addStatement("builder.$N = $T.emptyList()", new Object[]{fieldName, Collections.class});
                    continue;
                }
                if (field.type().isMap()) {
                    result.addStatement("builder.$N = $T.emptyMap()", new Object[]{fieldName, Collections.class});
                    continue;
                }
                result.addStatement("builder.$N = null", new Object[]{fieldName});
                continue;
            }
            if (field.type().isScalar() || this.isEnum(field.type())) continue;
            if (field.isRepeated()) {
                adapter = this.singleAdapterFor(field);
                result.addStatement("$T.redactElements(builder.$N, $L)", new Object[]{Internal.class, fieldName, adapter});
                continue;
            }
            if (field.type().isMap()) {
                if (field.type().valueType().isScalar() || this.isEnum(field.type().valueType())) continue;
                adapter = this.singleAdapterFor(field.type().valueType());
                result.addStatement("$T.redactElements(builder.$N, $L)", new Object[]{Internal.class, fieldName, adapter});
                continue;
            }
            adapter = this.adapterFor(field);
            if (!field.isRequired()) {
                result.addCode("if (builder.$N != null) ", new Object[]{fieldName});
            }
            result.addStatement("builder.$1N = $2L.redact(builder.$1N)", new Object[]{fieldName, adapter});
        }
        result.addStatement("builder.clearUnknownFields()", new Object[0]);
        result.addStatement("return builder.build()", new Object[0]);
        return result.build();
    }

    private FieldSpec optionsField(ProtoType optionsType, String fieldName, Options options) {
        TypeName optionsJavaType = this.typeName(optionsType);
        CodeBlock.Builder initializer = CodeBlock.builder();
        initializer.add("$[new $T.Builder()", new Object[]{optionsJavaType});
        boolean empty = true;
        for (Map.Entry entry : options.map().entrySet()) {
            if (((ProtoMember)entry.getKey()).equals((Object)FIELD_DEPRECATED) || ((ProtoMember)entry.getKey()).equals((Object)PACKED)) continue;
            Field optionField = this.schema.getField((ProtoMember)entry.getKey());
            initializer.add("\n.$L($L)", new Object[]{this.fieldName(optionsType, optionField), this.fieldInitializer(optionField.type(), entry.getValue())});
            empty = false;
        }
        initializer.add("\n.build()$]", new Object[0]);
        if (empty) {
            return null;
        }
        return FieldSpec.builder((TypeName)optionsJavaType, (String)fieldName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(initializer.build()).build();
    }

    private String fieldName(ProtoType type, Field field) {
        MessageType messageType = (MessageType)this.schema.getType(type);
        NameAllocator names = (NameAllocator)this.nameAllocators.getUnchecked((Object)messageType);
        return names.get((Object)field);
    }

    private TypeName fieldType(Field field) {
        ProtoType type = field.type();
        if (type.isMap()) {
            return ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{this.typeName(type.keyType()), this.typeName(type.valueType())});
        }
        TypeName messageType = this.typeName(type);
        return field.isRepeated() ? JavaGenerator.listOf(messageType) : messageType;
    }

    private FieldSpec defaultField(NameAllocator nameAllocator, Field field, TypeName fieldType) {
        String defaultFieldName = "DEFAULT_" + nameAllocator.get((Object)field).toUpperCase(Locale.US);
        return FieldSpec.builder((TypeName)fieldType, (String)defaultFieldName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer(this.defaultValue(field)).build();
    }

    private AnnotationSpec wireFieldAnnotation(Field field) {
        AnnotationSpec.Builder result = AnnotationSpec.builder(WireField.class);
        int tag = field.tag();
        result.addMember("tag", String.valueOf(tag), new Object[0]);
        if (field.type().isMap()) {
            result.addMember("keyAdapter", "$S", new Object[]{this.adapterString(field.type().keyType())});
            result.addMember("adapter", "$S", new Object[]{this.adapterString(field.type().valueType())});
        } else {
            result.addMember("adapter", "$S", new Object[]{this.adapterString(field.type())});
        }
        if (!field.isOptional()) {
            if (field.isPacked()) {
                result.addMember("label", "$T.PACKED", new Object[]{WireField.Label.class});
            } else if (field.label() != null) {
                result.addMember("label", "$T.$L", new Object[]{WireField.Label.class, field.label()});
            }
        }
        if (field.isRedacted()) {
            result.addMember("redacted", "true", new Object[0]);
        }
        return result.build();
    }

    private String adapterString(ProtoType type) {
        if (type.isScalar()) {
            return ProtoAdapter.class.getName() + '#' + type.toString().toUpperCase(Locale.US);
        }
        AdapterConstant adapterConstant = this.profile.getAdapter(type);
        if (adapterConstant != null) {
            return this.reflectionName(adapterConstant.className) + "#" + adapterConstant.memberName;
        }
        return this.reflectionName((ClassName)this.typeName(type)) + "#ADAPTER";
    }

    private String reflectionName(ClassName className) {
        return className.packageName().isEmpty() ? Joiner.on((char)'$').join((Iterable)className.simpleNames()) : className.packageName() + '.' + Joiner.on((char)'$').join((Iterable)className.simpleNames());
    }

    private MethodSpec messageFieldsConstructor(NameAllocator nameAllocator, MessageType type) {
        MethodSpec.Builder result = MethodSpec.constructorBuilder();
        result.addModifiers(new Modifier[]{Modifier.PUBLIC});
        result.addCode("this(", new Object[0]);
        for (Field field : type.fieldsAndOneOfFields()) {
            TypeName javaType = this.fieldType(field);
            String fieldName = nameAllocator.get((Object)field);
            ParameterSpec.Builder param = ParameterSpec.builder((TypeName)javaType, (String)fieldName, (Modifier[])new Modifier[0]);
            if (this.emitAndroidAnnotations && field.isOptional()) {
                param.addAnnotation(NULLABLE);
            }
            result.addParameter(param.build());
            result.addCode("$L, ", new Object[]{fieldName});
        }
        result.addCode("$T.EMPTY);\n", new Object[]{BYTE_STRING});
        return result.build();
    }

    private MethodSpec messageConstructor(NameAllocator nameAllocator, MessageType type, ClassName builderJavaType) {
        boolean constructorTakesAllFields = this.constructorTakesAllFields(type);
        NameAllocator localNameAllocator = nameAllocator.clone();
        String adapterName = localNameAllocator.get((Object)"ADAPTER");
        String unknownFieldsName = localNameAllocator.newName("unknownFields");
        String builderName = localNameAllocator.newName("builder");
        MethodSpec.Builder result = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super($N, $N)", new Object[]{adapterName, unknownFieldsName});
        for (OneOf oneOf : type.oneOfs()) {
            if (oneOf.fields().size() < 2) continue;
            CodeBlock.Builder fieldNamesBuilder = CodeBlock.builder();
            boolean first = true;
            for (Field field : oneOf.fields()) {
                if (!first) {
                    fieldNamesBuilder.add(", ", new Object[0]);
                }
                if (constructorTakesAllFields) {
                    fieldNamesBuilder.add("$N", new Object[]{localNameAllocator.get((Object)field)});
                } else {
                    fieldNamesBuilder.add("$N.$N", new Object[]{builderName, localNameAllocator.get((Object)field)});
                }
                first = false;
            }
            CodeBlock fieldNames = fieldNamesBuilder.build();
            result.beginControlFlow("if ($T.countNonNull($L) > 1)", new Object[]{Internal.class, fieldNames});
            result.addStatement("throw new IllegalArgumentException($S)", new Object[]{"at most one of " + fieldNames + " may be non-null"});
            result.endControlFlow();
        }
        for (Field field : type.fieldsAndOneOfFields()) {
            String fieldAccessName;
            TypeName javaType = this.fieldType(field);
            String fieldName = localNameAllocator.get((Object)field);
            String string = fieldAccessName = constructorTakesAllFields ? fieldName : builderName + "." + fieldName;
            if (constructorTakesAllFields) {
                ParameterSpec.Builder param = ParameterSpec.builder((TypeName)javaType, (String)fieldName, (Modifier[])new Modifier[0]);
                if (this.emitAndroidAnnotations && field.isOptional()) {
                    param.addAnnotation(NULLABLE);
                }
                result.addParameter(param.build());
            }
            if (field.isRepeated() || field.type().isMap()) {
                result.addStatement("this.$1L = $2T.immutableCopyOf($1S, $3L)", new Object[]{fieldName, Internal.class, fieldAccessName});
                continue;
            }
            result.addStatement("this.$1L = $2L", new Object[]{fieldName, fieldAccessName});
        }
        if (!constructorTakesAllFields) {
            result.addParameter((TypeName)builderJavaType, builderName, new Modifier[0]);
        }
        result.addParameter((TypeName)BYTE_STRING, unknownFieldsName, new Modifier[0]);
        return result.build();
    }

    private MethodSpec messageEquals(NameAllocator nameAllocator, MessageType type) {
        NameAllocator localNameAllocator = nameAllocator.clone();
        String otherName = localNameAllocator.newName("other");
        String oName = localNameAllocator.newName("o");
        TypeName javaType = this.typeName(type.type());
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"equals").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addParameter(Object.class, otherName, new Modifier[0]);
        result.addStatement("if ($N == this) return true", new Object[]{otherName});
        result.addStatement("if (!($N instanceof $T)) return false", new Object[]{otherName, javaType});
        result.addStatement("$T $N = ($T) $N", new Object[]{javaType, oName, javaType, otherName});
        result.addCode("$[return unknownFields().equals($N.unknownFields())", new Object[]{oName});
        ImmutableList fields = type.fieldsAndOneOfFields();
        for (Field field : fields) {
            String fieldName = localNameAllocator.get((Object)field);
            if (field.isRequired() || field.isRepeated() || field.type().isMap()) {
                result.addCode("\n&& $1L.equals($2N.$1L)", new Object[]{fieldName, oName});
                continue;
            }
            result.addCode("\n&& $1T.equals($2L, $3N.$2L)", new Object[]{Internal.class, fieldName, oName});
        }
        result.addCode(";\n$]", new Object[0]);
        return result.build();
    }

    private MethodSpec messageHashCode(NameAllocator nameAllocator, MessageType type) {
        NameAllocator localNameAllocator = nameAllocator.clone();
        String resultName = localNameAllocator.newName("result");
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"hashCode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE);
        ImmutableList fields = type.fieldsAndOneOfFields();
        if (fields.isEmpty()) {
            result.addStatement("return unknownFields().hashCode()", new Object[0]);
            return result.build();
        }
        result.addStatement("int $N = super.hashCode", new Object[]{resultName});
        result.beginControlFlow("if ($N == 0)", new Object[]{resultName});
        result.addStatement("$N = unknownFields().hashCode()", new Object[]{resultName});
        for (Field field : fields) {
            String fieldName = localNameAllocator.get((Object)field);
            result.addCode("$1N = $1N * 37 + ", new Object[]{resultName});
            if (field.isRepeated() || field.isRequired() || field.type().isMap()) {
                result.addStatement("$L.hashCode()", new Object[]{fieldName});
                continue;
            }
            result.addStatement("($1L != null ? $1L.hashCode() : 0)", new Object[]{fieldName});
        }
        result.addStatement("super.hashCode = $N", new Object[]{resultName});
        result.endControlFlow();
        result.addStatement("return $N", new Object[]{resultName});
        return result.build();
    }

    private MethodSpec messageToString(NameAllocator nameAllocator, MessageType type) {
        NameAllocator localNameAllocator = nameAllocator.clone();
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class);
        String builderName = localNameAllocator.newName("builder");
        result.addStatement("$1T $2N = new $1T()", new Object[]{StringBuilder.class, builderName});
        for (Field field : type.fieldsAndOneOfFields()) {
            String fieldName = nameAllocator.get((Object)field);
            if (field.isRepeated() || field.type().isMap()) {
                result.addCode("if (!$N.isEmpty()) ", new Object[]{fieldName});
            } else if (!field.isRequired()) {
                result.addCode("if ($N != null) ", new Object[]{fieldName});
            }
            if (field.isRedacted()) {
                result.addStatement("$N.append(\", $N=\u2588\u2588\")", new Object[]{builderName, field.name()});
                continue;
            }
            result.addStatement("$N.append(\", $N=\").append($L)", new Object[]{builderName, field.name(), fieldName});
        }
        result.addStatement("return builder.replace(0, 2, \"$L{\").append('}').toString()", new Object[]{type.type().simpleName()});
        return result.build();
    }

    private TypeSpec builder(NameAllocator nameAllocator, MessageType type, ClassName javaType, ClassName builderType) {
        TypeSpec.Builder result = TypeSpec.classBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        result.superclass(JavaGenerator.builderOf((TypeName)javaType, builderType));
        for (Field field : type.fieldsAndOneOfFields()) {
            String fieldName = nameAllocator.get((Object)field);
            result.addField(this.fieldType(field), fieldName, new Modifier[]{Modifier.PUBLIC});
        }
        result.addMethod(this.builderNoArgsConstructor(nameAllocator, type));
        for (Field field : type.fields()) {
            result.addMethod(this.setter(nameAllocator, (TypeName)builderType, null, field));
        }
        for (OneOf oneOf : type.oneOfs()) {
            for (Field field : oneOf.fields()) {
                result.addMethod(this.setter(nameAllocator, (TypeName)builderType, oneOf, field));
            }
        }
        result.addMethod(this.builderBuild(nameAllocator, type, javaType));
        return result.build();
    }

    private MethodSpec builderNoArgsConstructor(NameAllocator nameAllocator, MessageType type) {
        MethodSpec.Builder result = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (Field field : type.fieldsAndOneOfFields()) {
            String fieldName = nameAllocator.get((Object)field);
            CodeBlock initialValue = this.initialValue(field);
            if (initialValue == null) continue;
            result.addStatement("$L = $L", new Object[]{fieldName, initialValue});
        }
        return result.build();
    }

    @Nullable
    private CodeBlock initialValue(Field field) {
        if (field.isPacked() || field.isRepeated()) {
            return CodeBlock.of((String)"$T.newMutableList()", (Object[])new Object[]{Internal.class});
        }
        if (field.type().isMap()) {
            return CodeBlock.of((String)"$T.newMutableMap()", (Object[])new Object[]{Internal.class});
        }
        return null;
    }

    private MethodSpec newBuilder(NameAllocator nameAllocator, MessageType message) {
        NameAllocator localNameAllocator = nameAllocator.clone();
        String builderName = localNameAllocator.newName("builder");
        ClassName javaType = (ClassName)this.typeName(message.type());
        ClassName builderJavaType = javaType.nestedClass("Builder");
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"newBuilder").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)builderJavaType).addStatement("$1T $2L = new $1T()", new Object[]{builderJavaType, builderName});
        ImmutableList fields = message.fieldsAndOneOfFields();
        for (Field field : fields) {
            String fieldName = localNameAllocator.get((Object)field);
            if (field.isRepeated() || field.type().isMap()) {
                result.addStatement("$1L.$2L = $3T.copyOf($2L)", new Object[]{builderName, fieldName, Internal.class});
                continue;
            }
            result.addStatement("$1L.$2L = $2L", new Object[]{builderName, fieldName});
        }
        result.addStatement("$L.addUnknownFields(unknownFields())", new Object[]{builderName});
        result.addStatement("return $L", new Object[]{builderName});
        return result.build();
    }

    private MethodSpec setter(NameAllocator nameAllocator, TypeName builderType, OneOf oneOf, Field field) {
        TypeName javaType = this.fieldType(field);
        String fieldName = nameAllocator.get((Object)field);
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)fieldName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(javaType, fieldName, new Modifier[0]).returns(builderType);
        if (!field.documentation().isEmpty()) {
            result.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(field.documentation())});
        }
        if (field.isDeprecated()) {
            result.addAnnotation(Deprecated.class);
        }
        if (field.isRepeated() || field.type().isMap()) {
            result.addStatement("$T.checkElementsNotNull($L)", new Object[]{Internal.class, fieldName});
        }
        result.addStatement("this.$L = $L", new Object[]{fieldName, fieldName});
        if (oneOf != null) {
            for (Field other : oneOf.fields()) {
                if (field == other) continue;
                result.addStatement("this.$L = null", new Object[]{nameAllocator.get((Object)other)});
            }
        }
        result.addStatement("return this", new Object[0]);
        return result.build();
    }

    private MethodSpec builderBuild(NameAllocator nameAllocator, MessageType message, ClassName javaType) {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)javaType);
        ImmutableList requiredFields = message.getRequiredFields();
        if (!requiredFields.isEmpty()) {
            CodeBlock.Builder conditionals = CodeBlock.builder().add("$[", new Object[0]);
            CodeBlock.Builder missingArgs = CodeBlock.builder();
            for (int i = 0; i < requiredFields.size(); ++i) {
                Field requiredField = (Field)requiredFields.get(i);
                if (i > 0) {
                    conditionals.add("\n|| ", new Object[0]);
                }
                conditionals.add("$L == null", new Object[]{nameAllocator.get((Object)requiredField)});
                if (i > 0) {
                    missingArgs.add(",\n", new Object[0]);
                }
                missingArgs.add("$1L, $2S", new Object[]{nameAllocator.get((Object)requiredField), requiredField.name()});
            }
            result.beginControlFlow("if ($L)", new Object[]{conditionals.add("$]", new Object[0]).build()}).addStatement("throw $T.missingRequiredFields($L)", new Object[]{Internal.class, missingArgs.build()}).endControlFlow();
        }
        boolean constructorTakesAllFields = this.constructorTakesAllFields(message);
        result.addCode("return new $T(", new Object[]{javaType});
        if (constructorTakesAllFields) {
            for (Field field : message.fieldsAndOneOfFields()) {
                result.addCode("$L, ", new Object[]{nameAllocator.get((Object)field)});
            }
        } else {
            result.addCode("this, ", new Object[0]);
        }
        result.addCode("super.buildUnknownFields());\n", new Object[0]);
        return result.build();
    }

    private CodeBlock defaultValue(Field field) {
        String defaultValue = field.getDefault();
        if (defaultValue == null && this.isEnum(field.type())) {
            defaultValue = this.enumDefault(field.type()).getName();
        }
        if (field.type().isScalar() || defaultValue != null) {
            return this.fieldInitializer(field.type(), defaultValue);
        }
        throw new IllegalStateException("Field " + field + " cannot have default value");
    }

    private CodeBlock fieldInitializer(ProtoType type, @Nullable Object value) {
        TypeName javaType = this.typeName(type);
        if (value instanceof List) {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("$T.asList(", new Object[]{Arrays.class});
            boolean first = true;
            for (Object o : (List)value) {
                if (!first) {
                    builder.add(",", new Object[0]);
                }
                first = false;
                builder.add("\n$>$>$L$<$<", new Object[]{this.fieldInitializer(type, o)});
            }
            builder.add(")", new Object[0]);
            return builder.build();
        }
        if (value instanceof Map) {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("new $T.Builder()", new Object[]{javaType});
            for (Map.Entry entry : ((Map)value).entrySet()) {
                ProtoMember protoMember = (ProtoMember)entry.getKey();
                Field field = this.schema.getField(protoMember);
                CodeBlock valueInitializer = this.fieldInitializer(field.type(), entry.getValue());
                builder.add("\n$>$>.$L($L)$<$<", new Object[]{this.fieldName(type, field), valueInitializer});
            }
            builder.add("\n$>$>.build()$<$<", new Object[0]);
            return builder.build();
        }
        if (javaType.equals((Object)TypeName.BOOLEAN.box())) {
            return CodeBlock.of((String)"$L", (Object[])new Object[]{value != null ? value : Boolean.valueOf(false)});
        }
        if (javaType.equals((Object)TypeName.INT.box())) {
            return CodeBlock.of((String)"$L", (Object[])new Object[]{JavaGenerator.valueToInt(value)});
        }
        if (javaType.equals((Object)TypeName.LONG.box())) {
            return CodeBlock.of((String)"$LL", (Object[])new Object[]{Long.toString(JavaGenerator.valueToLong(value))});
        }
        if (javaType.equals((Object)TypeName.FLOAT.box())) {
            return CodeBlock.of((String)"$Lf", (Object[])new Object[]{value != null ? String.valueOf(value) : Float.valueOf(0.0f)});
        }
        if (javaType.equals((Object)TypeName.DOUBLE.box())) {
            return CodeBlock.of((String)"$Ld", (Object[])new Object[]{value != null ? String.valueOf(value) : Double.valueOf(0.0)});
        }
        if (javaType.equals((Object)STRING)) {
            return CodeBlock.of((String)"$S", (Object[])new Object[]{value != null ? (String)value : ""});
        }
        if (javaType.equals((Object)BYTE_STRING)) {
            if (value == null) {
                return CodeBlock.of((String)"$T.EMPTY", (Object[])new Object[]{ByteString.class});
            }
            return CodeBlock.of((String)"$T.decodeBase64($S)", (Object[])new Object[]{ByteString.class, ByteString.encodeString((String)String.valueOf(value), (Charset)Charsets.ISO_8859_1).base64()});
        }
        if (this.isEnum(type) && value != null) {
            return CodeBlock.of((String)"$T.$L", (Object[])new Object[]{javaType, value});
        }
        throw new IllegalStateException(type + " is not an allowed scalar type");
    }

    static int valueToInt(@Nullable Object value) {
        if (value == null) {
            return 0;
        }
        String string = String.valueOf(value);
        if (string.startsWith("0x") || string.startsWith("0X")) {
            return Integer.valueOf(string.substring("0x".length()), 16);
        }
        if (string.startsWith("0") && !string.equals("0")) {
            throw new IllegalStateException("Octal literal unsupported: " + value);
        }
        return new BigInteger(string).intValue();
    }

    static long valueToLong(@Nullable Object value) {
        if (value == null) {
            return 0L;
        }
        String string = String.valueOf(value);
        if (string.startsWith("0x") || string.startsWith("0X")) {
            return Long.valueOf(string.substring("0x".length()), 16);
        }
        if (string.startsWith("0") && !string.equals("0")) {
            throw new IllegalStateException("Octal literal unsupported: " + value);
        }
        return new BigInteger(string).longValue();
    }
}

