/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.java.internal;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.java.internal.ProfileFileElement;
import com.squareup.wire.java.internal.TypeConfigElement;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.internal.parser.SyntaxReader;

public final class ProfileParser {
    private final SyntaxReader reader;
    private final ProfileFileElement.Builder fileBuilder;
    private final ImmutableList.Builder<String> imports = ImmutableList.builder();
    private final ImmutableList.Builder<TypeConfigElement> typeConfigs = ImmutableList.builder();
    private String packageName;

    public ProfileParser(Location location, String data) {
        this.reader = new SyntaxReader(data.toCharArray(), location);
        this.fileBuilder = ProfileFileElement.builder(location);
    }

    public ProfileFileElement read() {
        String label = this.reader.readWord();
        if (!label.equals("syntax")) {
            throw this.reader.unexpected("expected 'syntax'");
        }
        this.reader.require('=');
        String syntaxString = this.reader.readQuotedString();
        if (!syntaxString.equals("wire2")) {
            throw this.reader.unexpected("expected 'wire2'");
        }
        this.reader.require(';');
        while (true) {
            String documentation = this.reader.readDocumentation();
            if (this.reader.exhausted()) {
                return this.fileBuilder.packageName(this.packageName).imports((ImmutableList<String>)this.imports.build()).typeConfigs((ImmutableList<TypeConfigElement>)this.typeConfigs.build()).build();
            }
            this.readDeclaration(documentation);
        }
    }

    private void readDeclaration(String documentation) {
        Location location = this.reader.location();
        String label = this.reader.readWord();
        if (label.equals("package")) {
            if (this.packageName != null) {
                throw this.reader.unexpected(location, "too many package names");
            }
            this.packageName = this.reader.readName();
            this.reader.require(';');
        } else if (label.equals("import")) {
            String importString = this.reader.readString();
            this.imports.add((Object)importString);
            this.reader.require(';');
        } else if (label.equals("type")) {
            this.typeConfigs.add((Object)this.readTypeConfig(location, documentation));
        } else {
            throw this.reader.unexpected(location, "unexpected label: " + label);
        }
    }

    private TypeConfigElement readTypeConfig(Location location, String documentation) {
        String name = this.reader.readDataType();
        String target = null;
        String adapter = null;
        this.reader.require('{');
        block6: while (!this.reader.peekChar('}')) {
            String word;
            Location wordLocation = this.reader.location();
            switch (word = this.reader.readWord()) {
                case "target": {
                    if (target != null) {
                        throw this.reader.unexpected(wordLocation, "too many targets");
                    }
                    target = this.reader.readWord();
                    if (!this.reader.readWord().equals("using")) {
                        throw this.reader.unexpected("expected 'using'");
                    }
                    String adapterType = this.reader.readWord();
                    this.reader.require('#');
                    String adapterConstant = this.reader.readWord();
                    this.reader.require(';');
                    adapter = adapterType + '#' + adapterConstant;
                    continue block6;
                }
            }
            throw this.reader.unexpected(wordLocation, "unexpected label: " + word);
        }
        return TypeConfigElement.builder(location).type(name).documentation(documentation).target(target).adapter(adapter).build();
    }
}

