/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.squareup.wire.Extension;
import com.squareup.wire.ExtensionRegistry;
import com.squareup.wire.FieldBinding;
import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.RuntimeMessageAdapter;
import com.squareup.wire.TagMap;
import com.squareup.wire.WireField;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okio.ByteString;

class MessageTypeAdapter<M extends Message<M>, B extends Message.Builder<M, B>>
extends TypeAdapter<M> {
    private final Class<M> messageType;
    private static final BigInteger POWER_64 = new BigInteger("18446744073709551616");
    private final Gson gson;
    private final RuntimeMessageAdapter<M, B> messageAdapter;
    private final Map<String, FieldBinding<M, B>> fieldBindings;
    private final Map<String, Extension<?, ?>> extensions;

    public MessageTypeAdapter(ExtensionRegistry extensionRegistry, Gson gson, TypeToken<M> type) {
        this.gson = gson;
        this.messageType = type.getRawType();
        this.messageAdapter = RuntimeMessageAdapter.create(this.messageType);
        LinkedHashMap<String, FieldBinding> fieldBindings = new LinkedHashMap<String, FieldBinding>();
        for (FieldBinding binding : this.messageAdapter.fieldBindings().values()) {
            fieldBindings.put(binding.name, binding);
        }
        this.fieldBindings = Collections.unmodifiableMap(fieldBindings);
        LinkedHashMap extensions = new LinkedHashMap();
        for (Extension extension : extensionRegistry.extensions(this.messageType)) {
            extensions.put(extension.getName(), extension);
        }
        this.extensions = extensions;
    }

    public void write(JsonWriter out, M message) throws IOException {
        if (message == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        for (FieldBinding tagBinding : this.messageAdapter.fieldBindings().values()) {
            Object value = tagBinding.get(message);
            if (value == null) continue;
            out.name(tagBinding.name);
            this.emitJson(out, value, tagBinding.singleAdapter(), tagBinding.label);
        }
        TagMap tagMap = ((Message)message).tagMap;
        if (tagMap != null) {
            for (Extension extension : tagMap.extensions(true)) {
                if (extension.isUnknown()) {
                    List values = (List)tagMap.get(extension);
                    if (values.isEmpty()) continue;
                    out.name(Integer.toString(extension.getTag()));
                    out.beginArray();
                    if (extension.getAdapter() == ProtoAdapter.UINT64) {
                        out.value("varint");
                        for (Object o : values) {
                            out.value((Number)((Long)o));
                        }
                    } else if (extension.getAdapter() == ProtoAdapter.FIXED32) {
                        out.value("fixed32");
                        for (Object o : values) {
                            out.value((Number)((Integer)o));
                        }
                    } else if (extension.getAdapter() == ProtoAdapter.FIXED64) {
                        out.value("fixed64");
                        for (Object o : values) {
                            out.value((Number)((Long)o));
                        }
                    } else if (extension.getAdapter() == ProtoAdapter.BYTES) {
                        out.value("length-delimited");
                        for (Object o : values) {
                            out.value(((ByteString)o).base64());
                        }
                    } else {
                        throw new AssertionError((Object)("Unknown wire type " + extension));
                    }
                    out.endArray();
                    continue;
                }
                Object value = tagMap.get(extension);
                out.name(extension.getName());
                this.emitJson(out, value, extension.getAdapter(), extension.getLabel());
            }
        }
        out.endObject();
    }

    private void emitJson(JsonWriter out, Object value, ProtoAdapter<?> adapter, WireField.Label label) throws IOException {
        if (adapter == ProtoAdapter.UINT64) {
            if (label.isRepeated()) {
                List longs = (List)value;
                out.beginArray();
                int count = longs.size();
                for (int i = 0; i < count; ++i) {
                    this.emitUint64((Long)longs.get(i), out);
                }
                out.endArray();
            } else {
                this.emitUint64((Long)value, out);
            }
        } else {
            this.gson.toJson(value, value.getClass(), out);
        }
    }

    private void emitUint64(Long value, JsonWriter out) throws IOException {
        if (value < 0L) {
            BigInteger unsigned = POWER_64.add(BigInteger.valueOf(value));
            out.value((Number)unsigned);
        } else {
            out.value((Number)value);
        }
    }

    public M read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        Message.Builder builder = this.messageAdapter.newBuilder();
        in.beginObject();
        while (in.peek() == JsonToken.NAME) {
            String name = in.nextName();
            FieldBinding<M, B> fieldBinding = this.fieldBindings.get(name);
            if (fieldBinding != null) {
                Object value = this.parseValue(fieldBinding.label, this.singleType(fieldBinding), this.parse(in));
                fieldBinding.set(builder, value);
                continue;
            }
            Extension<?, ?> extension = this.extensions.get(name);
            if (extension != null) {
                Object value = this.parseValue(extension.getLabel(), extension.getAdapter().javaType, this.parse(in));
                builder.setExtension(extension, value);
                continue;
            }
            this.parseUnknownField(in, builder, Integer.parseInt(name));
        }
        in.endObject();
        return (M)builder.build();
    }

    private JsonElement parse(JsonReader in) {
        return (JsonElement)this.gson.fromJson(in, JsonElement.class);
    }

    private Object parseValue(WireField.Label label, Type valueType, JsonElement valueElement) {
        if (label.isRepeated()) {
            ArrayList<Object> valueList = new ArrayList<Object>();
            for (JsonElement element : valueElement.getAsJsonArray()) {
                valueList.add(this.readJson(valueType, element));
            }
            return valueList;
        }
        return this.readJson(valueType, valueElement);
    }

    private void parseUnknownField(JsonReader in, B builder, int tag) throws IOException {
        in.beginArray();
        UnknownFieldType type = UnknownFieldType.of(in.nextString());
        block6: while (in.peek() != JsonToken.END_ARRAY) {
            switch (type) {
                case VARINT: {
                    long varint = in.nextLong();
                    builder.setExtension(Extension.unknown(this.messageType, (int)tag, (FieldEncoding)FieldEncoding.VARINT), (Object)varint);
                    continue block6;
                }
                case FIXED32: {
                    int fixed32 = in.nextInt();
                    builder.setExtension(Extension.unknown(this.messageType, (int)tag, (FieldEncoding)FieldEncoding.FIXED32), (Object)fixed32);
                    continue block6;
                }
                case FIXED64: {
                    long fixed64 = in.nextLong();
                    builder.setExtension(Extension.unknown(this.messageType, (int)tag, (FieldEncoding)FieldEncoding.FIXED64), (Object)fixed64);
                    continue block6;
                }
                case LENGTH_DELIMITED: {
                    ByteString byteString = ByteString.decodeBase64((String)in.nextString());
                    builder.setExtension(Extension.unknown(this.messageType, (int)tag, (FieldEncoding)FieldEncoding.LENGTH_DELIMITED), (Object)byteString);
                    continue block6;
                }
            }
            throw new AssertionError((Object)("Unknown field type " + (Object)((Object)type)));
        }
        in.endArray();
    }

    private Object readJson(Type valueType, JsonElement element) {
        return this.gson.fromJson(element, valueType);
    }

    private Type singleType(FieldBinding<M, B> tagBinding) {
        return tagBinding.singleAdapter().javaType;
    }

    static enum UnknownFieldType {
        VARINT,
        FIXED32,
        FIXED64,
        LENGTH_DELIMITED;


        public static UnknownFieldType of(String name) {
            if ("varint".equals(name)) {
                return VARINT;
            }
            if ("fixed32".equals(name)) {
                return FIXED32;
            }
            if ("fixed64".equals(name)) {
                return FIXED64;
            }
            if ("length-delimited".equals(name)) {
                return LENGTH_DELIMITED;
            }
            throw new IllegalArgumentException("Unknown type " + name);
        }
    }
}

