/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.squareup.wire.Message;
import com.squareup.wire.RuntimeMessageAdapter;
import com.squareup.wire.TagBinding;
import com.squareup.wire.UnknownFieldMap;
import com.squareup.wire.Wire;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okio.ByteString;

class MessageTypeAdapter<M extends Message>
extends TypeAdapter<M> {
    private static final BigInteger POWER_64 = new BigInteger("18446744073709551616");
    private final Gson gson;
    private final RuntimeMessageAdapter<M> messageAdapter;
    private final Map<String, TagBinding<M, Message.Builder<M>>> tagMap;

    public MessageTypeAdapter(Wire wire, Gson gson, TypeToken<M> type) {
        this.gson = gson;
        this.messageAdapter = wire.messageAdapter(type.getRawType());
        LinkedHashMap<String, TagBinding> tagMap = new LinkedHashMap<String, TagBinding>();
        for (TagBinding tagBinding : this.messageAdapter.tagBindings().values()) {
            tagMap.put(tagBinding.name, tagBinding);
        }
        this.tagMap = Collections.unmodifiableMap(tagMap);
    }

    public void write(JsonWriter out, M message) throws IOException {
        if (message == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        for (TagBinding tagBinding : this.messageAdapter.tagBindingsForMessage(message).values()) {
            Object value = tagBinding.get(message);
            if (value == null) continue;
            out.name(tagBinding.name);
            this.emitJson(out, value, tagBinding.datatype, tagBinding.label);
        }
        Collection unknownFields = message.unknownFields();
        if (unknownFields != null) {
            for (List fieldList : unknownFields) {
                int tag = ((UnknownFieldMap.Value)fieldList.get((int)0)).tag;
                out.name(String.valueOf(tag));
                out.beginArray();
                int count = fieldList.size();
                block8: for (int i = 0; i < count; ++i) {
                    UnknownFieldMap.Value unknownField = (UnknownFieldMap.Value)fieldList.get(i);
                    switch (unknownField.adapter.fieldEncoding) {
                        case VARINT: {
                            if (i == 0) {
                                out.value("varint");
                            }
                            out.value((Number)((Long)unknownField.value));
                            continue block8;
                        }
                        case FIXED32: {
                            if (i == 0) {
                                out.value("fixed32");
                            }
                            out.value((Number)((Integer)unknownField.value));
                            continue block8;
                        }
                        case FIXED64: {
                            if (i == 0) {
                                out.value("fixed64");
                            }
                            out.value((Number)((Long)unknownField.value));
                            continue block8;
                        }
                        case LENGTH_DELIMITED: {
                            if (i == 0) {
                                out.value("length-delimited");
                            }
                            out.value(((ByteString)unknownField.value).base64());
                            continue block8;
                        }
                        default: {
                            throw new AssertionError((Object)("Unknown wire type " + unknownField.adapter.fieldEncoding));
                        }
                    }
                }
                out.endArray();
            }
        }
        out.endObject();
    }

    private void emitJson(JsonWriter out, Object value, Message.Datatype datatype, Message.Label label) throws IOException {
        if (datatype == Message.Datatype.UINT64) {
            if (label.isRepeated()) {
                List longs = (List)value;
                out.beginArray();
                int count = longs.size();
                for (int i = 0; i < count; ++i) {
                    this.emitUint64((Long)longs.get(i), out);
                }
                out.endArray();
            } else {
                this.emitUint64((Long)value, out);
            }
        } else {
            this.gson.toJson(value, value.getClass(), out);
        }
    }

    private void emitUint64(Long value, JsonWriter out) throws IOException {
        if (value < 0L) {
            BigInteger unsigned = POWER_64.add(BigInteger.valueOf(value));
            out.value((Number)unsigned);
        } else {
            out.value((Number)value);
        }
    }

    public M read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        Message.Builder builder = this.messageAdapter.newBuilder();
        in.beginObject();
        while (in.peek() == JsonToken.NAME) {
            String name = in.nextName();
            TagBinding<M, Message.Builder<M>> tagBinding = this.tagMap.get(name);
            if (tagBinding != null) {
                Object value = this.parseValue(tagBinding.label, this.singleType(tagBinding), this.parse(in));
                tagBinding.set((Object)builder, value);
                continue;
            }
            this.parseUnknownField(in, builder, Integer.parseInt(name));
        }
        in.endObject();
        return (M)builder.build();
    }

    private JsonElement parse(JsonReader in) {
        return (JsonElement)this.gson.fromJson(in, JsonElement.class);
    }

    private Object parseValue(Message.Label label, Type valueType, JsonElement valueElement) {
        if (label.isRepeated()) {
            ArrayList<Object> valueList = new ArrayList<Object>();
            for (JsonElement element : valueElement.getAsJsonArray()) {
                valueList.add(this.readJson(valueType, element));
            }
            return valueList;
        }
        return this.readJson(valueType, valueElement);
    }

    private void parseUnknownField(JsonReader in, Message.Builder<M> builder, int tag) throws IOException {
        in.beginArray();
        UnknownFieldType type = UnknownFieldType.of(in.nextString());
        block6: while (in.peek() != JsonToken.END_ARRAY) {
            switch (type) {
                case VARINT: {
                    builder.addVarint(tag, (long)in.nextInt());
                    continue block6;
                }
                case FIXED32: {
                    builder.addFixed32(tag, in.nextInt());
                    continue block6;
                }
                case FIXED64: {
                    builder.addFixed64(tag, (long)in.nextInt());
                    continue block6;
                }
                case LENGTH_DELIMITED: {
                    builder.addLengthDelimited(tag, ByteString.decodeBase64((String)in.nextString()));
                    continue block6;
                }
            }
            throw new AssertionError((Object)("Unknown field type " + (Object)((Object)type)));
        }
        in.endArray();
    }

    private Object readJson(Type valueType, JsonElement element) {
        return this.gson.fromJson(element, valueType);
    }

    private Type singleType(TagBinding<M, Message.Builder<M>> tagBinding) {
        return tagBinding.singleAdapter.javaType;
    }

    static enum UnknownFieldType {
        VARINT,
        FIXED32,
        FIXED64,
        LENGTH_DELIMITED;


        public static UnknownFieldType of(String name) {
            if ("varint".equals(name)) {
                return VARINT;
            }
            if ("fixed32".equals(name)) {
                return FIXED32;
            }
            if ("fixed64".equals(name)) {
                return FIXED64;
            }
            if ("length-delimited".equals(name)) {
                return LENGTH_DELIMITED;
            }
            throw new IllegalArgumentException("Unknown type " + name);
        }
    }
}

