/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.mockwebserver;

import com.squareup.wire.GrpcCall;
import com.squareup.wire.GrpcClient;
import com.squareup.wire.GrpcMethod;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.Service;
import com.squareup.wire.internal.GrpcMessageSink;
import com.squareup.wire.internal.GrpcMessageSource;
import java.io.Closeable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.RecordedRequest;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 %2\u00020\u0001:\u0002%&B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J*\u0010\r\u001a\u00020\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00110\u00102\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002J-\u0010\u0013\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J8\u0010\u001d\u001a\u00020\u001c\"\b\b\u0000\u0010\u0014*\u00020\u0015\"\b\b\u0001\u0010\u001e*\u00020\u00152\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H\u001e0\f2\u0006\u0010 \u001a\u00020\u0017H\u0002J-\u0010!\u001a\u00020\"\"\b\b\u0000\u0010\u001e*\u00020\u00152\u0006\u0010#\u001a\u0002H\u001e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u0019H\u0002\u00a2\u0006\u0002\u0010$J \u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f0\n*\u00020\u0004H\u0002R\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/squareup/wire/mockwebserver/GrpcDispatcher;", "Lokhttp3/mockwebserver/Dispatcher;", "services", "", "Lcom/squareup/wire/Service;", "delegate", "(Ljava/util/List;Lokhttp3/mockwebserver/Dispatcher;)V", "getDelegate", "()Lokhttp3/mockwebserver/Dispatcher;", "endpoints", "", "", "Lcom/squareup/wire/mockwebserver/GrpcDispatcher$Endpoint;", "collectGrpcInterfaces", "", "sink", "", "Ljava/lang/Class;", "type", "decodeRequest", "S", "", "request", "Lokhttp3/mockwebserver/RecordedRequest;", "protoAdapter", "Lcom/squareup/wire/ProtoAdapter;", "(Lokhttp3/mockwebserver/RecordedRequest;Lcom/squareup/wire/ProtoAdapter;)Ljava/lang/Object;", "dispatch", "Lokhttp3/mockwebserver/MockResponse;", "dispatchGrpc", "R", "endpoint", "recordedRequest", "encodeResponse", "Lokio/Buffer;", "response", "(Ljava/lang/Object;Lcom/squareup/wire/ProtoAdapter;)Lokio/Buffer;", "Companion", "Endpoint", "wire-grpc-mockwebserver"})
public final class GrpcDispatcher
extends Dispatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Dispatcher delegate;
    @NotNull
    private final Map<String, Endpoint<?, ?>> endpoints;
    @NotNull
    private static final GrpcClient nullGrpcClient = new GrpcClient.Builder().callFactory(GrpcDispatcher::nullGrpcClient$lambda$2).baseUrl("https://localhost/").build();

    /*
     * WARNING - void declaration
     */
    public GrpcDispatcher(@NotNull List<? extends Service> services, @NotNull Dispatcher delegate) {
        Intrinsics.checkNotNullParameter(services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        GrpcDispatcher grpcDispatcher = this;
        GrpcDispatcher grpcDispatcher2 = this;
        boolean bl = false;
        Map map = new LinkedHashMap();
        for (Service service : services) {
            void $this$endpoints_u24lambda_u240;
            map.putAll(super.endpoints(service));
        }
        grpcDispatcher2.endpoints = map;
    }

    @NotNull
    public final Dispatcher getDelegate() {
        return this.delegate;
    }

    private final Map<String, Endpoint<?, ?>> endpoints(Service $this$endpoints) {
        Map result = new LinkedHashMap();
        Set grpcInterfaces = new LinkedHashSet();
        this.collectGrpcInterfaces(grpcInterfaces, $this$endpoints.getClass());
        for (Class grpcInterface : grpcInterfaces) {
            Method[] methodArray;
            Service grpcClientClass = nullGrpcClient.create(JvmClassMappingKt.getKotlinClass((Class)grpcInterface));
            Intrinsics.checkNotNullExpressionValue((Object)grpcInterface.getMethods(), (String)"getMethods(...)");
            for (Method javaMethod : methodArray) {
                GrpcCall grpcCall;
                Object object = javaMethod.invoke((Object)grpcClientClass, new Object[0]);
                if ((object instanceof GrpcCall ? (GrpcCall)object : null) == null) continue;
                grpcCall = grpcCall;
                GrpcMethod grpcMethod = grpcCall.getMethod();
                String string = grpcMethod.getPath();
                Intrinsics.checkNotNull((Object)javaMethod);
                result.put(string, new Endpoint(grpcMethod, javaMethod, $this$endpoints));
            }
        }
        return result;
    }

    private final void collectGrpcInterfaces(Set<Class<? extends Service>> sink, Class<?> type) {
        Class<?>[] interfaces = type.getInterfaces();
        if (type.isInterface() && interfaces.length == 1 && Intrinsics.areEqual(interfaces[0], Service.class)) {
            Collection collection = sink;
            Intrinsics.checkNotNull(type, (String)"null cannot be cast to non-null type java.lang.Class<out com.squareup.wire.Service>");
            collection.add(type);
            return;
        }
        Intrinsics.checkNotNull(interfaces);
        for (Class<?> parentInterface : interfaces) {
            Intrinsics.checkNotNull(parentInterface);
            this.collectGrpcInterfaces(sink, parentInterface);
        }
        Class<?> superclass = type.getSuperclass();
        if (superclass != null) {
            this.collectGrpcInterfaces(sink, superclass);
        }
    }

    @NotNull
    public MockResponse dispatch(@NotNull RecordedRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Endpoint<?, ?> endpoint = this.endpoints.get(request.getPath());
        if (endpoint == null) {
            return this.delegate.dispatch(request);
        }
        Endpoint<?, ?> endpoint2 = endpoint;
        if (!Intrinsics.areEqual((Object)request.getHeaders().get("content-type"), (Object)"application/grpc") || !Intrinsics.areEqual((Object)request.getMethod(), (Object)"POST")) {
            return this.delegate.dispatch(request);
        }
        return this.dispatchGrpc(endpoint2, request);
    }

    private final <S, R> MockResponse dispatchGrpc(Endpoint<S, R> endpoint, RecordedRequest recordedRequest) {
        S request = this.decodeRequest(recordedRequest, endpoint.getGrpcMethod().getRequestAdapter());
        GrpcCall<S, R> grpcCall = endpoint.newGrpcCall();
        Object response = grpcCall.executeBlocking(request);
        Buffer responseBody = this.encodeResponse(response, endpoint.getGrpcMethod().getResponseAdapter());
        String[] stringArray = new String[]{"grpc-status", "0"};
        return new MockResponse().setHeader("grpc-encoding", (Object)"identity").setHeader("grpc-accept-encoding", (Object)"gzip").setHeader("Content-Type", (Object)"application/grpc").setTrailers(Headers.Companion.of(stringArray)).setBody(responseBody);
    }

    private final <S> S decodeRequest(RecordedRequest request, ProtoAdapter<S> protoAdapter) {
        GrpcMessageSource source = new GrpcMessageSource((BufferedSource)request.getBody(), protoAdapter, request.getHeaders().get("grpc-encoding"));
        return (S)source.readExactlyOneAndClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> Buffer encodeResponse(R response, ProtoAdapter<R> protoAdapter) {
        Buffer result = new Buffer();
        Closeable closeable = (Closeable)new GrpcMessageSink((BufferedSink)result, 0L, protoAdapter, null, "identity");
        Throwable throwable = null;
        try {
            GrpcMessageSink it = (GrpcMessageSink)closeable;
            boolean bl = false;
            it.write(response);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return result;
    }

    private static final Call nullGrpcClient$lambda$2(Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Companion.NullCall.INSTANCE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/squareup/wire/mockwebserver/GrpcDispatcher$Companion;", "", "()V", "nullGrpcClient", "Lcom/squareup/wire/GrpcClient;", "NullCall", "wire-grpc-mockwebserver"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0004H\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/squareup/wire/mockwebserver/GrpcDispatcher$Companion$NullCall;", "Lokhttp3/Call;", "()V", "cancel", "", "clone", "enqueue", "responseCallback", "Lokhttp3/Callback;", "execute", "isCanceled", "isExecuted", "request", "timeout", "Lokio/Timeout;", "wire-grpc-mockwebserver"})
        public static final class NullCall
        implements Call {
            @NotNull
            public static final NullCall INSTANCE = new NullCall();

            private NullCall() {
            }

            @NotNull
            public Void cancel() {
                throw new IllegalStateException("unexpected call".toString());
            }

            @NotNull
            public Void clone() {
                throw new IllegalStateException("unexpected call".toString());
            }

            @NotNull
            public Void enqueue(@NotNull Callback responseCallback) {
                Intrinsics.checkNotNullParameter((Object)responseCallback, (String)"responseCallback");
                throw new IllegalStateException("unexpected call".toString());
            }

            @NotNull
            public Void execute() {
                throw new IllegalStateException("unexpected call".toString());
            }

            @NotNull
            public Void isCanceled() {
                throw new IllegalStateException("unexpected call".toString());
            }

            @NotNull
            public Void isExecuted() {
                throw new IllegalStateException("unexpected call".toString());
            }

            @NotNull
            public Void request() {
                throw new IllegalStateException("unexpected call".toString());
            }

            @NotNull
            public Timeout timeout() {
                return Timeout.NONE;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002B)\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0012R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/squareup/wire/mockwebserver/GrpcDispatcher$Endpoint;", "S", "", "R", "grpcMethod", "Lcom/squareup/wire/GrpcMethod;", "javaMethod", "Ljava/lang/reflect/Method;", "service", "Lcom/squareup/wire/Service;", "(Lcom/squareup/wire/GrpcMethod;Ljava/lang/reflect/Method;Lcom/squareup/wire/Service;)V", "getGrpcMethod", "()Lcom/squareup/wire/GrpcMethod;", "getJavaMethod", "()Ljava/lang/reflect/Method;", "getService", "()Lcom/squareup/wire/Service;", "newGrpcCall", "Lcom/squareup/wire/GrpcCall;", "wire-grpc-mockwebserver"})
    private static final class Endpoint<S, R> {
        @NotNull
        private final GrpcMethod<S, R> grpcMethod;
        @NotNull
        private final Method javaMethod;
        @NotNull
        private final Service service;

        public Endpoint(@NotNull GrpcMethod<S, R> grpcMethod, @NotNull Method javaMethod, @NotNull Service service) {
            Intrinsics.checkNotNullParameter(grpcMethod, (String)"grpcMethod");
            Intrinsics.checkNotNullParameter((Object)javaMethod, (String)"javaMethod");
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            this.grpcMethod = grpcMethod;
            this.javaMethod = javaMethod;
            this.service = service;
        }

        @NotNull
        public final GrpcMethod<S, R> getGrpcMethod() {
            return this.grpcMethod;
        }

        @NotNull
        public final Method getJavaMethod() {
            return this.javaMethod;
        }

        @NotNull
        public final Service getService() {
            return this.service;
        }

        @NotNull
        public final GrpcCall<S, R> newGrpcCall() {
            Object object = this.javaMethod.invoke((Object)this.service, new Object[0]);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.squareup.wire.GrpcCall<S of com.squareup.wire.mockwebserver.GrpcDispatcher.Endpoint, R of com.squareup.wire.mockwebserver.GrpcDispatcher.Endpoint>");
            return (GrpcCall)object;
        }
    }
}

