/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.GrpcEncoder;
import com.squareup.wire.GrpcEncoderKt;
import com.squareup.wire.MessageSink;
import com.squareup.wire.ProtoAdapter;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSink;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B#\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\f\u001a\u00020\rH\u0096\u0001J\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/squareup/wire/GrpcMessageSink;", "T", "", "Lcom/squareup/wire/MessageSink;", "Ljava/io/Closeable;", "sink", "Lokio/BufferedSink;", "messageAdapter", "Lcom/squareup/wire/ProtoAdapter;", "grpcEncoding", "", "(Lokio/BufferedSink;Lcom/squareup/wire/ProtoAdapter;Ljava/lang/String;)V", "close", "", "write", "message", "(Ljava/lang/Object;)V", "wire-grpc-client"})
public final class GrpcMessageSink<T>
implements MessageSink<T>,
Closeable {
    private final BufferedSink sink;
    private final ProtoAdapter<T> messageAdapter;
    private final String grpcEncoding;

    public void write(@NotNull T message) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        GrpcEncoder messageEncoding = GrpcEncoderKt.toGrpcEncoder(this.grpcEncoding);
        BufferedSink encodingSink = messageEncoding.encode(this.sink);
        int compressedFlag = Intrinsics.areEqual((Object)this.grpcEncoding, (Object)"identity") ? 0 : 1;
        encodingSink.writeByte(compressedFlag);
        Buffer encodedMessage = new Buffer();
        this.messageAdapter.encode((BufferedSink)encodedMessage, message);
        encodingSink.writeInt((int)encodedMessage.size());
        encodingSink.writeAll((Source)encodedMessage);
        this.sink.flush();
    }

    public GrpcMessageSink(@NotNull BufferedSink sink, @NotNull ProtoAdapter<T> messageAdapter, @NotNull String grpcEncoding) {
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        Intrinsics.checkParameterIsNotNull(messageAdapter, (String)"messageAdapter");
        Intrinsics.checkParameterIsNotNull((Object)grpcEncoding, (String)"grpcEncoding");
        this.sink = sink;
        this.messageAdapter = messageAdapter;
        this.grpcEncoding = grpcEncoding;
    }

    @Override
    public void close() {
        this.sink.close();
    }
}

