/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.ByteString;
import okio.Options;
import okio.Path;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0000\u001a\u0016\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0006H\u0000\u001a\u0014\u0010\t\u001a\u00020\n*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0000\u001a\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0000\u001a(\u0010\u000f\u001a\u00020\u0010*\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00042\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u0013H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"UNICODE_BOMS", "Lokio/Options;", "endsWithDotProto", "", "Lokio/Path;", "readBomAsCharset", "Ljava/nio/charset/Charset;", "Lokio/BufferedSource;", "default", "relativize", "", "descendant", "toOkioFileSystem", "Lokio/FileSystem;", "Ljava/nio/file/FileSystem;", "visitAll", "", "path", "block", "Lkotlin/Function1;", "wire-compiler"})
public final class FileSystemsKt {
    private static final Options UNICODE_BOMS = Options.Companion.of(new ByteString[]{ByteString.Companion.decodeHex("efbbbf"), ByteString.Companion.decodeHex("feff"), ByteString.Companion.decodeHex("fffe"), ByteString.Companion.decodeHex("0000ffff"), ByteString.Companion.decodeHex("ffff0000")});

    public static final void visitAll(@NotNull okio.FileSystem $this$visitAll, @NotNull Path path, @NotNull Function1<? super Path, Unit> block) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$visitAll, (String)"$this$visitAll");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        block.invoke((Object)path);
        try {
            list = $this$visitAll.list(path);
        }
        catch (IOException e) {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        }
        List toVisit = list;
        for (Path child : toVisit) {
            FileSystemsKt.visitAll($this$visitAll, child, block);
        }
    }

    @NotNull
    public static final okio.FileSystem toOkioFileSystem(@NotNull FileSystem $this$toOkioFileSystem) {
        Intrinsics.checkNotNullParameter((Object)$this$toOkioFileSystem, (String)"$this$toOkioFileSystem");
        if (!Intrinsics.areEqual((Object)$this$toOkioFileSystem, (Object)FileSystems.getDefault())) {
            String string = "Wire doesn't support non-default file system: " + $this$toOkioFileSystem;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return okio.FileSystem.SYSTEM;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final String relativize(@NotNull Path $this$relativize, @NotNull Path descendant) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)$this$relativize, (String)"$this$relativize");
            Intrinsics.checkNotNullParameter((Object)descendant, (String)"descendant");
            if (Intrinsics.areEqual((Object)$this$relativize, (Object)descendant)) {
                return "";
            }
            descendantString = descendant.toString();
            var5_4 = thisString = $this$relativize.toString();
            switch (var5_4.hashCode()) {
                case 92: {
                    if (!var5_4.equals("\\")) break;
                    ** GOTO lbl13
                }
                case 47: {
                    if (!var5_4.equals("/")) break;
lbl13:
                    // 2 sources

                    v0 = 0;
                    break block7;
                }
            }
            v0 = thisString.length();
        }
        slashIndex = v0;
        var5_5 = StringsKt.startsWith$default((String)descendantString, (String)thisString, (boolean)false, (int)2, null) != false && (descendantString.charAt(slashIndex) == '/' || descendantString.charAt(slashIndex) == '\\');
        var6_8 = 0;
        var7_9 = false;
        if (!var5_5) {
            $i$a$-require-FileSystemsKt$relativize$1 = false;
            var7_10 = "not a descendant of " + thisString + ": " + descendantString;
            throw (Throwable)new IllegalArgumentException(var7_10.toString());
        }
        var5_6 = descendantString;
        var6_8 = slashIndex + 1;
        var7_9 = false;
        v1 = var5_6;
        if (v1 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        v2 = v1.substring(var6_8);
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"(this as java.lang.String).substring(startIndex)");
        return v2;
    }

    public static final boolean endsWithDotProto(@NotNull Path $this$endsWithDotProto) {
        Intrinsics.checkNotNullParameter((Object)$this$endsWithDotProto, (String)"$this$endsWithDotProto");
        return StringsKt.endsWith$default((String)$this$endsWithDotProto.toString(), (String)".proto", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final Charset readBomAsCharset(@NotNull BufferedSource $this$readBomAsCharset, @NotNull Charset charset) {
        Charset charset2;
        Intrinsics.checkNotNullParameter((Object)$this$readBomAsCharset, (String)"$this$readBomAsCharset");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"default");
        switch ($this$readBomAsCharset.select(UNICODE_BOMS)) {
            case 0: {
                charset2 = Charsets.UTF_8;
                break;
            }
            case 1: {
                charset2 = Charsets.UTF_16BE;
                break;
            }
            case 2: {
                charset2 = Charsets.UTF_16LE;
                break;
            }
            case 3: {
                charset2 = Charsets.INSTANCE.UTF32_BE();
                break;
            }
            case 4: {
                charset2 = Charsets.INSTANCE.UTF32_LE();
                break;
            }
            case -1: {
                charset2 = charset;
                break;
            }
            default: {
                throw (Throwable)((Object)new AssertionError());
            }
        }
        return charset2;
    }

    public static /* synthetic */ Charset readBomAsCharset$default(BufferedSource bufferedSource, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return FileSystemsKt.readBomAsCharset(bufferedSource, charset);
    }
}

