/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.schema.FileSystemsKt;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFilePath;
import com.squareup.wire.schema.Root;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/squareup/wire/schema/DirectoryRoot;", "Lcom/squareup/wire/schema/Root;", "base", "", "fileSystem", "Lokio/FileSystem;", "rootDirectory", "Lokio/Path;", "(Ljava/lang/String;Lokio/FileSystem;Lokio/Path;)V", "getBase", "()Ljava/lang/String;", "getFileSystem", "()Lokio/FileSystem;", "getRootDirectory", "()Lokio/Path;", "allProtoFiles", "", "Lcom/squareup/wire/schema/ProtoFilePath;", "resolve", "import", "toString", "wire-compiler"})
public final class DirectoryRoot
extends Root {
    @NotNull
    private final String base;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Path rootDirectory;

    @Override
    @NotNull
    public Set<ProtoFilePath> allProtoFiles() {
        boolean bl = false;
        Set result = new LinkedHashSet();
        FileSystemsKt.visitAll(this.fileSystem, this.rootDirectory, (Function1<? super Path, Unit>)((Function1)new Function1<Path, Unit>(this, result){
            final /* synthetic */ DirectoryRoot this$0;
            final /* synthetic */ Set $result;

            public final void invoke(@NotNull Path descendant) {
                Intrinsics.checkNotNullParameter((Object)descendant, (String)"descendant");
                if (FileSystemsKt.endsWithDotProto(descendant)) {
                    Location location = Location.Companion.get(this.this$0.getBase(), FileSystemsKt.relativize(this.this$0.getRootDirectory(), descendant));
                    this.$result.add(new ProtoFilePath(location, this.this$0.getFileSystem(), descendant));
                }
            }
            {
                this.this$0 = directoryRoot;
                this.$result = set;
                super(1);
            }
        }));
        return result;
    }

    @Override
    @Nullable
    public ProtoFilePath resolve(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"import");
        Path resolved = this.rootDirectory.resolve(string);
        if (!this.fileSystem.exists(resolved)) {
            return null;
        }
        return new ProtoFilePath(Location.Companion.get(this.getBase(), string), this.fileSystem, resolved);
    }

    @NotNull
    public String toString() {
        return this.getBase();
    }

    @Override
    @NotNull
    public String getBase() {
        return this.base;
    }

    @NotNull
    public final FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @NotNull
    public final Path getRootDirectory() {
        return this.rootDirectory;
    }

    public DirectoryRoot(@NotNull String base, @NotNull FileSystem fileSystem, @NotNull Path rootDirectory) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
        super(null);
        this.base = base;
        this.fileSystem = fileSystem;
        this.rootDirectory = rootDirectory;
    }
}

