/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.ConsoleWireLogger;
import com.squareup.wire.WireLogger;
import com.squareup.wire.schema.IdentifierSet;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.NewSchemaLoader;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Target;
import com.squareup.wire.schema.Type;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BQ\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u00c6\u0003JY\u0010\u0017\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u001a\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020 J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\u0007H\u00d6\u0001J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006'"}, d2={"Lcom/squareup/wire/schema/WireRun;", "", "sourcePath", "", "Lcom/squareup/wire/schema/Location;", "protoPath", "treeShakingRoots", "", "treeShakingRubbish", "targets", "Lcom/squareup/wire/schema/Target;", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getProtoPath", "()Ljava/util/List;", "getSourcePath", "getTargets", "getTreeShakingRoots", "getTreeShakingRubbish", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "execute", "", "fs", "Ljava/nio/file/FileSystem;", "logger", "Lcom/squareup/wire/WireLogger;", "hashCode", "", "toString", "treeShake", "Lcom/squareup/wire/schema/Schema;", "schema", "wire-compiler"})
public final class WireRun {
    @NotNull
    private final List<Location> sourcePath;
    @NotNull
    private final List<Location> protoPath;
    @NotNull
    private final List<String> treeShakingRoots;
    @NotNull
    private final List<String> treeShakingRubbish;
    @NotNull
    private final List<Target> targets;

    public final void execute(@NotNull FileSystem fs, @NotNull WireLogger logger) {
        boolean bl;
        Iterable iterable;
        Schema fullSchema;
        Intrinsics.checkParameterIsNotNull((Object)fs, (String)"fs");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        NewSchemaLoader schemaLoader = new NewSchemaLoader(fs, this.sourcePath, this.protoPath);
        List<ProtoFile> protoFiles = schemaLoader.load();
        List protoFilesPlusDescriptor = CollectionsKt.plus((Collection)protoFiles, (Object)schemaLoader.loadDescriptorProto());
        Schema schema = fullSchema = new Linker((Iterable)protoFilesPlusDescriptor).link();
        Intrinsics.checkExpressionValueIsNotNull((Object)schema, (String)"fullSchema");
        Schema schema2 = this.treeShake(schema, logger);
        boolean bl2 = false;
        List typesToHandle = new ArrayList();
        boolean bl3 = false;
        List servicesToHandle = new ArrayList();
        for (ProtoFile protoFile : schema2.protoFiles()) {
            if (!schemaLoader.getSourceLocationPaths().contains(protoFile.location().getPath())) continue;
            Collection collection = typesToHandle;
            List list = protoFile.types();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"protoFile.types()");
            iterable = list;
            bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
            collection = servicesToHandle;
            List list2 = protoFile.services();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"protoFile.services()");
            iterable = list2;
            bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        }
        Iterable $this$sortedBy$iv = this.targets;
        boolean $i$f$sortedBy = false;
        iterable = $this$sortedBy$iv;
        bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Target it = (Target)a;
                boolean bl2 = false;
                Comparable comparable = Boolean.valueOf(it.getExclusive());
                it = (Target)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Boolean bl3 = it.getExclusive();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)bl3);
            }
        };
        List targetsExclusiveLast = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        for (Target target : targetsExclusiveLast) {
            IdentifierSet identifierSet;
            Target.SchemaHandler schemaHandler = target.newHandler$wire_compiler(schema2, fs, logger);
            Intrinsics.checkExpressionValueIsNotNull((Object)new IdentifierSet.Builder().include((Iterable)target.getIncludes()).exclude((Iterable)target.getExcludes()).build(), (String)"IdentifierSet.Builder()\n\u2026ludes)\n          .build()");
            Iterator i = typesToHandle.iterator();
            while (i.hasNext()) {
                Type type = (Type)i.next();
                if (!identifierSet.includes(type.type())) continue;
                schemaHandler.handle(type);
                if (!target.getExclusive()) continue;
                i.remove();
            }
            Iterator j = servicesToHandle.iterator();
            while (j.hasNext()) {
                Service service = (Service)j.next();
                if (!identifierSet.includes(service.type())) continue;
                schemaHandler.handle(service);
                if (!target.getExclusive()) continue;
                j.remove();
            }
            for (String rule : identifierSet.unusedIncludes()) {
                logger.info("Unused include in target: " + rule);
            }
            for (String rule : identifierSet.unusedExcludes()) {
                logger.info("Unused exclude in target: " + rule);
            }
        }
    }

    public static /* synthetic */ void execute$default(WireRun wireRun, FileSystem fileSystem, WireLogger wireLogger, int n, Object object) {
        if ((n & 1) != 0) {
            FileSystem fileSystem2 = FileSystems.getDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileSystem2, (String)"FileSystems.getDefault()");
            fileSystem = fileSystem2;
        }
        if ((n & 2) != 0) {
            wireLogger = new ConsoleWireLogger();
        }
        wireRun.execute(fileSystem, wireLogger);
    }

    private final Schema treeShake(Schema schema, WireLogger logger) {
        if (Intrinsics.areEqual(this.treeShakingRoots, (Object)CollectionsKt.listOf((Object)"*")) && this.treeShakingRubbish.isEmpty()) {
            return schema;
        }
        IdentifierSet identifierSet = new IdentifierSet.Builder().include((Iterable)this.treeShakingRoots).exclude((Iterable)this.treeShakingRubbish).build();
        Schema result = schema.prune(identifierSet);
        for (String rule : identifierSet.unusedIncludes()) {
            logger.info("Unused element in treeShakingRoots: " + rule);
        }
        for (String rule : identifierSet.unusedExcludes()) {
            logger.info("Unused element in treeShakingRubbish: " + rule);
        }
        Schema schema2 = result;
        Intrinsics.checkExpressionValueIsNotNull((Object)schema2, (String)"result");
        return schema2;
    }

    @NotNull
    public final List<Location> getSourcePath() {
        return this.sourcePath;
    }

    @NotNull
    public final List<Location> getProtoPath() {
        return this.protoPath;
    }

    @NotNull
    public final List<String> getTreeShakingRoots() {
        return this.treeShakingRoots;
    }

    @NotNull
    public final List<String> getTreeShakingRubbish() {
        return this.treeShakingRubbish;
    }

    @NotNull
    public final List<Target> getTargets() {
        return this.targets;
    }

    public WireRun(@NotNull List<Location> sourcePath, @NotNull List<Location> protoPath, @NotNull List<String> treeShakingRoots, @NotNull List<String> treeShakingRubbish, @NotNull List<? extends Target> targets) {
        Intrinsics.checkParameterIsNotNull(sourcePath, (String)"sourcePath");
        Intrinsics.checkParameterIsNotNull(protoPath, (String)"protoPath");
        Intrinsics.checkParameterIsNotNull(treeShakingRoots, (String)"treeShakingRoots");
        Intrinsics.checkParameterIsNotNull(treeShakingRubbish, (String)"treeShakingRubbish");
        Intrinsics.checkParameterIsNotNull(targets, (String)"targets");
        this.sourcePath = sourcePath;
        this.protoPath = protoPath;
        this.treeShakingRoots = treeShakingRoots;
        this.treeShakingRubbish = treeShakingRubbish;
        this.targets = targets;
    }

    public /* synthetic */ WireRun(List list, List list2, List list3, List list4, List list5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        boolean bl;
        if ((n & 2) != 0) {
            bl = false;
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list3 = CollectionsKt.listOf((Object)"*");
        }
        if ((n & 8) != 0) {
            bl = false;
            list4 = CollectionsKt.emptyList();
        }
        this(list, list2, list3, list4, list5);
    }

    @NotNull
    public final List<Location> component1() {
        return this.sourcePath;
    }

    @NotNull
    public final List<Location> component2() {
        return this.protoPath;
    }

    @NotNull
    public final List<String> component3() {
        return this.treeShakingRoots;
    }

    @NotNull
    public final List<String> component4() {
        return this.treeShakingRubbish;
    }

    @NotNull
    public final List<Target> component5() {
        return this.targets;
    }

    @NotNull
    public final WireRun copy(@NotNull List<Location> sourcePath, @NotNull List<Location> protoPath, @NotNull List<String> treeShakingRoots, @NotNull List<String> treeShakingRubbish, @NotNull List<? extends Target> targets) {
        Intrinsics.checkParameterIsNotNull(sourcePath, (String)"sourcePath");
        Intrinsics.checkParameterIsNotNull(protoPath, (String)"protoPath");
        Intrinsics.checkParameterIsNotNull(treeShakingRoots, (String)"treeShakingRoots");
        Intrinsics.checkParameterIsNotNull(treeShakingRubbish, (String)"treeShakingRubbish");
        Intrinsics.checkParameterIsNotNull(targets, (String)"targets");
        return new WireRun(sourcePath, protoPath, treeShakingRoots, treeShakingRubbish, targets);
    }

    public static /* synthetic */ WireRun copy$default(WireRun wireRun, List list, List list2, List list3, List list4, List list5, int n, Object object) {
        if ((n & 1) != 0) {
            list = wireRun.sourcePath;
        }
        if ((n & 2) != 0) {
            list2 = wireRun.protoPath;
        }
        if ((n & 4) != 0) {
            list3 = wireRun.treeShakingRoots;
        }
        if ((n & 8) != 0) {
            list4 = wireRun.treeShakingRubbish;
        }
        if ((n & 0x10) != 0) {
            list5 = wireRun.targets;
        }
        return wireRun.copy(list, list2, list3, list4, list5);
    }

    @NotNull
    public String toString() {
        return "WireRun(sourcePath=" + this.sourcePath + ", protoPath=" + this.protoPath + ", treeShakingRoots=" + this.treeShakingRoots + ", treeShakingRubbish=" + this.treeShakingRubbish + ", targets=" + this.targets + ")";
    }

    public int hashCode() {
        List<Location> list = this.sourcePath;
        List<Location> list2 = this.protoPath;
        List<String> list3 = this.treeShakingRoots;
        List<String> list4 = this.treeShakingRubbish;
        List<Target> list5 = this.targets;
        return ((((list != null ? ((Object)list).hashCode() : 0) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (list3 != null ? ((Object)list3).hashCode() : 0)) * 31 + (list4 != null ? ((Object)list4).hashCode() : 0)) * 31 + (list5 != null ? ((Object)list5).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof WireRun)) break block3;
                WireRun wireRun = (WireRun)object;
                if (!Intrinsics.areEqual(this.sourcePath, wireRun.sourcePath) || !Intrinsics.areEqual(this.protoPath, wireRun.protoPath) || !Intrinsics.areEqual(this.treeShakingRoots, wireRun.treeShakingRoots) || !Intrinsics.areEqual(this.treeShakingRubbish, wireRun.treeShakingRubbish) || !Intrinsics.areEqual(this.targets, wireRun.targets)) break block3;
            }
            return true;
        }
        return false;
    }
}

