/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import com.squareup.wire.ConsoleWireLogger;
import com.squareup.wire.WireException;
import com.squareup.wire.WireLogger;
import com.squareup.wire.java.JavaGenerator;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.IdentifierSet;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.SchemaLoader;
import com.squareup.wire.schema.Type;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;

public final class WireCompiler {
    public static final String PROTO_PATH_FLAG = "--proto_path=";
    public static final String JAVA_OUT_FLAG = "--java_out=";
    public static final String FILES_FLAG = "--files=";
    public static final String ROOTS_FLAG = "--roots=";
    public static final String INCLUDES_FLAG = "--includes=";
    public static final String EXCLUDES_FLAG = "--excludes=";
    public static final String NO_OPTIONS_FLAG = "--no_options";
    public static final String QUIET_FLAG = "--quiet";
    public static final String DRY_RUN_FLAG = "--dry_run";
    public static final String ANDROID = "--android";
    public static final String COMPACT = "--compact";
    private static final String CODE_GENERATED_BY_WIRE = "Code generated by Wire protocol buffer compiler, do not edit.";
    private final FileSystem fs;
    private final WireLogger log;
    final List<String> protoPaths;
    final String javaOut;
    final List<String> sourceFileNames;
    final IdentifierSet identifierSet;
    final boolean emitOptions;
    final boolean dryRun;
    final boolean emitAndroid;
    final boolean emitCompact;

    WireCompiler(FileSystem fs, WireLogger log, List<String> protoPaths, String javaOut, List<String> sourceFileNames, IdentifierSet identifierSet, boolean emitOptions, boolean dryRun, boolean emitAndroid, boolean emitCompact) {
        this.fs = fs;
        this.log = log;
        this.protoPaths = protoPaths;
        this.javaOut = javaOut;
        this.sourceFileNames = sourceFileNames;
        this.identifierSet = identifierSet;
        this.emitOptions = emitOptions;
        this.dryRun = dryRun;
        this.emitAndroid = emitAndroid;
        this.emitCompact = emitCompact;
    }

    public static void main(String ... args) throws IOException {
        try {
            WireCompiler wireCompiler = WireCompiler.forArgs(args);
            wireCompiler.compile();
        }
        catch (WireException e) {
            System.err.print("Fatal: ");
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    static WireCompiler forArgs(String ... args) throws WireException {
        return WireCompiler.forArgs(FileSystems.getDefault(), new ConsoleWireLogger(), args);
    }

    static WireCompiler forArgs(FileSystem fileSystem, WireLogger logger, String ... args) throws WireException {
        ArrayList<String> sourceFileNames = new ArrayList<String>();
        IdentifierSet.Builder identifierSetBuilder = new IdentifierSet.Builder();
        boolean emitOptions = true;
        ArrayList<String> protoPaths = new ArrayList<String>();
        String javaOut = null;
        boolean quiet = false;
        boolean dryRun = false;
        boolean emitAndroid = false;
        boolean emitCompact = false;
        for (String arg : args) {
            if (arg.startsWith(PROTO_PATH_FLAG)) {
                protoPaths.add(arg.substring(PROTO_PATH_FLAG.length()));
                continue;
            }
            if (arg.startsWith(JAVA_OUT_FLAG)) {
                javaOut = arg.substring(JAVA_OUT_FLAG.length());
                continue;
            }
            if (arg.startsWith(FILES_FLAG)) {
                String[] fileNames;
                File files = new File(arg.substring(FILES_FLAG.length()));
                try {
                    fileNames = new Scanner(files, "UTF-8").useDelimiter("\\A").next().split("\n");
                }
                catch (FileNotFoundException ex) {
                    throw new WireException("Error processing argument " + arg, ex);
                }
                sourceFileNames.addAll(Arrays.asList(fileNames));
                continue;
            }
            if (arg.startsWith(INCLUDES_FLAG) || arg.startsWith(ROOTS_FLAG)) {
                String prefix = arg.startsWith(INCLUDES_FLAG) ? INCLUDES_FLAG : ROOTS_FLAG;
                for (String identifier : WireCompiler.splitArg(arg, prefix.length())) {
                    identifierSetBuilder.include(identifier);
                }
                continue;
            }
            if (arg.startsWith(EXCLUDES_FLAG)) {
                for (String identifier : WireCompiler.splitArg(arg, EXCLUDES_FLAG.length())) {
                    identifierSetBuilder.exclude(identifier);
                }
                continue;
            }
            if (arg.equals(NO_OPTIONS_FLAG)) {
                emitOptions = false;
                continue;
            }
            if (arg.equals(QUIET_FLAG)) {
                quiet = true;
                continue;
            }
            if (arg.equals(DRY_RUN_FLAG)) {
                dryRun = true;
                continue;
            }
            if (arg.equals(ANDROID)) {
                emitAndroid = true;
                continue;
            }
            if (arg.equals(COMPACT)) {
                emitCompact = true;
                continue;
            }
            if (arg.startsWith("--")) {
                throw new IllegalArgumentException("Unknown argument '" + arg + "'.");
            }
            sourceFileNames.add(arg);
        }
        if (javaOut == null) {
            throw new WireException("Must specify --java_out= flag");
        }
        logger.setQuiet(quiet);
        return new WireCompiler(fileSystem, logger, protoPaths, javaOut, sourceFileNames, identifierSetBuilder.build(), emitOptions, dryRun, emitAndroid, emitCompact);
    }

    private static List<String> splitArg(String arg, int flagLength) {
        return Arrays.asList(arg.substring(flagLength).split(","));
    }

    void compile() throws IOException {
        SchemaLoader schemaLoader = new SchemaLoader();
        for (String string : this.protoPaths) {
            schemaLoader.addSource(this.fs.getPath(string, new String[0]));
        }
        for (String string : this.sourceFileNames) {
            schemaLoader.addProto(string);
        }
        Schema schema = schemaLoader.load();
        if (!this.identifierSet.isEmpty()) {
            this.log.info("Analyzing dependencies of root types.");
            schema = schema.prune(this.identifierSet);
            for (String rule : this.identifierSet.unusedIncludes()) {
                this.log.info("Unused include: " + rule);
            }
            for (String rule : this.identifierSet.unusedExcludes()) {
                this.log.info("Unused exclude: " + rule);
            }
        }
        JavaGenerator javaGenerator = JavaGenerator.get((Schema)schema).withOptions(this.emitOptions).withAndroid(this.emitAndroid).withCompact(this.emitCompact);
        for (ProtoFile protoFile : schema.protoFiles()) {
            if (!this.sourceFileNames.isEmpty() && !this.sourceFileNames.contains(protoFile.location().path())) continue;
            for (Type type : protoFile.types()) {
                ClassName javaTypeName = (ClassName)javaGenerator.typeName(type.name());
                TypeSpec typeSpec = type instanceof MessageType ? javaGenerator.generateMessage((MessageType)type) : javaGenerator.generateEnum((EnumType)type);
                this.writeJavaFile(javaTypeName, typeSpec, type.location());
            }
        }
    }

    private void writeJavaFile(ClassName javaTypeName, TypeSpec typeSpec, Location location) throws IOException {
        JavaFile.Builder builder = JavaFile.builder((String)javaTypeName.packageName(), (TypeSpec)typeSpec).addFileComment("$L", new Object[]{CODE_GENERATED_BY_WIRE});
        if (location != null) {
            builder.addFileComment("\nSource file: $L", new Object[]{location.withoutBase()});
        }
        JavaFile javaFile = builder.build();
        Path path = this.fs.getPath(this.javaOut, new String[0]);
        this.log.artifact(path, javaFile);
        try {
            if (!this.dryRun) {
                javaFile.writeTo(path);
            }
        }
        catch (IOException e) {
            throw new IOException("Error emitting " + javaFile.packageName + "." + javaFile.typeSpec.name + " to " + this.javaOut, e);
        }
    }
}

