/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.javawriter.JavaWriter;
import com.squareup.protoparser.DataType;
import com.squareup.protoparser.EnumConstantElement;
import com.squareup.protoparser.EnumElement;
import com.squareup.protoparser.ExtendElement;
import com.squareup.protoparser.FieldElement;
import com.squareup.protoparser.MessageElement;
import com.squareup.protoparser.OneOfElement;
import com.squareup.protoparser.OptionElement;
import com.squareup.protoparser.ProtoFile;
import com.squareup.protoparser.RpcElement;
import com.squareup.protoparser.ServiceElement;
import com.squareup.protoparser.TypeElement;
import com.squareup.wire.CommandLineOptions;
import com.squareup.wire.ConsoleWireLogger;
import com.squareup.wire.ExtensionInfo;
import com.squareup.wire.FieldInfo;
import com.squareup.wire.IO;
import com.squareup.wire.Message;
import com.squareup.wire.MessageWriter;
import com.squareup.wire.OptionsMapMaker;
import com.squareup.wire.OutputArtifact;
import com.squareup.wire.ServiceWriter;
import com.squareup.wire.TypeInfo;
import com.squareup.wire.WireCompilerException;
import com.squareup.wire.WireException;
import com.squareup.wire.WireLogger;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Modifier;
import okio.ByteString;

public class WireCompiler {
    static final String LINE_WRAP_INDENT = "    ";
    static final Set<String> DEFAULT_FIELD_OPTION_KEYS = new LinkedHashSet<String>(Arrays.asList("default", "deprecated", "packed"));
    private static final Charset ISO_8859_1 = Charset.forName("ISO_8859_1");
    private static final String CODE_GENERATED_BY_WIRE = "Code generated by Wire protocol buffer compiler, do not edit.";
    private final String repoPath;
    private final IO io;
    private final Set<String> typesToEmit = new LinkedHashSet<String>();
    private final Map<String, String> javaSymbolMap = new LinkedHashMap<String, String>();
    private final Set<String> javaSymbols = new LinkedHashSet<String>();
    private final Set<String> enumTypes = new LinkedHashSet<String>();
    private final Map<String, String> enumDefaults = new LinkedHashMap<String, String>();
    private final Map<String, ExtensionInfo> extensionInfo = new LinkedHashMap<String, ExtensionInfo>();
    private final Map<String, FieldInfo> fieldMap = new LinkedHashMap<String, FieldInfo>();
    private final List<String> extensionClasses = new ArrayList<String>();
    private final OptionsMapMaker optionsMapMaker = new OptionsMapMaker(this);
    private final CommandLineOptions options;
    private final WireLogger log;
    private ProtoFile protoFile;
    private String sourceFileName;
    private String protoFileName;
    private String typeBeingGenerated = "";
    private Constructor<?> serviceWriterConstructor;

    public static void main(String ... args) {
        try {
            new WireCompiler(new CommandLineOptions(args)).compile();
        }
        catch (WireException e) {
            System.err.print("Fatal: ");
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private static Constructor<?> loadServiceWriter(String serviceWriterClassName) throws WireException {
        Class<?> serviceWriterClass;
        try {
            serviceWriterClass = Class.forName(serviceWriterClassName);
        }
        catch (ClassNotFoundException e) {
            throw new WireException("Unable to load ServiceWriter class " + serviceWriterClassName + ".", e);
        }
        if (!ServiceWriter.class.isAssignableFrom(serviceWriterClass)) {
            throw new WireException("Class " + serviceWriterClassName + " does not implement ServiceWriter interface.");
        }
        try {
            return serviceWriterClass.getConstructor(JavaWriter.class, List.class);
        }
        catch (NoSuchMethodException e) {
            throw new WireException("ServiceWriter class " + serviceWriterClassName + " needs a constructor 'public " + serviceWriterClassName + "(JavaWriter writer, List<String> options)'.", e);
        }
    }

    @Deprecated
    public WireCompiler(String protoPath, List<String> sourceFileNames, List<String> roots, String outputDirectory, String registryClass, boolean emitOptions, List<String> enumOptions, Constructor<?> serviceWriterConstructor, List<String> serviceWriterOptions) throws WireException {
        this(new CommandLineOptions(protoPath, outputDirectory, sourceFileNames, roots, registryClass, emitOptions, new LinkedHashSet<String>(enumOptions), serviceWriterConstructor == null ? null : serviceWriterConstructor.getName(), serviceWriterOptions, false, false));
    }

    WireCompiler(CommandLineOptions options) throws WireException {
        this(options, new IO.FileIO(), new ConsoleWireLogger(options.quiet));
    }

    WireCompiler(CommandLineOptions options, IO io, WireLogger logger) throws WireException {
        this.options = options;
        this.io = io;
        this.log = logger;
        String protoPath = options.protoPath;
        if (options.javaOut == null) {
            throw new WireException("Must specify --java_out= flag");
        }
        if (options.protoPath == null) {
            protoPath = System.getProperty("user.dir");
            System.err.println("--proto_path= flag not specified, using current dir " + protoPath);
        }
        if (options.serviceWriter != null) {
            this.serviceWriterConstructor = WireCompiler.loadServiceWriter(options.serviceWriter);
        }
        this.repoPath = protoPath;
        this.typesToEmit.addAll(options.roots);
    }

    public void compile() throws WireException {
        LinkedHashMap<String, ProtoFile> parsedFiles = new LinkedHashMap<String, ProtoFile>();
        for (String string : this.options.sourceFileNames) {
            String sourcePath = this.repoPath + File.separator + string;
            try {
                ProtoFile protoFile = this.io.parse(sourcePath);
                parsedFiles.put(sourcePath, protoFile);
                this.loadSymbols(protoFile);
            }
            catch (IOException e) {
                throw new WireException("Error loading symbols for " + sourcePath, e);
            }
        }
        if (!this.typesToEmit.isEmpty()) {
            this.log.info("Analyzing dependencies of root types.");
            this.findDependencies(parsedFiles.values());
        }
        for (Map.Entry entry : parsedFiles.entrySet()) {
            this.sourceFileName = (String)entry.getKey();
            this.protoFile = (ProtoFile)entry.getValue();
            this.protoFileName = this.protoFileName(this.protoFile.filePath());
            this.log.info("Compiling proto source file " + this.sourceFileName);
            try {
                this.compileOne();
            }
            catch (IOException e) {
                throw new WireException("Error compiling " + (String)entry.getKey(), e);
            }
        }
        if (this.options.registryClass != null) {
            int packageClassSep = this.options.registryClass.lastIndexOf(".");
            String string = this.options.registryClass.substring(0, packageClassSep);
            String className = this.options.registryClass.substring(packageClassSep + 1);
            OutputArtifact artifact = new OutputArtifact(this.options.javaOut, string, className);
            this.log.artifact(artifact);
            if (!this.options.dryRun) {
                try {
                    this.emitRegistry(artifact);
                }
                catch (IOException e) {
                    throw new WireException("Error emitting registry class " + this.options.registryClass, e);
                }
            }
        }
    }

    boolean shouldEmitOptions() {
        return this.options.emitOptions;
    }

    Set<String> enumOptions() {
        return this.options.enumOptions;
    }

    ProtoFile getProtoFile() {
        return this.protoFile;
    }

    OptionsMapMaker getOptionsMapMaker() {
        return this.optionsMapMaker;
    }

    String getEnumDefault(String fullyQualifiedName) {
        return this.enumDefaults.get(fullyQualifiedName);
    }

    FieldInfo getField(String dollarName) {
        return this.fieldMap.get(dollarName);
    }

    String javaName(ProtoFile protoFile, MessageElement messageType, String type) {
        String scalarType = TypeInfo.scalarType(type);
        return scalarType != null ? scalarType : this.shortenJavaName(protoFile, this.javaName(this.fullyQualifiedName(protoFile, (TypeElement)messageType, type)));
    }

    boolean fullyQualifiedNameIsOutsidePackage(String fqName) {
        return fqName != null && !this.getJavaPackage().equals(this.getPackageFromFullyQualifiedJavaName(fqName));
    }

    String prefixWithPackageName(String name) {
        return this.prefixWithPackageName(this.protoFile, name);
    }

    boolean hasFields(TypeElement type) {
        return type instanceof MessageElement && !WireCompiler.allFields((MessageElement)type).isEmpty();
    }

    boolean hasExtensions(MessageElement messageType) {
        return !messageType.extensions().isEmpty();
    }

    String getTrailingSegment(String name) {
        int index = name.lastIndexOf(46);
        return index == -1 ? name : name.substring(index + 1);
    }

    ExtensionInfo getExtension(String name) {
        return this.extensionInfo.get(name);
    }

    String getInitializerForType(Object initialValue, String javaTypeName) {
        if ("Boolean".equals(javaTypeName)) {
            return initialValue == null ? "false" : String.valueOf(initialValue);
        }
        if ("Integer".equals(javaTypeName)) {
            return initialValue == null ? "0" : this.toInt(String.valueOf(initialValue));
        }
        if ("Long".equals(javaTypeName)) {
            return initialValue == null ? "0L" : this.toLong(String.valueOf(initialValue));
        }
        if ("Float".equals(javaTypeName)) {
            return initialValue == null ? "0F" : String.valueOf(initialValue) + "F";
        }
        if ("Double".equals(javaTypeName)) {
            return initialValue == null ? "0D" : String.valueOf(initialValue) + "D";
        }
        if ("String".equals(javaTypeName)) {
            return this.quoteString((String)initialValue);
        }
        if ("ByteString".equals(javaTypeName)) {
            if (initialValue == null) {
                return "ByteString.EMPTY";
            }
            return "ByteString.decodeBase64(\"" + ByteString.of((byte[])String.valueOf(initialValue).getBytes(ISO_8859_1)).base64() + "\")";
        }
        throw new WireCompilerException(javaTypeName + " is not an allowed scalar type");
    }

    boolean isEnum(String type) {
        return this.enumTypes.contains(type);
    }

    String javaName(MessageElement messageType, String type) {
        String scalarType = TypeInfo.scalarType(type);
        return scalarType != null ? scalarType : this.shortenJavaName(this.javaName(this.fullyQualifiedName((TypeElement)messageType, type)));
    }

    String javaName(String fqName) {
        return this.javaSymbolMap.get(fqName);
    }

    String fullyQualifiedName(TypeElement scope, String type) {
        String fqName = scope == null ? null : scope.qualifiedName();
        return this.fullyQualifiedName(this.protoFile, fqName, type);
    }

    String fullyQualifiedName(String fqName, String type) {
        return this.fullyQualifiedName(this.protoFile, fqName, type);
    }

    String shortenJavaName(String fullyQualifiedName) {
        return this.shortenJavaName(this.protoFile, fullyQualifiedName);
    }

    boolean isRedacted(OptionElement option) {
        return option.name().endsWith(".redacted") && "true".equals(String.valueOf(option.value()));
    }

    private void compileOne() throws IOException {
        this.typeBeingGenerated = "";
        if (this.hasExtends()) {
            OutputArtifact artifact = new OutputArtifact(this.options.javaOut, this.getJavaPackage(), "Ext_" + this.protoFileName);
            this.log.artifact(artifact);
            if (!this.options.dryRun) {
                this.emitExtensionClass(artifact);
                this.extensionClasses.add(artifact.fullClassName());
            }
        }
        for (TypeElement type : this.protoFile.typeElements()) {
            if (!this.shouldEmitType(type.qualifiedName())) continue;
            String savedType = this.typeBeingGenerated;
            this.typeBeingGenerated = this.typeBeingGenerated + type.name() + ".";
            OutputArtifact artifact = new OutputArtifact(this.options.javaOut, this.getJavaPackage(), type.name());
            this.log.artifact(artifact);
            if (!this.options.dryRun) {
                this.emitMessageClass(type, artifact);
            }
            this.typeBeingGenerated = savedType;
        }
        for (ServiceElement service : this.protoFile.services()) {
            if (!this.shouldEmitService(service.qualifiedName())) continue;
            ServiceElement.Builder serviceBuilder = ServiceElement.builder().name(service.name()).qualifiedName(service.qualifiedName()).documentation(service.documentation()).addOptions((Collection)service.options());
            for (RpcElement method : service.rpcs()) {
                if (!this.shouldEmitServiceMethod(service.qualifiedName(), method.name())) continue;
                serviceBuilder.addRpc(method);
            }
            ServiceElement limitedService = serviceBuilder.build();
            OutputArtifact artifact = new OutputArtifact(this.options.javaOut, this.getJavaPackage(), service.name());
            this.log.artifact(artifact);
            if (this.options.dryRun) continue;
            this.emitServiceInterface(limitedService, artifact);
        }
    }

    private boolean hasFieldOption(List<TypeElement> types) {
        for (TypeElement type : types) {
            if (!(type instanceof MessageElement)) continue;
            for (FieldElement field : WireCompiler.allFields((MessageElement)type)) {
                for (OptionElement option : field.options()) {
                    if (DEFAULT_FIELD_OPTION_KEYS.contains(option.name())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasMessageOption(List<TypeElement> types) {
        for (TypeElement type : types) {
            if (!(type instanceof MessageElement) || type.options().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean hasEnumOption(List<TypeElement> types) {
        for (TypeElement type : types) {
            if (!(type instanceof EnumElement) || type.options().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void getTypes(TypeElement parent, List<TypeElement> types) {
        types.add(parent);
        for (TypeElement nestedType : parent.nestedElements()) {
            this.getTypes(nestedType, types);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitRegistry(OutputArtifact artifact) throws IOException {
        JavaWriter writer = null;
        try {
            String classes;
            writer = this.io.getJavaWriter(artifact);
            writer.emitSingleLineComment(CODE_GENERATED_BY_WIRE, new Object[0]);
            writer.emitPackage(artifact.javaPackage());
            writer.emitImports(new String[]{"java.util.List"});
            writer.emitEmptyLine();
            int extensionsCount = this.extensionClasses.size();
            if (extensionsCount == 0) {
                writer.emitStaticImports(new String[]{"java.util.Collections.emptyList"});
            } else {
                writer.emitStaticImports(new String[]{"java.util.Arrays.asList", "java.util.Collections.unmodifiableList"});
            }
            writer.emitEmptyLine();
            writer.beginType(artifact.className(), "class", EnumSet.of(Modifier.PUBLIC, Modifier.FINAL));
            writer.emitEmptyLine();
            if (extensionsCount == 0) {
                classes = "emptyList()";
            } else {
                StringBuilder sb = new StringBuilder("unmodifiableList(asList(\n");
                for (int i = 0; i < extensionsCount; ++i) {
                    sb.append(writer.compressType(this.extensionClasses.get(i)));
                    sb.append(".class");
                    if (i >= extensionsCount - 1) continue;
                    sb.append(",\n");
                }
                sb.append("))");
                classes = sb.toString();
            }
            writer.emitAnnotation("SuppressWarnings(\"unchecked\")");
            String wildcard = extensionsCount == 1 ? this.extensionClasses.get(0) : "?";
            String listType = "List<Class<" + wildcard + ">>";
            writer.emitField(listType, "EXTENSIONS", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL), classes);
            writer.emitEmptyLine();
            writer.beginMethod(null, artifact.className(), EnumSet.of(Modifier.PRIVATE), new String[0]);
            writer.endMethod();
            writer.endType();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private boolean shouldEmitType(String name) {
        return this.typesToEmit.isEmpty() || this.typesToEmit.contains(name);
    }

    private boolean shouldEmitService(String serviceName) {
        if (this.typesToEmit.isEmpty()) {
            return true;
        }
        for (String type : this.typesToEmit) {
            if (!type.equals(serviceName) && !type.startsWith(serviceName + "#")) continue;
            return true;
        }
        return false;
    }

    private boolean shouldEmitServiceMethod(String serviceName, String method) {
        if (method == null) {
            throw new IllegalArgumentException("No method specified");
        }
        return this.typesToEmit.isEmpty() || this.typesToEmit.contains(serviceName) || this.typesToEmit.contains(serviceName + "#" + method);
    }

    private void findDependencies(Collection<ProtoFile> protoFiles) throws WireException {
        LinkedHashSet<String> loadedDependencies = new LinkedHashSet<String>();
        int count = this.typesToEmit.size();
        while (true) {
            for (ProtoFile protoFile : protoFiles) {
                this.findDependenciesHelper(protoFile, loadedDependencies);
            }
            int newCount = this.typesToEmit.size();
            if (newCount == count) break;
            count = newCount;
        }
    }

    private void findDependenciesHelper(ProtoFile protoFile, Set<String> loadedDependencies) throws WireException {
        for (String dependency : protoFile.dependencies()) {
            if (loadedDependencies.contains(dependency)) continue;
            String dep = this.repoPath + File.separator + dependency;
            try {
                ProtoFile dependencyFile = this.io.parse(dep);
                this.loadSymbols(dependencyFile);
            }
            catch (IOException e) {
                throw new WireException("Error loading symbols for " + dep, e);
            }
            loadedDependencies.add(dependency);
        }
        for (ExtendElement extend : protoFile.extendDeclarations()) {
            String typeName = extend.qualifiedName();
            this.typesToEmit.add(typeName);
            for (FieldElement field : extend.fields()) {
                String fieldTypeName = this.typeIsComplete(field.type().toString()) ? field.type().toString() : this.prefixWithPackageName(protoFile, field.type().toString());
                this.typesToEmit.add(fieldTypeName);
            }
        }
        this.addDependencies(protoFile.typeElements(), this.getJavaPackage(protoFile) + ".");
        this.addDependencies(protoFile.services());
    }

    private void addDependencies(List<ServiceElement> services) {
        for (ServiceElement service : services) {
            String fqName = service.qualifiedName();
            if (!this.shouldEmitService(fqName)) continue;
            for (RpcElement rpc : service.rpcs()) {
                if (!this.shouldEmitServiceMethod(fqName, rpc.name())) continue;
                this.addDependencyBranch(this.fullyQualifiedName(fqName, rpc.requestType().toString()));
                this.addDependencyBranch(this.fullyQualifiedName(fqName, rpc.responseType().toString()));
            }
        }
    }

    private void addDependencies(List<TypeElement> types, String javaPrefix) {
        for (TypeElement type : types) {
            String name = type.name();
            String fqName = type.qualifiedName();
            if (type instanceof MessageElement && this.typesToEmit.contains(fqName)) {
                for (FieldElement field : WireCompiler.allFields((MessageElement)type)) {
                    String fieldType = field.type().toString();
                    if (TypeInfo.isScalar(fieldType)) continue;
                    String fqFieldType = this.fullyQualifiedName(fqName, field.type().toString());
                    this.addDependencyBranch(fqFieldType);
                }
            }
            this.addDependencies(type.nestedElements(), javaPrefix + name + ".");
        }
    }

    private void addDependencyBranch(String name) {
        while (this.typeIsComplete(name)) {
            this.typesToEmit.add(name);
            name = this.removeTrailingSegment(name);
        }
    }

    private String removeTrailingSegment(String name) {
        int index = name.lastIndexOf(46);
        return index == -1 ? "" : name.substring(0, index);
    }

    public String getTypeBeingGenerated() {
        return this.typeBeingGenerated.substring(0, this.typeBeingGenerated.length() - 1);
    }

    private void loadSymbols(ProtoFile protoFile) throws IOException {
        this.loadSymbolsHelper(protoFile, new LinkedHashSet<String>(), LoadSymbolsPass.LOAD_TYPES);
        this.loadSymbolsHelper(protoFile, new LinkedHashSet<String>(), LoadSymbolsPass.LOAD_FIELDS);
    }

    private void loadSymbolsHelper(ProtoFile protoFile, Set<String> loadedDependencies, LoadSymbolsPass pass) throws IOException {
        for (String dependency : protoFile.dependencies()) {
            if (loadedDependencies.contains(dependency)) continue;
            String dep = this.repoPath + File.separator + dependency;
            ProtoFile dependencyFile = this.io.parse(dep);
            this.loadSymbolsHelper(dependencyFile, loadedDependencies, pass);
            loadedDependencies.add(dependency);
        }
        this.addTypes(protoFile.typeElements(), this.getJavaPackage(protoFile) + ".", pass);
        this.addExtensions(protoFile);
    }

    private void addExtensions(ProtoFile protoFile) {
        for (ExtendElement extend : protoFile.extendDeclarations()) {
            for (FieldElement field : extend.fields()) {
                boolean isEnum;
                String fieldType = field.type().toString();
                String type = this.javaName(protoFile, null, fieldType);
                if (type == null) {
                    type = this.javaName(protoFile, null, this.prefixWithPackageName(protoFile, fieldType));
                }
                type = this.shortenJavaName(protoFile, type);
                String fqName = this.prefixWithPackageName(protoFile, field.name());
                boolean isScalar = TypeInfo.isScalar(fieldType);
                boolean bl = isEnum = !isScalar && this.isEnum(this.fullyQualifiedName(protoFile, (String)null, fieldType));
                String fqType = isScalar ? (type = field.type().toString()) : (isEnum ? (type = this.fullyQualifiedName(protoFile, (String)null, fieldType)) : this.fullyQualifiedName(protoFile, (String)null, fieldType));
                String location = this.protoFileName(protoFile.filePath());
                String fqLocation = this.getJavaPackage(protoFile) + ".Ext_" + location;
                ExtensionInfo info = new ExtensionInfo(type, fqType, location, fqLocation, field.label());
                this.extensionInfo.put(fqName, info);
            }
        }
    }

    String getJavaPackage(ProtoFile protoFile) {
        OptionElement javaPackage = OptionElement.findByName((List)protoFile.options(), (String)"java_package");
        if (javaPackage != null) {
            return (String)javaPackage.value();
        }
        return protoFile.packageName() == null ? "" : protoFile.packageName();
    }

    String getJavaPackage() {
        return this.getJavaPackage(this.protoFile);
    }

    private void addTypes(List<TypeElement> types, String javaPrefix, LoadSymbolsPass pass) {
        for (TypeElement type : types) {
            String name = type.name();
            if (pass == LoadSymbolsPass.LOAD_TYPES) {
                String fqName = type.qualifiedName();
                this.javaSymbolMap.put(fqName, javaPrefix + name);
                if (type instanceof EnumElement) {
                    EnumElement enumType = (EnumElement)type;
                    if (!this.enumTypes.contains(fqName)) {
                        this.enumTypes.add(fqName);
                        this.enumDefaults.put(fqName, ((EnumConstantElement)enumType.constants().get(0)).name());
                    }
                }
            } else if (type instanceof MessageElement) {
                this.addFields((MessageElement)type);
            }
            this.addTypes(type.nestedElements(), javaPrefix + name + ".", pass);
        }
    }

    private void addFields(MessageElement messageType) {
        for (FieldElement field : WireCompiler.allFields(messageType)) {
            String fieldType = field.type().toString();
            String fqMessageName = messageType.qualifiedName();
            String key = fqMessageName + "$" + field.name();
            this.fieldMap.put(key, new FieldInfo(TypeInfo.isScalar(fieldType) ? fieldType : this.fullyQualifiedName(fqMessageName, fieldType), field.label()));
        }
    }

    private String fullyQualifiedName(ProtoFile protoFile, TypeElement scope, String type) {
        String fqName = scope == null ? null : scope.qualifiedName();
        return this.fullyQualifiedName(protoFile, fqName, type);
    }

    private String fullyQualifiedName(ProtoFile protoFile, String fqName, String type) {
        String prefix;
        if (this.typeIsComplete(type)) {
            return type;
        }
        String string = prefix = fqName == null ? protoFile.packageName() : fqName;
        while (!prefix.isEmpty()) {
            String fqname = prefix + "." + type;
            if (this.typeIsComplete(fqname)) {
                return fqname;
            }
            prefix = this.removeTrailingSegment(prefix);
        }
        throw new WireCompilerException("Unknown type " + type + " in type " + (fqName == null ? "<unknown>" : fqName));
    }

    private String shortenJavaName(ProtoFile protoFile, String fullyQualifiedName) {
        if (fullyQualifiedName == null) {
            return null;
        }
        String javaTypeBeingGenerated = this.getJavaPackage(protoFile) + "." + this.typeBeingGenerated;
        if (fullyQualifiedName.startsWith(javaTypeBeingGenerated)) {
            return fullyQualifiedName.substring(javaTypeBeingGenerated.length());
        }
        for (String javaSymbol : this.javaSymbolMap.values()) {
            if (!fullyQualifiedName.startsWith(javaSymbol)) continue;
            String pkgPrefix = this.getPackageFromFullyQualifiedJavaName(fullyQualifiedName) + '.';
            return fullyQualifiedName.substring(pkgPrefix.length());
        }
        return fullyQualifiedName;
    }

    private String protoFileName(String path) {
        int slashIndex = path.lastIndexOf(47);
        if (slashIndex != -1) {
            path = path.substring(slashIndex + 1);
        }
        if (path.endsWith(".proto")) {
            path = path.substring(0, path.length() - ".proto".length());
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitMessageClass(TypeElement type, OutputArtifact artifact) throws IOException {
        JavaWriter writer = null;
        try {
            writer = this.io.getJavaWriter(artifact);
            writer.emitSingleLineComment(CODE_GENERATED_BY_WIRE, new Object[0]);
            writer.emitSingleLineComment("Source file: %s", new Object[]{this.sourceFileName.replace("\\", "\\\\")});
            writer.emitPackage(this.getJavaPackage());
            ArrayList<TypeElement> types = new ArrayList<TypeElement>();
            this.getTypes(type, types);
            boolean hasMessage = this.hasMessage(types);
            boolean hasExtensions = this.hasExtensions(Collections.singletonList(type));
            LinkedHashSet<String> imports = new LinkedHashSet<String>();
            if (hasMessage) {
                imports.add("com.squareup.wire.Message");
            }
            if ((hasMessage || hasExtensions) && this.hasFields(type)) {
                imports.add("com.squareup.wire.ProtoField");
            }
            if (this.hasBytesField(types)) {
                imports.add("okio.ByteString");
            }
            if (this.hasEnum(types)) {
                imports.add("com.squareup.wire.ProtoEnum");
            }
            if (this.hasRepeatedField(types)) {
                imports.add("java.util.Collections");
                imports.add("java.util.List");
            }
            if (hasExtensions) {
                imports.add("com.squareup.wire.ExtendableMessage");
                imports.add("com.squareup.wire.Extension");
            }
            if (this.options.emitOptions) {
                if (this.hasFieldOption(types)) {
                    imports.add("com.google.protobuf.FieldOptions");
                }
                if (this.hasMessageOption(types)) {
                    imports.add("com.google.protobuf.MessageOptions");
                }
                if (this.hasEnumOption(types)) {
                    imports.add("com.google.protobuf.EnumOptions");
                }
            }
            ArrayList<String> externalTypes = new ArrayList<String>();
            this.getExternalTypes(type, externalTypes);
            Map<String, ?> optionsMap = null;
            if (this.options.emitOptions && type instanceof MessageElement) {
                optionsMap = this.optionsMapMaker.createMessageOptionsMap((MessageElement)type);
                this.optionsMapMaker.getOptionTypes(optionsMap, externalTypes);
                for (FieldElement field : WireCompiler.allFields((MessageElement)type)) {
                    Map<String, ?> fieldOptionsMap = this.optionsMapMaker.createFieldOptionsMap((MessageElement)type, field.options());
                    this.optionsMapMaker.getOptionTypes(fieldOptionsMap, externalTypes);
                }
            }
            imports.addAll(externalTypes);
            TreeSet<Message.Datatype> datatypes = new TreeSet<Message.Datatype>(Message.Datatype.ORDER_BY_NAME);
            TreeSet<Message.Label> labels = new TreeSet<Message.Label>(Message.Label.ORDER_BY_NAME);
            this.getDatatypesAndLabels(type, datatypes, labels);
            labels.remove(Message.Label.OPTIONAL);
            MessageWriter messageWriter = new MessageWriter(this);
            messageWriter.emitHeader(writer, imports, datatypes, labels);
            messageWriter.emitType(writer, type, this.protoFile.packageName() + ".", optionsMap, true);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitServiceInterface(ServiceElement service, OutputArtifact artifact) throws IOException {
        if (this.serviceWriterConstructor == null) {
            return;
        }
        JavaWriter writer = null;
        try {
            ServiceWriter serviceWriter;
            writer = this.io.getJavaWriter(artifact);
            try {
                serviceWriter = (ServiceWriter)this.serviceWriterConstructor.newInstance(writer, new ArrayList<String>(this.options.serviceWriterOptions));
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to construct an instance of " + this.serviceWriterConstructor.getDeclaringClass().getName() + ": " + e);
            }
            writer.emitSingleLineComment(CODE_GENERATED_BY_WIRE, new Object[0]);
            writer.emitSingleLineComment("Source file: %s", new Object[]{this.sourceFileName});
            writer.emitPackage(artifact.javaPackage());
            LinkedHashSet<String> imports = new LinkedHashSet<String>();
            ArrayList<String> externalTypes = new ArrayList<String>();
            this.getExternalTypes(service, externalTypes);
            imports.addAll(externalTypes);
            serviceWriter.emitService(service, imports);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void getExternalTypes(TypeElement parent, List<String> types) {
        if (parent instanceof MessageElement) {
            MessageElement messageType = (MessageElement)parent;
            for (FieldElement field : WireCompiler.allFields(messageType)) {
                String parentType;
                String fqName = this.fullyQualifiedJavaName(messageType, field.type().toString());
                if (fqName == null) continue;
                if (this.fullyQualifiedNameIsOutsidePackage(fqName)) {
                    fqName = this.getTopLevelMessageName(fqName);
                    types.add(fqName);
                }
                if (!this.javaTypeIsComplete(parentType = this.removeTrailingSegment(fqName)) || !this.fullyQualifiedNameIsOutsidePackage(parentType)) continue;
                types.add(parentType);
            }
        }
        for (TypeElement nestedType : parent.nestedElements()) {
            this.getExternalTypes(nestedType, types);
        }
    }

    private String getTopLevelMessageName(String fqName) {
        String parentType = this.removeTrailingSegment(fqName);
        while (!parentType.isEmpty() && this.javaTypeIsComplete(parentType) && this.fullyQualifiedNameIsOutsidePackage(parentType)) {
            fqName = parentType;
            parentType = this.removeTrailingSegment(parentType);
        }
        return fqName;
    }

    private void getExternalTypes(ServiceElement service, List<String> types) {
        for (RpcElement rpc : service.rpcs()) {
            this.addType(service, rpc.requestType().toString(), types);
            this.addType(service, rpc.responseType().toString(), types);
        }
    }

    private void addType(ServiceElement service, String method, List<String> types) {
        String serviceFQName = service.qualifiedName();
        String servicePackage = serviceFQName.substring(0, serviceFQName.length() - service.name().length() - 1);
        String fqName = this.javaName(this.fullyQualifiedName(servicePackage, method));
        if (this.fullyQualifiedNameIsOutsidePackage(fqName)) {
            types.add(fqName);
        }
    }

    private String getPackageFromFullyQualifiedJavaName(String fqName) {
        while (this.javaSymbolMap.containsValue(fqName)) {
            fqName = this.removeTrailingSegment(fqName);
        }
        return fqName;
    }

    private List<String> getExtensionTypes() {
        ArrayList<String> extensionClasses = new ArrayList<String>();
        for (ExtendElement extend : this.protoFile.extendDeclarations()) {
            String fqName = this.fullyQualifiedJavaName(null, extend.qualifiedName());
            if (this.fullyQualifiedNameIsOutsidePackage(fqName)) {
                extensionClasses.add(fqName);
            }
            for (FieldElement field : extend.fields()) {
                String fqFieldType = this.fullyQualifiedJavaName(null, field.type().toString());
                if (!this.fullyQualifiedNameIsOutsidePackage(fqFieldType)) continue;
                extensionClasses.add(fqFieldType);
            }
        }
        return extensionClasses;
    }

    private boolean hasExtends() {
        List declarations = this.protoFile.extendDeclarations();
        if (!this.shouldEmitOptions()) {
            for (ExtendElement declaration : declarations) {
                String name = declaration.qualifiedName();
                if (WireCompiler.isFieldOptions(name) || WireCompiler.isMessageOptions(name)) continue;
                return true;
            }
        }
        return !declarations.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitExtensionClass(OutputArtifact artifact) throws IOException {
        JavaWriter writer = null;
        try {
            writer = this.io.getJavaWriter(artifact);
            writer.emitSingleLineComment(CODE_GENERATED_BY_WIRE, new Object[0]);
            writer.emitSingleLineComment("Source file: %s", new Object[]{this.sourceFileName});
            writer.emitPackage(this.getJavaPackage());
            LinkedHashSet<String> imports = new LinkedHashSet<String>();
            if (this.hasByteStringExtension()) {
                imports.add("okio.ByteString");
            }
            imports.add("com.squareup.wire.Extension");
            if (this.hasRepeatedExtension()) {
                imports.add("java.util.List");
            }
            List<String> extensionTypes = this.getExtensionTypes();
            if (this.shouldEmitOptions()) {
                imports.addAll(extensionTypes);
            } else {
                for (String extensionType : extensionTypes) {
                    if (WireCompiler.isOptionType(extensionType)) continue;
                    imports.add(extensionType);
                }
            }
            writer.emitImports(imports);
            writer.emitEmptyLine();
            String className = "Ext_" + this.protoFileName;
            writer.beginType(className, "class", EnumSet.of(Modifier.PUBLIC, Modifier.FINAL));
            writer.emitEmptyLine();
            writer.beginMethod(null, className, EnumSet.of(Modifier.PRIVATE), new String[0]);
            writer.endMethod();
            writer.emitEmptyLine();
            this.emitExtensions(writer);
            writer.endType();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void emitExtensions(JavaWriter writer) throws IOException {
        for (ExtendElement extend : this.protoFile.extendDeclarations()) {
            String fullyQualifiedName = extend.qualifiedName();
            if (!this.shouldEmitOptions() && WireCompiler.isOptionType(fullyQualifiedName)) continue;
            String javaName = this.javaName(null, fullyQualifiedName);
            String name = this.shortenJavaName(javaName);
            for (FieldElement field : extend.fields()) {
                String fieldType = field.type().toString();
                String type = this.javaName(null, fieldType);
                if (type == null) {
                    type = this.javaName(null, this.prefixWithPackageName(fieldType));
                }
                type = this.shortenJavaName(type);
                String className = writer.compressType(name);
                String extensionName = field.name();
                String fqName = this.prefixWithPackageName(field.name());
                int tag = field.tag();
                boolean isScalar = TypeInfo.isScalar(fieldType);
                boolean isEnum = !isScalar && this.isEnum(this.fullyQualifiedName((String)null, fieldType));
                String labelString = this.getLabelString(field, isEnum);
                String initialValue = isScalar ? String.format("Extension%n.%1$sExtending(%2$s.class)%n.setName(\"%3$s\")%n.setTag(%4$d)%n.build%5$s()", field.type(), className, fqName, tag, labelString) : (isEnum ? String.format("Extension%n.enumExtending(%1$s.class, %2$s.class)%n.setName(\"%3$s\")%n.setTag(%4$d)%n.build%5$s()", type, className, fqName, tag, labelString) : String.format("Extension%n.messageExtending(%1$s.class, %2$s.class)%n.setName(\"%3$s\")%n.setTag(%4$d)%n.build%5$s()", type, className, fqName, tag, labelString));
                if (FieldInfo.isRepeated(field)) {
                    type = "List<" + type + ">";
                }
                writer.emitField("Extension<" + name + ", " + type + ">", extensionName, EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL), initialValue);
            }
        }
    }

    private static boolean isOptionType(String fullyQualifiedName) {
        return WireCompiler.isMessageOptions(fullyQualifiedName) || WireCompiler.isFieldOptions(fullyQualifiedName);
    }

    private static boolean isFieldOptions(String name) {
        return "google.protobuf.FieldOptions".equals(name) || "com.google.protobuf.FieldOptions".equals(name);
    }

    private static boolean isMessageOptions(String fullyQualifiedName) {
        return "google.protobuf.MessageOptions".equals(fullyQualifiedName) || "com.google.protobuf.MessageOptions".equals(fullyQualifiedName);
    }

    private String prefixWithPackageName(ProtoFile protoFile, String name) {
        return protoFile.packageName() + "." + name;
    }

    private String getLabelString(FieldElement field, boolean isEnum) {
        switch (field.label()) {
            case OPTIONAL: {
                return "Optional";
            }
            case REQUIRED: {
                return "Required";
            }
            case REPEATED: {
                return FieldInfo.isPacked(field, isEnum) ? "Packed" : "Repeated";
            }
        }
        throw new WireCompilerException("Unknown extension label \"" + field.label() + "\"");
    }

    private boolean hasByteStringExtension() {
        for (ExtendElement extend : this.protoFile.extendDeclarations()) {
            for (FieldElement field : extend.fields()) {
                if (field.type() != DataType.ScalarType.BYTES) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasRepeatedExtension() {
        for (ExtendElement extend : this.protoFile.extendDeclarations()) {
            for (FieldElement field : extend.fields()) {
                if (field.label() != FieldElement.Label.REPEATED) continue;
                return true;
            }
        }
        return false;
    }

    private String toInt(String value) {
        return Integer.toString(new BigDecimal(value).intValue());
    }

    private String toLong(String value) {
        return Long.toString(new BigDecimal(value).longValue()) + "L";
    }

    private String quoteString(String initialValue) {
        return initialValue == null ? "\"\"" : JavaWriter.stringLiteral((String)initialValue);
    }

    private boolean hasEnum(List<TypeElement> types) {
        for (TypeElement type : types) {
            if (!(type instanceof EnumElement) && !this.hasEnum(type.nestedElements())) continue;
            return true;
        }
        return false;
    }

    private boolean hasOneOf(List<TypeElement> types) {
        for (TypeElement type : types) {
            if ((!(type instanceof MessageElement) || ((MessageElement)type).oneOfs().isEmpty()) && !this.hasOneOf(type.nestedElements())) continue;
            return true;
        }
        return false;
    }

    private boolean hasExtensions(List<TypeElement> types) {
        for (TypeElement type : types) {
            if (type instanceof MessageElement && this.hasExtensions((MessageElement)type)) {
                return true;
            }
            if (!this.hasExtensions(type.nestedElements())) continue;
            return true;
        }
        return false;
    }

    private boolean hasMessage(List<TypeElement> types) {
        for (TypeElement type : types) {
            if (type instanceof MessageElement && !this.hasExtensions((MessageElement)type)) {
                return true;
            }
            if (!this.hasMessage(type.nestedElements())) continue;
            return true;
        }
        return false;
    }

    static List<FieldElement> allFields(MessageElement messageType) {
        ArrayList<FieldElement> allFields = new ArrayList<FieldElement>();
        allFields.addAll(messageType.fields());
        for (OneOfElement oneOfElement : messageType.oneOfs()) {
            allFields.addAll(oneOfElement.fields());
        }
        return allFields;
    }

    private boolean hasRepeatedField(List<TypeElement> types) {
        for (TypeElement type : types) {
            if (type instanceof MessageElement) {
                for (FieldElement field : WireCompiler.allFields((MessageElement)type)) {
                    if (!FieldInfo.isRepeated(field)) continue;
                    return true;
                }
            }
            if (!this.hasRepeatedField(type.nestedElements())) continue;
            return true;
        }
        return false;
    }

    private boolean hasBytesField(List<TypeElement> types) {
        for (TypeElement type : types) {
            if (type instanceof MessageElement) {
                for (FieldElement field : WireCompiler.allFields((MessageElement)type)) {
                    if (field.type() != DataType.ScalarType.BYTES) continue;
                    return true;
                }
            }
            if (!this.hasBytesField(type.nestedElements())) continue;
            return true;
        }
        return false;
    }

    private void getDatatypesAndLabels(TypeElement type, Collection<Message.Datatype> types, Collection<Message.Label> labels) {
        if (type instanceof MessageElement) {
            block6: for (FieldElement field : WireCompiler.allFields((MessageElement)type)) {
                String fieldType = field.type().toString();
                Message.Datatype datatype = Message.Datatype.of((String)fieldType);
                if (datatype == null && this.isEnum(this.fullyQualifiedName(type, field.type().toString()))) {
                    datatype = Message.Datatype.ENUM;
                }
                if (datatype != null) {
                    types.add(datatype);
                }
                FieldElement.Label label = field.label();
                switch (label) {
                    case OPTIONAL: {
                        labels.add(Message.Label.OPTIONAL);
                        continue block6;
                    }
                    case REQUIRED: {
                        labels.add(Message.Label.REQUIRED);
                        continue block6;
                    }
                    case REPEATED: {
                        if (FieldInfo.isPacked(field, datatype == Message.Datatype.ENUM)) {
                            labels.add(Message.Label.PACKED);
                            continue block6;
                        }
                        labels.add(Message.Label.REPEATED);
                        continue block6;
                    }
                    case ONE_OF: {
                        labels.add(Message.Label.ONE_OF);
                        continue block6;
                    }
                }
                throw new AssertionError((Object)("Unknown label " + label));
            }
            for (TypeElement nestedType : type.nestedElements()) {
                this.getDatatypesAndLabels(nestedType, types, labels);
            }
        }
    }

    private boolean typeIsComplete(String type) {
        return this.javaSymbolMap.containsKey(type);
    }

    private boolean javaTypeIsComplete(String type) {
        if (this.javaSymbols.isEmpty()) {
            this.javaSymbols.addAll(this.javaSymbolMap.values());
        }
        return this.javaSymbols.contains(type);
    }

    private String fullyQualifiedJavaName(MessageElement messageType, String type) {
        return TypeInfo.isScalar(type) ? null : this.javaName(this.fullyQualifiedName((TypeElement)messageType, type));
    }

    private static enum LoadSymbolsPass {
        LOAD_TYPES,
        LOAD_FIELDS;

    }
}

