/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.javawriter.JavaWriter;
import com.squareup.protoparser.RpcElement;
import com.squareup.protoparser.ServiceElement;
import com.squareup.wire.ServiceWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.lang.model.element.Modifier;

public class RxJavaServiceWriter
extends ServiceWriter {
    String requestType;
    String responseType;
    String func1Type;

    public RxJavaServiceWriter(JavaWriter writer, List<String> options) {
        super(writer, options);
    }

    @Override
    public void emitService(ServiceElement service, Set<String> importedTypes) throws IOException {
        importedTypes.add("javax.inject.Inject");
        if (!service.rpcs().isEmpty()) {
            importedTypes.add("retrofit.http.Body");
            importedTypes.add("retrofit.http.POST");
            importedTypes.add("rx.functions.Func1");
        }
        this.writer.emitImports(importedTypes);
        this.writer.emitEmptyLine();
        if (!service.documentation().isEmpty()) {
            this.writer.emitJavadoc(service.documentation(), new Object[0]);
        }
        this.writer.beginType(service.name(), "class", EnumSet.of(Modifier.PUBLIC, Modifier.FINAL));
        this.writer.emitEmptyLine();
        this.writer.beginType("Endpoint", "interface", EnumSet.of(Modifier.PUBLIC));
        for (RpcElement rpc : service.rpcs()) {
            this.writer.emitEmptyLine();
            this.writer.emitJavadoc(rpc.documentation(), new Object[0]);
            this.setTypes(rpc);
            this.writer.emitAnnotation("POST", (Object)("\"/" + service.qualifiedName() + "/" + rpc.name() + "\""));
            this.writer.beginMethod(this.responseType, this.getMethodName(rpc), EnumSet.noneOf(Modifier.class), Arrays.asList("@Body " + this.requestType, "request"), null);
            this.writer.endMethod();
        }
        this.writer.endType();
        for (RpcElement rpc : service.rpcs()) {
            this.writer.emitEmptyLine();
            this.setTypes(rpc);
            this.writer.emitField(this.func1Type, this.getMethodName(rpc), EnumSet.of(Modifier.PRIVATE, Modifier.FINAL), "\nnew " + this.func1Type + "() {\n" + "  @Override\n" + "  public " + this.responseType + " call(" + this.requestType + " request) {\n" + "    return endpoint." + this.getMethodName(rpc) + "(request);\n" + "  }\n" + "}");
        }
        this.writer.emitEmptyLine();
        this.writer.emitField("Endpoint", "endpoint", EnumSet.of(Modifier.PRIVATE, Modifier.FINAL));
        this.writer.emitEmptyLine();
        this.writer.emitAnnotation("Inject");
        this.writer.beginConstructor(EnumSet.of(Modifier.PUBLIC), new String[]{"Endpoint", "endpoint"});
        this.writer.emitStatement("this.endpoint = endpoint", new Object[0]);
        this.writer.endConstructor();
        for (RpcElement rpc : service.rpcs()) {
            this.writer.emitEmptyLine();
            this.setTypes(rpc);
            this.writer.beginMethod(this.func1Type, "get" + rpc.name(), EnumSet.of(Modifier.PUBLIC), new String[0]);
            this.writer.emitStatement("return " + this.getMethodName(rpc), new Object[0]);
            this.writer.endMethod();
        }
        this.writer.endType();
    }

    private String getMethodName(RpcElement rpc) {
        return this.lowerCaseInitialLetter(rpc.name());
    }

    private void setTypes(RpcElement rpc) {
        this.requestType = this.writer.compressType(rpc.requestType().toString());
        this.responseType = this.writer.compressType(rpc.responseType().toString());
        this.func1Type = "Func1<" + this.requestType + ", " + this.responseType + ">";
    }

    String lowerCaseInitialLetter(String name) {
        return name.substring(0, 1).toLowerCase(Locale.US) + name.substring(1);
    }
}

