/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.protoparser.EnumType;
import com.squareup.protoparser.MessageType;
import com.squareup.protoparser.Option;
import com.squareup.wire.ExtensionInfo;
import com.squareup.wire.FieldInfo;
import com.squareup.wire.TypeInfo;
import com.squareup.wire.WireCompiler;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OptionsMapMaker {
    private final WireCompiler compiler;

    public OptionsMapMaker(WireCompiler compiler) {
        this.compiler = compiler;
    }

    public Map<String, ?> createMessageOptionsMap(MessageType type) {
        List options = type.getOptions();
        if (options.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Option option : options) {
            this.insertOption(option.getName(), option.getValue(), type.getFullyQualifiedName(), map);
        }
        return map;
    }

    public Map<String, ?> createEnumOptionsMap(EnumType type) {
        List options = type.getOptions();
        if (options.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Option option : type.getOptions()) {
            this.insertOption(option.getName(), option.getValue(), "", map);
        }
        return map.isEmpty() ? null : map;
    }

    public Map<String, ?> createEnumValueOptionsMap(EnumType type) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (EnumType.Value value : type.getValues()) {
            for (Option option : value.getOptions()) {
                this.insertOption(option.getName(), option.getValue(), "", map);
            }
        }
        return map.isEmpty() ? null : map;
    }

    public Map<String, ?> createSingleEnumValueOptionMap(EnumType.Value value) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Option option : value.getOptions()) {
            this.insertOption(option.getName(), option.getValue(), "", map);
        }
        return map.isEmpty() ? null : map;
    }

    public Map<String, ?> createFieldOptionsMap(MessageType type, List<Option> options) {
        if (options.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Option option : options) {
            String key = option.getName();
            if (WireCompiler.DEFAULT_FIELD_OPTION_KEYS.contains(key)) continue;
            this.insertOption(key, option.getValue(), type.getFullyQualifiedName(), map);
        }
        return map;
    }

    private void insertOption(String name, Object value, String enclosingType, Map<String, Object> map) {
        String fqName = this.getExtensionPrefix(name);
        if (fqName.isEmpty()) {
            name = this.compiler.prefixWithPackageName(name);
        }
        this.insertOptionHelper(name, value, enclosingType, map);
    }

    private void insertOptionHelper(String name, Object value, String enclosingType, Map<String, Object> map) {
        String fieldType;
        ExtensionInfo info;
        String fqName;
        int firstDotAfterExtensionIndex = (name = this.stripSquareBrackets(name)).indexOf(46, (fqName = this.getExtensionPrefix(name)).length());
        if (firstDotAfterExtensionIndex != -1) {
            String prefix = name.substring(0, firstDotAfterExtensionIndex);
            String suffix = name.substring(firstDotAfterExtensionIndex + 1);
            String fieldType2 = this.getFieldType(enclosingType, prefix);
            this.insertOptionHelper(prefix, new Option(suffix, value), fieldType2, map);
            return;
        }
        ExtensionInfo extensionInfo = info = this.compiler.isEnum(enclosingType) ? null : this.getExtensionInfo(name);
        if (info == null && this.compiler.getProtoFile().getPackageName().endsWith("." + name) && value instanceof Option) {
            name = this.compiler.prefixWithPackageName(((Option)value).getName());
            info = this.compiler.getExtension(name);
            value = ((Option)value).getValue();
        }
        if (info != null) {
            enclosingType = info.fqType;
        }
        String string = fieldType = info == null ? this.getFieldType(enclosingType, name) : info.type;
        if (fieldType == null) {
            fieldType = enclosingType;
        }
        if (value instanceof String) {
            MessageType.Label fieldLabel = this.getFieldLabel(enclosingType, name);
            if (info != null) {
                fieldLabel = info.label;
            }
            this.insertStringOption(name, (String)value, map, fieldType, fieldLabel);
        } else if (value instanceof List) {
            this.insertListOption(name, (List)value, enclosingType, map, fieldType);
        } else if (value instanceof Option) {
            this.insertOptionOption(name, (Option)value, enclosingType, map);
        } else if (value instanceof Map) {
            this.insertMapOption(name, (Map)value, enclosingType, map);
        } else {
            throw new RuntimeException("value is not an Option, String, List, or Map");
        }
    }

    private ExtensionInfo getExtensionInfo(String name) {
        ExtensionInfo info = this.compiler.getExtension(name);
        if (info == null) {
            info = this.compiler.getExtension(this.compiler.prefixWithPackageName(name));
        }
        return info;
    }

    private MessageType.Label getFieldLabel(String enclosingType, String nestedName) {
        FieldInfo fieldInfo = this.compiler.getField(enclosingType + "$" + nestedName);
        return fieldInfo == null ? null : fieldInfo.label;
    }

    private String stripSquareBrackets(String name) {
        int lastIndex = name.length() - 1;
        if (name.charAt(0) == '[' && name.charAt(lastIndex) == ']' && !(name = name.substring(1, lastIndex)).contains(".")) {
            name = this.compiler.prefixWithPackageName(name);
        }
        return name;
    }

    private String getFieldType(String enclosingType, String nestedName) {
        FieldInfo fieldInfo = this.compiler.getField(enclosingType + "$" + nestedName);
        return this.getFieldType(fieldInfo);
    }

    private String getExtensionPrefix(String name) {
        int endIndex = name.length();
        while (endIndex != -1) {
            String fqName = name.substring(0, endIndex);
            if (this.compiler.getExtension(fqName) != null) {
                return fqName;
            }
            endIndex = name.lastIndexOf(46, endIndex - 1);
        }
        return "";
    }

    private String getFieldType(FieldInfo info) {
        return info == null ? null : info.name;
    }

    private void insertStringOption(String name, String value, Map<String, Object> map, String fieldType, MessageType.Label fieldLabel) {
        value = this.getOptionInitializer(value, fieldType);
        if (fieldLabel == MessageType.Label.REPEATED) {
            ArrayList<String> list = (ArrayList<String>)map.get(name);
            if (list == null) {
                list = new ArrayList<String>();
                map.put(name, list);
            }
            list.add(value);
        } else {
            map.put(name, value);
        }
    }

    private void insertListOption(String name, List<?> value, String enclosingType, Map<String, Object> map, String fieldType) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        for (Object objectValue : value) {
            if (objectValue instanceof String) {
                String stringValue = this.getOptionInitializer((String)objectValue, fieldType);
                valueList.add(stringValue);
                continue;
            }
            if (objectValue instanceof Map) {
                LinkedHashMap<String, Object> entryMap = new LinkedHashMap<String, Object>();
                entryMap.put("@type", enclosingType);
                this.insertOptionsFromMap(enclosingType, (Map)objectValue, entryMap);
                valueList.add(entryMap);
                continue;
            }
            throw new RuntimeException("List contains " + objectValue.getClass().getName() + ", not String or Map");
        }
        map.put(name, valueList);
    }

    private String getOptionInitializer(String stringValue, String fieldType) {
        if (TypeInfo.isScalar(fieldType)) {
            String javaTypeName = TypeInfo.scalarType(fieldType);
            return this.compiler.getInitializerForType(stringValue, javaTypeName);
        }
        if (this.compiler.isEnum(fieldType)) {
            String typeBeingGenerated;
            String javaPackage;
            String javaName = this.compiler.javaName(fieldType);
            if (javaName.startsWith((javaPackage = this.compiler.getJavaPackage()) + ".")) {
                javaName = javaName.substring(javaPackage.length() + 1);
            }
            if (javaName.startsWith((typeBeingGenerated = this.compiler.getTypeBeingGenerated()) + ".")) {
                javaName = javaName.substring(typeBeingGenerated.length() + 1);
            }
            return javaName + "." + this.compiler.getTrailingSegment(stringValue);
        }
        return stringValue;
    }

    private void insertOptionsFromMap(String enclosingType, Map<String, ?> inputMap, Map<String, Object> outputMap) {
        for (Map.Entry<String, ?> valueEntry : inputMap.entrySet()) {
            String nestedName = valueEntry.getKey();
            String fieldType = this.getFieldType(enclosingType, nestedName);
            Object val = this.qualifyEnum(enclosingType, nestedName, fieldType, valueEntry.getValue());
            this.insertOptionHelper(nestedName, val, fieldType, outputMap);
        }
    }

    private void insertOptionOption(String name, Option value, String enclosingType, Map<String, Object> map) {
        Map<String, Object> entryMap = this.getOrCreateFromMap(map, name);
        entryMap.put("@type", enclosingType);
        String nestedName = value.getName();
        String fieldType = this.getFieldType(enclosingType, nestedName);
        Object val = this.qualifyEnum(enclosingType, nestedName, fieldType, value.getValue());
        this.insertOptionHelper(nestedName, val, enclosingType, entryMap);
    }

    private Object qualifyEnum(String enclosingType, String optionValueName, String fieldType, Object value) {
        if (this.compiler.isEnum(this.getFieldType(enclosingType, optionValueName))) {
            return fieldType + "." + value;
        }
        return value;
    }

    private void insertMapOption(String name, Map<String, ?> value, String enclosingType, Map<String, Object> map) {
        Map<String, Object> entryMap = this.getOrCreateFromMap(map, name);
        entryMap.put("@type", enclosingType);
        this.insertOptionsFromMap(enclosingType, value, entryMap);
    }

    private Map<String, Object> getOrCreateFromMap(Map<String, Object> map, String name) {
        LinkedHashMap entry = map.get(name);
        if (entry == null) {
            entry = new LinkedHashMap();
            map.put(name, entry);
        }
        return entry;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String createOptionInitializer(Object listOrMap, String parentType, String parentField, String fieldType, boolean skipAsList, int level) {
        ++level;
        StringBuilder sb = new StringBuilder();
        if (listOrMap instanceof Map) {
            boolean emitAsList;
            Map map = (Map)listOrMap;
            String fullyQualifiedName = this.compiler.javaName(fieldType);
            String dollarName = parentType + "$" + parentField;
            FieldInfo fieldInfo = this.compiler.getField(dollarName);
            boolean bl = emitAsList = !skipAsList && fieldInfo != null && fieldInfo.isRepeated();
            if (emitAsList) {
                sb.append("java.util.Arrays.asList(");
            }
            String shortName = this.compiler.shortenJavaName(fullyQualifiedName);
            sb.append("new ").append(shortName).append(".Builder()");
            for (Map.Entry entry : map.entrySet()) {
                String nestedFieldType;
                String key = (String)entry.getKey();
                if (this.isMetadata(key)) continue;
                sb.append("\n");
                this.indent(sb, level);
                sb.append(".");
                ExtensionInfo extension = this.compiler.getExtension(key);
                if (extension != null) {
                    key = this.compiler.getTrailingSegment(key);
                    sb.append(String.format("setExtension(Ext_%s.%s, ", extension.location, key));
                } else {
                    sb.append(key).append("(");
                }
                FieldInfo info = this.compiler.getField(fieldType + "$" + key);
                if (info == null) {
                    ExtensionInfo extInfo = this.compiler.getExtension((String)entry.getKey());
                    if (extInfo == null) throw new RuntimeException("Unknown name " + (String)entry.getKey());
                    nestedFieldType = extInfo.fqType;
                } else {
                    nestedFieldType = this.getFieldType(info);
                }
                String optionInitializer = this.createOptionInitializer(entry.getValue(), fieldType, key, nestedFieldType, false, level);
                sb.append(optionInitializer).append(")");
            }
            sb.append("\n");
            this.indent(sb, level);
            sb.append(".build()");
            if (!emitAsList) return sb.toString();
            sb.append(")");
            return sb.toString();
        } else if (listOrMap instanceof List) {
            sb.append("java.util.Arrays.asList(");
            String sep = "\n";
            for (Object objectValue : (List)listOrMap) {
                sb.append(sep);
                this.indent(sb, level);
                if (objectValue instanceof String) {
                    sb.append((String)objectValue);
                } else if (objectValue instanceof Map) {
                    sb.append(this.createOptionInitializer(objectValue, parentType, parentField, fieldType, true, level));
                }
                sep = ",\n";
            }
            sb.append(")");
            return sb.toString();
        } else {
            sb.append((String)listOrMap);
        }
        return sb.toString();
    }

    private void indent(StringBuilder sb, int level) {
        for (int i = 0; i < level; ++i) {
            sb.append("    ");
        }
    }

    private boolean isMetadata(String key) {
        return key.charAt(0) == '@';
    }

    public void getOptionTypes(Map<String, ?> optionsMap, List<String> types) {
        if (optionsMap == null) {
            return;
        }
        for (Map.Entry<String, ?> entry : optionsMap.entrySet()) {
            String key = entry.getKey();
            ExtensionInfo info = this.compiler.getExtension(key);
            if (info != null && !info.fqLocation.startsWith(this.compiler.getJavaPackage())) {
                types.add(info.fqLocation);
            }
            if ("@type".equals(key)) {
                String type = (String)entry.getValue();
                String javaName = this.compiler.javaName(type);
                if (!this.compiler.fullyQualifiedNameIsOutsidePackage(javaName)) continue;
                types.add(javaName);
                continue;
            }
            if (entry.getValue() instanceof List) {
                for (Object objectValue : (List)entry.getValue()) {
                    if (!(objectValue instanceof Map)) continue;
                    this.getOptionTypes((Map)objectValue, types);
                }
                continue;
            }
            if (!(entry.getValue() instanceof Map)) continue;
            this.getOptionTypes((Map)entry.getValue(), types);
        }
    }
}

