/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.javawriter.JavaWriter;
import com.squareup.protoparser.ProtoFile;
import com.squareup.protoparser.ProtoSchemaParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

interface IO {
    public ProtoFile parse(String var1) throws IOException;

    public JavaWriter getJavaWriter(String var1, String var2, String var3) throws IOException;

    public static class FileIO
    implements IO {
        private static final Charset UTF_8 = Charset.forName("UTF8");

        @Override
        public ProtoFile parse(String filename) throws IOException {
            return ProtoSchemaParser.parse((String)filename, (Reader)new InputStreamReader((InputStream)new FileInputStream(filename), UTF_8));
        }

        @Override
        public JavaWriter getJavaWriter(String outputDirectory, String javaPackage, String className) throws IOException {
            String directory = outputDirectory + File.separator + javaPackage.replace(".", File.separator);
            boolean created = new File(directory).mkdirs();
            if (created) {
                System.out.println("Created output directory " + directory);
            }
            String fileName = directory + File.separator + className + ".java";
            System.out.println("Writing generated code to " + fileName);
            return new JavaWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), UTF_8));
        }
    }
}

