/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.javawriter.JavaWriter;
import com.squareup.protoparser.EnumType;
import com.squareup.protoparser.ExtendDeclaration;
import com.squareup.protoparser.MessageType;
import com.squareup.protoparser.Option;
import com.squareup.protoparser.ProtoFile;
import com.squareup.protoparser.Type;
import com.squareup.wire.ExtensionInfo;
import com.squareup.wire.FieldInfo;
import com.squareup.wire.FileIO;
import com.squareup.wire.IO;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoEnum;
import com.squareup.wire.ProtoField;
import com.squareup.wire.Stringer;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Modifier;

public class WireCompiler {
    private static final Charset ISO_8859_1 = Charset.forName("ISO_8859_1");
    private static final Map<String, String> JAVA_TYPES = new LinkedHashMap<String, String>();
    private static final Set<String> JAVA_KEYWORDS = new LinkedHashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"));
    private static final String PROTO_PATH_FLAG = "--proto_path=";
    private static final String JAVA_OUT_FLAG = "--java_out=";
    private static final String FILES_FLAG = "--files=";
    private static final String ROOTS_FLAG = "--roots=";
    private static final String URL_CHARS = "[-!#$%&'()*+,./0-9:;=?@A-Z\\[\\]_a-z~]";
    private static final String INDENT = "  ";
    private static final String LINE_WRAP_INDENT = "    ";
    private static final String CODE_GENERATED_BY_WIRE = "Code generated by Wire protocol buffer compiler, do not edit.";
    private final String repoPath;
    private final List<String> sourceFileNames;
    private final IO io;
    private final Set<String> typesToEmit = new LinkedHashSet<String>();
    private final Map<String, String> javaSymbolMap = new LinkedHashMap<String, String>();
    private final Set<String> enumTypes = new LinkedHashSet<String>();
    private final Map<String, String> enumDefaults = new LinkedHashMap<String, String>();
    private final Map<String, ExtensionInfo> extensionInfo = new LinkedHashMap<String, ExtensionInfo>();
    private final Map<String, FieldInfo> fieldMap = new LinkedHashMap<String, FieldInfo>();
    private final String outputDirectory;
    private ProtoFile protoFile;
    private String sourceFileName;
    private String protoFileName;
    private String typeBeingGenerated = "";
    private JavaWriter writer;

    public static void main(String ... args) throws Exception {
        String protoPath = null;
        String javaOut = null;
        ArrayList<String> sourceFileNames = new ArrayList<String>();
        ArrayList<String> roots = new ArrayList<String>();
        for (int index = 0; index < args.length; ++index) {
            if (args[index].startsWith(PROTO_PATH_FLAG)) {
                protoPath = args[index].substring(PROTO_PATH_FLAG.length());
                continue;
            }
            if (args[index].startsWith(JAVA_OUT_FLAG)) {
                javaOut = args[index].substring(JAVA_OUT_FLAG.length());
                continue;
            }
            if (args[index].startsWith(FILES_FLAG)) {
                File files = new File(args[index].substring(FILES_FLAG.length()));
                String[] fileNames = new Scanner(files, "UTF-8").useDelimiter("\\A").next().split("\n");
                sourceFileNames.addAll(Arrays.asList(fileNames));
                continue;
            }
            if (args[index].startsWith(ROOTS_FLAG)) {
                roots.addAll(Arrays.asList(args[index].substring(ROOTS_FLAG.length()).split(",")));
                continue;
            }
            sourceFileNames.add(args[index]);
        }
        if (javaOut == null) {
            System.err.println("Must specify --java_out= flag");
            System.exit(1);
        }
        if (protoPath == null) {
            protoPath = System.getProperty("user.dir");
            System.err.println("--proto_path= flag not specified, using current dir " + protoPath);
        }
        WireCompiler wireCompiler = new WireCompiler(protoPath, sourceFileNames, roots, javaOut);
        wireCompiler.compile();
    }

    public WireCompiler(String protoPath, List<String> sourceFileNames, List<String> roots, String outputDirectory) {
        this(protoPath, sourceFileNames, roots, outputDirectory, new FileIO());
    }

    WireCompiler(String protoPath, List<String> sourceFileNames, List<String> roots, String outputDirectory, IO io) {
        this.repoPath = protoPath;
        this.typesToEmit.addAll(roots);
        this.sourceFileNames = sourceFileNames;
        this.outputDirectory = outputDirectory;
        this.io = io;
    }

    public void compile() throws IOException {
        LinkedHashMap<String, ProtoFile> parsedFiles = new LinkedHashMap<String, ProtoFile>();
        for (String string : this.sourceFileNames) {
            String sourcePath = this.repoPath + File.separator + string;
            ProtoFile protoFile = this.io.parse(sourcePath);
            parsedFiles.put(sourcePath, protoFile);
            this.loadSymbols(protoFile);
        }
        if (!this.typesToEmit.isEmpty()) {
            System.out.println("Analyzing dependencies of root types.");
            this.findDependencies(parsedFiles.values());
        }
        for (Map.Entry entry : parsedFiles.entrySet()) {
            this.sourceFileName = (String)entry.getKey();
            this.protoFile = (ProtoFile)entry.getValue();
            this.protoFileName = this.protoFileName(this.protoFile.getFileName());
            System.out.println("Compiling proto source file " + this.sourceFileName);
            this.compileOne();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileOne() throws IOException {
        this.typeBeingGenerated = "";
        if (this.hasExtends()) {
            try {
                this.writer = this.io.getJavaWriter(this.outputDirectory, this.protoFile.getJavaPackage(), "Ext_" + this.protoFileName);
                this.emitExtensionClass();
            }
            finally {
                this.writer.close();
            }
        }
        for (Type type : this.protoFile.getTypes()) {
            if (!this.shouldEmitType(type.getFullyQualifiedName())) continue;
            String savedType = this.typeBeingGenerated;
            this.typeBeingGenerated = this.typeBeingGenerated + type.getName() + ".";
            this.emitMessageClass(type);
            this.typeBeingGenerated = savedType;
        }
    }

    private boolean shouldEmitType(String name) {
        return this.typesToEmit.isEmpty() || this.typesToEmit.contains(name);
    }

    private void findDependencies(Collection<ProtoFile> protoFiles) throws IOException {
        LinkedHashSet<String> loadedDependencies = new LinkedHashSet<String>();
        int count = this.typesToEmit.size();
        while (true) {
            for (ProtoFile protoFile : protoFiles) {
                this.findDependenciesHelper(protoFile, loadedDependencies);
            }
            int newCount = this.typesToEmit.size();
            if (newCount == count) break;
            count = newCount;
        }
    }

    private void findDependenciesHelper(ProtoFile protoFile, Set<String> loadedDependencies) throws IOException {
        for (String dependency : protoFile.getDependencies()) {
            if (loadedDependencies.contains(dependency)) continue;
            String dep = this.repoPath + File.separator + dependency;
            ProtoFile dependencyFile = this.io.parse(dep);
            this.loadSymbols(dependencyFile);
            loadedDependencies.add(dependency);
        }
        for (ExtendDeclaration extend : protoFile.getExtendDeclarations()) {
            String typeName = extend.getFullyQualifiedName();
            this.typesToEmit.add(typeName);
            for (MessageType.Field field : extend.getFields()) {
                String fieldTypeName = this.prefixWithPackageName(protoFile, field.getType());
                this.typesToEmit.add(fieldTypeName);
            }
        }
        this.addDependencies(protoFile.getTypes(), protoFile.getJavaPackage() + ".");
    }

    private void addDependencies(List<Type> types, String javaPrefix) {
        for (Type type : types) {
            String name = type.getName();
            String fqName = type.getFullyQualifiedName();
            if (type instanceof MessageType && this.typesToEmit.contains(fqName)) {
                for (MessageType.Field field : ((MessageType)type).getFields()) {
                    String fieldType = field.getType();
                    if (this.isScalar(fieldType)) continue;
                    String fqFieldType = this.fullyQualifiedName((MessageType)type, field.getType());
                    this.addDependencyBranch(fqFieldType);
                }
            }
            this.addDependencies(type.getNestedTypes(), javaPrefix + name + ".");
        }
    }

    private void addDependencyBranch(String name) {
        while (this.typeIsComplete(name)) {
            this.typesToEmit.add(name);
            name = this.removeTrailingSegment(name);
        }
    }

    private String removeTrailingSegment(String name) {
        int index = name.lastIndexOf(46);
        return index == -1 ? "" : name.substring(0, index);
    }

    private void loadSymbols(ProtoFile protoFile) throws IOException {
        this.loadSymbolsHelper(protoFile, new LinkedHashSet<String>(), LoadSymbolsPass.LOAD_TYPES);
        this.loadSymbolsHelper(protoFile, new LinkedHashSet<String>(), LoadSymbolsPass.LOAD_FIELDS);
    }

    private void loadSymbolsHelper(ProtoFile protoFile, Set<String> loadedDependencies, LoadSymbolsPass pass) throws IOException {
        for (String dependency : protoFile.getDependencies()) {
            if (loadedDependencies.contains(dependency)) continue;
            String dep = this.repoPath + File.separator + dependency;
            ProtoFile dependencyFile = this.io.parse(dep);
            this.loadSymbolsHelper(dependencyFile, loadedDependencies, pass);
            loadedDependencies.add(dependency);
        }
        this.addTypes(protoFile.getTypes(), protoFile.getJavaPackage() + ".", pass);
        this.addExtensions(protoFile);
    }

    private void addExtensions(ProtoFile protoFile) {
        for (ExtendDeclaration extend : protoFile.getExtendDeclarations()) {
            for (MessageType.Field field : extend.getFields()) {
                boolean isEnum;
                String fieldType = field.getType();
                String type = this.javaName(protoFile, null, fieldType);
                if (type == null) {
                    type = this.javaName(protoFile, null, this.prefixWithPackageName(protoFile, fieldType));
                }
                type = this.shortenJavaName(protoFile, type);
                String fqName = this.prefixWithPackageName(protoFile, field.getName());
                boolean isScalar = this.isScalar(fieldType);
                boolean bl = isEnum = !isScalar && this.isEnum(this.fullyQualifiedName(protoFile, null, fieldType));
                String fqType = isScalar ? (type = field.getType()) : (isEnum ? (type = this.fullyQualifiedName(protoFile, null, fieldType)) : this.fullyQualifiedName(protoFile, null, fieldType));
                String location = this.protoFileName(protoFile.getFileName());
                String fqLocation = protoFile.getJavaPackage() + ".Ext_" + location;
                ExtensionInfo info = new ExtensionInfo(type, fqType, location, fqLocation, field.getLabel());
                this.extensionInfo.put(fqName, info);
            }
        }
    }

    private void addTypes(List<Type> types, String javaPrefix, LoadSymbolsPass pass) {
        for (Type type : types) {
            String name = type.getName();
            if (pass == LoadSymbolsPass.LOAD_TYPES) {
                String fqName = type.getFullyQualifiedName();
                this.javaSymbolMap.put(fqName, javaPrefix + name);
                if (type instanceof EnumType) {
                    this.enumTypes.add(fqName);
                    this.enumDefaults.put(fqName, ((EnumType.Value)((EnumType)type).getValues().get(0)).getName());
                }
            } else if (type instanceof MessageType) {
                this.addFields((MessageType)type);
            }
            this.addTypes(type.getNestedTypes(), javaPrefix + name + ".", pass);
        }
    }

    private void addFields(MessageType messageType) {
        for (MessageType.Field field : messageType.getFields()) {
            String fieldType = field.getType();
            String fqMessageName = messageType.getFullyQualifiedName();
            String key = fqMessageName + "$" + field.getName();
            this.fieldMap.put(key, new FieldInfo(this.isScalar(fieldType) ? fieldType : this.fullyQualifiedName(messageType, fieldType), field.getLabel()));
        }
    }

    private String getJavaFieldType(ProtoFile protoFile, MessageType messageType, MessageType.Field field) {
        String javaName = this.javaName(protoFile, messageType, field.getType());
        if (this.isRepeated(field)) {
            javaName = "List<" + javaName + ">";
        }
        return javaName;
    }

    private String javaName(ProtoFile protoFile, MessageType messageType, String type) {
        String scalarType = this.scalarType(type);
        return scalarType != null ? scalarType : this.shortenJavaName(protoFile, this.javaName(this.fullyQualifiedName(protoFile, messageType, type)));
    }

    private String fullyQualifiedName(ProtoFile protoFile, MessageType messageType, String type) {
        String prefix;
        if (this.typeIsComplete(type)) {
            return type;
        }
        String string = prefix = messageType == null ? protoFile.getPackageName() : messageType.getFullyQualifiedName();
        while (!prefix.isEmpty()) {
            String fqname = prefix + "." + type;
            if (this.typeIsComplete(fqname)) {
                return fqname;
            }
            prefix = this.removeTrailingSegment(prefix);
        }
        throw new RuntimeException("Unknown type " + type + " in message " + (messageType == null ? "<unknown>" : messageType.getName()));
    }

    private String shortenJavaName(ProtoFile protoFile, String fullyQualifiedName) {
        if (fullyQualifiedName == null) {
            return null;
        }
        String javaTypeBeingGenerated = protoFile.getJavaPackage() + "." + this.typeBeingGenerated;
        if (fullyQualifiedName.startsWith(javaTypeBeingGenerated)) {
            return fullyQualifiedName.substring(javaTypeBeingGenerated.length());
        }
        for (String javaSymbol : this.javaSymbolMap.values()) {
            if (!fullyQualifiedName.startsWith(javaSymbol)) continue;
            String pkgPrefix = this.getPackageFromFullyQualifiedJavaName(fullyQualifiedName) + '.';
            return fullyQualifiedName.substring(pkgPrefix.length());
        }
        return fullyQualifiedName;
    }

    private String protoFileName(String path) {
        int slashIndex = path.lastIndexOf(47);
        if (slashIndex != -1) {
            path = path.substring(slashIndex + 1);
        }
        if (path.endsWith(".proto")) {
            path = path.substring(0, path.length() - ".proto".length());
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitMessageClass(Type type) throws IOException {
        try {
            this.writer = this.io.getJavaWriter(this.outputDirectory, this.protoFile.getJavaPackage(), type.getName());
            this.writer.emitSingleLineComment(CODE_GENERATED_BY_WIRE, new Object[0]);
            this.writer.emitSingleLineComment("Source file: %s", new Object[]{this.sourceFileName});
            this.writer.emitPackage(this.protoFile.getJavaPackage());
            ArrayList<Type> types = new ArrayList<Type>();
            this.getTypes(type, types);
            boolean hasMessage = this.hasMessage(types);
            boolean hasExtensions = this.hasExtensions(Arrays.asList(type));
            LinkedHashSet<String> imports = new LinkedHashSet<String>();
            if (hasMessage) {
                imports.add("com.squareup.wire.Message");
            }
            if ((hasMessage || hasExtensions) && this.hasFields(type)) {
                imports.add("com.squareup.wire.ProtoField");
            }
            if (this.hasBytesField(types)) {
                imports.add("com.squareup.wire.ByteString");
            }
            if (this.hasEnum(types)) {
                imports.add("com.squareup.wire.ProtoEnum");
            }
            if (this.hasRepeatedField(types)) {
                imports.add("java.util.Collections");
                imports.add("java.util.List");
            }
            if (hasExtensions) {
                imports.add("com.squareup.wire.ExtendableMessage");
                imports.add("com.squareup.wire.Extension");
            }
            if (this.hasMessageOption(types)) {
                imports.add("com.google.protobuf.MessageOptions");
            }
            ArrayList<String> externalTypes = new ArrayList<String>();
            this.getExternalTypes(type, externalTypes);
            Map<String, ?> optionsMap = null;
            if (type instanceof MessageType) {
                optionsMap = this.createOptionsMap((MessageType)type);
            }
            if (optionsMap != null) {
                this.getOptionTypes(optionsMap, externalTypes);
            }
            imports.addAll(externalTypes);
            this.writer.emitImports(imports);
            TreeSet<Message.Datatype> datatypes = new TreeSet<Message.Datatype>(Message.Datatype.ORDER_BY_NAME);
            TreeSet<Message.Label> labels = new TreeSet<Message.Label>(Message.Label.ORDER_BY_NAME);
            this.getDatatypesAndLabels(type, datatypes, labels);
            labels.remove(Message.Label.OPTIONAL);
            if (!datatypes.isEmpty() || !labels.isEmpty()) {
                this.writer.emitEmptyLine();
            }
            for (Message.Datatype datatype : datatypes) {
                this.writer.emitStaticImports(new String[]{"com.squareup.wire.Message.Datatype." + datatype.toString()});
            }
            for (Message.Label label : labels) {
                this.writer.emitStaticImports(new String[]{"com.squareup.wire.Message.Label." + label.toString()});
            }
            this.emitType(type, this.protoFile.getPackageName() + ".", optionsMap, true);
        }
        finally {
            this.writer.close();
        }
    }

    private void getOptionTypes(Map<String, ?> optionsMap, List<String> types) {
        for (Map.Entry<String, ?> entry : optionsMap.entrySet()) {
            ExtensionInfo info = this.extensionInfo.get(entry.getKey());
            if (info != null && !info.fqLocation.startsWith(this.protoFile.getJavaPackage())) {
                types.add(info.fqLocation);
            }
            if ("@type".equals(entry.getKey())) {
                String type = (String)entry.getValue();
                String javaName = this.javaName(type);
                if (!this.fullyQualifiedNameIsOutsidePackage(javaName)) continue;
                types.add(javaName);
                continue;
            }
            if (entry.getValue() instanceof List) {
                for (Object objectValue : (List)entry.getValue()) {
                    if (!(objectValue instanceof Map)) continue;
                    this.getOptionTypes((Map)objectValue, types);
                }
                continue;
            }
            if (!(entry.getValue() instanceof Map)) continue;
            this.getOptionTypes((Map)entry.getValue(), types);
        }
    }

    private boolean hasMessageOption(List<Type> types) {
        for (Type type : types) {
            if (!(type instanceof MessageType) || ((MessageType)type).getOptions().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void getTypes(Type parent, List<Type> types) {
        types.add(parent);
        for (Type nestedType : parent.getNestedTypes()) {
            this.getTypes(nestedType, types);
        }
    }

    private void getExternalTypes(Type parent, List<String> types) {
        if (parent instanceof MessageType) {
            MessageType messageType = (MessageType)parent;
            for (MessageType.Field field : messageType.getFields()) {
                String fqName = this.fullyQualifiedJavaName(messageType, field.getType());
                if (!this.fullyQualifiedNameIsOutsidePackage(fqName)) continue;
                types.add(fqName);
            }
        }
        for (Type nestedType : parent.getNestedTypes()) {
            this.getExternalTypes(nestedType, types);
        }
    }

    private String getPackageFromFullyQualifiedJavaName(String fqName) {
        while (this.javaSymbolMap.containsValue(fqName)) {
            fqName = this.removeTrailingSegment(fqName);
        }
        return fqName;
    }

    private List<String> getExtensionTypes() {
        ArrayList<String> extensionClasses = new ArrayList<String>();
        for (ExtendDeclaration extend : this.protoFile.getExtendDeclarations()) {
            String fqName = this.fullyQualifiedJavaName(null, extend.getFullyQualifiedName());
            if (this.fullyQualifiedNameIsOutsidePackage(fqName)) {
                extensionClasses.add(fqName);
            }
            for (MessageType.Field field : extend.getFields()) {
                String fqFieldType = this.fullyQualifiedJavaName(null, field.getType());
                if (!this.fullyQualifiedNameIsOutsidePackage(fqFieldType)) continue;
                extensionClasses.add(fqFieldType);
            }
        }
        return extensionClasses;
    }

    private boolean fullyQualifiedNameIsOutsidePackage(String fqName) {
        return fqName != null && !this.protoFile.getJavaPackage().equals(this.getPackageFromFullyQualifiedJavaName(fqName));
    }

    private boolean hasExtends() {
        return !this.protoFile.getExtendDeclarations().isEmpty();
    }

    private void emitExtensionClass() throws IOException {
        this.writer.emitSingleLineComment(CODE_GENERATED_BY_WIRE, new Object[0]);
        this.writer.emitSingleLineComment("Source file: %s", new Object[]{this.sourceFileName});
        this.writer.emitPackage(this.protoFile.getJavaPackage());
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        if (this.hasByteStringExtension()) {
            imports.add("com.squareup.wire.ByteString");
        }
        imports.add("com.squareup.wire.Extension");
        if (this.hasRepeatedExtension()) {
            imports.add("java.util.List");
        }
        imports.addAll(this.getExtensionTypes());
        this.writer.emitImports(imports);
        this.writer.emitEmptyLine();
        String className = "Ext_" + this.protoFileName;
        this.writer.beginType(className, "class", EnumSet.of(Modifier.PUBLIC, Modifier.FINAL));
        this.writer.emitEmptyLine();
        this.writer.beginMethod(null, className, EnumSet.of(Modifier.PRIVATE), new String[0]);
        this.writer.endMethod();
        this.writer.emitEmptyLine();
        this.emitExtensions();
        this.writer.endType();
    }

    private void emitExtensions() throws IOException {
        for (ExtendDeclaration extend : this.protoFile.getExtendDeclarations()) {
            String fullyQualifiedName = extend.getFullyQualifiedName();
            String javaName = this.javaName(null, fullyQualifiedName);
            String name = this.shortenJavaName(javaName);
            for (MessageType.Field field : extend.getFields()) {
                String fieldType = field.getType();
                String type = this.javaName(null, fieldType);
                if (type == null) {
                    type = this.javaName(null, this.prefixWithPackageName(fieldType));
                }
                type = this.shortenJavaName(type);
                String className = this.writer.compressType(name);
                String extensionName = field.getName();
                String fqName = this.prefixWithPackageName(field.getName());
                int tag = field.getTag();
                boolean isScalar = this.isScalar(fieldType);
                boolean isEnum = !isScalar && this.isEnum(this.fullyQualifiedName(null, fieldType));
                String labelString = this.getLabelString(field, isEnum);
                String initialValue = isScalar ? String.format("Extension%n%1$s.%2$sExtending(%3$s.class)%n%1$s.setName(\"%4$s\")%n%1$s.setTag(%5$d)%n%1$s.build%6$s()", "      ", field.getType(), className, fqName, tag, labelString) : (isEnum ? String.format("Extension%n%1$s.enumExtending(%2$s.class, %3$s.class)%n%1$s.setName(\"%4$s\")%n%1$s.setTag(%5$d)%n%1$s.build%6$s()", "      ", type, className, fqName, tag, labelString) : String.format("Extension%n%1$s.messageExtending(%2$s.class, %3$s.class)%n%1$s.setName(\"%4$s\")%n%1$s.setTag(%5$d)%n%1$s.build%6$s()", "      ", type, className, fqName, tag, labelString));
                if (this.isRepeated(field)) {
                    type = "List<" + type + ">";
                }
                this.writer.emitField("Extension<" + name + ", " + type + ">", extensionName, EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL), initialValue);
            }
        }
    }

    private String prefixWithPackageName(ProtoFile protoFile, String name) {
        return protoFile.getPackageName() + "." + name;
    }

    private String prefixWithPackageName(String name) {
        return this.prefixWithPackageName(this.protoFile, name);
    }

    private String getLabelString(MessageType.Field field, boolean isEnum) {
        switch (field.getLabel()) {
            case OPTIONAL: {
                return "Optional";
            }
            case REQUIRED: {
                return "Required";
            }
            case REPEATED: {
                return this.isPacked(field, isEnum) ? "Packed" : "Repeated";
            }
        }
        throw new RuntimeException("Unknown extension label \"" + field.getLabel() + "\"");
    }

    private boolean hasByteStringExtension() {
        for (ExtendDeclaration extend : this.protoFile.getExtendDeclarations()) {
            for (MessageType.Field field : extend.getFields()) {
                String fieldType = field.getType();
                if (!"bytes".equals(fieldType)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasRepeatedExtension() {
        for (ExtendDeclaration extend : this.protoFile.getExtendDeclarations()) {
            for (MessageType.Field field : extend.getFields()) {
                if (field.getLabel() != MessageType.Label.REPEATED) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasExtensions(MessageType messageType) {
        return !messageType.getExtensions().isEmpty();
    }

    private void emitType(Type type, String currentType, Map<String, ?> optionsMap, boolean topLevel) throws IOException {
        this.writer.emitEmptyLine();
        if (type instanceof MessageType) {
            MessageType messageType = (MessageType)type;
            EnumSet<Modifier> modifiers = EnumSet.of(Modifier.PUBLIC, Modifier.FINAL);
            if (!topLevel) {
                modifiers.add(Modifier.STATIC);
            }
            String name = messageType.getName();
            this.emitDocumentation(messageType.getDocumentation());
            this.writer.beginType(name, "class", modifiers, this.hasExtensions(messageType) ? "ExtendableMessage<" + name + ">" : "Message", new String[0]);
            this.emitMessageOptions(optionsMap);
            this.emitMessageDefaults(messageType);
            this.emitMessageFields(messageType);
            this.emitMessageConstructor(messageType);
            this.emitMessageEquals(messageType);
            this.emitMessageHashCode(messageType);
            this.emitBuilder(messageType);
            for (Type nestedType : type.getNestedTypes()) {
                this.emitType(nestedType, currentType + nestedType.getName() + ".", optionsMap, false);
            }
            this.writer.endType();
        } else if (type instanceof EnumType) {
            EnumType enumType = (EnumType)type;
            this.writer.beginType(enumType.getName(), "enum", EnumSet.of(Modifier.PUBLIC));
            for (EnumType.Value value : enumType.getValues()) {
                this.emitDocumentation(value.getDocumentation());
                this.writer.emitAnnotation(ProtoEnum.class, (Object)value.getTag());
                this.writer.emitEnumValue(value.getName());
            }
            this.writer.endType();
        }
    }

    private void emitDocumentation(String documentation) throws IOException {
        if (this.hasDocumentation(documentation)) {
            this.writer.emitJavadoc(this.sanitizeJavadoc(documentation), new Object[0]);
        }
    }

    private String sanitizeJavadoc(String documentation) {
        documentation = documentation.replace("%", "%%");
        documentation = documentation.replaceAll("\\s+\n", "\n");
        documentation = documentation.replaceAll("@see (http:[-!#$%&'()*+,./0-9:;=?@A-Z\\[\\]_a-z~]+)", "@see <a href=\"$1\">$1</a>");
        return documentation;
    }

    private void emitMessageOptions(Map<String, ?> optionsMap) throws IOException {
        if (optionsMap != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("new MessageOptions.Builder()");
            for (Map.Entry<String, ?> entry : optionsMap.entrySet()) {
                String fqName = entry.getKey();
                ExtensionInfo info = this.extensionInfo.get(fqName);
                sb.append(String.format("%n%s.setExtension(Ext_%s.%s, %s)", "      ", info.location, this.getTrailingSegment(fqName), this.createOptionInitializer(entry.getValue(), "", "", info.fqType, false, 1)));
            }
            sb.append("\n").append(INDENT).append(LINE_WRAP_INDENT).append(".build()");
            this.writer.emitEmptyLine();
            this.writer.emitField("MessageOptions", "MESSAGE_OPTIONS", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL), sb.toString());
        }
    }

    private String getTrailingSegment(String name) {
        int index = name.lastIndexOf(46);
        return index == -1 ? name : name.substring(index + 1);
    }

    private Map<String, ?> createOptionsMap(MessageType type) {
        List options = type.getOptions();
        if (options.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Option option : options) {
            this.insertOption(option.getName(), option.getValue(), type.getFullyQualifiedName(), map);
        }
        return map;
    }

    private void insertOption(String name, Object value, String enclosingType, Map<String, Object> map) {
        String fqName = this.getExtensionPrefix(name);
        if (fqName.isEmpty()) {
            name = this.prefixWithPackageName(name);
        }
        this.insertOptionHelper(name, value, enclosingType, map);
    }

    private String getExtensionPrefix(String name) {
        int endIndex = name.length();
        while (endIndex != -1) {
            String fqName = name.substring(0, endIndex);
            if (this.extensionInfo.containsKey(fqName)) {
                return fqName;
            }
            endIndex = name.lastIndexOf(46, endIndex - 1);
        }
        return "";
    }

    private void insertOptionHelper(String name, Object value, String enclosingType, Map<String, Object> map) {
        String fieldType;
        String fqName;
        int firstDotAfterExtensionIndex = (name = this.stripSquareBrackets(name)).indexOf(46, (fqName = this.getExtensionPrefix(name)).length());
        if (firstDotAfterExtensionIndex != -1) {
            String prefix = name.substring(0, firstDotAfterExtensionIndex);
            String suffix = name.substring(firstDotAfterExtensionIndex + 1);
            String fieldType2 = this.getFieldType(enclosingType, prefix);
            this.insertOptionHelper(prefix, new Option(suffix, value), fieldType2, map);
            return;
        }
        ExtensionInfo info = this.getExtensionInfo(name);
        if (info == null && this.protoFile.getPackageName().endsWith("." + name) && value instanceof Option) {
            name = this.prefixWithPackageName(((Option)value).getName());
            info = this.extensionInfo.get(name);
            value = ((Option)value).getValue();
        }
        if (info != null) {
            enclosingType = info.fqType;
        }
        String string = fieldType = info == null ? this.getFieldType(enclosingType, name) : info.type;
        if (fieldType == null) {
            fieldType = enclosingType;
        }
        if (value instanceof String) {
            MessageType.Label fieldLabel = this.getFieldLabel(enclosingType, name);
            if (info != null) {
                fieldLabel = info.label;
            }
            this.insertStringOption(name, (String)value, map, fieldType, fieldLabel);
        } else if (value instanceof List) {
            this.insertListOption(name, (List)value, enclosingType, map, fieldType);
        } else if (value instanceof Option) {
            this.insertOptionOption(name, (Option)value, enclosingType, map);
        } else if (value instanceof Map) {
            this.insertMapOption(name, (Map)value, enclosingType, map);
        } else {
            throw new RuntimeException("value is not an Option, String, List, or Map");
        }
    }

    private String stripSquareBrackets(String name) {
        int lastIndex = name.length() - 1;
        if (name.charAt(0) == '[' && name.charAt(lastIndex) == ']' && !(name = name.substring(1, lastIndex)).contains(".")) {
            name = this.prefixWithPackageName(name);
        }
        return name;
    }

    private void insertStringOption(String name, String value, Map<String, Object> map, String fieldType, MessageType.Label fieldLabel) {
        value = this.getOptionInitializer(value, fieldType);
        if (fieldLabel == MessageType.Label.REPEATED) {
            ArrayList<String> list = (ArrayList<String>)map.get(name);
            if (list == null) {
                list = new ArrayList<String>();
                map.put(name, list);
            }
            list.add(value);
        } else {
            map.put(name, value);
        }
    }

    private void insertListOption(String name, List<?> value, String enclosingType, Map<String, Object> map, String fieldType) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        for (Object objectValue : value) {
            if (objectValue instanceof String) {
                String stringValue = this.getOptionInitializer((String)objectValue, fieldType);
                valueList.add(stringValue);
                continue;
            }
            if (objectValue instanceof Map) {
                LinkedHashMap<String, Object> entryMap = new LinkedHashMap<String, Object>();
                entryMap.put("@type", enclosingType);
                this.insertOptionsFromMap(enclosingType, (Map)objectValue, entryMap);
                valueList.add(entryMap);
                continue;
            }
            throw new RuntimeException("List contains " + objectValue.getClass().getName() + ", not String or Map");
        }
        map.put(name, valueList);
    }

    private void insertOptionOption(String name, Option value, String enclosingType, Map<String, Object> map) {
        Map<String, Object> entryMap = this.getOrCreateFromMap(map, name);
        entryMap.put("@type", enclosingType);
        String nestedName = value.getName();
        String fieldType = this.getFieldType(enclosingType, nestedName);
        Object val = this.qualifyEnum(enclosingType, nestedName, fieldType, value.getValue());
        this.insertOptionHelper(nestedName, val, enclosingType, entryMap);
    }

    private void insertMapOption(String name, Map<String, ?> value, String enclosingType, Map<String, Object> map) {
        Map<String, Object> entryMap = this.getOrCreateFromMap(map, name);
        entryMap.put("@type", enclosingType);
        this.insertOptionsFromMap(enclosingType, value, entryMap);
    }

    private Map<String, Object> getOrCreateFromMap(Map<String, Object> map, String name) {
        LinkedHashMap entry = map.get(name);
        if (entry == null) {
            entry = new LinkedHashMap();
            map.put(name, entry);
        }
        return entry;
    }

    private ExtensionInfo getExtensionInfo(String name) {
        ExtensionInfo info = this.extensionInfo.get(name);
        if (info == null) {
            info = this.extensionInfo.get(this.prefixWithPackageName(name));
        }
        return info;
    }

    private void insertOptionsFromMap(String enclosingType, Map<String, ?> inputMap, Map<String, Object> outputMap) {
        for (Map.Entry<String, ?> valueEntry : inputMap.entrySet()) {
            String nestedName = valueEntry.getKey();
            String fieldType = this.getFieldType(enclosingType, nestedName);
            Object val = this.qualifyEnum(enclosingType, nestedName, fieldType, valueEntry.getValue());
            this.insertOptionHelper(nestedName, val, fieldType, outputMap);
        }
    }

    private String getOptionInitializer(String stringValue, String fieldType) {
        if (this.isScalar(fieldType)) {
            String javaTypeName = this.scalarType(fieldType);
            return this.getInitializerForType(stringValue, javaTypeName);
        }
        if (this.isEnum(fieldType)) {
            String shortName = this.shortenJavaName(this.javaName(fieldType));
            return shortName + "." + this.getTrailingSegment(stringValue);
        }
        return stringValue;
    }

    private String getFieldType(String enclosingType, String nestedName) {
        FieldInfo fieldInfo = this.fieldMap.get(enclosingType + "$" + nestedName);
        return this.getFieldType(fieldInfo);
    }

    private MessageType.Label getFieldLabel(String enclosingType, String nestedName) {
        FieldInfo fieldInfo = this.fieldMap.get(enclosingType + "$" + nestedName);
        return fieldInfo == null ? null : fieldInfo.label;
    }

    private Object qualifyEnum(String enclosingType, String optionValueName, String fieldType, Object value) {
        if (this.isEnum(this.getFieldType(enclosingType, optionValueName))) {
            return fieldType + "." + value;
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String createOptionInitializer(Object listOrMap, String parentType, String parentField, String fieldType, boolean skipAsList, int level) {
        ++level;
        StringBuilder sb = new StringBuilder();
        if (listOrMap instanceof Map) {
            boolean emitAsList;
            Map map = (Map)listOrMap;
            String fullyQualifiedName = this.javaName(fieldType);
            String dollarName = parentType + "$" + parentField;
            FieldInfo fieldInfo = this.fieldMap.get(dollarName);
            boolean bl = emitAsList = !skipAsList && this.isRepeated(fieldInfo);
            if (emitAsList) {
                sb.append("asList(");
            }
            String shortName = this.shortenJavaName(fullyQualifiedName);
            sb.append("new ").append(shortName).append(".Builder()");
            for (Map.Entry entry : map.entrySet()) {
                String nestedFieldType;
                String key = (String)entry.getKey();
                if (this.isMetadata(key)) continue;
                sb.append("\n  ");
                this.indent(sb, level);
                sb.append(".");
                ExtensionInfo extension = this.extensionInfo.get(key);
                if (extension != null) {
                    key = this.getTrailingSegment(key);
                    sb.append(String.format("setExtension(Ext_%s.%s, ", extension.location, key));
                } else {
                    sb.append(key).append("(");
                }
                FieldInfo info = this.fieldMap.get(fieldType + "$" + key);
                if (info == null) {
                    ExtensionInfo extInfo = this.extensionInfo.get(entry.getKey());
                    if (extInfo == null) throw new RuntimeException("Unknown name " + (String)entry.getKey());
                    nestedFieldType = extInfo.fqType;
                } else {
                    nestedFieldType = this.getFieldType(info);
                }
                String optionInitializer = this.createOptionInitializer(entry.getValue(), fieldType, key, nestedFieldType, false, level);
                sb.append(optionInitializer).append(")");
            }
            sb.append("\n  ");
            this.indent(sb, level);
            sb.append(".build()");
            if (!emitAsList) return sb.toString();
            sb.append(")");
            return sb.toString();
        } else if (listOrMap instanceof List) {
            sb.append("asList(\n");
            String sep = INDENT;
            for (Object objectValue : (List)listOrMap) {
                sb.append(sep);
                this.indent(sb, level);
                if (objectValue instanceof String) {
                    sb.append((String)objectValue);
                } else if (objectValue instanceof Map) {
                    sb.append(this.createOptionInitializer(objectValue, parentType, parentField, fieldType, true, level));
                }
                sep = ",\n  ";
            }
            sb.append(")");
            return sb.toString();
        } else {
            sb.append((String)listOrMap);
        }
        return sb.toString();
    }

    private String getFieldType(FieldInfo info) {
        return info == null ? null : info.name;
    }

    private boolean isRepeated(FieldInfo fieldInfo) {
        return fieldInfo != null && fieldInfo.label == MessageType.Label.REPEATED;
    }

    private boolean isMetadata(String key) {
        return key.charAt(0) == '@';
    }

    private void indent(StringBuilder sb, int level) {
        for (int i = 0; i < level; ++i) {
            sb.append(LINE_WRAP_INDENT);
        }
    }

    private void emitMessageDefaults(MessageType messageType) throws IOException {
        ArrayList<MessageType.Field> defaultFields = new ArrayList<MessageType.Field>();
        for (MessageType.Field field : messageType.getFields()) {
            if (this.isMessageType(messageType, field) && !this.isRepeated(field)) continue;
            defaultFields.add(field);
        }
        if (!defaultFields.isEmpty()) {
            this.writer.emitEmptyLine();
        }
        for (MessageType.Field field : defaultFields) {
            String javaName = this.getJavaFieldType(messageType, field);
            if (javaName == null) {
                throw new IllegalArgumentException("Unknown type for field " + field + " in message " + messageType.getName());
            }
            String defaultValue = this.getDefaultValue(messageType, field);
            this.writer.emitField(javaName, "DEFAULT_" + field.getName().toUpperCase(Locale.US), EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL), defaultValue);
        }
    }

    private String getJavaFieldType(MessageType messageType, MessageType.Field field) {
        return this.getJavaFieldType(this.protoFile, messageType, field);
    }

    private String sanitize(String name) {
        return JAVA_KEYWORDS.contains(name) ? "_" + name : name;
    }

    private String getDefaultValue(MessageType messageType, MessageType.Field field) {
        String initialValue = field.getDefault();
        if (this.isRepeated(field)) {
            return "Collections.emptyList()";
        }
        String javaName = this.javaName(messageType, field.getType());
        if (this.isScalar(field.getType())) {
            return this.getInitializerForType(initialValue, javaName);
        }
        if (initialValue != null) {
            return javaName + "." + initialValue;
        }
        String fullyQualifiedName = this.fullyQualifiedName(messageType, field.getType());
        if (this.isEnum(fullyQualifiedName)) {
            return javaName + "." + this.enumDefaults.get(fullyQualifiedName);
        }
        throw new IllegalArgumentException("Field " + field + " cannot have default value");
    }

    private String getInitializerForType(String initialValue, String javaTypeName) {
        if ("Boolean".equals(javaTypeName)) {
            return initialValue == null ? "false" : initialValue;
        }
        if ("Integer".equals(javaTypeName)) {
            return initialValue == null ? "0" : this.toInt(initialValue);
        }
        if ("Long".equals(javaTypeName)) {
            return initialValue == null ? "0L" : this.toLong(initialValue) + "L";
        }
        if ("Float".equals(javaTypeName)) {
            return initialValue == null ? "0F" : initialValue + "F";
        }
        if ("Double".equals(javaTypeName)) {
            return initialValue == null ? "0D" : initialValue + "D";
        }
        if ("String".equals(javaTypeName)) {
            return this.quoteString(initialValue);
        }
        if ("ByteString".equals(javaTypeName)) {
            if (initialValue == null) {
                return "ByteString.EMPTY";
            }
            return "ByteString.of(\"" + Stringer.encode((byte[])initialValue.getBytes(ISO_8859_1)) + "\")";
        }
        throw new IllegalArgumentException(javaTypeName + " is not an allowed scalar type");
    }

    private String toInt(String value) {
        return Integer.toString(new BigDecimal(value).intValue());
    }

    private String toLong(String value) {
        return Long.toString(new BigDecimal(value).longValue());
    }

    private String quoteString(String initialValue) {
        return initialValue == null ? "\"\"" : JavaWriter.stringLiteral((String)initialValue);
    }

    private void emitMessageFields(MessageType messageType) throws IOException {
        HashSet<Integer> tags = new HashSet<Integer>();
        for (MessageType.Field field : messageType.getFields()) {
            int tag = field.getTag();
            if (tags.contains(tag)) {
                throw new RuntimeException("Duplicate tag value for field " + messageType.getFullyQualifiedName() + "." + field.getName());
            }
            tags.add(tag);
            String fieldType = field.getType();
            String javaName = this.javaName(messageType, fieldType);
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("tag", String.valueOf(tag));
            boolean isEnum = false;
            if (this.isScalar(fieldType)) {
                map.put("type", this.scalarTypeConstant(fieldType));
            } else {
                String fullyQualifiedName = this.fullyQualifiedName(messageType, fieldType);
                isEnum = this.isEnum(fullyQualifiedName);
                if (isEnum) {
                    map.put("type", "ENUM");
                }
            }
            if (!this.isOptional(field)) {
                if (this.isPacked(field, isEnum)) {
                    map.put("label", "PACKED");
                } else {
                    map.put("label", field.getLabel().toString());
                }
            }
            this.writer.emitEmptyLine();
            this.emitDocumentation(field.getDocumentation());
            this.writer.emitAnnotation(ProtoField.class, map);
            if (this.isRepeated(field)) {
                javaName = "List<" + javaName + ">";
            }
            this.writer.emitField(javaName, this.sanitize(field.getName()), EnumSet.of(Modifier.PUBLIC, Modifier.FINAL));
        }
    }

    private void emitMessageConstructor(MessageType messageType) throws IOException {
        this.writer.emitEmptyLine();
        this.writer.beginMethod(null, messageType.getName(), EnumSet.of(Modifier.PRIVATE), new String[]{"Builder", "builder"});
        this.writer.emitStatement("super(builder)", new Object[0]);
        for (MessageType.Field field : messageType.getFields()) {
            if (this.isRepeated(field)) {
                this.writer.emitStatement("this.%1$s = immutableCopyOf(builder.%1$s)", new Object[]{this.sanitize(field.getName())});
                continue;
            }
            this.writer.emitStatement("this.%1$s = builder.%1$s", new Object[]{this.sanitize(field.getName())});
        }
        this.writer.endMethod();
    }

    private void emitMessageEquals(MessageType messageType) throws IOException {
        this.writer.emitEmptyLine();
        this.writer.emitAnnotation(Override.class);
        this.writer.beginMethod("boolean", "equals", EnumSet.of(Modifier.PUBLIC), new String[]{"Object", "other"});
        List fields = messageType.getFields();
        if (fields.isEmpty()) {
            this.writer.emitStatement("return other instanceof %s", new Object[]{messageType.getName()});
        } else {
            this.writer.emitStatement("if (other == this) return true", new Object[0]);
            this.writer.emitStatement("if (!(other instanceof %s)) return false", new Object[]{messageType.getName()});
            if (this.hasOnlyOneField(messageType)) {
                String name = this.sanitize(((MessageType.Field)fields.get(0)).getName());
                this.writer.emitStatement("return equals(%1$s, ((%2$s) other).%3$s)", new Object[]{this.addThisIfOneOf(name, "other", "o"), messageType.getName(), name});
            } else {
                this.writer.emitStatement("%1$s o = (%1$s) other", new Object[]{messageType.getName()});
                if (this.hasExtensions(messageType)) {
                    this.writer.emitStatement("if (!extensionsEqual(o)) return false", new Object[0]);
                }
                StringBuilder sb = new StringBuilder();
                String prefix = "return ";
                for (MessageType.Field field : fields) {
                    sb.append(prefix);
                    prefix = "\n&& ";
                    String name = this.sanitize(field.getName());
                    sb.append(String.format("equals(%1$s, o.%2$s)", this.addThisIfOneOf(name, "other", "o"), name));
                }
                this.writer.emitStatement(sb.toString(), new Object[0]);
            }
        }
        this.writer.endMethod();
    }

    private String addThisIfOneOf(String name, String ... matches) {
        for (String match : matches) {
            if (!match.equals(name)) continue;
            return "this." + name;
        }
        return name;
    }

    private boolean hasOnlyOneField(MessageType messageType) {
        return messageType.getFields().size() == 1 && !this.hasExtensions(messageType);
    }

    private void emitMessageHashCode(MessageType messageType) throws IOException {
        this.writer.emitEmptyLine();
        this.writer.emitAnnotation(Override.class);
        this.writer.beginMethod("int", "hashCode", EnumSet.of(Modifier.PUBLIC), new String[0]);
        if (!this.hasFields((Type)messageType) && !this.hasExtensions(messageType)) {
            this.writer.emitStatement("return 0", new Object[0]);
        } else if (this.hasOnlyOneField(messageType)) {
            MessageType.Field field = (MessageType.Field)messageType.getFields().get(0);
            String name = this.sanitize(field.getName());
            name = this.addThisIfOneOf(name, "result");
            this.writer.emitStatement("int result = hashCode", new Object[0]);
            this.writer.emitStatement("return result != 0 ? result : (hashCode = %1$s != null ? %1$s.hashCode() : 0)", new Object[]{name});
        } else {
            this.writer.emitStatement("int result = hashCode", new Object[0]);
            this.writer.beginControlFlow("if (result == 0)");
            boolean afterFirstAssignment = false;
            if (this.hasExtensions(messageType)) {
                this.writer.emitStatement("result = extensionsHashCode()", new Object[0]);
                afterFirstAssignment = true;
            }
            for (MessageType.Field field : messageType.getFields()) {
                String name = this.sanitize(field.getName());
                name = this.addThisIfOneOf(name, "result");
                if (afterFirstAssignment) {
                    this.writer.emitStatement("result = result * 37 + (%1$s != null ? %1$s.hashCode() : 0)", new Object[]{name});
                    continue;
                }
                this.writer.emitStatement("result = %1$s != null ? %1$s.hashCode() : 0", new Object[]{name});
                afterFirstAssignment = true;
            }
            this.writer.emitStatement("hashCode = result", new Object[0]);
            this.writer.endControlFlow();
            this.writer.emitStatement("return result", new Object[0]);
        }
        this.writer.endMethod();
    }

    private void emitBuilder(MessageType messageType) throws IOException {
        this.writer.emitEmptyLine();
        this.writer.beginType("Builder", "class", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL), (this.hasExtensions(messageType) ? "ExtendableBuilder<" : "Message.Builder<") + messageType.getName() + ">", new String[0]);
        this.emitBuilderFields(messageType);
        this.emitBuilderConstructors(messageType);
        this.emitBuilderSetters(messageType);
        if (this.hasExtensions(messageType)) {
            this.emitBuilderSetExtension(messageType);
        }
        this.emitBuilderBuild(messageType);
        this.writer.endType();
    }

    private void emitBuilderFields(MessageType messageType) throws IOException {
        List fields = messageType.getFields();
        if (!fields.isEmpty()) {
            this.writer.emitEmptyLine();
        }
        for (MessageType.Field field : fields) {
            String javaName = this.getJavaFieldType(messageType, field);
            this.writer.emitField(javaName, this.sanitize(field.getName()), EnumSet.of(Modifier.PUBLIC));
        }
    }

    private void emitBuilderConstructors(MessageType messageType) throws IOException {
        this.writer.emitEmptyLine();
        this.writer.beginMethod(null, "Builder", EnumSet.of(Modifier.PUBLIC), new String[0]);
        this.writer.endMethod();
        this.writer.emitEmptyLine();
        this.writer.beginMethod(null, "Builder", EnumSet.of(Modifier.PUBLIC), new String[]{messageType.getName(), "message"});
        this.writer.emitStatement("super(message)", new Object[0]);
        List fields = messageType.getFields();
        if (!fields.isEmpty()) {
            this.writer.emitStatement("if (message == null) return", new Object[0]);
        }
        for (MessageType.Field field : fields) {
            if (this.isRepeated(field)) {
                this.writer.emitStatement("this.%1$s = copyOf(message.%1$s)", new Object[]{this.sanitize(field.getName())});
                continue;
            }
            this.writer.emitStatement("this.%1$s = message.%1$s", new Object[]{this.sanitize(field.getName())});
        }
        this.writer.endMethod();
    }

    private void emitBuilderSetters(MessageType messageType) throws IOException {
        for (MessageType.Field field : messageType.getFields()) {
            String javaName = this.getJavaFieldType(messageType, field);
            ArrayList<String> args = new ArrayList<String>();
            args.add(javaName);
            String sanitized = this.sanitize(field.getName());
            args.add(sanitized);
            this.writer.emitEmptyLine();
            this.emitDocumentation(field.getDocumentation());
            this.writer.beginMethod("Builder", sanitized, EnumSet.of(Modifier.PUBLIC), args, null);
            this.writer.emitStatement("this.%1$s = %1$s", new Object[]{sanitized});
            this.writer.emitStatement("return this", new Object[0]);
            this.writer.endMethod();
        }
    }

    private void emitBuilderSetExtension(MessageType messageType) throws IOException {
        this.writer.emitEmptyLine();
        this.writer.emitAnnotation(Override.class);
        this.writer.beginMethod("<E> Builder", "setExtension", EnumSet.of(Modifier.PUBLIC), new String[]{"Extension<" + messageType.getName() + ", E>", "extension", "E", "value"});
        this.writer.emitStatement("super.setExtension(extension, value)", new Object[0]);
        this.writer.emitStatement("return this", new Object[0]);
        this.writer.endMethod();
    }

    private void emitBuilderBuild(MessageType messageType) throws IOException {
        this.writer.emitEmptyLine();
        this.writer.emitAnnotation(Override.class);
        this.writer.beginMethod(messageType.getName(), "build", EnumSet.of(Modifier.PUBLIC), new String[0]);
        if (this.hasRequiredFields((Type)messageType)) {
            this.writer.emitStatement("checkRequiredFields()", new Object[0]);
        }
        this.writer.emitStatement("return new %s(this)", new Object[]{messageType.getName()});
        this.writer.endMethod();
    }

    private boolean hasEnum(List<Type> types) {
        for (Type type : types) {
            if (!(type instanceof EnumType) && !this.hasEnum(type.getNestedTypes())) continue;
            return true;
        }
        return false;
    }

    private boolean hasExtensions(List<Type> types) {
        for (Type type : types) {
            if (type instanceof MessageType && this.hasExtensions((MessageType)type)) {
                return true;
            }
            if (!this.hasExtensions(type.getNestedTypes())) continue;
            return true;
        }
        return false;
    }

    private boolean hasMessage(List<Type> types) {
        for (Type type : types) {
            if (type instanceof MessageType && !this.hasExtensions((MessageType)type)) {
                return true;
            }
            if (!this.hasMessage(type.getNestedTypes())) continue;
            return true;
        }
        return false;
    }

    private boolean hasRepeatedField(List<Type> types) {
        for (Type type : types) {
            if (type instanceof MessageType) {
                for (MessageType.Field field : ((MessageType)type).getFields()) {
                    if (!this.isRepeated(field)) continue;
                    return true;
                }
            }
            if (!this.hasRepeatedField(type.getNestedTypes())) continue;
            return true;
        }
        return false;
    }

    private boolean hasBytesField(List<Type> types) {
        for (Type type : types) {
            if (type instanceof MessageType) {
                for (MessageType.Field field : ((MessageType)type).getFields()) {
                    if (!"bytes".equals(field.getType())) continue;
                    return true;
                }
            }
            if (!this.hasBytesField(type.getNestedTypes())) continue;
            return true;
        }
        return false;
    }

    private boolean hasFields(Type type) {
        return type instanceof MessageType && !((MessageType)type).getFields().isEmpty();
    }

    private boolean hasRequiredFields(Type type) {
        if (type instanceof MessageType) {
            for (MessageType.Field field : ((MessageType)type).getFields()) {
                if (!this.isRequired(field)) continue;
                return true;
            }
        }
        return false;
    }

    private void getDatatypesAndLabels(Type type, Collection<Message.Datatype> types, Collection<Message.Label> labels) {
        if (type instanceof MessageType) {
            block5: for (MessageType.Field field : ((MessageType)type).getFields()) {
                String fieldType = field.getType();
                Message.Datatype datatype = Message.Datatype.of((String)fieldType);
                if (datatype == null && this.isEnum(this.fullyQualifiedName((MessageType)type, field.getType()))) {
                    datatype = Message.Datatype.ENUM;
                }
                if (datatype != null) {
                    types.add(datatype);
                }
                MessageType.Label label = field.getLabel();
                switch (label) {
                    case OPTIONAL: {
                        labels.add(Message.Label.OPTIONAL);
                        continue block5;
                    }
                    case REQUIRED: {
                        labels.add(Message.Label.REQUIRED);
                        continue block5;
                    }
                    case REPEATED: {
                        if (this.isPacked(field, false)) {
                            labels.add(Message.Label.PACKED);
                            continue block5;
                        }
                        labels.add(Message.Label.REPEATED);
                        continue block5;
                    }
                }
                throw new AssertionError((Object)("Unknown label " + label));
            }
            for (Type nestedType : type.getNestedTypes()) {
                this.getDatatypesAndLabels(nestedType, types, labels);
            }
        }
    }

    private boolean hasDocumentation(String documentation) {
        return documentation != null && !documentation.isEmpty();
    }

    private String scalarTypeConstant(String type) {
        return type.toUpperCase(Locale.US);
    }

    private boolean isScalar(String type) {
        return JAVA_TYPES.containsKey(type);
    }

    private String scalarType(String type) {
        return JAVA_TYPES.get(type);
    }

    private boolean isEnum(String type) {
        return this.enumTypes.contains(type);
    }

    private boolean isOptional(MessageType.Field field) {
        return field.getLabel() == MessageType.Label.OPTIONAL;
    }

    private boolean isRepeated(MessageType.Field field) {
        return field.getLabel() == MessageType.Label.REPEATED;
    }

    private boolean isRequired(MessageType.Field field) {
        return field.getLabel() == MessageType.Label.REQUIRED;
    }

    private boolean isMessageType(MessageType messageType, MessageType.Field field) {
        return !this.isScalar(field.getType()) && !this.isEnum(this.fullyQualifiedName(messageType, field.getType()));
    }

    private boolean isPacked(MessageType.Field field, boolean isEnum) {
        return "true".equals(field.getExtensions().get("packed")) && (isEnum || this.isPackableScalar(field));
    }

    private boolean isPackableScalar(MessageType.Field field) {
        String type = field.getType();
        return this.isScalar(type) && !"string".equals(type) && !"bytes".equals(type);
    }

    private String javaName(MessageType messageType, String type) {
        String scalarType = this.scalarType(type);
        return scalarType != null ? scalarType : this.shortenJavaName(this.javaName(this.fullyQualifiedName(messageType, type)));
    }

    private String javaName(String fqName) {
        return this.javaSymbolMap.get(fqName);
    }

    private String fullyQualifiedName(MessageType messageType, String type) {
        return this.fullyQualifiedName(this.protoFile, messageType, type);
    }

    private boolean typeIsComplete(String type) {
        return this.javaSymbolMap.containsKey(type);
    }

    private String fullyQualifiedJavaName(MessageType messageType, String type) {
        return this.isScalar(type) ? null : this.javaName(this.fullyQualifiedName(messageType, type));
    }

    private String shortenJavaName(String fullyQualifiedName) {
        return this.shortenJavaName(this.protoFile, fullyQualifiedName);
    }

    static {
        JAVA_TYPES.put("bool", "Boolean");
        JAVA_TYPES.put("bytes", "ByteString");
        JAVA_TYPES.put("double", "Double");
        JAVA_TYPES.put("float", "Float");
        JAVA_TYPES.put("fixed32", "Integer");
        JAVA_TYPES.put("fixed64", "Long");
        JAVA_TYPES.put("int32", "Integer");
        JAVA_TYPES.put("int64", "Long");
        JAVA_TYPES.put("sfixed32", "Integer");
        JAVA_TYPES.put("sfixed64", "Long");
        JAVA_TYPES.put("sint32", "Integer");
        JAVA_TYPES.put("sint64", "Long");
        JAVA_TYPES.put("string", "String");
        JAVA_TYPES.put("uint32", "Integer");
        JAVA_TYPES.put("uint64", "Long");
    }

    private static enum LoadSymbolsPass {
        LOAD_TYPES,
        LOAD_FIELDS;

    }
}

